/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.lpmfoundations.paymentmethod.definitions;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.lpmfoundations.FormHeaderInformation;
import com.stripe.android.lpmfoundations.luxe.FormElementsBuilder;
import com.stripe.android.lpmfoundations.luxe.SupportedPaymentMethod;
import com.stripe.android.lpmfoundations.paymentmethod.DisplayableCustomPaymentMethod;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodDefinition;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodMetadata;
import com.stripe.android.lpmfoundations.paymentmethod.UiDefinitionFactory;
import com.stripe.android.paymentsheet.model.PaymentMethodIncentive;
import com.stripe.android.ui.core.elements.SharedDataSpec;
import com.stripe.android.ui.core.elements.StaticTextElement;
import com.stripe.android.uicore.elements.FormElement;
import com.stripe.android.uicore.elements.IdentifierSpec;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/definitions/CustomPaymentMethodUiDefinitionFactory;", "Lcom/stripe/android/lpmfoundations/paymentmethod/UiDefinitionFactory$Simple;", "displayableCustomPaymentMethod", "Lcom/stripe/android/lpmfoundations/paymentmethod/DisplayableCustomPaymentMethod;", "<init>", "(Lcom/stripe/android/lpmfoundations/paymentmethod/DisplayableCustomPaymentMethod;)V", "createSupportedPaymentMethod", "Lcom/stripe/android/lpmfoundations/luxe/SupportedPaymentMethod;", "createFormElements", "", "Lcom/stripe/android/uicore/elements/FormElement;", "metadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "arguments", "Lcom/stripe/android/lpmfoundations/paymentmethod/UiDefinitionFactory$Arguments;", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class CustomPaymentMethodUiDefinitionFactory
implements UiDefinitionFactory.Simple {
    @NotNull
    private final DisplayableCustomPaymentMethod displayableCustomPaymentMethod;
    public static final int $stable = 8;

    public CustomPaymentMethodUiDefinitionFactory(@NotNull DisplayableCustomPaymentMethod displayableCustomPaymentMethod) {
        Intrinsics.checkNotNullParameter((Object)displayableCustomPaymentMethod, (String)"displayableCustomPaymentMethod");
        this.displayableCustomPaymentMethod = displayableCustomPaymentMethod;
    }

    @Override
    @NotNull
    public SupportedPaymentMethod createSupportedPaymentMethod() {
        String string2 = this.displayableCustomPaymentMethod.getId();
        ResolvableString resolvableString = ResolvableStringUtilsKt.getResolvableString((String)this.displayableCustomPaymentMethod.getDisplayName());
        ResolvableString resolvableString2 = this.displayableCustomPaymentMethod.getSubtitle();
        String string3 = this.displayableCustomPaymentMethod.getLogoUrl();
        String string4 = this.displayableCustomPaymentMethod.getLogoUrl();
        return new SupportedPaymentMethod(string2, resolvableString, 0, string3, string4, false, resolvableString2);
    }

    @Override
    @NotNull
    public List<FormElement> createFormElements(@NotNull PaymentMethodMetadata metadata2, @NotNull UiDefinitionFactory.Arguments arguments) {
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        FormElementsBuilder builder = new FormElementsBuilder(arguments);
        ResolvableString resolvableString = this.displayableCustomPaymentMethod.getSubtitle();
        if (resolvableString != null) {
            ResolvableString subtitle = resolvableString;
            boolean bl = false;
            builder.header((FormElement)new StaticTextElement(IdentifierSpec.Companion.Generic("CustomPaymentMethodHeader"), subtitle, null, 4, null));
        }
        if (this.displayableCustomPaymentMethod.getDoesNotCollectBillingDetails()) {
            builder.ignoreContactInformationRequirements();
            builder.ignoreBillingAddressRequirements();
        }
        return builder.build();
    }

    @Override
    @NotNull
    public FormHeaderInformation createFormHeaderInformation(boolean customerHasSavedPaymentMethods, @Nullable PaymentMethodIncentive incentive) {
        return UiDefinitionFactory.Simple.DefaultImpls.createFormHeaderInformation(this, customerHasSavedPaymentMethods, incentive);
    }

    @Override
    public boolean canBeDisplayedInUi(@NotNull PaymentMethodDefinition definition, @NotNull List<SharedDataSpec> sharedDataSpecs) {
        return UiDefinitionFactory.Simple.DefaultImpls.canBeDisplayedInUi(this, definition, sharedDataSpecs);
    }

    @Override
    @Nullable
    public SupportedPaymentMethod supportedPaymentMethod(@NotNull PaymentMethodMetadata metadata2, @NotNull PaymentMethodDefinition definition, @NotNull List<SharedDataSpec> sharedDataSpecs) {
        return UiDefinitionFactory.Simple.DefaultImpls.supportedPaymentMethod(this, metadata2, definition, sharedDataSpecs);
    }

    @Override
    @Nullable
    public FormHeaderInformation formHeaderInformation(@NotNull PaymentMethodDefinition definition, @NotNull PaymentMethodMetadata metadata2, @NotNull List<SharedDataSpec> sharedDataSpecs, boolean customerHasSavedPaymentMethods) {
        return UiDefinitionFactory.Simple.DefaultImpls.formHeaderInformation(this, definition, metadata2, sharedDataSpecs, customerHasSavedPaymentMethods);
    }

    @Override
    @Nullable
    public List<FormElement> formElements(@NotNull PaymentMethodDefinition definition, @NotNull PaymentMethodMetadata metadata2, @NotNull List<SharedDataSpec> sharedDataSpecs, @NotNull UiDefinitionFactory.Arguments arguments) {
        return UiDefinitionFactory.Simple.DefaultImpls.formElements(this, definition, metadata2, sharedDataSpecs, arguments);
    }
}

