/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.lpmfoundations.paymentmethod.definitions;

import androidx.compose.ui.unit.Dp;
import com.stripe.android.CardBrandFilter;
import com.stripe.android.cards.CardAccountRangeRepository;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.link.ui.inline.LinkSignupMode;
import com.stripe.android.lpmfoundations.FormHeaderInformation;
import com.stripe.android.lpmfoundations.luxe.SaveForFutureUseHelperKt;
import com.stripe.android.lpmfoundations.luxe.SupportedPaymentMethod;
import com.stripe.android.lpmfoundations.paymentmethod.CustomerMetadata;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodDefinition;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodMetadata;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodSaveConsentBehavior;
import com.stripe.android.lpmfoundations.paymentmethod.UiDefinitionFactory;
import com.stripe.android.lpmfoundations.paymentmethod.definitions.CardDefinition;
import com.stripe.android.lpmfoundations.paymentmethod.definitions.CardDefinitionKt;
import com.stripe.android.lpmfoundations.paymentmethod.link.LinkFormElement;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.model.PaymentMethodIncentive;
import com.stripe.android.ui.core.R;
import com.stripe.android.ui.core.cbc.CardBrandChoiceEligibility;
import com.stripe.android.ui.core.elements.CardDetailsSectionElement;
import com.stripe.android.ui.core.elements.MandateTextElement;
import com.stripe.android.ui.core.elements.SaveForFutureUseElement;
import com.stripe.android.ui.core.elements.SetAsDefaultPaymentMethodElement;
import com.stripe.android.ui.core.elements.SharedDataSpec;
import com.stripe.android.uicore.elements.FormElement;
import com.stripe.android.uicore.elements.IdentifierSpec;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u001b\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u0010\u001f\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J*\u0010 \u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006#"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/definitions/CardUiDefinitionFactory;", "Lcom/stripe/android/lpmfoundations/paymentmethod/UiDefinitionFactory$Simple;", "<init>", "()V", "createSupportedPaymentMethod", "Lcom/stripe/android/lpmfoundations/luxe/SupportedPaymentMethod;", "createFormHeaderInformation", "Lcom/stripe/android/lpmfoundations/FormHeaderInformation;", "customerHasSavedPaymentMethods", "", "incentive", "Lcom/stripe/android/paymentsheet/model/PaymentMethodIncentive;", "createFormElements", "", "Lcom/stripe/android/uicore/elements/FormElement;", "metadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "arguments", "Lcom/stripe/android/lpmfoundations/paymentmethod/UiDefinitionFactory$Arguments;", "createCardMandateElement", "Lcom/stripe/android/ui/core/elements/MandateTextElement;", "merchantName", "", "signupMode", "Lcom/stripe/android/link/ui/inline/LinkSignupMode;", "canChangeSaveForFutureUse", "saveForFutureUsageIsChangeable", "addContactInformationElement", "", "billingDetailsCollectionConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "addCardBillingElements", "addSavePaymentOptionElements", "canChangeSaveForFutureUsage", "getSetAsDefaultInitialValueFromArguments", "paymentsheet_release"})
@SourceDebugExtension(value={"SMAP\nCardDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardDefinition.kt\ncom/stripe/android/lpmfoundations/paymentmethod/definitions/CardUiDefinitionFactory\n+ 2 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,308:1\n154#2:309\n154#2:310\n154#2:311\n154#2:312\n295#3,2:313\n*S KotlinDebug\n*F\n+ 1 CardDefinition.kt\ncom/stripe/android/lpmfoundations/paymentmethod/definitions/CardUiDefinitionFactory\n*L\n141#1:309\n142#1:310\n143#1:311\n144#1:312\n230#1:313,2\n*E\n"})
final class CardUiDefinitionFactory
implements UiDefinitionFactory.Simple {
    @NotNull
    public static final CardUiDefinitionFactory INSTANCE = new CardUiDefinitionFactory();

    private CardUiDefinitionFactory() {
    }

    @Override
    @NotNull
    public SupportedPaymentMethod createSupportedPaymentMethod() {
        return new SupportedPaymentMethod(CardDefinition.INSTANCE, null, R.string.stripe_paymentsheet_payment_method_card, R.drawable.stripe_ic_paymentsheet_pm_card, true, null, 34, null);
    }

    @Override
    @NotNull
    public FormHeaderInformation createFormHeaderInformation(boolean customerHasSavedPaymentMethods, @Nullable PaymentMethodIncentive incentive) {
        int displayName = customerHasSavedPaymentMethods ? R.string.stripe_paymentsheet_add_new_card : R.string.stripe_paymentsheet_add_card;
        return FormHeaderInformation.copy$default(this.createSupportedPaymentMethod().asFormHeaderInformation(incentive), ResolvableStringUtilsKt.getResolvableString((int)displayName), false, 0, null, null, false, null, 124, null);
    }

    @Override
    @NotNull
    public List<FormElement> createFormElements(@NotNull PaymentMethodMetadata metadata2, @NotNull UiDefinitionFactory.Arguments arguments) {
        LinkSignupMode signupMode;
        LinkSignupMode linkSignupMode;
        List list;
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = metadata2.getBillingDetailsCollectionConfiguration();
        List $this$createFormElements_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        INSTANCE.addContactInformationElement($this$createFormElements_u24lambda_u240, arguments, metadata2.getBillingDetailsCollectionConfiguration());
        CardAccountRangeRepository.Factory factory = arguments.getCardAccountRangeRepositoryFactory();
        Map<IdentifierSpec, String> map2 = arguments.getInitialValues();
        IdentifierSpec identifierSpec = IdentifierSpec.Companion.Generic("card_details");
        boolean bl2 = billingDetailsCollectionConfiguration.getCollectsName$paymentsheet_release();
        CardBrandChoiceEligibility cardBrandChoiceEligibility = arguments.getCbcEligibility();
        CardBrandFilter cardBrandFilter = arguments.getCardBrandFilter();
        String string2 = metadata2.getElementsSessionId();
        $this$createFormElements_u24lambda_u240.add(new CardDetailsSectionElement(factory, map2, string2, bl2, cardBrandChoiceEligibility, cardBrandFilter, identifierSpec, null, 128, null));
        INSTANCE.addCardBillingElements($this$createFormElements_u24lambda_u240, arguments, metadata2.getBillingDetailsCollectionConfiguration());
        boolean canChangeSaveForFutureUsage = INSTANCE.saveForFutureUsageIsChangeable(metadata2);
        INSTANCE.addSavePaymentOptionElements($this$createFormElements_u24lambda_u240, canChangeSaveForFutureUsage, metadata2, arguments);
        if (metadata2.getLinkInlineConfiguration() != null && arguments.getLinkConfigurationCoordinator() != null) {
            $this$createFormElements_u24lambda_u240.add(new LinkFormElement(metadata2.getLinkInlineConfiguration(), arguments.getLinkConfigurationCoordinator(), arguments.getInitialLinkUserInput(), arguments.getOnLinkInlineSignupStateChanged()));
            linkSignupMode = metadata2.getLinkInlineConfiguration().getSignupMode();
        } else {
            linkSignupMode = signupMode = null;
        }
        if (metadata2.hasIntentToSetup()) {
            $this$createFormElements_u24lambda_u240.add(INSTANCE.createCardMandateElement(metadata2.getMerchantName(), signupMode, canChangeSaveForFutureUsage));
        }
        return CollectionsKt.build((List)list);
    }

    private final MandateTextElement createCardMandateElement(String merchantName, LinkSignupMode signupMode, boolean canChangeSaveForFutureUse) {
        float f;
        boolean $i$f$getDp;
        int $this$dp$iv;
        IdentifierSpec identifierSpec = IdentifierSpec.Companion.Generic("card_mandate");
        int n = R.string.stripe_paymentsheet_card_mandate;
        if (signupMode == LinkSignupMode.AlongsideSaveForFutureUse) {
            $this$dp$iv = 0;
            $i$f$getDp = false;
            f = Dp.constructor-impl((float)$this$dp$iv);
        } else if (signupMode == LinkSignupMode.InsteadOfSaveForFutureUse) {
            $this$dp$iv = 4;
            $i$f$getDp = false;
            f = Dp.constructor-impl((float)$this$dp$iv);
        } else if (canChangeSaveForFutureUse) {
            $this$dp$iv = 6;
            $i$f$getDp = false;
            f = Dp.constructor-impl((float)$this$dp$iv);
        } else {
            $this$dp$iv = 2;
            $i$f$getDp = false;
            f = Dp.constructor-impl((float)$this$dp$iv);
        }
        float f2 = f;
        List list = CollectionsKt.listOf((Object)merchantName);
        return new MandateTextElement(identifierSpec, n, list, f2, null, 16, null);
    }

    private final boolean saveForFutureUsageIsChangeable(PaymentMethodMetadata metadata2) {
        String string2 = PaymentMethod.Type.Card.code;
        StripeIntent stripeIntent = metadata2.getStripeIntent();
        PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior = metadata2.getPaymentMethodSaveConsentBehavior();
        CustomerMetadata customerMetadata = metadata2.getCustomerMetadata();
        boolean bl = customerMetadata != null ? customerMetadata.getHasCustomerConfiguration() : false;
        return SaveForFutureUseHelperKt.isSaveForFutureUseValueChangeable(string2, paymentMethodSaveConsentBehavior, stripeIntent, bl);
    }

    private final boolean addContactInformationElement(List<FormElement> $this$addContactInformationElement, UiDefinitionFactory.Arguments arguments, PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration) {
        FormElement contactInformationElement = CardDefinitionKt.access$contactInformationElement(arguments.getInitialValues(), billingDetailsCollectionConfiguration.getCollectsEmail$paymentsheet_release(), billingDetailsCollectionConfiguration.getCollectsPhone$paymentsheet_release());
        return contactInformationElement != null ? $this$addContactInformationElement.add(contactInformationElement) : false;
    }

    private final boolean addCardBillingElements(List<FormElement> $this$addCardBillingElements, UiDefinitionFactory.Arguments arguments, PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration) {
        return billingDetailsCollectionConfiguration.getAddress() != PaymentSheet.BillingDetailsCollectionConfiguration.AddressCollectionMode.Never ? $this$addCardBillingElements.addAll(CardDefinitionKt.access$cardBillingElements(CardDefinitionKt.toInternal(billingDetailsCollectionConfiguration.getAddress()), arguments.getInitialValues(), arguments.getShippingValues())) : false;
    }

    private final boolean addSavePaymentOptionElements(List<FormElement> $this$addSavePaymentOptionElements, boolean canChangeSaveForFutureUsage, PaymentMethodMetadata metadata2, UiDefinitionFactory.Arguments arguments) {
        boolean isSetAsDefaultPaymentMethodEnabled;
        SaveForFutureUseElement saveForFutureUseElement = new SaveForFutureUseElement(arguments.getSaveForFutureUseInitialValue(), arguments.getMerchantName());
        StateFlow isSaveForFutureUseCheckedFlow = saveForFutureUseElement.getController().getSaveForFutureUse();
        CustomerMetadata customerMetadata = metadata2.getCustomerMetadata();
        boolean bl = isSetAsDefaultPaymentMethodEnabled = customerMetadata != null ? customerMetadata.isPaymentMethodSetAsDefaultEnabled() : false;
        if (canChangeSaveForFutureUsage) {
            $this$addSavePaymentOptionElements.add((FormElement)saveForFutureUseElement);
        }
        if (canChangeSaveForFutureUsage && isSetAsDefaultPaymentMethodEnabled) {
            $this$addSavePaymentOptionElements.add((FormElement)new SetAsDefaultPaymentMethodElement(this.getSetAsDefaultInitialValueFromArguments(arguments), isSaveForFutureUseCheckedFlow, arguments.getSetAsDefaultMatchesSaveForFutureUse()));
        }
        return true;
    }

    private final boolean getSetAsDefaultInitialValueFromArguments(UiDefinitionFactory.Arguments arguments) {
        String string2;
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = arguments.getInitialValues().entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)((IdentifierSpec)it.getKey()).getV1(), (CharSequence)IdentifierSpec.Companion.getSetAsDefaultPaymentMethod().getV1(), (boolean)false, (int)2, null)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null && (string2 = (String)entry.getValue()) != null ? Boolean.parseBoolean(string2) : false;
    }

    @Override
    public boolean canBeDisplayedInUi(@NotNull PaymentMethodDefinition definition, @NotNull List<SharedDataSpec> sharedDataSpecs) {
        return UiDefinitionFactory.Simple.DefaultImpls.canBeDisplayedInUi(this, definition, sharedDataSpecs);
    }

    @Override
    @Nullable
    public SupportedPaymentMethod supportedPaymentMethod(@NotNull PaymentMethodMetadata metadata2, @NotNull PaymentMethodDefinition definition, @NotNull List<SharedDataSpec> sharedDataSpecs) {
        return UiDefinitionFactory.Simple.DefaultImpls.supportedPaymentMethod(this, metadata2, definition, sharedDataSpecs);
    }

    @Override
    @Nullable
    public FormHeaderInformation formHeaderInformation(@NotNull PaymentMethodDefinition definition, @NotNull PaymentMethodMetadata metadata2, @NotNull List<SharedDataSpec> sharedDataSpecs, boolean customerHasSavedPaymentMethods) {
        return UiDefinitionFactory.Simple.DefaultImpls.formHeaderInformation(this, definition, metadata2, sharedDataSpecs, customerHasSavedPaymentMethods);
    }

    @Override
    @Nullable
    public List<FormElement> formElements(@NotNull PaymentMethodDefinition definition, @NotNull PaymentMethodMetadata metadata2, @NotNull List<SharedDataSpec> sharedDataSpecs, @NotNull UiDefinitionFactory.Arguments arguments) {
        return UiDefinitionFactory.Simple.DefaultImpls.formElements(this, definition, metadata2, sharedDataSpecs, arguments);
    }
}

