/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.link.model.AccountStatus;
import com.stripe.android.model.ConsumerSession;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u001b\u001a\u00020\u0013*\u00020\u0003H\u0002J\f\u0010\u001c\u001a\u00020\u0013*\u00020\u0003H\u0002J\f\u0010\u001d\u001a\u00020\u0013*\u00020\u0003H\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\t\u001a\u0004\b\u000e\u0010\u000bR\u0017\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\t\u001a\u0004\b\u0011\u0010\u000bR\u0017\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\t\u001a\u0004\b\u0012\u0010\u0015R\u0017\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\t\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lcom/stripe/android/link/model/LinkAccount;", "Landroid/os/Parcelable;", "consumerSession", "Lcom/stripe/android/model/ConsumerSession;", "<init>", "(Lcom/stripe/android/model/ConsumerSession;)V", "redactedPhoneNumber", "", "getRedactedPhoneNumber$annotations", "()V", "getRedactedPhoneNumber", "()Ljava/lang/String;", "clientSecret", "getClientSecret$annotations", "getClientSecret", "email", "getEmail$annotations", "getEmail", "isVerified", "", "isVerified$annotations", "()Z", "accountStatus", "Lcom/stripe/android/link/model/AccountStatus;", "getAccountStatus$annotations", "getAccountStatus", "()Lcom/stripe/android/link/model/AccountStatus;", "containsSMSSessionStarted", "containsVerifiedSMSSession", "isVerifiedForSignup", "describeContents", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
@Parcelize
@StabilityInferred(parameters=0)
public final class LinkAccount
implements Parcelable {
    @NotNull
    private final ConsumerSession consumerSession;
    @NotNull
    private final String redactedPhoneNumber;
    @NotNull
    private final String clientSecret;
    @NotNull
    private final String email;
    private final boolean isVerified;
    @NotNull
    private final AccountStatus accountStatus;
    @NotNull
    public static final Parcelable.Creator<LinkAccount> CREATOR;
    public static final int $stable;

    public LinkAccount(@NotNull ConsumerSession consumerSession) {
        Intrinsics.checkNotNullParameter((Object)consumerSession, (String)"consumerSession");
        this.consumerSession = consumerSession;
        this.redactedPhoneNumber = StringsKt.replace$default((String)this.consumerSession.getRedactedFormattedPhoneNumber(), (String)"*", (String)"\u2022", (boolean)false, (int)4, null);
        this.clientSecret = this.consumerSession.getClientSecret();
        this.email = this.consumerSession.getEmailAddress();
        boolean bl = this.isVerified = this.containsVerifiedSMSSession(this.consumerSession) || this.isVerifiedForSignup(this.consumerSession);
        this.accountStatus = this.isVerified ? AccountStatus.Verified : (this.containsSMSSessionStarted(this.consumerSession) ? AccountStatus.VerificationStarted : AccountStatus.NeedsVerification);
    }

    @NotNull
    public final String getRedactedPhoneNumber() {
        return this.redactedPhoneNumber;
    }

    public static /* synthetic */ void getRedactedPhoneNumber$annotations() {
    }

    @NotNull
    public final String getClientSecret() {
        return this.clientSecret;
    }

    public static /* synthetic */ void getClientSecret$annotations() {
    }

    @NotNull
    public final String getEmail() {
        return this.email;
    }

    public static /* synthetic */ void getEmail$annotations() {
    }

    public final boolean isVerified() {
        return this.isVerified;
    }

    public static /* synthetic */ void isVerified$annotations() {
    }

    @NotNull
    public final AccountStatus getAccountStatus() {
        return this.accountStatus;
    }

    public static /* synthetic */ void getAccountStatus$annotations() {
    }

    private final boolean containsSMSSessionStarted(ConsumerSession $this$containsSMSSessionStarted) {
        Object v0;
        block1: {
            Iterable iterable = $this$containsSMSSessionStarted.getVerificationSessions();
            for (Object t : iterable) {
                ConsumerSession.VerificationSession it = (ConsumerSession.VerificationSession)t;
                boolean bl = false;
                if (!(it.getType() == ConsumerSession.VerificationSession.SessionType.Sms && it.getState() == ConsumerSession.VerificationSession.SessionState.Started)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    private final boolean containsVerifiedSMSSession(ConsumerSession $this$containsVerifiedSMSSession) {
        Object v0;
        block1: {
            Iterable iterable = $this$containsVerifiedSMSSession.getVerificationSessions();
            for (Object t : iterable) {
                ConsumerSession.VerificationSession it = (ConsumerSession.VerificationSession)t;
                boolean bl = false;
                if (!(it.getType() == ConsumerSession.VerificationSession.SessionType.Sms && it.getState() == ConsumerSession.VerificationSession.SessionState.Verified)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    private final boolean isVerifiedForSignup(ConsumerSession $this$isVerifiedForSignup) {
        Object v0;
        block1: {
            Iterable iterable = $this$isVerifiedForSignup.getVerificationSessions();
            for (Object t : iterable) {
                ConsumerSession.VerificationSession it = (ConsumerSession.VerificationSession)t;
                boolean bl = false;
                if (!(it.getType() == ConsumerSession.VerificationSession.SessionType.SignUp && it.getState() == ConsumerSession.VerificationSession.SessionState.Started)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    public final void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeParcelable((Parcelable)this.consumerSession, flags);
    }

    public final int describeContents() {
        return 0;
    }

    static {
        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<LinkAccount> {
            public final LinkAccount[] newArray(int size) {
                return new LinkAccount[size];
            }

            public final LinkAccount createFromParcel(Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new LinkAccount((ConsumerSession)parcel.readParcelable(LinkAccount.class.getClassLoader()));
            }
        }
        CREATOR = new Creator();
        $stable = 8;
    }
}

