/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link.injection;

import android.app.Application;
import android.content.Context;
import androidx.lifecycle.SavedStateHandle;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.cards.CardAccountRangeRepository;
import com.stripe.android.cards.DefaultCardAccountRangeRepositoryFactory;
import com.stripe.android.cards.DefaultCardAccountRangeRepositoryFactory_Factory;
import com.stripe.android.common.di.ApplicationIdModule_ProvideApplicationIdFactory;
import com.stripe.android.core.Logger;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.AnalyticsRequestFactory;
import com.stripe.android.core.networking.AnalyticsRequestV2Executor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor_Factory;
import com.stripe.android.core.utils.DurationProvider;
import com.stripe.android.core.utils.RealUserFacingLogger;
import com.stripe.android.core.utils.RealUserFacingLogger_Factory;
import com.stripe.android.link.LinkActivityViewModel;
import com.stripe.android.link.LinkConfiguration;
import com.stripe.android.link.WebLinkActivityContract;
import com.stripe.android.link.account.DefaultLinkAccountManager;
import com.stripe.android.link.account.DefaultLinkAccountManager_Factory;
import com.stripe.android.link.account.DefaultLinkAuth;
import com.stripe.android.link.account.DefaultLinkAuth_Factory;
import com.stripe.android.link.account.LinkAccountHolder;
import com.stripe.android.link.account.LinkAccountManager;
import com.stripe.android.link.account.LinkAuth;
import com.stripe.android.link.analytics.DefaultLinkEventsReporter;
import com.stripe.android.link.analytics.DefaultLinkEventsReporter_Factory;
import com.stripe.android.link.analytics.LinkEventsReporter;
import com.stripe.android.link.attestation.DefaultLinkAttestationCheck;
import com.stripe.android.link.attestation.DefaultLinkAttestationCheck_Factory;
import com.stripe.android.link.attestation.LinkAttestationCheck;
import com.stripe.android.link.confirmation.DefaultLinkConfirmationHandler;
import com.stripe.android.link.confirmation.DefaultLinkConfirmationHandler_Factory_Factory;
import com.stripe.android.link.confirmation.LinkConfirmationHandler;
import com.stripe.android.link.gate.DefaultLinkGate;
import com.stripe.android.link.gate.DefaultLinkGate_Factory;
import com.stripe.android.link.gate.LinkGate;
import com.stripe.android.link.injection.LinkViewModelModule_ProvideLinkActivityViewModelFactory;
import com.stripe.android.link.injection.NativeLinkComponent;
import com.stripe.android.link.injection.NativeLinkModule_Companion_IoContextFactory;
import com.stripe.android.link.injection.NativeLinkModule_Companion_ProvideAllowsManualConfirmationFactory;
import com.stripe.android.link.injection.NativeLinkModule_Companion_ProvideAnalyticsRequestFactoryFactory;
import com.stripe.android.link.injection.NativeLinkModule_Companion_ProvideConsumersApiServiceFactory;
import com.stripe.android.link.injection.NativeLinkModule_Companion_ProvideDurationProviderFactory;
import com.stripe.android.link.injection.NativeLinkModule_Companion_ProvideEventReporterModeFactory;
import com.stripe.android.link.injection.NativeLinkModule_Companion_ProvideIntegrityStandardRequestManagerFactory;
import com.stripe.android.link.injection.NativeLinkModule_Companion_ProvideLinkConfirmationHandlerFactoryFactory;
import com.stripe.android.link.injection.NativeLinkModule_Companion_ProvideLocaleFactory;
import com.stripe.android.link.injection.NativeLinkModule_Companion_ProvideLoggerFactory;
import com.stripe.android.link.injection.NativeLinkModule_Companion_ProvidePaymentConfigurationFactory;
import com.stripe.android.link.injection.NativeLinkModule_Companion_ProvideProductUsageTokensFactory;
import com.stripe.android.link.injection.NativeLinkModule_Companion_ProvidesAnalyticEventCallbackFactory;
import com.stripe.android.link.injection.NativeLinkModule_Companion_ProvidesEnableLoggingFactory;
import com.stripe.android.link.injection.NativeLinkModule_Companion_ProvidesLinkAccountHolderFactory;
import com.stripe.android.link.injection.NativeLinkModule_Companion_ProvidesLinkPassthroughConfirmationDefinitionFactory;
import com.stripe.android.link.model.LinkAccount;
import com.stripe.android.link.repositories.LinkApiRepository;
import com.stripe.android.link.repositories.LinkApiRepository_Factory;
import com.stripe.android.link.repositories.LinkRepository;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory_Factory;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeApiRepository_Factory;
import com.stripe.android.networking.StripeRepository;
import com.stripe.android.paymentelement.AnalyticEventCallback;
import com.stripe.android.paymentelement.confirmation.ConfirmationDefinition;
import com.stripe.android.paymentelement.confirmation.ConfirmationRegistry;
import com.stripe.android.paymentelement.confirmation.DefaultConfirmationHandler;
import com.stripe.android.paymentelement.confirmation.DefaultConfirmationHandler_Factory_Factory;
import com.stripe.android.paymentelement.confirmation.injection.ConfirmationHandlerModule_Companion_ProvidesConfirmationRegistryFactory;
import com.stripe.android.paymentelement.confirmation.intent.DefaultIntentConfirmationInterceptor;
import com.stripe.android.paymentelement.confirmation.intent.DefaultIntentConfirmationInterceptor_Factory;
import com.stripe.android.paymentelement.confirmation.intent.IntentConfirmationModule_Companion_ProvidesCreateIntentCallbackFactory;
import com.stripe.android.paymentelement.confirmation.intent.IntentConfirmationModule_Companion_ProvidesIntentConfirmationDefinitionFactory;
import com.stripe.android.paymentelement.confirmation.link.LinkPassthroughConfirmationDefinition;
import com.stripe.android.paymentelement.confirmation.link.LinkPassthroughConfirmationDefinition_Factory;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import com.stripe.android.payments.core.analytics.RealErrorReporter;
import com.stripe.android.payments.core.analytics.RealErrorReporter_Factory;
import com.stripe.android.payments.core.injection.StripeRepositoryModule_Companion_ProvidesAnalyticsRequestV2ExecutorFactory;
import com.stripe.android.payments.paymentlauncher.StripePaymentLauncherAssistedFactory;
import com.stripe.android.payments.paymentlauncher.StripePaymentLauncherAssistedFactory_Impl;
import com.stripe.android.payments.paymentlauncher.StripePaymentLauncher_Factory;
import com.stripe.android.paymentsheet.CreateIntentCallback;
import com.stripe.android.paymentsheet.analytics.DefaultEventReporter;
import com.stripe.android.paymentsheet.analytics.DefaultEventReporter_Factory;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.repository.ConsumersApiService;
import com.stripe.android.ui.core.IsStripeCardScanAvailable;
import com.stripe.android.ui.core.di.CardScanModule_ProvidesIsStripeCardScanAvailableFactory;
import com.stripe.attestation.IntegrityRequestManager;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import dagger.internal.SetFactory;
import java.util.Locale;
import java.util.Set;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;

@DaggerGenerated
public final class DaggerNativeLinkComponent {
    private DaggerNativeLinkComponent() {
    }

    public static NativeLinkComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements NativeLinkComponent.Builder {
        private LinkConfiguration configuration;
        private Function0<String> publishableKeyProvider;
        private Function0<String> stripeAccountIdProvider;
        private String paymentElementCallbackIdentifier;
        private Context context;
        private SavedStateHandle savedStateHandle;
        private Integer statusBarColor;
        private Application application;
        private Boolean startWithVerificationDialog;
        private LinkAccount linkAccount;

        private Builder() {
        }

        @Override
        public Builder configuration(LinkConfiguration configuration) {
            this.configuration = (LinkConfiguration)Preconditions.checkNotNull((Object)configuration);
            return this;
        }

        @Override
        public Builder publishableKeyProvider(Function0<String> publishableKeyProvider) {
            this.publishableKeyProvider = (Function0)Preconditions.checkNotNull(publishableKeyProvider);
            return this;
        }

        @Override
        public Builder stripeAccountIdProvider(Function0<String> stripeAccountIdProvider) {
            this.stripeAccountIdProvider = (Function0)Preconditions.checkNotNull(stripeAccountIdProvider);
            return this;
        }

        @Override
        public Builder paymentElementCallbackIdentifier(String paymentElementCallbackIdentifier) {
            this.paymentElementCallbackIdentifier = (String)Preconditions.checkNotNull((Object)paymentElementCallbackIdentifier);
            return this;
        }

        @Override
        public Builder context(Context context) {
            this.context = (Context)Preconditions.checkNotNull((Object)context);
            return this;
        }

        @Override
        public Builder savedStateHandle(SavedStateHandle savedStateHandle) {
            this.savedStateHandle = (SavedStateHandle)Preconditions.checkNotNull((Object)savedStateHandle);
            return this;
        }

        @Override
        public Builder statusBarColor(Integer statusBarColor) {
            this.statusBarColor = statusBarColor;
            return this;
        }

        @Override
        public Builder application(Application application) {
            this.application = (Application)Preconditions.checkNotNull((Object)application);
            return this;
        }

        @Override
        public Builder startWithVerificationDialog(boolean startWithVerificationDialog) {
            this.startWithVerificationDialog = (Boolean)Preconditions.checkNotNull((Object)startWithVerificationDialog);
            return this;
        }

        @Override
        public Builder linkAccount(LinkAccount linkAccount) {
            this.linkAccount = linkAccount;
            return this;
        }

        @Override
        public NativeLinkComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.configuration, LinkConfiguration.class);
            Preconditions.checkBuilderRequirement(this.publishableKeyProvider, Function0.class);
            Preconditions.checkBuilderRequirement(this.stripeAccountIdProvider, Function0.class);
            Preconditions.checkBuilderRequirement((Object)this.paymentElementCallbackIdentifier, String.class);
            Preconditions.checkBuilderRequirement((Object)this.context, Context.class);
            Preconditions.checkBuilderRequirement((Object)this.savedStateHandle, SavedStateHandle.class);
            Preconditions.checkBuilderRequirement((Object)this.application, Application.class);
            Preconditions.checkBuilderRequirement((Object)this.startWithVerificationDialog, Boolean.class);
            return new NativeLinkComponentImpl(this.configuration, this.publishableKeyProvider, this.stripeAccountIdProvider, this.paymentElementCallbackIdentifier, this.context, this.savedStateHandle, this.statusBarColor, this.application, this.startWithVerificationDialog, this.linkAccount);
        }
    }

    private static final class NativeLinkComponentImpl
    implements NativeLinkComponent {
        private final LinkConfiguration configuration;
        private final Context context;
        private final Function0<String> publishableKeyProvider2;
        private final SavedStateHandle savedStateHandle;
        private final NativeLinkComponentImpl nativeLinkComponentImpl = this;
        private Provider<SavedStateHandle> savedStateHandleProvider;
        private Provider<LinkAccount> linkAccountProvider;
        private Provider<LinkAccountHolder> providesLinkAccountHolderProvider;
        private Provider<LinkConfiguration> configurationProvider;
        private Provider<Application> applicationProvider;
        private Provider<Function0<String>> publishableKeyProvider;
        private Provider<Function0<String>> stripeAccountIdProvider;
        private Provider<Context> contextProvider;
        private Provider<CoroutineContext> ioContextProvider;
        private Provider<Set<String>> provideProductUsageTokensProvider;
        private Provider<PaymentAnalyticsRequestFactory> paymentAnalyticsRequestFactoryProvider;
        private Provider<Boolean> providesEnableLoggingProvider;
        private Provider<Logger> provideLoggerProvider;
        private Provider<DefaultAnalyticsRequestExecutor> defaultAnalyticsRequestExecutorProvider;
        private Provider<StripeApiRepository> stripeApiRepositoryProvider;
        private Provider<ConsumersApiService> provideConsumersApiServiceProvider;
        private Provider<Locale> provideLocaleProvider;
        private Provider<AnalyticsRequestFactory> provideAnalyticsRequestFactoryProvider;
        private Provider<RealErrorReporter> realErrorReporterProvider;
        private Provider<ErrorReporter> bindsErrorReporterProvider;
        private Provider<LinkApiRepository> linkApiRepositoryProvider;
        private Provider<LinkRepository> bindLinkRepositoryProvider;
        private Provider<DurationProvider> provideDurationProvider;
        private Provider<DefaultLinkEventsReporter> defaultLinkEventsReporterProvider;
        private Provider<LinkEventsReporter> bindLinkEventsReporterProvider;
        private Provider<DefaultLinkAccountManager> defaultLinkAccountManagerProvider;
        private Provider<LinkAccountManager> bindLinkAccountManagerProvider;
        private Provider<DefaultLinkConfirmationHandler.Factory> factoryProvider;
        private Provider<LinkConfirmationHandler.Factory> provideLinkConfirmationHandlerFactoryProvider;
        private Provider<DefaultCardAccountRangeRepositoryFactory> defaultCardAccountRangeRepositoryFactoryProvider;
        private Provider<CardAccountRangeRepository.Factory> bindsCardAccountRangeRepositoryFactoryProvider;
        private Provider<DefaultLinkGate> defaultLinkGateProvider;
        private Provider<LinkGate> bindsLinkGateProvider;
        private Provider<IntegrityRequestManager> provideIntegrityStandardRequestManagerProvider;
        private Provider<String> provideApplicationIdProvider;
        private Provider<DefaultLinkAuth> defaultLinkAuthProvider;
        private Provider<LinkAuth> bindsLinkAuthProvider;
        private Provider<NativeLinkComponent> nativeLinkComponentProvider;
        private Provider<ConfirmationDefinition<?, ?, ?, ?>> providesLinkPassthroughConfirmationDefinitionProvider;
        private Provider<String> paymentElementCallbackIdentifierProvider;
        private Provider<CreateIntentCallback> providesCreateIntentCallbackProvider;
        private Provider<Boolean> provideAllowsManualConfirmationProvider;
        private Provider<DefaultIntentConfirmationInterceptor> defaultIntentConfirmationInterceptorProvider;
        private StripePaymentLauncher_Factory stripePaymentLauncherProvider;
        private Provider<StripePaymentLauncherAssistedFactory> stripePaymentLauncherAssistedFactoryProvider;
        private Provider<Integer> statusBarColorProvider;
        private Provider<PaymentConfiguration> providePaymentConfigurationProvider;
        private Provider<ConfirmationDefinition<?, ?, ?, ?>> providesIntentConfirmationDefinitionProvider;
        private Provider<LinkPassthroughConfirmationDefinition> linkPassthroughConfirmationDefinitionProvider;
        private Provider<Set<ConfirmationDefinition<?, ?, ?, ?>>> setOfConfirmationDefinitionOfAndAndAndProvider;
        private Provider<ConfirmationRegistry> providesConfirmationRegistryProvider;
        private Provider<DefaultConfirmationHandler.Factory> factoryProvider2;
        private Provider<EventReporter.Mode> provideEventReporterModeProvider;
        private Provider<AnalyticsRequestV2Executor> providesAnalyticsRequestV2ExecutorProvider;
        private Provider<AnalyticEventCallback> providesAnalyticEventCallbackProvider;
        private Provider<RealUserFacingLogger> realUserFacingLoggerProvider;
        private Provider<DefaultEventReporter> defaultEventReporterProvider;
        private Provider<EventReporter> bindsEventReporterProvider;
        private Provider<DefaultLinkAttestationCheck> defaultLinkAttestationCheckProvider;
        private Provider<LinkAttestationCheck> bindsLinkAttestationCheckProvider;
        private Provider<Boolean> startWithVerificationDialogProvider;
        private Provider<LinkActivityViewModel> provideLinkActivityViewModelProvider;

        private NativeLinkComponentImpl(LinkConfiguration configurationParam, Function0<String> publishableKeyProviderParam, Function0<String> stripeAccountIdProviderParam, String paymentElementCallbackIdentifierParam, Context contextParam, SavedStateHandle savedStateHandleParam, Integer statusBarColorParam, Application applicationParam, Boolean startWithVerificationDialogParam, LinkAccount linkAccountParam) {
            this.configuration = configurationParam;
            this.context = contextParam;
            this.publishableKeyProvider2 = publishableKeyProviderParam;
            this.savedStateHandle = savedStateHandleParam;
            this.initialize(configurationParam, publishableKeyProviderParam, stripeAccountIdProviderParam, paymentElementCallbackIdentifierParam, contextParam, savedStateHandleParam, statusBarColorParam, applicationParam, startWithVerificationDialogParam, linkAccountParam);
            this.initialize2(configurationParam, publishableKeyProviderParam, stripeAccountIdProviderParam, paymentElementCallbackIdentifierParam, contextParam, savedStateHandleParam, statusBarColorParam, applicationParam, startWithVerificationDialogParam, linkAccountParam);
            this.initialize3(configurationParam, publishableKeyProviderParam, stripeAccountIdProviderParam, paymentElementCallbackIdentifierParam, contextParam, savedStateHandleParam, statusBarColorParam, applicationParam, startWithVerificationDialogParam, linkAccountParam);
        }

        private PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory() {
            return new PaymentAnalyticsRequestFactory(this.context, this.publishableKeyProvider2, (Set)this.provideProductUsageTokensProvider.get());
        }

        private DefaultAnalyticsRequestExecutor defaultAnalyticsRequestExecutor() {
            return new DefaultAnalyticsRequestExecutor((Logger)this.provideLoggerProvider.get(), (CoroutineContext)this.ioContextProvider.get());
        }

        private StripeApiRepository stripeApiRepository() {
            return new StripeApiRepository(this.context, this.publishableKeyProvider2, (CoroutineContext)this.ioContextProvider.get(), (Set)this.provideProductUsageTokensProvider.get(), this.paymentAnalyticsRequestFactory(), (AnalyticsRequestExecutor)this.defaultAnalyticsRequestExecutor(), (Logger)this.provideLoggerProvider.get());
        }

        private void initialize(LinkConfiguration configurationParam, Function0<String> publishableKeyProviderParam, Function0<String> stripeAccountIdProviderParam, String paymentElementCallbackIdentifierParam, Context contextParam, SavedStateHandle savedStateHandleParam, Integer statusBarColorParam, Application applicationParam, Boolean startWithVerificationDialogParam, LinkAccount linkAccountParam) {
            this.savedStateHandleProvider = InstanceFactory.create((Object)savedStateHandleParam);
            this.linkAccountProvider = InstanceFactory.createNullable((Object)linkAccountParam);
            this.providesLinkAccountHolderProvider = DoubleCheck.provider((Provider)NativeLinkModule_Companion_ProvidesLinkAccountHolderFactory.create(this.savedStateHandleProvider, this.linkAccountProvider));
            this.configurationProvider = InstanceFactory.create((Object)configurationParam);
            this.applicationProvider = InstanceFactory.create((Object)applicationParam);
            this.publishableKeyProvider = InstanceFactory.create(publishableKeyProviderParam);
            this.stripeAccountIdProvider = InstanceFactory.create(stripeAccountIdProviderParam);
            this.contextProvider = InstanceFactory.create((Object)contextParam);
            this.ioContextProvider = DoubleCheck.provider((Provider)NativeLinkModule_Companion_IoContextFactory.create());
            this.provideProductUsageTokensProvider = DoubleCheck.provider((Provider)NativeLinkModule_Companion_ProvideProductUsageTokensFactory.create());
            this.paymentAnalyticsRequestFactoryProvider = PaymentAnalyticsRequestFactory_Factory.create(this.contextProvider, this.publishableKeyProvider, this.provideProductUsageTokensProvider);
            this.providesEnableLoggingProvider = DoubleCheck.provider((Provider)NativeLinkModule_Companion_ProvidesEnableLoggingFactory.create());
            this.provideLoggerProvider = DoubleCheck.provider((Provider)NativeLinkModule_Companion_ProvideLoggerFactory.create(this.providesEnableLoggingProvider));
            this.defaultAnalyticsRequestExecutorProvider = DefaultAnalyticsRequestExecutor_Factory.create(this.provideLoggerProvider, this.ioContextProvider);
            this.stripeApiRepositoryProvider = StripeApiRepository_Factory.create(this.contextProvider, this.publishableKeyProvider, this.ioContextProvider, this.provideProductUsageTokensProvider, this.paymentAnalyticsRequestFactoryProvider, this.defaultAnalyticsRequestExecutorProvider, this.provideLoggerProvider);
            this.provideConsumersApiServiceProvider = DoubleCheck.provider((Provider)NativeLinkModule_Companion_ProvideConsumersApiServiceFactory.create(this.provideLoggerProvider, this.ioContextProvider));
            this.provideLocaleProvider = DoubleCheck.provider((Provider)NativeLinkModule_Companion_ProvideLocaleFactory.create());
            this.provideAnalyticsRequestFactoryProvider = DoubleCheck.provider((Provider)NativeLinkModule_Companion_ProvideAnalyticsRequestFactoryFactory.create(this.contextProvider, this.publishableKeyProvider));
            this.realErrorReporterProvider = RealErrorReporter_Factory.create(this.defaultAnalyticsRequestExecutorProvider, this.provideAnalyticsRequestFactoryProvider);
            this.bindsErrorReporterProvider = DoubleCheck.provider(this.realErrorReporterProvider);
            this.linkApiRepositoryProvider = LinkApiRepository_Factory.create(this.applicationProvider, this.publishableKeyProvider, this.stripeAccountIdProvider, this.stripeApiRepositoryProvider, this.provideConsumersApiServiceProvider, this.ioContextProvider, this.provideLocaleProvider, this.bindsErrorReporterProvider);
            this.bindLinkRepositoryProvider = DoubleCheck.provider(this.linkApiRepositoryProvider);
            this.provideDurationProvider = DoubleCheck.provider((Provider)NativeLinkModule_Companion_ProvideDurationProviderFactory.create());
            this.defaultLinkEventsReporterProvider = DefaultLinkEventsReporter_Factory.create(this.defaultAnalyticsRequestExecutorProvider, this.paymentAnalyticsRequestFactoryProvider, this.bindsErrorReporterProvider, this.ioContextProvider, this.provideLoggerProvider, this.provideDurationProvider);
            this.bindLinkEventsReporterProvider = DoubleCheck.provider(this.defaultLinkEventsReporterProvider);
        }

        private void initialize2(LinkConfiguration configurationParam, Function0<String> publishableKeyProviderParam, Function0<String> stripeAccountIdProviderParam, String paymentElementCallbackIdentifierParam, Context contextParam, SavedStateHandle savedStateHandleParam, Integer statusBarColorParam, Application applicationParam, Boolean startWithVerificationDialogParam, LinkAccount linkAccountParam) {
            this.defaultLinkAccountManagerProvider = DefaultLinkAccountManager_Factory.create(this.providesLinkAccountHolderProvider, this.configurationProvider, this.bindLinkRepositoryProvider, this.bindLinkEventsReporterProvider, this.bindsErrorReporterProvider);
            this.bindLinkAccountManagerProvider = DoubleCheck.provider(this.defaultLinkAccountManagerProvider);
            this.factoryProvider = DefaultLinkConfirmationHandler_Factory_Factory.create(this.configurationProvider, this.provideLoggerProvider);
            this.provideLinkConfirmationHandlerFactoryProvider = DoubleCheck.provider((Provider)NativeLinkModule_Companion_ProvideLinkConfirmationHandlerFactoryFactory.create(this.factoryProvider));
            this.defaultCardAccountRangeRepositoryFactoryProvider = DefaultCardAccountRangeRepositoryFactory_Factory.create(this.contextProvider, this.defaultAnalyticsRequestExecutorProvider);
            this.bindsCardAccountRangeRepositoryFactoryProvider = DoubleCheck.provider(this.defaultCardAccountRangeRepositoryFactoryProvider);
            this.defaultLinkGateProvider = DefaultLinkGate_Factory.create(this.configurationProvider);
            this.bindsLinkGateProvider = DoubleCheck.provider(this.defaultLinkGateProvider);
            this.provideIntegrityStandardRequestManagerProvider = DoubleCheck.provider((Provider)NativeLinkModule_Companion_ProvideIntegrityStandardRequestManagerFactory.create(this.applicationProvider));
            this.provideApplicationIdProvider = ApplicationIdModule_ProvideApplicationIdFactory.create(this.applicationProvider);
            this.defaultLinkAuthProvider = DefaultLinkAuth_Factory.create(this.bindsLinkGateProvider, this.bindLinkAccountManagerProvider, this.provideIntegrityStandardRequestManagerProvider, this.bindsErrorReporterProvider, this.provideApplicationIdProvider);
            this.bindsLinkAuthProvider = DoubleCheck.provider(this.defaultLinkAuthProvider);
            this.nativeLinkComponentProvider = InstanceFactory.create((Object)this.nativeLinkComponentImpl);
            this.providesLinkPassthroughConfirmationDefinitionProvider = NativeLinkModule_Companion_ProvidesLinkPassthroughConfirmationDefinitionFactory.create(this.defaultLinkAccountManagerProvider);
            this.paymentElementCallbackIdentifierProvider = InstanceFactory.create((Object)paymentElementCallbackIdentifierParam);
            this.providesCreateIntentCallbackProvider = IntentConfirmationModule_Companion_ProvidesCreateIntentCallbackFactory.create(this.paymentElementCallbackIdentifierProvider);
            this.provideAllowsManualConfirmationProvider = DoubleCheck.provider((Provider)NativeLinkModule_Companion_ProvideAllowsManualConfirmationFactory.create());
            this.defaultIntentConfirmationInterceptorProvider = DefaultIntentConfirmationInterceptor_Factory.create(this.stripeApiRepositoryProvider, this.bindsErrorReporterProvider, this.providesCreateIntentCallbackProvider, this.provideAllowsManualConfirmationProvider, this.publishableKeyProvider, this.stripeAccountIdProvider);
            this.stripePaymentLauncherProvider = StripePaymentLauncher_Factory.create(this.providesEnableLoggingProvider, this.provideProductUsageTokensProvider);
            this.stripePaymentLauncherAssistedFactoryProvider = StripePaymentLauncherAssistedFactory_Impl.createFactoryProvider((StripePaymentLauncher_Factory)this.stripePaymentLauncherProvider);
            this.statusBarColorProvider = InstanceFactory.createNullable((Object)statusBarColorParam);
            this.providePaymentConfigurationProvider = DoubleCheck.provider((Provider)NativeLinkModule_Companion_ProvidePaymentConfigurationFactory.create(this.contextProvider));
            this.providesIntentConfirmationDefinitionProvider = IntentConfirmationModule_Companion_ProvidesIntentConfirmationDefinitionFactory.create(this.defaultIntentConfirmationInterceptorProvider, this.stripePaymentLauncherAssistedFactoryProvider, this.statusBarColorProvider, this.providePaymentConfigurationProvider);
            this.linkPassthroughConfirmationDefinitionProvider = LinkPassthroughConfirmationDefinition_Factory.create(this.bindLinkAccountManagerProvider);
            this.setOfConfirmationDefinitionOfAndAndAndProvider = SetFactory.builder((int)3, (int)0).addProvider(this.providesLinkPassthroughConfirmationDefinitionProvider).addProvider(this.providesIntentConfirmationDefinitionProvider).addProvider(this.linkPassthroughConfirmationDefinitionProvider).build();
        }

        private void initialize3(LinkConfiguration configurationParam, Function0<String> publishableKeyProviderParam, Function0<String> stripeAccountIdProviderParam, String paymentElementCallbackIdentifierParam, Context contextParam, SavedStateHandle savedStateHandleParam, Integer statusBarColorParam, Application applicationParam, Boolean startWithVerificationDialogParam, LinkAccount linkAccountParam) {
            this.providesConfirmationRegistryProvider = ConfirmationHandlerModule_Companion_ProvidesConfirmationRegistryFactory.create(this.setOfConfirmationDefinitionOfAndAndAndProvider);
            this.factoryProvider2 = DefaultConfirmationHandler_Factory_Factory.create(this.providesConfirmationRegistryProvider, this.savedStateHandleProvider, this.bindsErrorReporterProvider);
            this.provideEventReporterModeProvider = DoubleCheck.provider((Provider)NativeLinkModule_Companion_ProvideEventReporterModeFactory.create());
            this.providesAnalyticsRequestV2ExecutorProvider = StripeRepositoryModule_Companion_ProvidesAnalyticsRequestV2ExecutorFactory.create(this.contextProvider, this.ioContextProvider, this.provideLoggerProvider);
            this.providesAnalyticEventCallbackProvider = NativeLinkModule_Companion_ProvidesAnalyticEventCallbackFactory.create(this.paymentElementCallbackIdentifierProvider);
            this.realUserFacingLoggerProvider = RealUserFacingLogger_Factory.create(this.contextProvider);
            this.defaultEventReporterProvider = DefaultEventReporter_Factory.create(this.contextProvider, this.provideEventReporterModeProvider, this.defaultAnalyticsRequestExecutorProvider, this.providesAnalyticsRequestV2ExecutorProvider, this.paymentAnalyticsRequestFactoryProvider, this.provideDurationProvider, this.providesAnalyticEventCallbackProvider, this.ioContextProvider, (Provider<IsStripeCardScanAvailable>)CardScanModule_ProvidesIsStripeCardScanAvailableFactory.create(), this.realUserFacingLoggerProvider);
            this.bindsEventReporterProvider = DoubleCheck.provider(this.defaultEventReporterProvider);
            this.defaultLinkAttestationCheckProvider = DefaultLinkAttestationCheck_Factory.create(this.bindsLinkGateProvider, this.bindsLinkAuthProvider, this.provideIntegrityStandardRequestManagerProvider, this.bindLinkAccountManagerProvider, this.configurationProvider, this.bindsErrorReporterProvider, this.ioContextProvider);
            this.bindsLinkAttestationCheckProvider = DoubleCheck.provider(this.defaultLinkAttestationCheckProvider);
            this.startWithVerificationDialogProvider = InstanceFactory.create((Object)startWithVerificationDialogParam);
            this.provideLinkActivityViewModelProvider = DoubleCheck.provider((Provider)LinkViewModelModule_ProvideLinkActivityViewModelFactory.create(this.nativeLinkComponentProvider, this.factoryProvider2, this.bindLinkAccountManagerProvider, this.providesLinkAccountHolderProvider, this.bindsEventReporterProvider, this.configurationProvider, this.bindsLinkAttestationCheckProvider, this.savedStateHandleProvider, this.startWithVerificationDialogProvider));
        }

        @Override
        public LinkAccountManager getLinkAccountManager() {
            return (LinkAccountManager)this.bindLinkAccountManagerProvider.get();
        }

        @Override
        public LinkConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        public LinkEventsReporter getLinkEventsReporter() {
            return (LinkEventsReporter)this.bindLinkEventsReporterProvider.get();
        }

        @Override
        public ErrorReporter getErrorReporter() {
            return (ErrorReporter)this.bindsErrorReporterProvider.get();
        }

        @Override
        public Logger getLogger() {
            return (Logger)this.provideLoggerProvider.get();
        }

        @Override
        public LinkConfirmationHandler.Factory getLinkConfirmationHandlerFactory() {
            return (LinkConfirmationHandler.Factory)this.provideLinkConfirmationHandlerFactoryProvider.get();
        }

        @Override
        public WebLinkActivityContract getWebLinkActivityContract() {
            return new WebLinkActivityContract((StripeRepository)this.stripeApiRepository(), (ErrorReporter)this.bindsErrorReporterProvider.get());
        }

        @Override
        public CardAccountRangeRepository.Factory getCardAccountRangeRepositoryFactory() {
            return (CardAccountRangeRepository.Factory)this.bindsCardAccountRangeRepositoryFactoryProvider.get();
        }

        @Override
        public LinkAuth getLinkAuth() {
            return (LinkAuth)this.bindsLinkAuthProvider.get();
        }

        @Override
        public SavedStateHandle getSavedStateHandle() {
            return this.savedStateHandle;
        }

        @Override
        public LinkActivityViewModel getViewModel() {
            return (LinkActivityViewModel)((Object)this.provideLinkActivityViewModelProvider.get());
        }

        @Override
        public EventReporter getEventReporter() {
            return (EventReporter)this.bindsEventReporterProvider.get();
        }
    }
}

