/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link.gate;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.utils.FeatureFlag;
import com.stripe.android.core.utils.FeatureFlags;
import com.stripe.android.link.LinkConfiguration;
import com.stripe.android.link.gate.LinkGate;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001:\u0001\u000eB\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/link/gate/DefaultLinkGate;", "Lcom/stripe/android/link/gate/LinkGate;", "configuration", "Lcom/stripe/android/link/LinkConfiguration;", "<init>", "(Lcom/stripe/android/link/LinkConfiguration;)V", "useNativeLink", "", "getUseNativeLink", "()Z", "useAttestationEndpoints", "getUseAttestationEndpoints", "suppress2faModal", "getSuppress2faModal", "Factory", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class DefaultLinkGate
implements LinkGate {
    @NotNull
    private final LinkConfiguration configuration;
    public static final int $stable = 8;

    @Inject
    public DefaultLinkGate(@NotNull LinkConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.configuration = configuration;
    }

    @Override
    public boolean getUseNativeLink() {
        boolean bl;
        if (this.configuration.getStripeIntent().isLiveMode()) {
            return this.getUseAttestationEndpoints();
        }
        FeatureFlag.Flag flag = FeatureFlags.INSTANCE.getNativeLinkEnabled().getValue();
        if (Intrinsics.areEqual((Object)flag, (Object)FeatureFlag.Flag.Disabled.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)flag, (Object)FeatureFlag.Flag.Enabled.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)flag, (Object)FeatureFlag.Flag.NotSet.INSTANCE)) {
            bl = this.getUseAttestationEndpoints();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public boolean getUseAttestationEndpoints() {
        boolean bl;
        if (this.configuration.getStripeIntent().isLiveMode()) {
            return this.configuration.getUseAttestationEndpointsForLink();
        }
        FeatureFlag.Flag flag = FeatureFlags.INSTANCE.getNativeLinkAttestationEnabled().getValue();
        if (Intrinsics.areEqual((Object)flag, (Object)FeatureFlag.Flag.Disabled.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)flag, (Object)FeatureFlag.Flag.Enabled.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)flag, (Object)FeatureFlag.Flag.NotSet.INSTANCE)) {
            bl = this.configuration.getUseAttestationEndpointsForLink();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public boolean getSuppress2faModal() {
        return !this.getUseNativeLink() || this.configuration.getSuppress2faModal();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/link/gate/DefaultLinkGate$Factory;", "Lcom/stripe/android/link/gate/LinkGate$Factory;", "<init>", "()V", "create", "Lcom/stripe/android/link/gate/LinkGate;", "configuration", "Lcom/stripe/android/link/LinkConfiguration;", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static final class Factory
    implements LinkGate.Factory {
        public static final int $stable;

        @Inject
        public Factory() {
        }

        @Override
        @NotNull
        public LinkGate create(@NotNull LinkConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            return new DefaultLinkGate(configuration);
        }
    }
}

