/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.os.BundleCompat;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.link.LinkAccountUpdate;
import com.stripe.android.link.LinkActivity;
import com.stripe.android.link.LinkActivityContract;
import com.stripe.android.link.LinkActivityResult;
import com.stripe.android.link.LinkConfiguration;
import com.stripe.android.link.NativeLinkArgs;
import com.stripe.android.link.model.LinkAccount;
import com.stripe.android.paymentelement.callbacks.PaymentElementCallbackIdentifier;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0001\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0013\b\u0007\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001a\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/link/NativeLinkActivityContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/stripe/android/link/LinkActivityContract$Args;", "Lcom/stripe/android/link/LinkActivityResult;", "paymentElementCallbackIdentifier", "", "<init>", "(Ljava/lang/String;)V", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "parseResult", "resultCode", "", "intent", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class NativeLinkActivityContract
extends ActivityResultContract<LinkActivityContract.Args, LinkActivityResult> {
    @NotNull
    private final String paymentElementCallbackIdentifier;
    public static final int $stable;

    @Inject
    public NativeLinkActivityContract(@PaymentElementCallbackIdentifier @NotNull String paymentElementCallbackIdentifier) {
        Intrinsics.checkNotNullParameter((Object)paymentElementCallbackIdentifier, (String)"paymentElementCallbackIdentifier");
        this.paymentElementCallbackIdentifier = paymentElementCallbackIdentifier;
    }

    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull LinkActivityContract.Args input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        PaymentConfiguration paymentConfiguration = PaymentConfiguration.Companion.getInstance(context);
        LinkConfiguration linkConfiguration = input.getConfiguration$paymentsheet_release();
        String string2 = paymentConfiguration.getStripeAccountId();
        String string3 = paymentConfiguration.getPublishableKey();
        boolean bl = input.getStartWithVerificationDialog$paymentsheet_release();
        String string4 = this.paymentElementCallbackIdentifier;
        LinkAccount linkAccount = input.getLinkAccount$paymentsheet_release();
        return LinkActivity.Companion.createIntent$paymentsheet_release(context, new NativeLinkArgs(linkConfiguration, string3, string2, bl, linkAccount, string4));
    }

    @NotNull
    public LinkActivityResult parseResult(int resultCode, @Nullable Intent intent) {
        LinkActivityResult linkActivityResult;
        switch (resultCode) {
            case 0: {
                linkActivityResult = new LinkActivityResult.Canceled(null, LinkAccountUpdate.None.INSTANCE, 1, null);
                break;
            }
            case 73563: {
                LinkActivityResult result2;
                LinkActivityResult linkActivityResult2;
                LinkActivityResult linkActivityResult3;
                Intent intent2 = intent;
                if (intent2 != null && (intent2 = intent2.getExtras()) != null) {
                    Intent it = intent2;
                    boolean bl = false;
                    linkActivityResult3 = (LinkActivityResult)BundleCompat.getParcelable((Bundle)it, (String)"com.stripe.android.link.LinkActivityContract.extra_result", LinkActivityResult.class);
                } else {
                    linkActivityResult3 = null;
                }
                if ((linkActivityResult2 = (result2 = linkActivityResult3)) == null) {
                    linkActivityResult2 = new LinkActivityResult.Canceled(null, LinkAccountUpdate.None.INSTANCE, 1, null);
                }
                return linkActivityResult2;
            }
            default: {
                linkActivityResult = new LinkActivityResult.Canceled(null, LinkAccountUpdate.None.INSTANCE, 1, null);
            }
        }
        return linkActivityResult;
    }
}

