/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.link;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.activity.ComponentActivity;
import androidx.activity.OnBackPressedDispatcher;
import androidx.activity.compose.ComponentActivityKt;
import androidx.activity.result.ActivityResultCaller;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.os.BundleKt;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.stripe.android.core.Logger;
import com.stripe.android.link.LinkActivityContract;
import com.stripe.android.link.LinkActivityResult;
import com.stripe.android.link.LinkActivityViewModel;
import com.stripe.android.link.LinkConfiguration;
import com.stripe.android.link.LinkScreenContentKt;
import com.stripe.android.link.NativeLinkArgs;
import com.stripe.android.link.NoArgsException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0014J\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eR$\u0010\u0004\u001a\u00020\u00058\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/stripe/android/link/LinkActivity;", "Landroidx/activity/ComponentActivity;", "<init>", "()V", "viewModelFactory", "Landroidx/lifecycle/ViewModelProvider$Factory;", "getViewModelFactory$paymentsheet_release$annotations", "getViewModelFactory$paymentsheet_release", "()Landroidx/lifecycle/ViewModelProvider$Factory;", "setViewModelFactory$paymentsheet_release", "(Landroidx/lifecycle/ViewModelProvider$Factory;)V", "viewModel", "Lcom/stripe/android/link/LinkActivityViewModel;", "getViewModel$paymentsheet_release", "()Lcom/stripe/android/link/LinkActivityViewModel;", "setViewModel$paymentsheet_release", "(Lcom/stripe/android/link/LinkActivityViewModel;)V", "webLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/link/LinkActivityContract$Args;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "dismissWithResult", "result", "Lcom/stripe/android/link/LinkActivityResult;", "onDestroy", "launchWebFlow", "configuration", "Lcom/stripe/android/link/LinkConfiguration;", "Companion", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class LinkActivity
extends ComponentActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ViewModelProvider.Factory viewModelFactory = LinkActivityViewModel.Companion.factory$default(LinkActivityViewModel.Companion, null, 1, null);
    @Nullable
    private LinkActivityViewModel viewModel;
    @Nullable
    private ActivityResultLauncher<LinkActivityContract.Args> webLauncher;
    public static final int $stable = 8;
    @NotNull
    public static final String EXTRA_ARGS = "native_link_args";
    public static final int RESULT_COMPLETE = 73563;

    @NotNull
    public final ViewModelProvider.Factory getViewModelFactory$paymentsheet_release() {
        return this.viewModelFactory;
    }

    public final void setViewModelFactory$paymentsheet_release(@NotNull ViewModelProvider.Factory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"<set-?>");
        this.viewModelFactory = factory;
    }

    @VisibleForTesting
    public static /* synthetic */ void getViewModelFactory$paymentsheet_release$annotations() {
    }

    @Nullable
    public final LinkActivityViewModel getViewModel$paymentsheet_release() {
        return this.viewModel;
    }

    public final void setViewModel$paymentsheet_release(@Nullable LinkActivityViewModel linkActivityViewModel) {
        this.viewModel = linkActivityViewModel;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.viewModel = (LinkActivityViewModel)new ViewModelProvider((ViewModelStoreOwner)this, this.viewModelFactory).get(LinkActivityViewModel.class);
        }
        catch (NoArgsException e) {
            Logger.Companion.getInstance(false).error("Failed to create LinkActivityViewModel", (Throwable)e);
            this.setResult(0);
            this.finish();
        }
        LinkActivityViewModel linkActivityViewModel = this.viewModel;
        if (linkActivityViewModel == null) {
            return;
        }
        LinkActivityViewModel vm = linkActivityViewModel;
        vm.registerActivityForConfirmation((ActivityResultCaller)this, (LifecycleOwner)this);
        this.webLauncher = this.registerForActivityResult(vm.getActivityRetainedComponent().getWebLinkActivityContract(), arg_0 -> LinkActivity.onCreate$lambda$0(this, arg_0));
        vm.setLaunchWebFlow((Function1<? super LinkConfiguration, Unit>)((Function1)new Function1<LinkConfiguration, Unit>((Object)this){

            public final void invoke(LinkConfiguration p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((LinkActivity)((Object)this.receiver)).launchWebFlow(p0);
            }
        }));
        vm.setDismissWithResult((Function1<? super LinkActivityResult, Unit>)((Function1)new Function1<LinkActivityResult, Unit>((Object)this){

            public final void invoke(LinkActivityResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                LinkActivity.access$dismissWithResult((LinkActivity)((Object)this.receiver), p0);
            }
        }));
        this.getLifecycle().addObserver((LifecycleObserver)vm);
        ComponentActivityKt.setContent$default((ComponentActivity)this, null, (Function2)((Function2)ComposableLambdaKt.composableLambdaInstance((int)1514588233, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(vm, this){
            final /* synthetic */ LinkActivityViewModel $vm;
            final /* synthetic */ LinkActivity this$0;
            {
                this.$vm = $vm;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            @Composable
            @ComposableTarget(applier="androidx.compose.ui.UiComposable")
            public final void invoke(Composer $composer, int $changed) {
                if (($changed & 3) != 2 || !$composer.getSkipping()) {
                    Object object;
                    void $this$cache$iv;
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventStart((int)1514588233, (int)$changed, (int)-1, (String)"com.stripe.android.link.LinkActivity.onCreate.<anonymous> (LinkActivity.kt:50)");
                    }
                    LinkActivityViewModel linkActivityViewModel = this.$vm;
                    OnBackPressedDispatcher onBackPressedDispatcher = this.this$0.getOnBackPressedDispatcher();
                    $composer.startReplaceGroup(2139275748);
                    Composer composer = $composer;
                    boolean invalid$iv = $composer.changedInstance((Object)onBackPressedDispatcher);
                    boolean $i$f$cache = false;
                    Object it$iv = $this$cache$iv.rememberedValue();
                    boolean bl = false;
                    if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
                        LinkActivityViewModel linkActivityViewModel2 = linkActivityViewModel;
                        boolean bl2 = false;
                        linkActivityViewModel = linkActivityViewModel2;
                        KFunction value$iv = (KFunction)new Function0<Unit>((Object)onBackPressedDispatcher){

                            public final void invoke() {
                                ((OnBackPressedDispatcher)this.receiver).onBackPressed();
                            }
                        };
                        $this$cache$iv.updateRememberedValue((Object)value$iv);
                        object = value$iv;
                    } else {
                        object = it$iv;
                    }
                    KFunction kFunction = (KFunction)object;
                    $composer.endReplaceGroup();
                    LinkScreenContentKt.LinkScreenContent(linkActivityViewModel, (Function0<Unit>)((Function0)kFunction), $composer, 0);
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventEnd();
                    }
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        })), (int)1, null);
    }

    private final void dismissWithResult(LinkActivityResult result2) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"com.stripe.android.link.LinkActivityContract.extra_result", (Object)result2)};
        Bundle bundle = BundleKt.bundleOf((Pair[])pairArray);
        this.setResult(73563, new Intent().putExtras(bundle));
        this.finish();
    }

    protected void onDestroy() {
        block0: {
            super.onDestroy();
            LinkActivityViewModel linkActivityViewModel = this.viewModel;
            if (linkActivityViewModel == null) break block0;
            linkActivityViewModel.unregisterActivity();
        }
    }

    public final void launchWebFlow(@NotNull LinkConfiguration configuration) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            ActivityResultLauncher<LinkActivityContract.Args> activityResultLauncher2 = this.webLauncher;
            if (activityResultLauncher2 == null) break block0;
            activityResultLauncher2.launch((Object)new LinkActivityContract.Args(configuration, false, null));
        }
    }

    private static final void onCreate$lambda$0(LinkActivity this$0, LinkActivityResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this$0.dismissWithResult(result2);
    }

    public static final /* synthetic */ void access$dismissWithResult(LinkActivity $this, LinkActivityResult result2) {
        $this.dismissWithResult(result2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/link/LinkActivity$Companion;", "", "<init>", "()V", "EXTRA_ARGS", "", "RESULT_COMPLETE", "", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "args", "Lcom/stripe/android/link/NativeLinkArgs;", "createIntent$paymentsheet_release", "getArgs", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "getArgs$paymentsheet_release", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Intent createIntent$paymentsheet_release(@NotNull Context context, @NotNull NativeLinkArgs args) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intent intent = new Intent(context, LinkActivity.class).putExtra(LinkActivity.EXTRA_ARGS, (Parcelable)args);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"putExtra(...)");
            return intent;
        }

        @Nullable
        public final NativeLinkArgs getArgs$paymentsheet_release(@NotNull SavedStateHandle savedStateHandle) {
            Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
            return (NativeLinkArgs)savedStateHandle.get(LinkActivity.EXTRA_ARGS);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

