/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.customersheet.util;

import android.app.Application;
import androidx.activity.ComponentActivity;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.stripe.android.common.coroutines.Single;
import com.stripe.android.common.coroutines.SingleKt;
import com.stripe.android.customersheet.CustomerSheetIntegration;
import com.stripe.android.customersheet.data.CustomerSheetInitializationDataSource;
import com.stripe.android.customersheet.data.CustomerSheetIntentDataSource;
import com.stripe.android.customersheet.data.CustomerSheetPaymentMethodDataSource;
import com.stripe.android.customersheet.data.CustomerSheetSavedSelectionDataSource;
import com.stripe.android.customersheet.data.injection.CustomerAdapterDataSourceComponent;
import com.stripe.android.customersheet.data.injection.CustomerSessionDataSourceComponent;
import com.stripe.android.customersheet.data.injection.DaggerCustomerAdapterDataSourceComponent;
import com.stripe.android.customersheet.data.injection.DaggerCustomerSessionDataSourceComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u0018R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\n\u00a8\u0006 "}, d2={"Lcom/stripe/android/customersheet/util/CustomerSheetHacks;", "", "<init>", "()V", "_initializationDataSource", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/android/customersheet/data/CustomerSheetInitializationDataSource;", "initializationDataSource", "Lcom/stripe/android/common/coroutines/Single;", "getInitializationDataSource", "()Lcom/stripe/android/common/coroutines/Single;", "_paymentMethodDataSource", "Lcom/stripe/android/customersheet/data/CustomerSheetPaymentMethodDataSource;", "paymentMethodDataSource", "getPaymentMethodDataSource", "_savedSelectionDataSource", "Lcom/stripe/android/customersheet/data/CustomerSheetSavedSelectionDataSource;", "savedSelectionDataSource", "getSavedSelectionDataSource", "_intentDataSource", "Lcom/stripe/android/customersheet/data/CustomerSheetIntentDataSource;", "intentDataSource", "getIntentDataSource", "initialize", "", "application", "Landroid/app/Application;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "integration", "Lcom/stripe/android/customersheet/CustomerSheetIntegration;", "clear", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class CustomerSheetHacks {
    @NotNull
    public static final CustomerSheetHacks INSTANCE = new CustomerSheetHacks();
    @NotNull
    private static final MutableStateFlow<CustomerSheetInitializationDataSource> _initializationDataSource = StateFlowKt.MutableStateFlow(null);
    @NotNull
    private static final MutableStateFlow<CustomerSheetPaymentMethodDataSource> _paymentMethodDataSource = StateFlowKt.MutableStateFlow(null);
    @NotNull
    private static final MutableStateFlow<CustomerSheetSavedSelectionDataSource> _savedSelectionDataSource = StateFlowKt.MutableStateFlow(null);
    @NotNull
    private static final MutableStateFlow<CustomerSheetIntentDataSource> _intentDataSource = StateFlowKt.MutableStateFlow(null);
    public static final int $stable = 8;

    private CustomerSheetHacks() {
    }

    @NotNull
    public final Single<CustomerSheetInitializationDataSource> getInitializationDataSource() {
        return SingleKt.asSingle((StateFlow)_initializationDataSource);
    }

    @NotNull
    public final Single<CustomerSheetPaymentMethodDataSource> getPaymentMethodDataSource() {
        return SingleKt.asSingle((StateFlow)_paymentMethodDataSource);
    }

    @NotNull
    public final Single<CustomerSheetSavedSelectionDataSource> getSavedSelectionDataSource() {
        return SingleKt.asSingle((StateFlow)_savedSelectionDataSource);
    }

    @NotNull
    public final Single<CustomerSheetIntentDataSource> getIntentDataSource() {
        return SingleKt.asSingle((StateFlow)_intentDataSource);
    }

    public final void initialize(@NotNull Application application, @NotNull LifecycleOwner lifecycleOwner, @NotNull CustomerSheetIntegration integration) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)integration, (String)"integration");
        CustomerSheetIntegration customerSheetIntegration = integration;
        if (customerSheetIntegration instanceof CustomerSheetIntegration.Adapter) {
            CustomerAdapterDataSourceComponent adapterDataSourceComponent = DaggerCustomerAdapterDataSourceComponent.builder().application(application).adapter(((CustomerSheetIntegration.Adapter)integration).getAdapter()).build();
            _initializationDataSource.setValue((Object)adapterDataSourceComponent.getCustomerSheetInitializationDataSource());
            _paymentMethodDataSource.setValue((Object)adapterDataSourceComponent.getCustomerSheetPaymentMethodDataSource());
            _intentDataSource.setValue((Object)adapterDataSourceComponent.getCustomerSheetIntentDataSource());
            _savedSelectionDataSource.setValue((Object)adapterDataSourceComponent.getCustomerSheetSavedSelectionDataSource());
        } else if (customerSheetIntegration instanceof CustomerSheetIntegration.CustomerSession) {
            CustomerSessionDataSourceComponent customerSessionDataSourceComponent = DaggerCustomerSessionDataSourceComponent.builder().application(application).customerSessionProvider(((CustomerSheetIntegration.CustomerSession)integration).getCustomerSessionProvider()).build();
            _initializationDataSource.setValue((Object)customerSessionDataSourceComponent.getCustomerSheetInitializationDataSource());
            _paymentMethodDataSource.setValue((Object)customerSessionDataSourceComponent.getCustomerSheetPaymentMethodDataSource());
            _intentDataSource.setValue((Object)customerSessionDataSourceComponent.getCustomerSheetIntentDataSource());
            _savedSelectionDataSource.setValue((Object)customerSessionDataSourceComponent.getCustomerSheetSavedSelectionDataSource());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(){

            public void onDestroy(LifecycleOwner owner) {
                boolean isChangingConfigurations;
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                LifecycleOwner lifecycleOwner = owner;
                if (lifecycleOwner instanceof ComponentActivity) {
                    bl = ((ComponentActivity)owner).isChangingConfigurations();
                } else if (lifecycleOwner instanceof Fragment) {
                    FragmentActivity fragmentActivity = ((Fragment)owner).getActivity();
                    bl = fragmentActivity != null ? fragmentActivity.isChangingConfigurations() : false;
                } else {
                    bl = isChangingConfigurations = false;
                }
                if (!isChangingConfigurations) {
                    CustomerSheetHacks.INSTANCE.clear();
                }
                super.onDestroy(owner);
            }
        });
    }

    public final void clear() {
        _initializationDataSource.setValue(null);
        _paymentMethodDataSource.setValue(null);
        _savedSelectionDataSource.setValue(null);
        _intentDataSource.setValue(null);
    }
}

