/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.customersheet.data.injection;

import android.app.Application;
import android.content.Context;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.common.di.ApplicationIdModule_ProvideApplicationIdFactory;
import com.stripe.android.common.di.MobileSessionIdModule;
import com.stripe.android.common.di.MobileSessionIdModule_MobileSessionIdProviderFactory;
import com.stripe.android.core.Logger;
import com.stripe.android.core.injection.CoreCommonModule;
import com.stripe.android.core.injection.CoreCommonModule_ProvideLoggerFactory;
import com.stripe.android.core.injection.CoroutineContextModule;
import com.stripe.android.core.injection.CoroutineContextModule_ProvideWorkContextFactory;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.AnalyticsRequestFactory;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor_Factory;
import com.stripe.android.customersheet.CustomerSheet;
import com.stripe.android.customersheet.data.CustomerSessionElementsSessionManager;
import com.stripe.android.customersheet.data.CustomerSessionInitializationDataSource;
import com.stripe.android.customersheet.data.CustomerSessionIntentDataSource;
import com.stripe.android.customersheet.data.CustomerSessionPaymentMethodDataSource;
import com.stripe.android.customersheet.data.CustomerSessionSavedSelectionDataSource;
import com.stripe.android.customersheet.data.CustomerSheetInitializationDataSource;
import com.stripe.android.customersheet.data.CustomerSheetIntentDataSource;
import com.stripe.android.customersheet.data.CustomerSheetPaymentMethodDataSource;
import com.stripe.android.customersheet.data.CustomerSheetSavedSelectionDataSource;
import com.stripe.android.customersheet.data.DefaultCustomerSessionElementsSessionManager;
import com.stripe.android.customersheet.data.DefaultCustomerSessionElementsSessionManager_Factory;
import com.stripe.android.customersheet.data.injection.CustomerSessionDataSourceComponent;
import com.stripe.android.customersheet.data.injection.CustomerSessionDataSourceModule_Companion_ProvidePrefsRepositoryFactoryFactory;
import com.stripe.android.customersheet.injection.CustomerSheetDataCommonModule_Companion_ProvideAnalyticsRequestFactoryFactory;
import com.stripe.android.customersheet.injection.CustomerSheetDataCommonModule_Companion_ProvidePaymentConfigurationFactory;
import com.stripe.android.customersheet.injection.CustomerSheetDataCommonModule_Companion_ProvidePublishableKeyFactory;
import com.stripe.android.customersheet.injection.CustomerSheetDataCommonModule_Companion_ProvideTimeProviderFactory;
import com.stripe.android.customersheet.injection.CustomerSheetDataCommonModule_Companion_ProvidesEnableLoggingFactory;
import com.stripe.android.customersheet.injection.CustomerSheetDataCommonModule_Companion_ProvidesProductUsageFactory;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory_Factory;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeApiRepository_Factory;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import com.stripe.android.payments.core.analytics.RealErrorReporter;
import com.stripe.android.payments.core.analytics.RealErrorReporter_Factory;
import com.stripe.android.paymentsheet.PrefsRepository;
import com.stripe.android.paymentsheet.repositories.CustomerApiRepository;
import com.stripe.android.paymentsheet.repositories.CustomerApiRepository_Factory;
import com.stripe.android.paymentsheet.repositories.CustomerRepository;
import com.stripe.android.paymentsheet.repositories.RealElementsSessionRepository;
import com.stripe.android.paymentsheet.repositories.RealElementsSessionRepository_Factory;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import java.util.Set;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;

@DaggerGenerated
public final class DaggerCustomerSessionDataSourceComponent {
    private DaggerCustomerSessionDataSourceComponent() {
    }

    public static CustomerSessionDataSourceComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements CustomerSessionDataSourceComponent.Builder {
        private Application application;
        private CustomerSheet.CustomerSessionProvider customerSessionProvider;

        private Builder() {
        }

        @Override
        public Builder application(Application application) {
            this.application = (Application)Preconditions.checkNotNull((Object)application);
            return this;
        }

        @Override
        public Builder customerSessionProvider(CustomerSheet.CustomerSessionProvider customerSessionProvider) {
            this.customerSessionProvider = (CustomerSheet.CustomerSessionProvider)Preconditions.checkNotNull((Object)customerSessionProvider);
            return this;
        }

        @Override
        public CustomerSessionDataSourceComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.application, Application.class);
            Preconditions.checkBuilderRequirement((Object)this.customerSessionProvider, CustomerSheet.CustomerSessionProvider.class);
            return new CustomerSessionDataSourceComponentImpl(new CoroutineContextModule(), new CoreCommonModule(), new MobileSessionIdModule(), this.application, this.customerSessionProvider);
        }
    }

    private static final class CustomerSessionDataSourceComponentImpl
    implements CustomerSessionDataSourceComponent {
        private final Application application;
        private final CustomerSheet.CustomerSessionProvider customerSessionProvider2;
        private final CustomerSessionDataSourceComponentImpl customerSessionDataSourceComponentImpl = this;
        private Provider<Application> applicationProvider;
        private Provider<PaymentConfiguration> providePaymentConfigurationProvider;
        private Provider<Function0<String>> providePublishableKeyProvider;
        private Provider<CoroutineContext> provideWorkContextProvider;
        private Provider<PaymentAnalyticsRequestFactory> paymentAnalyticsRequestFactoryProvider;
        private Provider<Logger> provideLoggerProvider;
        private Provider<DefaultAnalyticsRequestExecutor> defaultAnalyticsRequestExecutorProvider;
        private Provider<StripeApiRepository> stripeApiRepositoryProvider;
        private Provider<String> mobileSessionIdProvider;
        private Provider<String> provideApplicationIdProvider;
        private Provider<RealElementsSessionRepository> realElementsSessionRepositoryProvider;
        private Provider<Function1<String, PrefsRepository>> providePrefsRepositoryFactoryProvider;
        private Provider<CustomerSheet.CustomerSessionProvider> customerSessionProvider;
        private Provider<AnalyticsRequestFactory> provideAnalyticsRequestFactoryProvider;
        private Provider<RealErrorReporter> realErrorReporterProvider;
        private Provider<DefaultCustomerSessionElementsSessionManager> defaultCustomerSessionElementsSessionManagerProvider;
        private Provider<CustomerApiRepository> customerApiRepositoryProvider;

        private CustomerSessionDataSourceComponentImpl(CoroutineContextModule coroutineContextModuleParam, CoreCommonModule coreCommonModuleParam, MobileSessionIdModule mobileSessionIdModuleParam, Application applicationParam, CustomerSheet.CustomerSessionProvider customerSessionProviderParam) {
            this.application = applicationParam;
            this.customerSessionProvider2 = customerSessionProviderParam;
            this.initialize(coroutineContextModuleParam, coreCommonModuleParam, mobileSessionIdModuleParam, applicationParam, customerSessionProviderParam);
        }

        private DefaultAnalyticsRequestExecutor defaultAnalyticsRequestExecutor() {
            return new DefaultAnalyticsRequestExecutor((Logger)this.provideLoggerProvider.get(), (CoroutineContext)this.provideWorkContextProvider.get());
        }

        private AnalyticsRequestFactory analyticsRequestFactory() {
            return CustomerSheetDataCommonModule_Companion_ProvideAnalyticsRequestFactoryFactory.provideAnalyticsRequestFactory((Context)this.application, this.providePaymentConfigurationProvider);
        }

        private RealErrorReporter realErrorReporter() {
            return new RealErrorReporter((AnalyticsRequestExecutor)this.defaultAnalyticsRequestExecutor(), this.analyticsRequestFactory());
        }

        private CustomerSessionPaymentMethodDataSource customerSessionPaymentMethodDataSource() {
            return new CustomerSessionPaymentMethodDataSource((CustomerSessionElementsSessionManager)this.defaultCustomerSessionElementsSessionManagerProvider.get(), (CustomerRepository)this.customerApiRepositoryProvider.get(), (ErrorReporter)this.realErrorReporter(), (CoroutineContext)this.provideWorkContextProvider.get());
        }

        private Function1<String, PrefsRepository> function1OfStringAndPrefsRepository() {
            return CustomerSessionDataSourceModule_Companion_ProvidePrefsRepositoryFactoryFactory.providePrefsRepositoryFactory((Context)this.application, (CoroutineContext)this.provideWorkContextProvider.get());
        }

        private CustomerSessionSavedSelectionDataSource customerSessionSavedSelectionDataSource() {
            return new CustomerSessionSavedSelectionDataSource((CustomerSessionElementsSessionManager)this.defaultCustomerSessionElementsSessionManagerProvider.get(), (CustomerRepository)this.customerApiRepositoryProvider.get(), this.function1OfStringAndPrefsRepository(), (CoroutineContext)this.provideWorkContextProvider.get());
        }

        private CustomerSessionIntentDataSource customerSessionIntentDataSource() {
            return new CustomerSessionIntentDataSource((CustomerSessionElementsSessionManager)this.defaultCustomerSessionElementsSessionManagerProvider.get(), this.customerSessionProvider2);
        }

        private CustomerSessionInitializationDataSource customerSessionInitializationDataSource() {
            return new CustomerSessionInitializationDataSource((CustomerSessionElementsSessionManager)this.defaultCustomerSessionElementsSessionManagerProvider.get(), this.customerSessionSavedSelectionDataSource(), (CoroutineContext)this.provideWorkContextProvider.get());
        }

        private void initialize(CoroutineContextModule coroutineContextModuleParam, CoreCommonModule coreCommonModuleParam, MobileSessionIdModule mobileSessionIdModuleParam, Application applicationParam, CustomerSheet.CustomerSessionProvider customerSessionProviderParam) {
            this.applicationProvider = InstanceFactory.create((Object)applicationParam);
            this.providePaymentConfigurationProvider = CustomerSheetDataCommonModule_Companion_ProvidePaymentConfigurationFactory.create(this.applicationProvider);
            this.providePublishableKeyProvider = CustomerSheetDataCommonModule_Companion_ProvidePublishableKeyFactory.create(this.providePaymentConfigurationProvider);
            this.provideWorkContextProvider = DoubleCheck.provider((Provider)CoroutineContextModule_ProvideWorkContextFactory.create((CoroutineContextModule)coroutineContextModuleParam));
            this.paymentAnalyticsRequestFactoryProvider = PaymentAnalyticsRequestFactory_Factory.create(this.applicationProvider, this.providePublishableKeyProvider, (Provider)CustomerSheetDataCommonModule_Companion_ProvidesProductUsageFactory.create());
            this.provideLoggerProvider = DoubleCheck.provider((Provider)CoreCommonModule_ProvideLoggerFactory.create((CoreCommonModule)coreCommonModuleParam, (Provider)CustomerSheetDataCommonModule_Companion_ProvidesEnableLoggingFactory.create()));
            this.defaultAnalyticsRequestExecutorProvider = DefaultAnalyticsRequestExecutor_Factory.create(this.provideLoggerProvider, this.provideWorkContextProvider);
            this.stripeApiRepositoryProvider = StripeApiRepository_Factory.create(this.applicationProvider, this.providePublishableKeyProvider, this.provideWorkContextProvider, (Provider)CustomerSheetDataCommonModule_Companion_ProvidesProductUsageFactory.create(), this.paymentAnalyticsRequestFactoryProvider, this.defaultAnalyticsRequestExecutorProvider, this.provideLoggerProvider);
            this.mobileSessionIdProvider = MobileSessionIdModule_MobileSessionIdProviderFactory.create(mobileSessionIdModuleParam);
            this.provideApplicationIdProvider = ApplicationIdModule_ProvideApplicationIdFactory.create(this.applicationProvider);
            this.realElementsSessionRepositoryProvider = RealElementsSessionRepository_Factory.create(this.stripeApiRepositoryProvider, this.providePaymentConfigurationProvider, this.provideWorkContextProvider, this.mobileSessionIdProvider, this.provideApplicationIdProvider);
            this.providePrefsRepositoryFactoryProvider = CustomerSessionDataSourceModule_Companion_ProvidePrefsRepositoryFactoryFactory.create(this.applicationProvider, this.provideWorkContextProvider);
            this.customerSessionProvider = InstanceFactory.create((Object)customerSessionProviderParam);
            this.provideAnalyticsRequestFactoryProvider = CustomerSheetDataCommonModule_Companion_ProvideAnalyticsRequestFactoryFactory.create(this.applicationProvider, this.providePaymentConfigurationProvider);
            this.realErrorReporterProvider = RealErrorReporter_Factory.create(this.defaultAnalyticsRequestExecutorProvider, this.provideAnalyticsRequestFactoryProvider);
            this.defaultCustomerSessionElementsSessionManagerProvider = DoubleCheck.provider((Provider)DefaultCustomerSessionElementsSessionManager_Factory.create(this.realElementsSessionRepositoryProvider, this.providePrefsRepositoryFactoryProvider, this.customerSessionProvider, this.realErrorReporterProvider, (Provider<Function0<Long>>)CustomerSheetDataCommonModule_Companion_ProvideTimeProviderFactory.create(), this.provideWorkContextProvider));
            this.customerApiRepositoryProvider = DoubleCheck.provider((Provider)CustomerApiRepository_Factory.create(this.stripeApiRepositoryProvider, this.providePaymentConfigurationProvider, this.provideLoggerProvider, this.realErrorReporterProvider, this.provideWorkContextProvider, (Provider<Set<String>>)CustomerSheetDataCommonModule_Companion_ProvidesProductUsageFactory.create()));
        }

        @Override
        public CustomerSheetPaymentMethodDataSource getCustomerSheetPaymentMethodDataSource() {
            return this.customerSessionPaymentMethodDataSource();
        }

        @Override
        public CustomerSheetSavedSelectionDataSource getCustomerSheetSavedSelectionDataSource() {
            return this.customerSessionSavedSelectionDataSource();
        }

        @Override
        public CustomerSheetIntentDataSource getCustomerSheetIntentDataSource() {
            return this.customerSessionIntentDataSource();
        }

        @Override
        public CustomerSheetInitializationDataSource getCustomerSheetInitializationDataSource() {
            return this.customerSessionInitializationDataSource();
        }
    }
}

