/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.customersheet.data.injection;

import android.app.Application;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.common.di.ApplicationIdModule_ProvideApplicationIdFactory;
import com.stripe.android.common.di.MobileSessionIdModule;
import com.stripe.android.common.di.MobileSessionIdModule_MobileSessionIdProviderFactory;
import com.stripe.android.core.Logger;
import com.stripe.android.core.injection.CoreCommonModule;
import com.stripe.android.core.injection.CoreCommonModule_ProvideLoggerFactory;
import com.stripe.android.core.injection.CoroutineContextModule;
import com.stripe.android.core.injection.CoroutineContextModule_ProvideWorkContextFactory;
import com.stripe.android.core.networking.AnalyticsRequestFactory;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor_Factory;
import com.stripe.android.customersheet.CustomerAdapter;
import com.stripe.android.customersheet.data.CustomerAdapterDataSource;
import com.stripe.android.customersheet.data.CustomerAdapterDataSource_Factory;
import com.stripe.android.customersheet.data.CustomerSheetInitializationDataSource;
import com.stripe.android.customersheet.data.CustomerSheetIntentDataSource;
import com.stripe.android.customersheet.data.CustomerSheetPaymentMethodDataSource;
import com.stripe.android.customersheet.data.CustomerSheetSavedSelectionDataSource;
import com.stripe.android.customersheet.data.injection.CustomerAdapterDataSourceComponent;
import com.stripe.android.customersheet.injection.CustomerSheetDataCommonModule_Companion_ProvideAnalyticsRequestFactoryFactory;
import com.stripe.android.customersheet.injection.CustomerSheetDataCommonModule_Companion_ProvidePaymentConfigurationFactory;
import com.stripe.android.customersheet.injection.CustomerSheetDataCommonModule_Companion_ProvidePublishableKeyFactory;
import com.stripe.android.customersheet.injection.CustomerSheetDataCommonModule_Companion_ProvidesEnableLoggingFactory;
import com.stripe.android.customersheet.injection.CustomerSheetDataCommonModule_Companion_ProvidesProductUsageFactory;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory_Factory;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeApiRepository_Factory;
import com.stripe.android.payments.core.analytics.RealErrorReporter;
import com.stripe.android.payments.core.analytics.RealErrorReporter_Factory;
import com.stripe.android.paymentsheet.repositories.RealElementsSessionRepository;
import com.stripe.android.paymentsheet.repositories.RealElementsSessionRepository_Factory;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;

@DaggerGenerated
public final class DaggerCustomerAdapterDataSourceComponent {
    private DaggerCustomerAdapterDataSourceComponent() {
    }

    public static CustomerAdapterDataSourceComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements CustomerAdapterDataSourceComponent.Builder {
        private Application application;
        private CustomerAdapter adapter;

        private Builder() {
        }

        @Override
        public Builder application(Application application) {
            this.application = (Application)Preconditions.checkNotNull((Object)application);
            return this;
        }

        @Override
        public Builder adapter(CustomerAdapter customerAdapter) {
            this.adapter = (CustomerAdapter)Preconditions.checkNotNull((Object)customerAdapter);
            return this;
        }

        @Override
        public CustomerAdapterDataSourceComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.application, Application.class);
            Preconditions.checkBuilderRequirement((Object)this.adapter, CustomerAdapter.class);
            return new CustomerAdapterDataSourceComponentImpl(new CoroutineContextModule(), new CoreCommonModule(), new MobileSessionIdModule(), this.application, this.adapter);
        }
    }

    private static final class CustomerAdapterDataSourceComponentImpl
    implements CustomerAdapterDataSourceComponent {
        private final CustomerAdapterDataSourceComponentImpl customerAdapterDataSourceComponentImpl = this;
        private Provider<Application> applicationProvider;
        private Provider<PaymentConfiguration> providePaymentConfigurationProvider;
        private Provider<Function0<String>> providePublishableKeyProvider;
        private Provider<CoroutineContext> provideWorkContextProvider;
        private Provider<PaymentAnalyticsRequestFactory> paymentAnalyticsRequestFactoryProvider;
        private Provider<Logger> provideLoggerProvider;
        private Provider<DefaultAnalyticsRequestExecutor> defaultAnalyticsRequestExecutorProvider;
        private Provider<StripeApiRepository> stripeApiRepositoryProvider;
        private Provider<String> mobileSessionIdProvider;
        private Provider<String> provideApplicationIdProvider;
        private Provider<RealElementsSessionRepository> realElementsSessionRepositoryProvider;
        private Provider<CustomerAdapter> adapterProvider;
        private Provider<AnalyticsRequestFactory> provideAnalyticsRequestFactoryProvider;
        private Provider<RealErrorReporter> realErrorReporterProvider;
        private Provider<CustomerAdapterDataSource> customerAdapterDataSourceProvider;

        private CustomerAdapterDataSourceComponentImpl(CoroutineContextModule coroutineContextModuleParam, CoreCommonModule coreCommonModuleParam, MobileSessionIdModule mobileSessionIdModuleParam, Application applicationParam, CustomerAdapter adapterParam) {
            this.initialize(coroutineContextModuleParam, coreCommonModuleParam, mobileSessionIdModuleParam, applicationParam, adapterParam);
        }

        private void initialize(CoroutineContextModule coroutineContextModuleParam, CoreCommonModule coreCommonModuleParam, MobileSessionIdModule mobileSessionIdModuleParam, Application applicationParam, CustomerAdapter adapterParam) {
            this.applicationProvider = InstanceFactory.create((Object)applicationParam);
            this.providePaymentConfigurationProvider = CustomerSheetDataCommonModule_Companion_ProvidePaymentConfigurationFactory.create(this.applicationProvider);
            this.providePublishableKeyProvider = CustomerSheetDataCommonModule_Companion_ProvidePublishableKeyFactory.create(this.providePaymentConfigurationProvider);
            this.provideWorkContextProvider = DoubleCheck.provider((Provider)CoroutineContextModule_ProvideWorkContextFactory.create((CoroutineContextModule)coroutineContextModuleParam));
            this.paymentAnalyticsRequestFactoryProvider = PaymentAnalyticsRequestFactory_Factory.create(this.applicationProvider, this.providePublishableKeyProvider, (Provider)CustomerSheetDataCommonModule_Companion_ProvidesProductUsageFactory.create());
            this.provideLoggerProvider = DoubleCheck.provider((Provider)CoreCommonModule_ProvideLoggerFactory.create((CoreCommonModule)coreCommonModuleParam, (Provider)CustomerSheetDataCommonModule_Companion_ProvidesEnableLoggingFactory.create()));
            this.defaultAnalyticsRequestExecutorProvider = DefaultAnalyticsRequestExecutor_Factory.create(this.provideLoggerProvider, this.provideWorkContextProvider);
            this.stripeApiRepositoryProvider = StripeApiRepository_Factory.create(this.applicationProvider, this.providePublishableKeyProvider, this.provideWorkContextProvider, (Provider)CustomerSheetDataCommonModule_Companion_ProvidesProductUsageFactory.create(), this.paymentAnalyticsRequestFactoryProvider, this.defaultAnalyticsRequestExecutorProvider, this.provideLoggerProvider);
            this.mobileSessionIdProvider = MobileSessionIdModule_MobileSessionIdProviderFactory.create(mobileSessionIdModuleParam);
            this.provideApplicationIdProvider = ApplicationIdModule_ProvideApplicationIdFactory.create(this.applicationProvider);
            this.realElementsSessionRepositoryProvider = RealElementsSessionRepository_Factory.create(this.stripeApiRepositoryProvider, this.providePaymentConfigurationProvider, this.provideWorkContextProvider, this.mobileSessionIdProvider, this.provideApplicationIdProvider);
            this.adapterProvider = InstanceFactory.create((Object)adapterParam);
            this.provideAnalyticsRequestFactoryProvider = CustomerSheetDataCommonModule_Companion_ProvideAnalyticsRequestFactoryFactory.create(this.applicationProvider, this.providePaymentConfigurationProvider);
            this.realErrorReporterProvider = RealErrorReporter_Factory.create(this.defaultAnalyticsRequestExecutorProvider, this.provideAnalyticsRequestFactoryProvider);
            this.customerAdapterDataSourceProvider = DoubleCheck.provider((Provider)CustomerAdapterDataSource_Factory.create(this.realElementsSessionRepositoryProvider, this.adapterProvider, this.realErrorReporterProvider, this.provideWorkContextProvider));
        }

        @Override
        public CustomerSheetPaymentMethodDataSource getCustomerSheetPaymentMethodDataSource() {
            return (CustomerSheetPaymentMethodDataSource)this.customerAdapterDataSourceProvider.get();
        }

        @Override
        public CustomerSheetSavedSelectionDataSource getCustomerSheetSavedSelectionDataSource() {
            return (CustomerSheetSavedSelectionDataSource)this.customerAdapterDataSourceProvider.get();
        }

        @Override
        public CustomerSheetIntentDataSource getCustomerSheetIntentDataSource() {
            return (CustomerSheetIntentDataSource)this.customerAdapterDataSourceProvider.get();
        }

        @Override
        public CustomerSheetInitializationDataSource getCustomerSheetInitializationDataSource() {
            return (CustomerSheetInitializationDataSource)this.customerAdapterDataSourceProvider.get();
        }
    }
}

