/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.customersheet;

import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistryOwner;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.app.ActivityOptionsCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.stripe.android.ExperimentalAllowsRemovalOfLastSavedPaymentMethodApi;
import com.stripe.android.common.configuration.ConfigurationDefaults;
import com.stripe.android.customersheet.CustomerAdapter;
import com.stripe.android.customersheet.CustomerSheetConfigViewModel;
import com.stripe.android.customersheet.CustomerSheetConfigureRequest;
import com.stripe.android.customersheet.CustomerSheetContract;
import com.stripe.android.customersheet.CustomerSheetIntegration;
import com.stripe.android.customersheet.CustomerSheetResult;
import com.stripe.android.customersheet.CustomerSheetResultCallback;
import com.stripe.android.customersheet.InternalCustomerSheetResult;
import com.stripe.android.customersheet.PaymentOptionSelection;
import com.stripe.android.customersheet.data.CustomerSheetDataResult;
import com.stripe.android.customersheet.data.CustomerSheetPaymentMethodDataSource;
import com.stripe.android.customersheet.data.CustomerSheetSavedSelectionDataSource;
import com.stripe.android.customersheet.util.CustomerSheetHacks;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.ExperimentalCustomerSessionApi;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.model.PaymentOptionFactory;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.model.SavedSelection;
import com.stripe.android.uicore.image.StripeImageLoader;
import com.stripe.android.uicore.utils.AnimationConstants;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 *2\u00020\u0001:\u0005&'()*BQ\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001bJ\u0006\u0010\u001f\u001a\u00020\u001bJ\u000e\u0010 \u001a\u00020!H\u0086@\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/stripe/android/customersheet/CustomerSheet;", "", "application", "Landroid/app/Application;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "activityResultRegistryOwner", "Landroidx/activity/result/ActivityResultRegistryOwner;", "viewModelStoreOwner", "Landroidx/lifecycle/ViewModelStoreOwner;", "integrationType", "Lcom/stripe/android/customersheet/CustomerSheetIntegration$Type;", "paymentOptionFactory", "Lcom/stripe/android/paymentsheet/model/PaymentOptionFactory;", "callback", "Lcom/stripe/android/customersheet/CustomerSheetResultCallback;", "statusBarColor", "Lkotlin/Function0;", "", "<init>", "(Landroid/app/Application;Landroidx/lifecycle/LifecycleOwner;Landroidx/activity/result/ActivityResultRegistryOwner;Landroidx/lifecycle/ViewModelStoreOwner;Lcom/stripe/android/customersheet/CustomerSheetIntegration$Type;Lcom/stripe/android/paymentsheet/model/PaymentOptionFactory;Lcom/stripe/android/customersheet/CustomerSheetResultCallback;Lkotlin/jvm/functions/Function0;)V", "customerSheetActivityLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/customersheet/CustomerSheetContract$Args;", "viewModel", "Lcom/stripe/android/customersheet/CustomerSheetConfigViewModel;", "configure", "", "configuration", "Lcom/stripe/android/customersheet/CustomerSheet$Configuration;", "present", "resetCustomer", "retrievePaymentOptionSelection", "Lcom/stripe/android/customersheet/CustomerSheetResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onCustomerSheetResult", "result", "Lcom/stripe/android/customersheet/InternalCustomerSheetResult;", "Configuration", "IntentConfiguration", "CustomerSessionClientSecret", "CustomerSessionProvider", "Companion", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class CustomerSheet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Application application;
    @NotNull
    private final CustomerSheetIntegration.Type integrationType;
    @NotNull
    private final PaymentOptionFactory paymentOptionFactory;
    @NotNull
    private final CustomerSheetResultCallback callback;
    @NotNull
    private final Function0<Integer> statusBarColor;
    @NotNull
    private final ActivityResultLauncher<CustomerSheetContract.Args> customerSheetActivityLauncher;
    @NotNull
    private final CustomerSheetConfigViewModel viewModel;
    public static final int $stable = 8;

    public CustomerSheet(@NotNull Application application, @NotNull LifecycleOwner lifecycleOwner, @NotNull ActivityResultRegistryOwner activityResultRegistryOwner, @NotNull ViewModelStoreOwner viewModelStoreOwner, @NotNull CustomerSheetIntegration.Type integrationType, @NotNull PaymentOptionFactory paymentOptionFactory, @NotNull CustomerSheetResultCallback callback2, @NotNull Function0<Integer> statusBarColor) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)activityResultRegistryOwner, (String)"activityResultRegistryOwner");
        Intrinsics.checkNotNullParameter((Object)viewModelStoreOwner, (String)"viewModelStoreOwner");
        Intrinsics.checkNotNullParameter((Object)((Object)integrationType), (String)"integrationType");
        Intrinsics.checkNotNullParameter((Object)paymentOptionFactory, (String)"paymentOptionFactory");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter(statusBarColor, (String)"statusBarColor");
        this.application = application;
        this.integrationType = integrationType;
        this.paymentOptionFactory = paymentOptionFactory;
        this.callback = callback2;
        this.statusBarColor = statusBarColor;
        this.customerSheetActivityLauncher = activityResultRegistryOwner.getActivityResultRegistry().register("CustomerSheet", (ActivityResultContract)new CustomerSheetContract(), new ActivityResultCallback(this){
            final /* synthetic */ CustomerSheet $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final void onActivityResult(InternalCustomerSheetResult p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                CustomerSheet.access$onCustomerSheetResult(this.$tmp0, p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)this.$tmp0, CustomerSheet.class, "onCustomerSheetResult", "onCustomerSheetResult(Lcom/stripe/android/customersheet/InternalCustomerSheetResult;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof ActivityResultCallback ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
        this.viewModel = (CustomerSheetConfigViewModel)new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)CustomerSheetConfigViewModel.Factory.INSTANCE).get(CustomerSheetConfigViewModel.class);
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(){

            public void onDestroy(LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                customerSheetActivityLauncher.unregister();
                super.onDestroy(owner);
            }
        });
    }

    public final void configure(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.viewModel.setConfigureRequest(new CustomerSheetConfigureRequest(configuration));
    }

    public final void present() {
        CustomerSheetConfigureRequest customerSheetConfigureRequest = this.viewModel.getConfigureRequest();
        if (customerSheetConfigureRequest == null) {
            CustomerSheet $this$present_u24lambda_u240 = this;
            boolean bl = false;
            $this$present_u24lambda_u240.callback.onCustomerSheetResult(new CustomerSheetResult.Failed(new IllegalStateException("Must call `configure` first before attempting to present `CustomerSheet`!")));
            return;
        }
        CustomerSheetConfigureRequest request = customerSheetConfigureRequest;
        Configuration configuration = request.getConfiguration();
        CustomerSheetIntegration.Type type = this.integrationType;
        Integer n = (Integer)this.statusBarColor.invoke();
        CustomerSheetContract.Args args = new CustomerSheetContract.Args(type, configuration, n);
        ActivityOptionsCompat activityOptionsCompat = ActivityOptionsCompat.makeCustomAnimation((Context)this.application.getApplicationContext(), (int)AnimationConstants.INSTANCE.getFADE_IN(), (int)AnimationConstants.INSTANCE.getFADE_OUT());
        Intrinsics.checkNotNullExpressionValue((Object)activityOptionsCompat, (String)"makeCustomAnimation(...)");
        ActivityOptionsCompat options = activityOptionsCompat;
        this.customerSheetActivityLauncher.launch((Object)args, options);
    }

    public final void resetCustomer() {
        this.viewModel.setConfigureRequest(null);
        CustomerSheetHacks.INSTANCE.clear();
    }

    @Nullable
    public final Object retrievePaymentOptionSelection(@NotNull Continuation<? super CustomerSheetResult> $completion) {
        CustomerSheetConfigureRequest customerSheetConfigureRequest = this.viewModel.getConfigureRequest();
        if (customerSheetConfigureRequest == null) {
            return new CustomerSheetResult.Failed(new IllegalStateException("Must call `configure` first before attempting to fetch the saved payment option!"));
        }
        CustomerSheetConfigureRequest request = customerSheetConfigureRequest;
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CustomerSheetResult>, Object>(this, request, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CustomerSheet this$0;
            final /* synthetic */ CustomerSheetConfigureRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var16_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$coroutineScope = (CoroutineScope)this.L$0;
                        savedSelectionDeferred = BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result<? extends SavedSelection>>, Object>(null){
                            int label;

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        this.label = 1;
                                        v0 = CustomerSheetHacks.INSTANCE.getSavedSelectionDataSource().await((Continuation<CustomerSheetSavedSelectionDataSource>)((Continuation)this));
                                        if (v0 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        this.label = 2;
                                        v1 = ((CustomerSheetSavedSelectionDataSource)v0).retrieveSavedSelection(null, (Continuation<? super CustomerSheetDataResult<SavedSelection>>)((Continuation)this));
                                        if (v1 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl21
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl21:
                                        // 2 sources

                                        return Result.box-impl((Object)((CustomerSheetDataResult)v1).toResult-d1pmJ48());
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Result<? extends SavedSelection>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        paymentMethodsDeferred = BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result<? extends List<? extends PaymentMethod>>>, Object>(null){
                            int label;

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        this.label = 1;
                                        v0 = CustomerSheetHacks.INSTANCE.getPaymentMethodDataSource().await((Continuation<CustomerSheetPaymentMethodDataSource>)((Continuation)this));
                                        if (v0 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        this.label = 2;
                                        v1 = ((CustomerSheetPaymentMethodDataSource)v0).retrievePaymentMethods((Continuation<? super CustomerSheetDataResult<List<PaymentMethod>>>)((Continuation)this));
                                        if (v1 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl21
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl21:
                                        // 2 sources

                                        return Result.box-impl((Object)((CustomerSheetDataResult)v1).toResult-d1pmJ48());
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Result<? extends List<PaymentMethod>>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        this.L$0 = paymentMethodsDeferred;
                        this.label = 1;
                        v0 = savedSelectionDeferred.await((Continuation)this);
                        if (v0 == var16_2) {
                            return var16_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        paymentMethodsDeferred = (Deferred)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        this.L$0 = savedSelection = ((Result)v0).unbox-impl();
                        this.label = 2;
                        v1 = paymentMethodsDeferred.await((Continuation)this);
                        if (v1 == var16_2) {
                            return var16_2;
                        }
                        ** GOTO lbl28
                    }
                    case 2: {
                        savedSelection = this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl28:
                        // 2 sources

                        paymentMethods = ((Result)v1).unbox-impl();
                        var8_8 = savedSelection;
                        if (Result.isSuccess-impl((Object)var8_8)) {
                            selection = (SavedSelection)var8_8;
                            $i$a$-map-CustomerSheet$retrievePaymentOptionSelection$2$selection$1 = false;
                            v2 = selection;
                            v3 = Result.constructor-impl((Object)(v2 != null ? CustomerAdapter.PaymentOption.Companion.toPaymentOption$paymentsheet_release((SavedSelection)v2) : null));
                        } else {
                            v3 = Result.constructor-impl((Object)var8_8);
                        }
                        var8_8 = v3;
                        selection = this.this$0;
                        $i$a$-map-CustomerSheet$retrievePaymentOptionSelection$2$selection$1 = this.$request;
                        if (Result.isSuccess-impl((Object)var8_8)) {
                            var11_14 = var8_8;
                            try {
                                var12_15 = var11_14;
                                paymentOption = (CustomerAdapter.PaymentOption)var12_15;
                                $i$a$-mapCatching-CustomerSheet$retrievePaymentOptionSelection$2$selection$2 = false;
                                var12_15 = Result.constructor-impl(paymentOption != null && (var15_19 = paymentOption.toPaymentSelection$paymentsheet_release((Function1<? super String, PaymentMethod>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$3$lambda$2(java.lang.Object com.stripe.android.customersheet.CustomerAdapter$PaymentOption java.lang.String ), (Ljava/lang/String;)Lcom/stripe/android/model/PaymentMethod;)((Object)paymentMethods, (CustomerAdapter.PaymentOption)paymentOption))) != null ? CustomerSheet.Companion.toPaymentOptionSelection$paymentsheet_release(var15_19, CustomerSheet.access$getPaymentOptionFactory$p((CustomerSheet)selection), $i$a$-map-CustomerSheet$retrievePaymentOptionSelection$2$selection$1.getConfiguration().getGooglePayEnabled()) : null);
                            }
                            catch (Throwable var13_17) {
                                var12_15 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var13_17));
                            }
                            v4 = var12_15;
                        } else {
                            v4 = Result.constructor-impl((Object)var8_8);
                        }
                        var8_8 = selection = v4;
                        v5 = Result.exceptionOrNull-impl((Object)var8_8);
                        if (v5 == null) {
                            it = (PaymentOptionSelection)var8_8;
                            $i$a$-fold-CustomerSheet$retrievePaymentOptionSelection$2$1 = false;
                            v6 = new CustomerSheetResult.Selected(it);
                        } else {
                            cause = v5;
                            $i$a$-fold-CustomerSheet$retrievePaymentOptionSelection$2$2 = false;
                            v6 = new CustomerSheetResult.Failed(cause);
                        }
                        return v6;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super CustomerSheetResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final PaymentMethod invokeSuspend$lambda$3$lambda$2(Object $paymentMethods, CustomerAdapter.PaymentOption $paymentOption, String it) {
                PaymentMethod paymentMethod;
                List list = (List)(Result.isFailure-impl((Object)$paymentMethods) ? null : $paymentMethods);
                if (list != null) {
                    Object v1;
                    block3: {
                        Iterable iterable = list;
                        for (T t : iterable) {
                            PaymentMethod it2 = (PaymentMethod)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it2.id, (Object)$paymentOption.getId())) continue;
                            v1 = t;
                            break block3;
                        }
                        v1 = null;
                    }
                    paymentMethod = v1;
                } else {
                    paymentMethod = null;
                }
                return paymentMethod;
            }
        }), $completion);
    }

    private final void onCustomerSheetResult(InternalCustomerSheetResult result2) {
        this.callback.onCustomerSheetResult(result2.toPublicResult(this.paymentOptionFactory));
    }

    @JvmStatic
    @NotNull
    public static final CustomerSheet create(@NotNull ComponentActivity activity, @NotNull CustomerAdapter customerAdapter, @NotNull CustomerSheetResultCallback callback2) {
        return Companion.create(activity, customerAdapter, callback2);
    }

    @JvmStatic
    @ExperimentalCustomerSessionApi
    @NotNull
    public static final CustomerSheet create(@NotNull ComponentActivity activity, @NotNull CustomerSessionProvider customerSessionProvider, @NotNull CustomerSheetResultCallback callback2) {
        return Companion.create(activity, customerSessionProvider, callback2);
    }

    @JvmStatic
    @NotNull
    public static final CustomerSheet create(@NotNull Fragment fragment, @NotNull CustomerAdapter customerAdapter, @NotNull CustomerSheetResultCallback callback2) {
        return Companion.create(fragment, customerAdapter, callback2);
    }

    @JvmStatic
    @ExperimentalCustomerSessionApi
    @NotNull
    public static final CustomerSheet create(@NotNull Fragment fragment, @NotNull CustomerSessionProvider customerSessionProvider, @NotNull CustomerSheetResultCallback callback2) {
        return Companion.create(fragment, customerSessionProvider, callback2);
    }

    public static final /* synthetic */ PaymentOptionFactory access$getPaymentOptionFactory$p(CustomerSheet $this) {
        return $this.paymentOptionFactory;
    }

    public static final /* synthetic */ void access$onCustomerSheetResult(CustomerSheet $this, InternalCustomerSheetResult result2) {
        $this.onCustomerSheetResult(result2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007JM\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001eJ%\u0010\u001f\u001a\u0004\u0018\u00010 *\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&\u00a8\u0006'"}, d2={"Lcom/stripe/android/customersheet/CustomerSheet$Companion;", "", "<init>", "()V", "create", "Lcom/stripe/android/customersheet/CustomerSheet;", "activity", "Landroidx/activity/ComponentActivity;", "customerAdapter", "Lcom/stripe/android/customersheet/CustomerAdapter;", "callback", "Lcom/stripe/android/customersheet/CustomerSheetResultCallback;", "customerSessionProvider", "Lcom/stripe/android/customersheet/CustomerSheet$CustomerSessionProvider;", "fragment", "Landroidx/fragment/app/Fragment;", "getInstance", "application", "Landroid/app/Application;", "viewModelStoreOwner", "Landroidx/lifecycle/ViewModelStoreOwner;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "activityResultRegistryOwner", "Landroidx/activity/result/ActivityResultRegistryOwner;", "statusBarColor", "Lkotlin/Function0;", "", "integration", "Lcom/stripe/android/customersheet/CustomerSheetIntegration;", "getInstance$paymentsheet_release", "toPaymentOptionSelection", "Lcom/stripe/android/customersheet/PaymentOptionSelection;", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "paymentOptionFactory", "Lcom/stripe/android/paymentsheet/model/PaymentOptionFactory;", "canUseGooglePay", "", "toPaymentOptionSelection$paymentsheet_release", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CustomerSheet create(@NotNull ComponentActivity activity, @NotNull CustomerAdapter customerAdapter, @NotNull CustomerSheetResultCallback callback2) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)customerAdapter, (String)"customerAdapter");
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            Application application = activity.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            Application application2 = application;
            CustomerSheetIntegration.Adapter adapter = new CustomerSheetIntegration.Adapter(customerAdapter);
            return this.getInstance$paymentsheet_release(application2, (ViewModelStoreOwner)activity, (LifecycleOwner)activity, (ActivityResultRegistryOwner)activity, (Function0<Integer>)((Function0)() -> Companion.create$lambda$0(activity)), adapter, callback2);
        }

        @JvmStatic
        @ExperimentalCustomerSessionApi
        @NotNull
        public final CustomerSheet create(@NotNull ComponentActivity activity, @NotNull CustomerSessionProvider customerSessionProvider, @NotNull CustomerSheetResultCallback callback2) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)customerSessionProvider, (String)"customerSessionProvider");
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            Application application = activity.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            Application application2 = application;
            CustomerSheetIntegration.CustomerSession customerSession = new CustomerSheetIntegration.CustomerSession(customerSessionProvider);
            return this.getInstance$paymentsheet_release(application2, (ViewModelStoreOwner)activity, (LifecycleOwner)activity, (ActivityResultRegistryOwner)activity, (Function0<Integer>)((Function0)() -> Companion.create$lambda$1(activity)), customerSession, callback2);
        }

        @JvmStatic
        @NotNull
        public final CustomerSheet create(@NotNull Fragment fragment, @NotNull CustomerAdapter customerAdapter, @NotNull CustomerSheetResultCallback callback2) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            Intrinsics.checkNotNullParameter((Object)customerAdapter, (String)"customerAdapter");
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            Application application = fragment.requireActivity().getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            Application application2 = application;
            Object object = fragment.getHost();
            ActivityResultRegistryOwner activityResultRegistryOwner = object instanceof ActivityResultRegistryOwner ? (ActivityResultRegistryOwner)object : null;
            if (activityResultRegistryOwner == null) {
                FragmentActivity fragmentActivity = fragment.requireActivity();
                Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity(...)");
                activityResultRegistryOwner = (ActivityResultRegistryOwner)fragmentActivity;
            }
            ActivityResultRegistryOwner activityResultRegistryOwner2 = activityResultRegistryOwner;
            CustomerSheetIntegration.Adapter adapter = new CustomerSheetIntegration.Adapter(customerAdapter);
            return this.getInstance$paymentsheet_release(application2, (ViewModelStoreOwner)fragment, (LifecycleOwner)fragment, activityResultRegistryOwner2, (Function0<Integer>)((Function0)() -> Companion.create$lambda$2(fragment)), adapter, callback2);
        }

        @JvmStatic
        @ExperimentalCustomerSessionApi
        @NotNull
        public final CustomerSheet create(@NotNull Fragment fragment, @NotNull CustomerSessionProvider customerSessionProvider, @NotNull CustomerSheetResultCallback callback2) {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            Intrinsics.checkNotNullParameter((Object)customerSessionProvider, (String)"customerSessionProvider");
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            Application application = fragment.requireActivity().getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            Application application2 = application;
            Object object = fragment.getHost();
            ActivityResultRegistryOwner activityResultRegistryOwner = object instanceof ActivityResultRegistryOwner ? (ActivityResultRegistryOwner)object : null;
            if (activityResultRegistryOwner == null) {
                FragmentActivity fragmentActivity = fragment.requireActivity();
                Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity(...)");
                activityResultRegistryOwner = (ActivityResultRegistryOwner)fragmentActivity;
            }
            ActivityResultRegistryOwner activityResultRegistryOwner2 = activityResultRegistryOwner;
            CustomerSheetIntegration.CustomerSession customerSession = new CustomerSheetIntegration.CustomerSession(customerSessionProvider);
            return this.getInstance$paymentsheet_release(application2, (ViewModelStoreOwner)fragment, (LifecycleOwner)fragment, activityResultRegistryOwner2, (Function0<Integer>)((Function0)() -> Companion.create$lambda$3(fragment)), customerSession, callback2);
        }

        @NotNull
        public final CustomerSheet getInstance$paymentsheet_release(@NotNull Application application, @NotNull ViewModelStoreOwner viewModelStoreOwner, @NotNull LifecycleOwner lifecycleOwner, @NotNull ActivityResultRegistryOwner activityResultRegistryOwner, @NotNull Function0<Integer> statusBarColor, @NotNull CustomerSheetIntegration integration, @NotNull CustomerSheetResultCallback callback2) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)viewModelStoreOwner, (String)"viewModelStoreOwner");
            Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
            Intrinsics.checkNotNullParameter((Object)activityResultRegistryOwner, (String)"activityResultRegistryOwner");
            Intrinsics.checkNotNullParameter(statusBarColor, (String)"statusBarColor");
            Intrinsics.checkNotNullParameter((Object)integration, (String)"integration");
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            CustomerSheetHacks.INSTANCE.initialize(application, lifecycleOwner, integration);
            CustomerSheetIntegration.Type type = integration.getType();
            Resources resources = application.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"getResources(...)");
            PaymentOptionFactory paymentOptionFactory = new PaymentOptionFactory(new PaymentSelection.IconLoader(resources, new StripeImageLoader((Context)application, null, null, null, null, 30, null)), (Context)application);
            return new CustomerSheet(application, lifecycleOwner, activityResultRegistryOwner, viewModelStoreOwner, type, paymentOptionFactory, callback2, statusBarColor);
        }

        @Nullable
        public final PaymentOptionSelection toPaymentOptionSelection$paymentsheet_release(@Nullable PaymentSelection $this$toPaymentOptionSelection, @NotNull PaymentOptionFactory paymentOptionFactory, boolean canUseGooglePay) {
            PaymentOptionSelection paymentOptionSelection;
            Intrinsics.checkNotNullParameter((Object)paymentOptionFactory, (String)"paymentOptionFactory");
            PaymentSelection paymentSelection2 = $this$toPaymentOptionSelection;
            if (paymentSelection2 instanceof PaymentSelection.GooglePay) {
                PaymentOptionSelection.GooglePay googlePay;
                PaymentOptionSelection.GooglePay it = googlePay = new PaymentOptionSelection.GooglePay(paymentOptionFactory.create($this$toPaymentOptionSelection));
                boolean bl = false;
                paymentOptionSelection = canUseGooglePay ? googlePay : null;
            } else {
                paymentOptionSelection = paymentSelection2 instanceof PaymentSelection.Saved ? (PaymentOptionSelection)new PaymentOptionSelection.PaymentMethod(((PaymentSelection.Saved)$this$toPaymentOptionSelection).getPaymentMethod(), paymentOptionFactory.create($this$toPaymentOptionSelection)) : null;
            }
            return paymentOptionSelection;
        }

        private static final Integer create$lambda$0(ComponentActivity $activity) {
            return $activity.getWindow().getStatusBarColor();
        }

        private static final Integer create$lambda$1(ComponentActivity $activity) {
            return $activity.getWindow().getStatusBarColor();
        }

        private static final Integer create$lambda$2(Fragment $fragment) {
            FragmentActivity fragmentActivity = $fragment.getActivity();
            return fragmentActivity != null && (fragmentActivity = fragmentActivity.getWindow()) != null ? Integer.valueOf(fragmentActivity.getStatusBarColor()) : null;
        }

        private static final Integer create$lambda$3(Fragment $fragment) {
            FragmentActivity fragmentActivity = $fragment.getActivity();
            return fragmentActivity != null && (fragmentActivity = fragmentActivity.getWindow()) != null ? Integer.valueOf(fragmentActivity.getStatusBarColor()) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 22\u00020\u0001:\u000212By\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015B\u0011\b\u0010\u0012\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0016J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+J\u0016\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020+R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0010\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001aR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u00063"}, d2={"Lcom/stripe/android/customersheet/CustomerSheet$Configuration;", "Landroid/os/Parcelable;", "appearance", "Lcom/stripe/android/paymentsheet/PaymentSheet$Appearance;", "googlePayEnabled", "", "headerTextForSelectionScreen", "", "defaultBillingDetails", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "billingDetailsCollectionConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "merchantDisplayName", "preferredNetworks", "", "Lcom/stripe/android/model/CardBrand;", "allowsRemovalOfLastSavedPaymentMethod", "paymentMethodOrder", "cardBrandAcceptance", "Lcom/stripe/android/paymentsheet/PaymentSheet$CardBrandAcceptance;", "<init>", "(Lcom/stripe/android/paymentsheet/PaymentSheet$Appearance;ZLjava/lang/String;Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;Ljava/lang/String;Ljava/util/List;ZLjava/util/List;Lcom/stripe/android/paymentsheet/PaymentSheet$CardBrandAcceptance;)V", "(Ljava/lang/String;)V", "getAppearance", "()Lcom/stripe/android/paymentsheet/PaymentSheet$Appearance;", "getGooglePayEnabled", "()Z", "getHeaderTextForSelectionScreen", "()Ljava/lang/String;", "getDefaultBillingDetails", "()Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "getBillingDetailsCollectionConfiguration", "()Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "getMerchantDisplayName", "getPreferredNetworks", "()Ljava/util/List;", "getAllowsRemovalOfLastSavedPaymentMethod$paymentsheet_release", "getPaymentMethodOrder$paymentsheet_release", "getCardBrandAcceptance$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/PaymentSheet$CardBrandAcceptance;", "newBuilder", "Lcom/stripe/android/customersheet/CustomerSheet$Configuration$Builder;", "describeContents", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "Builder", "Companion", "paymentsheet_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Configuration
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final PaymentSheet.Appearance appearance;
        private final boolean googlePayEnabled;
        @Nullable
        private final String headerTextForSelectionScreen;
        @NotNull
        private final PaymentSheet.BillingDetails defaultBillingDetails;
        @NotNull
        private final PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration;
        @NotNull
        private final String merchantDisplayName;
        @NotNull
        private final List<CardBrand> preferredNetworks;
        private final boolean allowsRemovalOfLastSavedPaymentMethod;
        @NotNull
        private final List<String> paymentMethodOrder;
        @NotNull
        private final PaymentSheet.CardBrandAcceptance cardBrandAcceptance;
        @NotNull
        public static final Parcelable.Creator<Configuration> CREATOR;
        public static final int $stable;

        public Configuration(@NotNull PaymentSheet.Appearance appearance, boolean googlePayEnabled, @Nullable String headerTextForSelectionScreen, @NotNull PaymentSheet.BillingDetails defaultBillingDetails, @NotNull PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration, @NotNull String merchantDisplayName, @NotNull List<? extends CardBrand> preferredNetworks, boolean allowsRemovalOfLastSavedPaymentMethod, @NotNull List<String> paymentMethodOrder, @NotNull PaymentSheet.CardBrandAcceptance cardBrandAcceptance) {
            Intrinsics.checkNotNullParameter((Object)appearance, (String)"appearance");
            Intrinsics.checkNotNullParameter((Object)defaultBillingDetails, (String)"defaultBillingDetails");
            Intrinsics.checkNotNullParameter((Object)billingDetailsCollectionConfiguration, (String)"billingDetailsCollectionConfiguration");
            Intrinsics.checkNotNullParameter((Object)merchantDisplayName, (String)"merchantDisplayName");
            Intrinsics.checkNotNullParameter(preferredNetworks, (String)"preferredNetworks");
            Intrinsics.checkNotNullParameter(paymentMethodOrder, (String)"paymentMethodOrder");
            Intrinsics.checkNotNullParameter((Object)cardBrandAcceptance, (String)"cardBrandAcceptance");
            this.appearance = appearance;
            this.googlePayEnabled = googlePayEnabled;
            this.headerTextForSelectionScreen = headerTextForSelectionScreen;
            this.defaultBillingDetails = defaultBillingDetails;
            this.billingDetailsCollectionConfiguration = billingDetailsCollectionConfiguration;
            this.merchantDisplayName = merchantDisplayName;
            this.preferredNetworks = preferredNetworks;
            this.allowsRemovalOfLastSavedPaymentMethod = allowsRemovalOfLastSavedPaymentMethod;
            this.paymentMethodOrder = paymentMethodOrder;
            this.cardBrandAcceptance = cardBrandAcceptance;
        }

        public /* synthetic */ Configuration(PaymentSheet.Appearance appearance, boolean bl, String string2, PaymentSheet.BillingDetails billingDetails, PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration, String string3, List list, boolean bl2, List list2, PaymentSheet.CardBrandAcceptance cardBrandAcceptance, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                appearance = ConfigurationDefaults.INSTANCE.getAppearance();
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                string2 = ConfigurationDefaults.INSTANCE.getHeaderTextForSelectionScreen();
            }
            if ((n & 8) != 0) {
                billingDetails = ConfigurationDefaults.INSTANCE.getBillingDetails();
            }
            if ((n & 0x10) != 0) {
                billingDetailsCollectionConfiguration = ConfigurationDefaults.INSTANCE.getBillingDetailsCollectionConfiguration();
            }
            if ((n & 0x40) != 0) {
                list = ConfigurationDefaults.INSTANCE.getPreferredNetworks();
            }
            if ((n & 0x80) != 0) {
                bl2 = true;
            }
            if ((n & 0x100) != 0) {
                list2 = ConfigurationDefaults.INSTANCE.getPaymentMethodOrder();
            }
            if ((n & 0x200) != 0) {
                cardBrandAcceptance = ConfigurationDefaults.INSTANCE.getCardBrandAcceptance();
            }
            this(appearance, bl, string2, billingDetails, billingDetailsCollectionConfiguration, string3, list, bl2, list2, cardBrandAcceptance);
        }

        @NotNull
        public final PaymentSheet.Appearance getAppearance() {
            return this.appearance;
        }

        public final boolean getGooglePayEnabled() {
            return this.googlePayEnabled;
        }

        @Nullable
        public final String getHeaderTextForSelectionScreen() {
            return this.headerTextForSelectionScreen;
        }

        @NotNull
        public final PaymentSheet.BillingDetails getDefaultBillingDetails() {
            return this.defaultBillingDetails;
        }

        @NotNull
        public final PaymentSheet.BillingDetailsCollectionConfiguration getBillingDetailsCollectionConfiguration() {
            return this.billingDetailsCollectionConfiguration;
        }

        @NotNull
        public final String getMerchantDisplayName() {
            return this.merchantDisplayName;
        }

        @NotNull
        public final List<CardBrand> getPreferredNetworks() {
            return this.preferredNetworks;
        }

        public final boolean getAllowsRemovalOfLastSavedPaymentMethod$paymentsheet_release() {
            return this.allowsRemovalOfLastSavedPaymentMethod;
        }

        @NotNull
        public final List<String> getPaymentMethodOrder$paymentsheet_release() {
            return this.paymentMethodOrder;
        }

        @NotNull
        public final PaymentSheet.CardBrandAcceptance getCardBrandAcceptance$paymentsheet_release() {
            return this.cardBrandAcceptance;
        }

        public Configuration(@NotNull String merchantDisplayName) {
            Intrinsics.checkNotNullParameter((Object)merchantDisplayName, (String)"merchantDisplayName");
            this(ConfigurationDefaults.INSTANCE.getAppearance(), false, ConfigurationDefaults.INSTANCE.getHeaderTextForSelectionScreen(), ConfigurationDefaults.INSTANCE.getBillingDetails(), ConfigurationDefaults.INSTANCE.getBillingDetailsCollectionConfiguration(), merchantDisplayName, null, true, null, null, 832, null);
        }

        @NotNull
        public final Builder newBuilder() {
            return new Builder(this.merchantDisplayName).appearance(this.appearance).googlePayEnabled(this.googlePayEnabled).headerTextForSelectionScreen(this.headerTextForSelectionScreen).defaultBillingDetails(this.defaultBillingDetails).billingDetailsCollectionConfiguration(this.billingDetailsCollectionConfiguration).allowsRemovalOfLastSavedPaymentMethod(this.allowsRemovalOfLastSavedPaymentMethod).paymentMethodOrder(this.paymentMethodOrder);
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            this.appearance.writeToParcel(dest, flags);
            dest.writeInt(this.googlePayEnabled ? 1 : 0);
            dest.writeString(this.headerTextForSelectionScreen);
            this.defaultBillingDetails.writeToParcel(dest, flags);
            this.billingDetailsCollectionConfiguration.writeToParcel(dest, flags);
            dest.writeString(this.merchantDisplayName);
            List<CardBrand> list = this.preferredNetworks;
            dest.writeInt(list.size());
            Iterator<CardBrand> iterator = list.iterator();
            while (iterator.hasNext()) {
                dest.writeString(iterator.next().name());
            }
            dest.writeInt(this.allowsRemovalOfLastSavedPaymentMethod ? 1 : 0);
            dest.writeStringList(this.paymentMethodOrder);
            dest.writeParcelable((Parcelable)this.cardBrandAcceptance, flags);
        }

        public final int describeContents() {
            return 0;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Configuration)) {
                return false;
            }
            Configuration configuration = (Configuration)other;
            if (!Intrinsics.areEqual((Object)this.appearance, (Object)configuration.appearance)) {
                return false;
            }
            if (this.googlePayEnabled != configuration.googlePayEnabled) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.headerTextForSelectionScreen, (Object)configuration.headerTextForSelectionScreen)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.defaultBillingDetails, (Object)configuration.defaultBillingDetails)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.billingDetailsCollectionConfiguration, (Object)configuration.billingDetailsCollectionConfiguration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.merchantDisplayName, (Object)configuration.merchantDisplayName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.preferredNetworks, configuration.preferredNetworks)) {
                return false;
            }
            if (this.allowsRemovalOfLastSavedPaymentMethod != configuration.allowsRemovalOfLastSavedPaymentMethod) {
                return false;
            }
            if (!Intrinsics.areEqual(this.paymentMethodOrder, configuration.paymentMethodOrder)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cardBrandAcceptance, (Object)configuration.cardBrandAcceptance);
        }

        public int hashCode() {
            int result2 = this.appearance.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.googlePayEnabled);
            result2 = result2 * 31 + (this.headerTextForSelectionScreen == null ? 0 : this.headerTextForSelectionScreen.hashCode());
            result2 = result2 * 31 + this.defaultBillingDetails.hashCode();
            result2 = result2 * 31 + this.billingDetailsCollectionConfiguration.hashCode();
            result2 = result2 * 31 + this.merchantDisplayName.hashCode();
            result2 = result2 * 31 + ((Object)this.preferredNetworks).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.allowsRemovalOfLastSavedPaymentMethod);
            result2 = result2 * 31 + ((Object)this.paymentMethodOrder).hashCode();
            result2 = result2 * 31 + this.cardBrandAcceptance.hashCode();
            return result2;
        }

        @NotNull
        public String toString() {
            return "Configuration(appearance=" + this.appearance + ", googlePayEnabled=" + this.googlePayEnabled + ", headerTextForSelectionScreen=" + this.headerTextForSelectionScreen + ", defaultBillingDetails=" + this.defaultBillingDetails + ", billingDetailsCollectionConfiguration=" + this.billingDetailsCollectionConfiguration + ", merchantDisplayName=" + this.merchantDisplayName + ", preferredNetworks=" + this.preferredNetworks + ", allowsRemovalOfLastSavedPaymentMethod=" + this.allowsRemovalOfLastSavedPaymentMethod + ", paymentMethodOrder=" + this.paymentMethodOrder + ", cardBrandAcceptance=" + this.cardBrandAcceptance + ")";
        }

        @JvmStatic
        @NotNull
        public static final Builder builder(@NotNull String merchantDisplayName) {
            return Companion.builder(merchantDisplayName);
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Configuration> {
                public final Configuration[] newArray(int size) {
                    return new Configuration[size];
                }

                public final Configuration createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    int n = parcel.readInt();
                    ArrayList<CardBrand> arrayList = new ArrayList<CardBrand>(n);
                    String string2 = parcel.readString();
                    PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = (PaymentSheet.BillingDetailsCollectionConfiguration)PaymentSheet.BillingDetailsCollectionConfiguration.CREATOR.createFromParcel(parcel);
                    PaymentSheet.BillingDetails billingDetails = (PaymentSheet.BillingDetails)PaymentSheet.BillingDetails.CREATOR.createFromParcel(parcel);
                    String string3 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    PaymentSheet.Appearance appearance = (PaymentSheet.Appearance)PaymentSheet.Appearance.CREATOR.createFromParcel(parcel);
                    for (int i = 0; i != n; ++i) {
                        arrayList.add(CardBrand.valueOf((String)parcel.readString()));
                    }
                    PaymentSheet.CardBrandAcceptance cardBrandAcceptance = (PaymentSheet.CardBrandAcceptance)parcel.readParcelable(Configuration.class.getClassLoader());
                    List list = parcel.createStringArrayList();
                    boolean bl2 = parcel.readInt() != 0;
                    List list2 = arrayList;
                    String string4 = string2;
                    PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration2 = billingDetailsCollectionConfiguration;
                    PaymentSheet.BillingDetails billingDetails2 = billingDetails;
                    String string5 = string3;
                    boolean bl3 = bl;
                    PaymentSheet.Appearance appearance2 = appearance;
                    return new Configuration(appearance2, bl3, string5, billingDetails2, billingDetailsCollectionConfiguration2, string4, list2, bl2, list, cardBrandAcceptance);
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u00020\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\tH\u0007J\u0014\u0010\u0013\u001a\u00020\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/customersheet/CustomerSheet$Configuration$Builder;", "", "merchantDisplayName", "", "<init>", "(Ljava/lang/String;)V", "appearance", "Lcom/stripe/android/paymentsheet/PaymentSheet$Appearance;", "googlePayEnabled", "", "headerTextForSelectionScreen", "defaultBillingDetails", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "billingDetailsCollectionConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "preferredNetworks", "", "Lcom/stripe/android/model/CardBrand;", "allowsRemovalOfLastSavedPaymentMethod", "paymentMethodOrder", "cardBrandAcceptance", "Lcom/stripe/android/paymentsheet/PaymentSheet$CardBrandAcceptance;", "details", "configuration", "build", "Lcom/stripe/android/customersheet/CustomerSheet$Configuration;", "paymentsheet_release"})
        @StabilityInferred(parameters=0)
        public static final class Builder {
            @NotNull
            private final String merchantDisplayName;
            @NotNull
            private PaymentSheet.Appearance appearance;
            private boolean googlePayEnabled;
            @Nullable
            private String headerTextForSelectionScreen;
            @NotNull
            private PaymentSheet.BillingDetails defaultBillingDetails;
            @NotNull
            private PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration;
            @NotNull
            private List<? extends CardBrand> preferredNetworks;
            private boolean allowsRemovalOfLastSavedPaymentMethod;
            @NotNull
            private List<String> paymentMethodOrder;
            @NotNull
            private PaymentSheet.CardBrandAcceptance cardBrandAcceptance;
            public static final int $stable = 8;

            public Builder(@NotNull String merchantDisplayName) {
                Intrinsics.checkNotNullParameter((Object)merchantDisplayName, (String)"merchantDisplayName");
                this.merchantDisplayName = merchantDisplayName;
                this.appearance = ConfigurationDefaults.INSTANCE.getAppearance();
                this.headerTextForSelectionScreen = ConfigurationDefaults.INSTANCE.getHeaderTextForSelectionScreen();
                this.defaultBillingDetails = ConfigurationDefaults.INSTANCE.getBillingDetails();
                this.billingDetailsCollectionConfiguration = ConfigurationDefaults.INSTANCE.getBillingDetailsCollectionConfiguration();
                this.preferredNetworks = ConfigurationDefaults.INSTANCE.getPreferredNetworks();
                this.allowsRemovalOfLastSavedPaymentMethod = true;
                this.paymentMethodOrder = ConfigurationDefaults.INSTANCE.getPaymentMethodOrder();
                this.cardBrandAcceptance = ConfigurationDefaults.INSTANCE.getCardBrandAcceptance();
            }

            @NotNull
            public final Builder appearance(@NotNull PaymentSheet.Appearance appearance) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)appearance, (String)"appearance");
                Builder $this$appearance_u24lambda_u240 = builder = this;
                boolean bl = false;
                $this$appearance_u24lambda_u240.appearance = appearance;
                return builder;
            }

            @NotNull
            public final Builder googlePayEnabled(boolean googlePayEnabled) {
                Builder builder;
                Builder $this$googlePayEnabled_u24lambda_u241 = builder = this;
                boolean bl = false;
                $this$googlePayEnabled_u24lambda_u241.googlePayEnabled = googlePayEnabled;
                return builder;
            }

            @NotNull
            public final Builder headerTextForSelectionScreen(@Nullable String headerTextForSelectionScreen) {
                Builder builder;
                Builder $this$headerTextForSelectionScreen_u24lambda_u242 = builder = this;
                boolean bl = false;
                $this$headerTextForSelectionScreen_u24lambda_u242.headerTextForSelectionScreen = headerTextForSelectionScreen;
                return builder;
            }

            @NotNull
            public final Builder defaultBillingDetails(@NotNull PaymentSheet.BillingDetails details) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)details, (String)"details");
                Builder $this$defaultBillingDetails_u24lambda_u243 = builder = this;
                boolean bl = false;
                $this$defaultBillingDetails_u24lambda_u243.defaultBillingDetails = details;
                return builder;
            }

            @NotNull
            public final Builder billingDetailsCollectionConfiguration(@NotNull PaymentSheet.BillingDetailsCollectionConfiguration configuration) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Builder $this$billingDetailsCollectionConfiguration_u24lambda_u244 = builder = this;
                boolean bl = false;
                $this$billingDetailsCollectionConfiguration_u24lambda_u244.billingDetailsCollectionConfiguration = configuration;
                return builder;
            }

            @NotNull
            public final Builder preferredNetworks(@NotNull List<? extends CardBrand> preferredNetworks) {
                Builder builder;
                Intrinsics.checkNotNullParameter(preferredNetworks, (String)"preferredNetworks");
                Builder $this$preferredNetworks_u24lambda_u245 = builder = this;
                boolean bl = false;
                $this$preferredNetworks_u24lambda_u245.preferredNetworks = preferredNetworks;
                return builder;
            }

            @ExperimentalAllowsRemovalOfLastSavedPaymentMethodApi
            @NotNull
            public final Builder allowsRemovalOfLastSavedPaymentMethod(boolean allowsRemovalOfLastSavedPaymentMethod) {
                Builder builder;
                Builder $this$allowsRemovalOfLastSavedPaymentMethod_u24lambda_u246 = builder = this;
                boolean bl = false;
                $this$allowsRemovalOfLastSavedPaymentMethod_u24lambda_u246.allowsRemovalOfLastSavedPaymentMethod = allowsRemovalOfLastSavedPaymentMethod;
                return builder;
            }

            @NotNull
            public final Builder paymentMethodOrder(@NotNull List<String> paymentMethodOrder) {
                Builder builder;
                Intrinsics.checkNotNullParameter(paymentMethodOrder, (String)"paymentMethodOrder");
                Builder $this$paymentMethodOrder_u24lambda_u247 = builder = this;
                boolean bl = false;
                $this$paymentMethodOrder_u24lambda_u247.paymentMethodOrder = paymentMethodOrder;
                return builder;
            }

            @NotNull
            public final Builder cardBrandAcceptance(@NotNull PaymentSheet.CardBrandAcceptance cardBrandAcceptance) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)cardBrandAcceptance, (String)"cardBrandAcceptance");
                Builder $this$cardBrandAcceptance_u24lambda_u248 = builder = this;
                boolean bl = false;
                $this$cardBrandAcceptance_u24lambda_u248.cardBrandAcceptance = cardBrandAcceptance;
                return builder;
            }

            @NotNull
            public final Configuration build() {
                return new Configuration(this.appearance, this.googlePayEnabled, this.headerTextForSelectionScreen, this.defaultBillingDetails, this.billingDetailsCollectionConfiguration, this.merchantDisplayName, this.preferredNetworks, this.allowsRemovalOfLastSavedPaymentMethod, this.paymentMethodOrder, this.cardBrandAcceptance);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/customersheet/CustomerSheet$Configuration$Companion;", "", "<init>", "()V", "builder", "Lcom/stripe/android/customersheet/CustomerSheet$Configuration$Builder;", "merchantDisplayName", "", "paymentsheet_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Builder builder(@NotNull String merchantDisplayName) {
                Intrinsics.checkNotNullParameter((Object)merchantDisplayName, (String)"merchantDisplayName");
                return new Builder(merchantDisplayName);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/customersheet/CustomerSheet$CustomerSessionClientSecret;", "", "customerId", "", "clientSecret", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getCustomerId$paymentsheet_release", "()Ljava/lang/String;", "getClientSecret$paymentsheet_release", "Companion", "paymentsheet_release"})
    @ExperimentalCustomerSessionApi
    @StabilityInferred(parameters=1)
    public static final class CustomerSessionClientSecret {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String customerId;
        @NotNull
        private final String clientSecret;
        public static final int $stable;

        public CustomerSessionClientSecret(@NotNull String customerId, @NotNull String clientSecret) {
            Intrinsics.checkNotNullParameter((Object)customerId, (String)"customerId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            this.customerId = customerId;
            this.clientSecret = clientSecret;
        }

        @NotNull
        public final String getCustomerId$paymentsheet_release() {
            return this.customerId;
        }

        @NotNull
        public final String getClientSecret$paymentsheet_release() {
            return this.clientSecret;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CustomerSessionClientSecret)) {
                return false;
            }
            CustomerSessionClientSecret customerSessionClientSecret = (CustomerSessionClientSecret)other;
            if (!Intrinsics.areEqual((Object)this.customerId, (Object)customerSessionClientSecret.customerId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.clientSecret, (Object)customerSessionClientSecret.clientSecret);
        }

        public int hashCode() {
            int result2 = this.customerId.hashCode();
            result2 = result2 * 31 + this.clientSecret.hashCode();
            return result2;
        }

        @NotNull
        public String toString() {
            return "CustomerSessionClientSecret(customerId=" + this.customerId + ", clientSecret=" + this.clientSecret + ")";
        }

        @JvmStatic
        @NotNull
        public static final CustomerSessionClientSecret create(@NotNull String customerId, @NotNull String clientSecret) {
            return Companion.create(customerId, clientSecret);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a8\u0006\t"}, d2={"Lcom/stripe/android/customersheet/CustomerSheet$CustomerSessionClientSecret$Companion;", "", "<init>", "()V", "create", "Lcom/stripe/android/customersheet/CustomerSheet$CustomerSessionClientSecret;", "customerId", "", "clientSecret", "paymentsheet_release"})
        @ExperimentalCustomerSessionApi
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final CustomerSessionClientSecret create(@NotNull String customerId, @NotNull String clientSecret) {
                Intrinsics.checkNotNullParameter((Object)customerId, (String)"customerId");
                Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
                return new CustomerSessionClientSecret(customerId, clientSecret);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0096@\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u000b\u001a\u00020\nH\u00a6@\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005H\u00a6@\u00a2\u0006\u0004\b\u0010\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/customersheet/CustomerSheet$CustomerSessionProvider;", "", "<init>", "()V", "intentConfiguration", "Lkotlin/Result;", "Lcom/stripe/android/customersheet/CustomerSheet$IntentConfiguration;", "intentConfiguration-IoAF18A", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "provideSetupIntentClientSecret", "", "customerId", "provideSetupIntentClientSecret-gIAlu-s", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "providesCustomerSessionClientSecret", "Lcom/stripe/android/customersheet/CustomerSheet$CustomerSessionClientSecret;", "providesCustomerSessionClientSecret-IoAF18A", "paymentsheet_release"})
    @ExperimentalCustomerSessionApi
    @StabilityInferred(parameters=1)
    public static abstract class CustomerSessionProvider {
        public static final int $stable;

        @Nullable
        public Object intentConfiguration-IoAF18A(@NotNull Continuation<? super Result<IntentConfiguration>> $completion) {
            return CustomerSessionProvider.intentConfiguration-IoAF18A$suspendImpl(this, $completion);
        }

        static /* synthetic */ Object intentConfiguration-IoAF18A$suspendImpl(CustomerSessionProvider $this, Continuation<? super Result<IntentConfiguration>> $completion) {
            return Result.constructor-impl((Object)new IntentConfiguration.Builder().build());
        }

        @Nullable
        public abstract Object provideSetupIntentClientSecret-gIAlu-s(@NotNull String var1, @NotNull Continuation<? super Result<String>> var2);

        @Nullable
        public abstract Object providesCustomerSessionClientSecret-IoAF18A(@NotNull Continuation<? super Result<CustomerSessionClientSecret>> var1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0001\tB\u0017\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lcom/stripe/android/customersheet/CustomerSheet$IntentConfiguration;", "", "paymentMethodTypes", "", "", "<init>", "(Ljava/util/List;)V", "getPaymentMethodTypes$paymentsheet_release", "()Ljava/util/List;", "Builder", "paymentsheet_release"})
    @ExperimentalCustomerSessionApi
    @StabilityInferred(parameters=0)
    public static final class IntentConfiguration {
        @NotNull
        private final List<String> paymentMethodTypes;
        public static final int $stable = 8;

        public IntentConfiguration(@NotNull List<String> paymentMethodTypes) {
            Intrinsics.checkNotNullParameter(paymentMethodTypes, (String)"paymentMethodTypes");
            this.paymentMethodTypes = paymentMethodTypes;
        }

        @NotNull
        public final List<String> getPaymentMethodTypes$paymentsheet_release() {
            return this.paymentMethodTypes;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0006\u0010\u0007\u001a\u00020\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/customersheet/CustomerSheet$IntentConfiguration$Builder;", "", "<init>", "()V", "paymentMethodTypes", "", "", "build", "Lcom/stripe/android/customersheet/CustomerSheet$IntentConfiguration;", "paymentsheet_release"})
        @ExperimentalCustomerSessionApi
        @StabilityInferred(parameters=0)
        public static final class Builder {
            @NotNull
            private List<String> paymentMethodTypes = CollectionsKt.emptyList();
            public static final int $stable = 8;

            @NotNull
            public final Builder paymentMethodTypes(@NotNull List<String> paymentMethodTypes) {
                Builder builder;
                Intrinsics.checkNotNullParameter(paymentMethodTypes, (String)"paymentMethodTypes");
                Builder $this$paymentMethodTypes_u24lambda_u240 = builder = this;
                boolean bl = false;
                $this$paymentMethodTypes_u24lambda_u240.paymentMethodTypes = paymentMethodTypes;
                return builder;
            }

            @NotNull
            public final IntentConfiguration build() {
                return new IntentConfiguration(this.paymentMethodTypes);
            }
        }
    }
}

