/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.ui;

import androidx.annotation.DrawableRes;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.paymentdatacollection.ach.TransformToBankIcon;
import com.stripe.payments.model.R;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0001\u001a\f\u0010\u0007\u001a\u00020\u0005*\u00020\u0006H\u0001\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\tH\u0000\u001a\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005*\u00020\tH\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u0016\u0010\f\u001a\u00020\u0005*\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0001\u00a8\u0006\u000f"}, d2={"createCardLabel", "Lcom/stripe/android/core/strings/ResolvableString;", "last4", "", "getCardBrandIcon", "", "Lcom/stripe/android/model/CardBrand;", "getCardBrandIconForVerticalMode", "getLabel", "Lcom/stripe/android/model/PaymentMethod;", "getLabelIcon", "(Lcom/stripe/android/model/PaymentMethod;)Ljava/lang/Integer;", "getSavedPaymentMethodIcon", "forVerticalMode", "", "paymentsheet_release"})
@SourceDebugExtension(value={"SMAP\nPaymentMethodsUiExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentMethodsUiExtension.kt\ncom/stripe/android/paymentsheet/ui/PaymentMethodsUiExtensionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class PaymentMethodsUiExtensionKt {
    @DrawableRes
    public static final int getSavedPaymentMethodIcon(@NotNull PaymentMethod $this$getSavedPaymentMethodIcon, boolean forVerticalMode) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$getSavedPaymentMethodIcon, (String)"<this>");
        PaymentMethod.Type type = $this$getSavedPaymentMethodIcon.type;
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                CardBrand brand;
                CardBrand cardBrand;
                PaymentMethod.Card card = $this$getSavedPaymentMethodIcon.card;
                CardBrand it = cardBrand = CardBrand.Companion.fromCode(card != null ? card.displayBrand : null);
                boolean bl = false;
                Object object = it != CardBrand.Unknown ? cardBrand : null;
                if (object == null) {
                    PaymentMethod.Card card2 = $this$getSavedPaymentMethodIcon.card;
                    object = brand = card2 != null ? card2.brand : null;
                }
                if (forVerticalMode) {
                    CardBrand cardBrand2 = brand;
                    if (cardBrand2 != null) {
                        n = PaymentMethodsUiExtensionKt.getCardBrandIconForVerticalMode(cardBrand2);
                        break;
                    }
                    n = null;
                    break;
                }
                CardBrand cardBrand3 = brand;
                if (cardBrand3 != null) {
                    n = PaymentMethodsUiExtensionKt.getCardBrandIcon(cardBrand3);
                    break;
                }
                n = null;
                break;
            }
            case 2: {
                n = R.drawable.stripe_ic_paymentsheet_sepa;
                break;
            }
            case 3: {
                Object object = $this$getSavedPaymentMethodIcon.usBankAccount;
                if (object != null && (object = object.bankName) != null) {
                    Object it = object;
                    boolean bl = false;
                    n = TransformToBankIcon.Companion.invoke((String)it);
                    break;
                }
                n = null;
                break;
            }
            default: {
                n = null;
            }
        }
        return n != null ? n : R.drawable.stripe_ic_paymentsheet_card_unknown;
    }

    public static /* synthetic */ int getSavedPaymentMethodIcon$default(PaymentMethod paymentMethod, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return PaymentMethodsUiExtensionKt.getSavedPaymentMethodIcon(paymentMethod, bl);
    }

    @DrawableRes
    public static final int getCardBrandIcon(@NotNull CardBrand $this$getCardBrandIcon) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getCardBrandIcon, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$getCardBrandIcon.ordinal()]) {
            case 1: {
                n = R.drawable.stripe_ic_paymentsheet_card_visa;
                break;
            }
            case 2: {
                n = R.drawable.stripe_ic_paymentsheet_card_amex;
                break;
            }
            case 3: {
                n = R.drawable.stripe_ic_paymentsheet_card_discover;
                break;
            }
            case 4: {
                n = R.drawable.stripe_ic_paymentsheet_card_jcb;
                break;
            }
            case 5: {
                n = R.drawable.stripe_ic_paymentsheet_card_dinersclub;
                break;
            }
            case 6: {
                n = R.drawable.stripe_ic_paymentsheet_card_mastercard;
                break;
            }
            case 7: {
                n = R.drawable.stripe_ic_paymentsheet_card_unionpay;
                break;
            }
            case 8: {
                n = R.drawable.stripe_ic_paymentsheet_card_cartes_bancaires;
                break;
            }
            case 9: {
                n = R.drawable.stripe_ic_paymentsheet_card_unknown;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @DrawableRes
    public static final int getCardBrandIconForVerticalMode(@NotNull CardBrand $this$getCardBrandIconForVerticalMode) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getCardBrandIconForVerticalMode, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$getCardBrandIconForVerticalMode.ordinal()]) {
            case 1: {
                n = R.drawable.stripe_ic_visa_unpadded;
                break;
            }
            case 2: {
                n = R.drawable.stripe_ic_amex_unpadded;
                break;
            }
            case 3: {
                n = R.drawable.stripe_ic_discover_unpadded;
                break;
            }
            case 4: {
                n = R.drawable.stripe_ic_jcb_unpadded;
                break;
            }
            case 5: {
                n = R.drawable.stripe_ic_diners_unpadded;
                break;
            }
            case 6: {
                n = R.drawable.stripe_ic_mastercard_unpadded;
                break;
            }
            case 7: {
                n = R.drawable.stripe_ic_unionpay_unpadded;
                break;
            }
            case 8: {
                n = R.drawable.stripe_ic_cartes_bancaires_unpadded;
                break;
            }
            case 9: {
                n = R.drawable.stripe_ic_paymentsheet_card_unknown;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Nullable
    public static final ResolvableString getLabel(@NotNull PaymentMethod $this$getLabel) {
        ResolvableString resolvableString;
        Intrinsics.checkNotNullParameter((Object)$this$getLabel, (String)"<this>");
        PaymentMethod.Type type = $this$getLabel.type;
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                PaymentMethod.Card card = $this$getLabel.card;
                resolvableString = PaymentMethodsUiExtensionKt.createCardLabel(card != null ? card.last4 : null);
                break;
            }
            case 2: {
                Object[] objectArray = new Object[1];
                PaymentMethod.SepaDebit sepaDebit = $this$getLabel.sepaDebit;
                objectArray[0] = sepaDebit != null ? sepaDebit.last4 : null;
                resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_paymentsheet_payment_method_item_card_number, (Object[])objectArray, null, (int)4, null);
                break;
            }
            case 3: {
                Object[] objectArray = new Object[1];
                PaymentMethod.USBankAccount uSBankAccount = $this$getLabel.usBankAccount;
                objectArray[0] = uSBankAccount != null ? uSBankAccount.last4 : null;
                resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_paymentsheet_payment_method_item_card_number, (Object[])objectArray, null, (int)4, null);
                break;
            }
            default: {
                resolvableString = null;
            }
        }
        return resolvableString;
    }

    @Nullable
    public static final Integer getLabelIcon(@NotNull PaymentMethod $this$getLabelIcon) {
        Intrinsics.checkNotNullParameter((Object)$this$getLabelIcon, (String)"<this>");
        PaymentMethod.Type type = $this$getLabelIcon.type;
        return (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) == 3 ? Integer.valueOf(R.drawable.stripe_ic_paymentsheet_bank) : null;
    }

    @Nullable
    public static final ResolvableString createCardLabel(@Nullable String last4) {
        ResolvableString resolvableString;
        String string2 = last4;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            Object[] objectArray = new Object[]{last4};
            resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_paymentsheet_payment_method_item_card_number, (Object[])objectArray, null, (int)4, null);
        } else {
            resolvableString = null;
        }
        return resolvableString;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PaymentMethod.Type.values().length];
            try {
                nArray[PaymentMethod.Type.Card.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.SepaDebit.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.USBankAccount.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CardBrand.values().length];
            try {
                nArray[CardBrand.Visa.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.AmericanExpress.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.Discover.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.JCB.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.DinersClub.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.MasterCard.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.UnionPay.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.CartesBancaires.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CardBrand.Unknown.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

