/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.model;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentsheet.model.StripeIntentValidatorKt;
import com.stripe.android.paymentsheet.state.PaymentSheetLoadingException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/paymentsheet/model/StripeIntentValidator;", "", "()V", "requireValid", "Lcom/stripe/android/model/StripeIntent;", "stripeIntent", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class StripeIntentValidator {
    @NotNull
    public static final StripeIntentValidator INSTANCE = new StripeIntentValidator();
    public static final int $stable;

    private StripeIntentValidator() {
    }

    @NotNull
    public final StripeIntent requireValid(@NotNull StripeIntent stripeIntent) {
        PaymentSheetLoadingException exception;
        Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
        PaymentSheetLoadingException paymentSheetLoadingException = stripeIntent instanceof PaymentIntent && ((PaymentIntent)stripeIntent).getConfirmationMethod() != PaymentIntent.ConfirmationMethod.Automatic ? (PaymentSheetLoadingException)new PaymentSheetLoadingException.InvalidConfirmationMethod(((PaymentIntent)stripeIntent).getConfirmationMethod()) : (stripeIntent instanceof PaymentIntent && StripeIntentValidatorKt.access$isInTerminalState((PaymentIntent)stripeIntent) ? (PaymentSheetLoadingException)new PaymentSheetLoadingException.PaymentIntentInTerminalState(stripeIntent.getStatus()) : (stripeIntent instanceof PaymentIntent && (((PaymentIntent)stripeIntent).getAmount() == null || ((PaymentIntent)stripeIntent).getCurrency() == null) ? (PaymentSheetLoadingException)PaymentSheetLoadingException.MissingAmountOrCurrency.INSTANCE : (exception = stripeIntent instanceof SetupIntent && StripeIntentValidatorKt.access$isInTerminalState((SetupIntent)stripeIntent) ? (PaymentSheetLoadingException)new PaymentSheetLoadingException.SetupIntentInTerminalState(stripeIntent.getStatus()) : null)));
        if (exception != null) {
            throw exception;
        }
        return stripeIntent;
    }
}

