/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.flowcontroller;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodMetadata;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.PaymentSheetConfigurationKtxKt;
import com.stripe.android.paymentsheet.flowcontroller.PaymentSelectionUpdater;
import com.stripe.android.paymentsheet.flowcontroller.PaymentSelectionUpdaterKt;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.state.CustomerState;
import com.stripe.android.paymentsheet.state.PaymentSheetState;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J'\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\bH\u0096\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/paymentsheet/flowcontroller/DefaultPaymentSelectionUpdater;", "Lcom/stripe/android/paymentsheet/flowcontroller/PaymentSelectionUpdater;", "()V", "canUseSelection", "", "selection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "state", "Lcom/stripe/android/paymentsheet/state/PaymentSheetState$Full;", "invoke", "currentSelection", "previousConfig", "Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "newState", "shouldAskForMandate", "Lcom/stripe/android/paymentsheet/model/PaymentSelection$New;", "metadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class DefaultPaymentSelectionUpdater
implements PaymentSelectionUpdater {
    public static final int $stable;

    @Inject
    public DefaultPaymentSelectionUpdater() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public PaymentSelection invoke(@Nullable PaymentSelection currentSelection, @Nullable PaymentSheet.Configuration previousConfig, @NotNull PaymentSheetState.Full newState) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                v0 = currentSelection;
                if (v0 == null) break block7;
                selection = var4_4 = v0;
                $i$a$-takeIf-DefaultPaymentSelectionUpdater$invoke$1 = false;
                if (!this.canUseSelection(selection, newState)) ** GOTO lbl-1000
                v1 = previousConfig;
                if (v1 != null) {
                    previousConfig = v1;
                    $i$a$-let-DefaultPaymentSelectionUpdater$invoke$1$1 = false;
                    v2 = !PaymentSheetConfigurationKtxKt.containsVolatileDifferences(previousConfig, newState.getConfig());
                } else {
                    v2 = true;
                }
                if (v2) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if ((v0 = v3 != false ? var4_4 : null) != null) break block8;
            }
            v0 = newState.getPaymentSelection();
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canUseSelection(PaymentSelection selection2, PaymentSheetState.Full state2) {
        boolean bl;
        List<String> allowedTypes = state2.getPaymentMethodMetadata().supportedPaymentMethodTypes();
        PaymentSelection paymentSelection = selection2;
        if (paymentSelection instanceof PaymentSelection.New) {
            boolean requiresMandate = this.shouldAskForMandate((PaymentSelection.New)selection2, state2.getPaymentMethodMetadata());
            String code = ((PaymentSelection.New)selection2).getPaymentMethodCreateParams().getTypeCode();
            if (!allowedTypes.contains(code)) return false;
            if (requiresMandate) return false;
            return true;
        }
        if (paymentSelection instanceof PaymentSelection.Saved) {
            PaymentMethod paymentMethod = ((PaymentSelection.Saved)selection2).getPaymentMethod();
            PaymentMethod.Type type = paymentMethod.type;
            String code = type != null ? type.code : null;
            if (!CollectionsKt.contains((Iterable)allowedTypes, (Object)code)) return false;
            Object object = state2.getCustomer();
            if (object == null || (object = ((CustomerState)object).getPaymentMethods()) == null) {
                object = CollectionsKt.emptyList();
            }
            if (!object.contains(paymentMethod)) return false;
            return true;
        }
        if (paymentSelection instanceof PaymentSelection.GooglePay) {
            bl = state2.getPaymentMethodMetadata().isGooglePayReady();
            return bl;
        } else {
            if (paymentSelection instanceof PaymentSelection.Link) {
                if (state2.getLinkState() == null) return false;
                return true;
            }
            if (!(paymentSelection instanceof PaymentSelection.ExternalPaymentMethod)) throw new NoWhenBranchMatchedException();
            bl = state2.getPaymentMethodMetadata().isExternalPaymentMethod(((PaymentSelection.ExternalPaymentMethod)selection2).getType());
        }
        return bl;
    }

    private final boolean shouldAskForMandate(PaymentSelection.New currentSelection, PaymentMethodMetadata metadata2) {
        String code = currentSelection.getPaymentMethodCreateParams().getTypeCode();
        boolean paymentMethodRequiresMandate = metadata2.requiresMandate(code);
        return paymentMethodRequiresMandate ? !PaymentSelectionUpdaterKt.access$getCustomerAcknowledgedMandate(currentSelection) : false;
    }
}

