/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.exception.LocalStripeException;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import com.stripe.android.payments.paymentlauncher.PaymentResult;
import com.stripe.android.paymentsheet.ExternalPaymentMethodInput;
import com.stripe.android.paymentsheet.ExternalPaymentMethodProxyActivity;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001a\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/paymentsheet/ExternalPaymentMethodContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/stripe/android/paymentsheet/ExternalPaymentMethodInput;", "Lcom/stripe/android/payments/paymentlauncher/PaymentResult;", "errorReporter", "Lcom/stripe/android/payments/core/analytics/ErrorReporter;", "(Lcom/stripe/android/payments/core/analytics/ErrorReporter;)V", "getErrorReporter", "()Lcom/stripe/android/payments/core/analytics/ErrorReporter;", "createIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "input", "parseResult", "resultCode", "", "intent", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class ExternalPaymentMethodContract
extends ActivityResultContract<ExternalPaymentMethodInput, PaymentResult> {
    @NotNull
    private final ErrorReporter errorReporter;
    public static final int $stable = 8;

    public ExternalPaymentMethodContract(@NotNull ErrorReporter errorReporter) {
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        this.errorReporter = errorReporter;
    }

    @NotNull
    public final ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull ExternalPaymentMethodInput input) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intent intent = new Intent().setClass(context, ExternalPaymentMethodProxyActivity.class).putExtra("external_payment_method_type", input.getType()).putExtra("external_payment_method_billing_details", (Parcelable)input.getBillingDetails());
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"putExtra(...)");
        return intent;
    }

    @NotNull
    public PaymentResult parseResult(int resultCode, @Nullable Intent intent) {
        PaymentResult paymentResult;
        switch (resultCode) {
            case -1: {
                paymentResult = (PaymentResult)PaymentResult.Completed.INSTANCE;
                break;
            }
            case 0: {
                paymentResult = (PaymentResult)PaymentResult.Canceled.INSTANCE;
                break;
            }
            case 1: {
                Intent intent2 = intent;
                paymentResult = (PaymentResult)new PaymentResult.Failed((Throwable)new LocalStripeException(intent2 != null ? intent2.getStringExtra("external_payment_method_error_message") : null, "externalPaymentMethodFailure"));
                break;
            }
            default: {
                ErrorReporter.DefaultImpls.report$default((ErrorReporter)this.errorReporter, (ErrorReporter.ErrorEvent)((ErrorReporter.ErrorEvent)ErrorReporter.UnexpectedErrorEvent.EXTERNAL_PAYMENT_METHOD_UNEXPECTED_RESULT_CODE), null, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"result_code", (Object)String.valueOf(resultCode))), (int)2, null);
                paymentResult = (PaymentResult)new PaymentResult.Failed((Throwable)new IllegalArgumentException("Invalid result code returned by external payment method activity"));
            }
        }
        return paymentResult;
    }
}

