/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.lpmfoundations.paymentmethod;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.CardBrandFilter;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentSheetCardBrandFilterKt;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.PaymentSheet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0006H\u00d6\u0001J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentSheetCardBrandFilter;", "Lcom/stripe/android/CardBrandFilter;", "cardBrandAcceptance", "Lcom/stripe/android/paymentsheet/PaymentSheet$CardBrandAcceptance;", "(Lcom/stripe/android/paymentsheet/PaymentSheet$CardBrandAcceptance;)V", "describeContents", "", "isAccepted", "", "cardBrand", "Lcom/stripe/android/model/CardBrand;", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
@Parcelize
@StabilityInferred(parameters=1)
public final class PaymentSheetCardBrandFilter
implements CardBrandFilter {
    @NotNull
    private final PaymentSheet.CardBrandAcceptance cardBrandAcceptance;
    public static final int $stable;
    @NotNull
    public static final Parcelable.Creator<PaymentSheetCardBrandFilter> CREATOR;

    public PaymentSheetCardBrandFilter(@NotNull PaymentSheet.CardBrandAcceptance cardBrandAcceptance) {
        Intrinsics.checkNotNullParameter((Object)cardBrandAcceptance, (String)"cardBrandAcceptance");
        this.cardBrandAcceptance = cardBrandAcceptance;
    }

    public boolean isAccepted(@NotNull CardBrand cardBrand) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)cardBrand, (String)"cardBrand");
        PaymentSheet.CardBrandAcceptance.BrandCategory brandCategory = PaymentSheetCardBrandFilterKt.toBrandCategory(cardBrand);
        PaymentSheet.CardBrandAcceptance cardBrandAcceptance = this.cardBrandAcceptance;
        if (cardBrandAcceptance instanceof PaymentSheet.CardBrandAcceptance.All) {
            bl = true;
        } else if (cardBrandAcceptance instanceof PaymentSheet.CardBrandAcceptance.Allowed) {
            boolean isAllowed;
            boolean bl2 = isAllowed = brandCategory != null && ((PaymentSheet.CardBrandAcceptance.Allowed)this.cardBrandAcceptance).getBrands().contains((Object)brandCategory);
            if (!isAllowed) {
                // empty if block
            }
            bl = isAllowed;
        } else if (cardBrandAcceptance instanceof PaymentSheet.CardBrandAcceptance.Disallowed) {
            boolean isDisallowed;
            boolean bl3 = isDisallowed = brandCategory != null && ((PaymentSheet.CardBrandAcceptance.Disallowed)this.cardBrandAcceptance).getBrands().contains((Object)brandCategory);
            if (isDisallowed) {
                // empty if block
            }
            bl = !isDisallowed;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public final boolean isAccepted(@NotNull PaymentMethod paymentMethod) {
        Object object;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
                object = paymentMethod.card;
                if (object == null || (object = object.displayBrand) == null) break block3;
                Object displayBrand = object;
                boolean bl = false;
                CardBrand cardBrand = CardBrand.Companion.fromCode((String)displayBrand);
                CardBrand cardBrand2 = cardBrand == CardBrand.Unknown ? null : cardBrand;
                object = cardBrand2;
                if (cardBrand2 != null) break block4;
            }
            PaymentMethod.Card card = paymentMethod.card;
            object = card != null ? card.brand : CardBrand.Unknown;
        }
        Object brand = object;
        return paymentMethod.type != PaymentMethod.Type.Card || this.isAccepted((CardBrand)brand);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeParcelable((Parcelable)this.cardBrandAcceptance, flags);
    }

    static {
        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<PaymentSheetCardBrandFilter> {
            @NotNull
            public final PaymentSheetCardBrandFilter[] newArray(int size) {
                return new PaymentSheetCardBrandFilter[size];
            }

            @NotNull
            public final PaymentSheetCardBrandFilter createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new PaymentSheetCardBrandFilter((PaymentSheet.CardBrandAcceptance)parcel.readParcelable(PaymentSheetCardBrandFilter.class.getClassLoader()));
            }
        }
        CREATOR = new Creator();
    }
}

