/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.lpmfoundations.paymentmethod;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.customersheet.CustomerSheet;
import com.stripe.android.lpmfoundations.FormHeaderInformation;
import com.stripe.android.lpmfoundations.luxe.SupportedPaymentMethod;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodDefinition;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodDefinitionKt;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodMetadataKtxKt;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodRegistry;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodSaveConsentBehavior;
import com.stripe.android.lpmfoundations.paymentmethod.UiDefinitionFactory;
import com.stripe.android.lpmfoundations.paymentmethod.definitions.ExternalPaymentMethodUiDefinitionFactory;
import com.stripe.android.lpmfoundations.paymentmethod.definitions.LinkCardBrandDefinition;
import com.stripe.android.lpmfoundations.paymentmethod.link.LinkInlineConfiguration;
import com.stripe.android.model.ElementsSession;
import com.stripe.android.model.LinkMode;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.payments.financialconnections.DefaultIsFinancialConnectionsAvailable;
import com.stripe.android.payments.financialconnections.IsFinancialConnectionsAvailable;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.addresselement.AddressDetails;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.ui.core.Amount;
import com.stripe.android.ui.core.cbc.CardBrandChoiceEligibility;
import com.stripe.android.ui.core.elements.ExternalPaymentMethodSpec;
import com.stripe.android.ui.core.elements.SharedDataSpec;
import com.stripe.android.uicore.elements.FormElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u0081\b\u0018\u0000 z2\u00020\u0001:\u0001zB\u00a9\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000b\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\n\u0012\u0006\u0010\u0017\u001a\u00020\u0007\u0012\u0006\u0010\u0018\u001a\u00020\u0007\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u0012\b\b\u0002\u0010\u001f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010 J\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?J\b\u0010@\u001a\u0004\u0018\u00010AJ\t\u0010B\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00140\nH\u00c6\u0003J\u000f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00160\nH\u00c6\u0003J\t\u0010E\u001a\u00020\u0007H\u00c6\u0003J\t\u0010F\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010G\u001a\u0004\u0018\u00010\u001aH\u00c6\u0003J\t\u0010H\u001a\u00020\u001cH\u00c6\u0003J\u000b\u0010I\u001a\u0004\u0018\u00010\u001eH\u00c6\u0003J\t\u0010J\u001a\u00020\u0007H\u00c6\u0003J\t\u0010K\u001a\u00020\u0005H\u00c6\u0003J\t\u0010L\u001a\u00020\u0007H\u00c6\u0003J\t\u0010M\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010N\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\t\u0010O\u001a\u00020\rH\u00c6\u0003J\t\u0010P\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010Q\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\u000b\u0010R\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\u00cd\u0001\u0010S\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\n2\b\b\u0002\u0010\u0017\u001a\u00020\u00072\b\b\u0002\u0010\u0018\u001a\u00020\u00072\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u0007H\u00c6\u0001J\t\u0010T\u001a\u00020UH\u00d6\u0001J\u0013\u0010V\u001a\u00020\u00072\b\u0010W\u001a\u0004\u0018\u00010XH\u00d6\u0003J\u000e\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u001e\u0010Z\u001a\n\u0012\u0004\u0012\u00020[\u0018\u00010\n2\u0006\u0010\\\u001a\u00020\u000b2\u0006\u0010]\u001a\u00020^J\u0018\u0010_\u001a\u0004\u0018\u00010`2\u0006\u0010\\\u001a\u00020\u000b2\u0006\u0010a\u001a\u00020\u0007J\u0012\u0010b\u001a\u0004\u0018\u00010c2\u0006\u0010\\\u001a\u00020\u000bH\u0002J\u0006\u0010d\u001a\u00020\u0007J\t\u0010e\u001a\u00020UH\u00d6\u0001J\u000e\u0010f\u001a\u00020\u00072\u0006\u0010\\\u001a\u00020\u000bJ\u000e\u0010g\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u000e\u0010h\u001a\u00020\u00072\u0006\u0010i\u001a\u00020\u000bJ\f\u0010j\u001a\b\u0012\u0004\u0012\u00020k0\nJ\u000e\u0010l\u001a\b\u0012\u0004\u0012\u00020m0\nH\u0002J\u0010\u0010n\u001a\u0004\u0018\u00010k2\u0006\u0010\\\u001a\u00020\u000bJ\f\u0010o\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\f\u0010p\u001a\b\u0012\u0004\u0012\u00020q0\nJ\t\u0010r\u001a\u00020\u000bH\u00d6\u0001J\u0019\u0010s\u001a\u00020t2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020UH\u00d6\u0001J\u001e\u0010x\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020U0y*\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\n\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u001f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\"R\u0011\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\"R\u0011\u0010\u0018\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\"R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010+R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010+R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;\u00a8\u0006{"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "Landroid/os/Parcelable;", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "billingDetailsCollectionConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "allowsDelayedPaymentMethods", "", "allowsPaymentMethodsRequiringShippingAddress", "paymentMethodOrder", "", "", "cbcEligibility", "Lcom/stripe/android/ui/core/cbc/CardBrandChoiceEligibility;", "merchantName", "defaultBillingDetails", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "shippingDetails", "Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;", "sharedDataSpecs", "Lcom/stripe/android/ui/core/elements/SharedDataSpec;", "externalPaymentMethodSpecs", "Lcom/stripe/android/ui/core/elements/ExternalPaymentMethodSpec;", "hasCustomerConfiguration", "isGooglePayReady", "linkInlineConfiguration", "Lcom/stripe/android/lpmfoundations/paymentmethod/link/LinkInlineConfiguration;", "paymentMethodSaveConsentBehavior", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodSaveConsentBehavior;", "linkMode", "Lcom/stripe/android/model/LinkMode;", "financialConnectionsAvailable", "(Lcom/stripe/android/model/StripeIntent;Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;ZZLjava/util/List;Lcom/stripe/android/ui/core/cbc/CardBrandChoiceEligibility;Ljava/lang/String;Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;Ljava/util/List;Ljava/util/List;ZZLcom/stripe/android/lpmfoundations/paymentmethod/link/LinkInlineConfiguration;Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodSaveConsentBehavior;Lcom/stripe/android/model/LinkMode;Z)V", "getAllowsDelayedPaymentMethods", "()Z", "getAllowsPaymentMethodsRequiringShippingAddress", "getBillingDetailsCollectionConfiguration", "()Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "getCbcEligibility", "()Lcom/stripe/android/ui/core/cbc/CardBrandChoiceEligibility;", "getDefaultBillingDetails", "()Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "getExternalPaymentMethodSpecs", "()Ljava/util/List;", "getFinancialConnectionsAvailable", "getHasCustomerConfiguration", "getLinkInlineConfiguration", "()Lcom/stripe/android/lpmfoundations/paymentmethod/link/LinkInlineConfiguration;", "getLinkMode", "()Lcom/stripe/android/model/LinkMode;", "getMerchantName", "()Ljava/lang/String;", "getPaymentMethodOrder", "getPaymentMethodSaveConsentBehavior", "()Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodSaveConsentBehavior;", "getSharedDataSpecs", "getShippingDetails", "()Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;", "getStripeIntent", "()Lcom/stripe/android/model/StripeIntent;", "allowRedisplay", "Lcom/stripe/android/model/PaymentMethod$AllowRedisplay;", "customerRequestedSave", "Lcom/stripe/android/paymentsheet/model/PaymentSelection$CustomerRequestedSave;", "amount", "Lcom/stripe/android/ui/core/Amount;", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "describeContents", "", "equals", "other", "", "externalPaymentMethodTypes", "formElementsForCode", "Lcom/stripe/android/uicore/elements/FormElement;", "code", "uiDefinitionFactoryArgumentsFactory", "Lcom/stripe/android/lpmfoundations/paymentmethod/UiDefinitionFactory$Arguments$Factory;", "formHeaderInformationForCode", "Lcom/stripe/android/lpmfoundations/FormHeaderInformation;", "customerHasSavedPaymentMethods", "getUiDefinitionFactoryForExternalPaymentMethod", "Lcom/stripe/android/lpmfoundations/paymentmethod/UiDefinitionFactory$Simple;", "hasIntentToSetup", "hashCode", "isExternalPaymentMethod", "orderedPaymentMethodTypes", "requiresMandate", "paymentMethodCode", "sortedSupportedPaymentMethods", "Lcom/stripe/android/lpmfoundations/luxe/SupportedPaymentMethod;", "supportedPaymentMethodDefinitions", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodDefinition;", "supportedPaymentMethodForCode", "supportedPaymentMethodTypes", "supportedSavedPaymentMethodTypes", "Lcom/stripe/android/model/PaymentMethod$Type;", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "mapOrderToIndex", "", "Companion", "paymentsheet_release"})
@Parcelize
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPaymentMethodMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentMethodMetadata.kt\ncom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n1549#2:289\n1620#2,3:290\n1045#2:293\n766#2:294\n857#2,2:295\n1549#2:297\n1620#2,3:298\n288#2,2:301\n1603#2,9:303\n1855#2:312\n1856#2:314\n1612#2:315\n1559#2:316\n1590#2,4:317\n1549#2:321\n1620#2,3:322\n288#2,2:325\n1603#2,9:327\n1855#2:336\n1856#2:338\n1612#2:339\n766#2:340\n857#2,2:341\n766#2:343\n857#2,2:344\n819#2:346\n847#2,2:347\n766#2:349\n857#2,2:350\n288#2,2:352\n288#2,2:354\n1#3:313\n1#3:337\n*S KotlinDebug\n*F\n+ 1 PaymentMethodMetadata.kt\ncom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata\n*L\n64#1:289\n64#1:290,3\n72#1:293\n80#1:294\n80#1:295,2\n82#1:297\n82#1:298,3\n93#1:301,2\n99#1:303,9\n99#1:312\n99#1:314\n99#1:315\n120#1:316\n120#1:317,4\n126#1:321\n126#1:322,3\n134#1:325,2\n139#1:327,9\n139#1:336\n139#1:338\n139#1:339\n141#1:340\n141#1:341,2\n145#1:343\n145#1:344,2\n151#1:346\n151#1:347,2\n154#1:349\n154#1:350,2\n178#1:352,2\n199#1:354,2\n99#1:313\n139#1:337\n*E\n"})
public final class PaymentMethodMetadata
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StripeIntent stripeIntent;
    @NotNull
    private final PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration;
    private final boolean allowsDelayedPaymentMethods;
    private final boolean allowsPaymentMethodsRequiringShippingAddress;
    @NotNull
    private final List<String> paymentMethodOrder;
    @NotNull
    private final CardBrandChoiceEligibility cbcEligibility;
    @NotNull
    private final String merchantName;
    @Nullable
    private final PaymentSheet.BillingDetails defaultBillingDetails;
    @Nullable
    private final AddressDetails shippingDetails;
    @NotNull
    private final List<SharedDataSpec> sharedDataSpecs;
    @NotNull
    private final List<ExternalPaymentMethodSpec> externalPaymentMethodSpecs;
    private final boolean hasCustomerConfiguration;
    private final boolean isGooglePayReady;
    @Nullable
    private final LinkInlineConfiguration linkInlineConfiguration;
    @NotNull
    private final PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior;
    @Nullable
    private final LinkMode linkMode;
    private final boolean financialConnectionsAvailable;
    public static final int $stable = 8;
    @NotNull
    public static final Parcelable.Creator<PaymentMethodMetadata> CREATOR;

    public PaymentMethodMetadata(@NotNull StripeIntent stripeIntent, @NotNull PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration, boolean allowsDelayedPaymentMethods, boolean allowsPaymentMethodsRequiringShippingAddress, @NotNull List<String> paymentMethodOrder, @NotNull CardBrandChoiceEligibility cbcEligibility, @NotNull String merchantName, @Nullable PaymentSheet.BillingDetails defaultBillingDetails, @Nullable AddressDetails shippingDetails, @NotNull List<SharedDataSpec> sharedDataSpecs, @NotNull List<ExternalPaymentMethodSpec> externalPaymentMethodSpecs, boolean hasCustomerConfiguration, boolean isGooglePayReady2, @Nullable LinkInlineConfiguration linkInlineConfiguration, @NotNull PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior, @Nullable LinkMode linkMode, boolean financialConnectionsAvailable) {
        Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
        Intrinsics.checkNotNullParameter((Object)billingDetailsCollectionConfiguration, (String)"billingDetailsCollectionConfiguration");
        Intrinsics.checkNotNullParameter(paymentMethodOrder, (String)"paymentMethodOrder");
        Intrinsics.checkNotNullParameter((Object)cbcEligibility, (String)"cbcEligibility");
        Intrinsics.checkNotNullParameter((Object)merchantName, (String)"merchantName");
        Intrinsics.checkNotNullParameter(sharedDataSpecs, (String)"sharedDataSpecs");
        Intrinsics.checkNotNullParameter(externalPaymentMethodSpecs, (String)"externalPaymentMethodSpecs");
        Intrinsics.checkNotNullParameter((Object)paymentMethodSaveConsentBehavior, (String)"paymentMethodSaveConsentBehavior");
        this.stripeIntent = stripeIntent;
        this.billingDetailsCollectionConfiguration = billingDetailsCollectionConfiguration;
        this.allowsDelayedPaymentMethods = allowsDelayedPaymentMethods;
        this.allowsPaymentMethodsRequiringShippingAddress = allowsPaymentMethodsRequiringShippingAddress;
        this.paymentMethodOrder = paymentMethodOrder;
        this.cbcEligibility = cbcEligibility;
        this.merchantName = merchantName;
        this.defaultBillingDetails = defaultBillingDetails;
        this.shippingDetails = shippingDetails;
        this.sharedDataSpecs = sharedDataSpecs;
        this.externalPaymentMethodSpecs = externalPaymentMethodSpecs;
        this.hasCustomerConfiguration = hasCustomerConfiguration;
        this.isGooglePayReady = isGooglePayReady2;
        this.linkInlineConfiguration = linkInlineConfiguration;
        this.paymentMethodSaveConsentBehavior = paymentMethodSaveConsentBehavior;
        this.linkMode = linkMode;
        this.financialConnectionsAvailable = financialConnectionsAvailable;
    }

    public /* synthetic */ PaymentMethodMetadata(StripeIntent stripeIntent, PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration, boolean bl, boolean bl2, List list, CardBrandChoiceEligibility cardBrandChoiceEligibility, String string2, PaymentSheet.BillingDetails billingDetails, AddressDetails addressDetails, List list2, List list3, boolean bl3, boolean bl4, LinkInlineConfiguration linkInlineConfiguration, PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior, LinkMode linkMode, boolean bl5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10000) != 0) {
            bl5 = DefaultIsFinancialConnectionsAvailable.INSTANCE.invoke();
        }
        this(stripeIntent, billingDetailsCollectionConfiguration, bl, bl2, list, cardBrandChoiceEligibility, string2, billingDetails, addressDetails, list2, list3, bl3, bl4, linkInlineConfiguration, paymentMethodSaveConsentBehavior, linkMode, bl5);
    }

    @NotNull
    public final StripeIntent getStripeIntent() {
        return this.stripeIntent;
    }

    @NotNull
    public final PaymentSheet.BillingDetailsCollectionConfiguration getBillingDetailsCollectionConfiguration() {
        return this.billingDetailsCollectionConfiguration;
    }

    public final boolean getAllowsDelayedPaymentMethods() {
        return this.allowsDelayedPaymentMethods;
    }

    public final boolean getAllowsPaymentMethodsRequiringShippingAddress() {
        return this.allowsPaymentMethodsRequiringShippingAddress;
    }

    @NotNull
    public final List<String> getPaymentMethodOrder() {
        return this.paymentMethodOrder;
    }

    @NotNull
    public final CardBrandChoiceEligibility getCbcEligibility() {
        return this.cbcEligibility;
    }

    @NotNull
    public final String getMerchantName() {
        return this.merchantName;
    }

    @Nullable
    public final PaymentSheet.BillingDetails getDefaultBillingDetails() {
        return this.defaultBillingDetails;
    }

    @Nullable
    public final AddressDetails getShippingDetails() {
        return this.shippingDetails;
    }

    @NotNull
    public final List<SharedDataSpec> getSharedDataSpecs() {
        return this.sharedDataSpecs;
    }

    @NotNull
    public final List<ExternalPaymentMethodSpec> getExternalPaymentMethodSpecs() {
        return this.externalPaymentMethodSpecs;
    }

    public final boolean getHasCustomerConfiguration() {
        return this.hasCustomerConfiguration;
    }

    public final boolean isGooglePayReady() {
        return this.isGooglePayReady;
    }

    @Nullable
    public final LinkInlineConfiguration getLinkInlineConfiguration() {
        return this.linkInlineConfiguration;
    }

    @NotNull
    public final PaymentMethodSaveConsentBehavior getPaymentMethodSaveConsentBehavior() {
        return this.paymentMethodSaveConsentBehavior;
    }

    @Nullable
    public final LinkMode getLinkMode() {
        return this.linkMode;
    }

    public final boolean getFinancialConnectionsAvailable() {
        return this.financialConnectionsAvailable;
    }

    public final boolean hasIntentToSetup() {
        boolean bl;
        StripeIntent stripeIntent = this.stripeIntent;
        if (stripeIntent instanceof PaymentIntent) {
            bl = ((PaymentIntent)this.stripeIntent).getSetupFutureUsage() != null;
        } else if (stripeIntent instanceof SetupIntent) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public final boolean requiresMandate(@NotNull String paymentMethodCode) {
        Intrinsics.checkNotNullParameter((Object)paymentMethodCode, (String)"paymentMethodCode");
        PaymentMethodDefinition paymentMethodDefinition = PaymentMethodRegistry.INSTANCE.getDefinitionsByCode().get(paymentMethodCode);
        return paymentMethodDefinition != null ? paymentMethodDefinition.requiresMandate(this) : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> supportedPaymentMethodTypes() {
        List list;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.supportedPaymentMethodDefinitions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void paymentMethodDefinition;
            PaymentMethodDefinition paymentMethodDefinition2 = (PaymentMethodDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(paymentMethodDefinition.getType().code);
        }
        List $this$supportedPaymentMethodTypes_u24lambda_u242 = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.externalPaymentMethodTypes());
        boolean bl = false;
        if (this.paymentMethodOrder.isEmpty()) {
            list = $this$supportedPaymentMethodTypes_u24lambda_u242;
        } else {
            Map<String, Integer> orderedPaymentMethodTypes = this.mapOrderToIndex(this.orderedPaymentMethodTypes());
            Iterable $this$sortedBy$iv = $this$supportedPaymentMethodTypes_u24lambda_u242;
            boolean $i$f$sortedBy = false;
            list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(orderedPaymentMethodTypes){
                final /* synthetic */ Map $orderedPaymentMethodTypes$inlined;
                {
                    this.$orderedPaymentMethodTypes$inlined = map2;
                }

                public final int compare(T a, T b) {
                    String code = (String)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)this.$orderedPaymentMethodTypes$inlined.get(code);
                    code = (String)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)this.$orderedPaymentMethodTypes$inlined.get(code)));
                }
            });
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PaymentMethod.Type> supportedSavedPaymentMethodTypes() {
        void $this$mapTo$iv$iv;
        PaymentMethodDefinition paymentMethodDefinition;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.supportedPaymentMethodDefinitions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            paymentMethodDefinition = (PaymentMethodDefinition)element$iv$iv;
            boolean bl = false;
            if (!paymentMethodDefinition.getSupportedAsSavedPaymentMethod()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            paymentMethodDefinition = (PaymentMethodDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final SupportedPaymentMethod supportedPaymentMethodForCode(@NotNull String code) {
        SupportedPaymentMethod supportedPaymentMethod;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        if (this.isExternalPaymentMethod(code)) {
            UiDefinitionFactory.Simple simple = this.getUiDefinitionFactoryForExternalPaymentMethod(code);
            supportedPaymentMethod = simple != null ? simple.createSupportedPaymentMethod() : null;
        } else {
            Object v2;
            block4: {
                Iterable $this$firstOrNull$iv = this.supportedPaymentMethodDefinitions();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PaymentMethodDefinition it = (PaymentMethodDefinition)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType().code, (Object)code)) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            PaymentMethodDefinition paymentMethodDefinition = v2;
            if (paymentMethodDefinition == null) {
                return null;
            }
            PaymentMethodDefinition definition = paymentMethodDefinition;
            supportedPaymentMethod = definition.uiDefinitionFactory().supportedPaymentMethod(definition, this.sharedDataSpecs);
        }
        return supportedPaymentMethod;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SupportedPaymentMethod> sortedSupportedPaymentMethods() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.supportedPaymentMethodTypes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            SupportedPaymentMethod it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.supportedPaymentMethodForCode(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> orderedPaymentMethodTypes() {
        List originalOrderedTypes = CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)this.stripeIntent.getPaymentMethodTypes(), (Iterable)this.externalPaymentMethodTypes()));
        List result2 = new ArrayList();
        for (String pm : this.paymentMethodOrder) {
            if (!originalOrderedTypes.contains(pm)) continue;
            ((Collection)result2).add(pm);
            originalOrderedTypes.remove(pm);
        }
        result2.addAll(originalOrderedTypes);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Integer> mapOrderToIndex(List<String> $this$mapOrderToIndex) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = $this$mapOrderToIndex;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void s;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)s, (Object)((int)index)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> externalPaymentMethodTypes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.externalPaymentMethodSpecs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExternalPaymentMethodSpec externalPaymentMethodSpec = (ExternalPaymentMethodSpec)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        return (List)destination$iv$iv;
    }

    public final boolean isExternalPaymentMethod(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return this.externalPaymentMethodTypes().contains(code);
    }

    private final UiDefinitionFactory.Simple getUiDefinitionFactoryForExternalPaymentMethod(String code) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = this.externalPaymentMethodSpecs;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ExternalPaymentMethodSpec it = (ExternalPaymentMethodSpec)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)code)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        ExternalPaymentMethodSpec externalPaymentMethodSpec = v0;
        if (externalPaymentMethodSpec == null) {
            return null;
        }
        ExternalPaymentMethodSpec externalPaymentMethodSpecForCode = externalPaymentMethodSpec;
        return new ExternalPaymentMethodUiDefinitionFactory(externalPaymentMethodSpecForCode);
    }

    /*
     * WARNING - void declaration
     */
    private final List<PaymentMethodDefinition> supportedPaymentMethodDefinitions() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterNotTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.stripeIntent.getPaymentMethodTypes();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PaymentMethodDefinition it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (PaymentMethodRegistry.INSTANCE.getDefinitionsByCode().get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv2 = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            PaymentMethodDefinition it = (PaymentMethodDefinition)element$iv$iv;
            boolean bl = false;
            if (!PaymentMethodDefinitionKt.isSupported(it, this)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List supportedPaymentMethodTypes = (List)destination$iv$iv;
        Iterable $this$filter$iv3 = CollectionsKt.listOf((Object)LinkCardBrandDefinition.INSTANCE);
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv3;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            LinkCardBrandDefinition it = (LinkCardBrandDefinition)element$iv$iv;
            boolean bl = false;
            if (!PaymentMethodDefinitionKt.isSupported(it, this)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List syntheticPaymentMethodTypes = (List)destination$iv$iv2;
        List paymentMethodTypes = CollectionsKt.plus((Collection)supportedPaymentMethodTypes, (Iterable)syntheticPaymentMethodTypes);
        Iterable $this$filterNot$iv = paymentMethodTypes;
        boolean $i$f$filterNot = false;
        destination$iv$iv2 = $this$filterNot$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            PaymentMethodDefinition it = (PaymentMethodDefinition)element$iv$iv;
            boolean bl = false;
            if (this.stripeIntent.isLiveMode() && this.stripeIntent.getUnactivatedPaymentMethods().contains(it.getType().code)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv3;
        boolean $i$f$filter3 = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PaymentMethodDefinition paymentMethodDefinition = (PaymentMethodDefinition)element$iv$iv;
            boolean bl = false;
            if (!paymentMethodDefinition.uiDefinitionFactory().canBeDisplayedInUi(paymentMethodDefinition, this.sharedDataSpecs)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        return (List)destination$iv$iv3;
    }

    @Nullable
    public final Amount amount() {
        if (this.stripeIntent instanceof PaymentIntent) {
            Long l = ((PaymentIntent)this.stripeIntent).getAmount();
            if (l == null) {
                String string2 = "Required value was null.";
                throw new IllegalArgumentException(string2.toString());
            }
            String string3 = ((PaymentIntent)this.stripeIntent).getCurrency();
            if (string3 == null) {
                String string4 = "Required value was null.";
                throw new IllegalArgumentException(string4.toString());
            }
            return new Amount(((Number)l).longValue(), string3);
        }
        return null;
    }

    @Nullable
    public final FormHeaderInformation formHeaderInformationForCode(@NotNull String code, boolean customerHasSavedPaymentMethods) {
        FormHeaderInformation formHeaderInformation;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        if (this.isExternalPaymentMethod(code)) {
            UiDefinitionFactory.Simple simple = this.getUiDefinitionFactoryForExternalPaymentMethod(code);
            formHeaderInformation = simple != null ? simple.createFormHeaderInformation(customerHasSavedPaymentMethods) : null;
        } else {
            Object v2;
            block4: {
                Iterable $this$firstOrNull$iv = this.supportedPaymentMethodDefinitions();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PaymentMethodDefinition it = (PaymentMethodDefinition)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType().code, (Object)code)) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            PaymentMethodDefinition paymentMethodDefinition = v2;
            if (paymentMethodDefinition == null) {
                return null;
            }
            PaymentMethodDefinition definition = paymentMethodDefinition;
            UiDefinitionFactory uiDefinitionFactory = definition.uiDefinitionFactory();
            List<SharedDataSpec> list = this.sharedDataSpecs;
            formHeaderInformation = uiDefinitionFactory.formHeaderInformation(definition, this, list, customerHasSavedPaymentMethods);
        }
        return formHeaderInformation;
    }

    @Nullable
    public final List<FormElement> formElementsForCode(@NotNull String code, @NotNull UiDefinitionFactory.Arguments.Factory uiDefinitionFactoryArgumentsFactory) {
        List<FormElement> list;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)uiDefinitionFactoryArgumentsFactory, (String)"uiDefinitionFactoryArgumentsFactory");
        if (this.isExternalPaymentMethod(code)) {
            UiDefinitionFactory.Simple simple = this.getUiDefinitionFactoryForExternalPaymentMethod(code);
            list = simple != null ? simple.createFormElements(this, uiDefinitionFactoryArgumentsFactory.create(this, false)) : null;
        } else {
            Object v2;
            block4: {
                Iterable $this$firstOrNull$iv = this.supportedPaymentMethodDefinitions();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PaymentMethodDefinition it = (PaymentMethodDefinition)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType().code, (Object)code)) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            PaymentMethodDefinition paymentMethodDefinition = v2;
            if (paymentMethodDefinition == null) {
                return null;
            }
            PaymentMethodDefinition definition = paymentMethodDefinition;
            UiDefinitionFactory uiDefinitionFactory = definition.uiDefinitionFactory();
            List<SharedDataSpec> list2 = this.sharedDataSpecs;
            UiDefinitionFactory.Arguments arguments = uiDefinitionFactoryArgumentsFactory.create(this, definition.requiresMandate(this));
            list = uiDefinitionFactory.formElements(definition, this, list2, arguments);
        }
        return list;
    }

    @NotNull
    public final PaymentMethod.AllowRedisplay allowRedisplay(@NotNull PaymentSelection.CustomerRequestedSave customerRequestedSave) {
        Intrinsics.checkNotNullParameter((Object)((Object)customerRequestedSave), (String)"customerRequestedSave");
        return this.paymentMethodSaveConsentBehavior.allowRedisplay(this.hasIntentToSetup(), customerRequestedSave);
    }

    @NotNull
    public final StripeIntent component1() {
        return this.stripeIntent;
    }

    @NotNull
    public final PaymentSheet.BillingDetailsCollectionConfiguration component2() {
        return this.billingDetailsCollectionConfiguration;
    }

    public final boolean component3() {
        return this.allowsDelayedPaymentMethods;
    }

    public final boolean component4() {
        return this.allowsPaymentMethodsRequiringShippingAddress;
    }

    @NotNull
    public final List<String> component5() {
        return this.paymentMethodOrder;
    }

    @NotNull
    public final CardBrandChoiceEligibility component6() {
        return this.cbcEligibility;
    }

    @NotNull
    public final String component7() {
        return this.merchantName;
    }

    @Nullable
    public final PaymentSheet.BillingDetails component8() {
        return this.defaultBillingDetails;
    }

    @Nullable
    public final AddressDetails component9() {
        return this.shippingDetails;
    }

    @NotNull
    public final List<SharedDataSpec> component10() {
        return this.sharedDataSpecs;
    }

    @NotNull
    public final List<ExternalPaymentMethodSpec> component11() {
        return this.externalPaymentMethodSpecs;
    }

    public final boolean component12() {
        return this.hasCustomerConfiguration;
    }

    public final boolean component13() {
        return this.isGooglePayReady;
    }

    @Nullable
    public final LinkInlineConfiguration component14() {
        return this.linkInlineConfiguration;
    }

    @NotNull
    public final PaymentMethodSaveConsentBehavior component15() {
        return this.paymentMethodSaveConsentBehavior;
    }

    @Nullable
    public final LinkMode component16() {
        return this.linkMode;
    }

    public final boolean component17() {
        return this.financialConnectionsAvailable;
    }

    @NotNull
    public final PaymentMethodMetadata copy(@NotNull StripeIntent stripeIntent, @NotNull PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration, boolean allowsDelayedPaymentMethods, boolean allowsPaymentMethodsRequiringShippingAddress, @NotNull List<String> paymentMethodOrder, @NotNull CardBrandChoiceEligibility cbcEligibility, @NotNull String merchantName, @Nullable PaymentSheet.BillingDetails defaultBillingDetails, @Nullable AddressDetails shippingDetails, @NotNull List<SharedDataSpec> sharedDataSpecs, @NotNull List<ExternalPaymentMethodSpec> externalPaymentMethodSpecs, boolean hasCustomerConfiguration, boolean isGooglePayReady2, @Nullable LinkInlineConfiguration linkInlineConfiguration, @NotNull PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior, @Nullable LinkMode linkMode, boolean financialConnectionsAvailable) {
        Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
        Intrinsics.checkNotNullParameter((Object)billingDetailsCollectionConfiguration, (String)"billingDetailsCollectionConfiguration");
        Intrinsics.checkNotNullParameter(paymentMethodOrder, (String)"paymentMethodOrder");
        Intrinsics.checkNotNullParameter((Object)cbcEligibility, (String)"cbcEligibility");
        Intrinsics.checkNotNullParameter((Object)merchantName, (String)"merchantName");
        Intrinsics.checkNotNullParameter(sharedDataSpecs, (String)"sharedDataSpecs");
        Intrinsics.checkNotNullParameter(externalPaymentMethodSpecs, (String)"externalPaymentMethodSpecs");
        Intrinsics.checkNotNullParameter((Object)paymentMethodSaveConsentBehavior, (String)"paymentMethodSaveConsentBehavior");
        return new PaymentMethodMetadata(stripeIntent, billingDetailsCollectionConfiguration, allowsDelayedPaymentMethods, allowsPaymentMethodsRequiringShippingAddress, paymentMethodOrder, cbcEligibility, merchantName, defaultBillingDetails, shippingDetails, sharedDataSpecs, externalPaymentMethodSpecs, hasCustomerConfiguration, isGooglePayReady2, linkInlineConfiguration, paymentMethodSaveConsentBehavior, linkMode, financialConnectionsAvailable);
    }

    public static /* synthetic */ PaymentMethodMetadata copy$default(PaymentMethodMetadata paymentMethodMetadata, StripeIntent stripeIntent, PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration, boolean bl, boolean bl2, List list, CardBrandChoiceEligibility cardBrandChoiceEligibility, String string2, PaymentSheet.BillingDetails billingDetails, AddressDetails addressDetails, List list2, List list3, boolean bl3, boolean bl4, LinkInlineConfiguration linkInlineConfiguration, PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior, LinkMode linkMode, boolean bl5, int n, Object object) {
        if ((n & 1) != 0) {
            stripeIntent = paymentMethodMetadata.stripeIntent;
        }
        if ((n & 2) != 0) {
            billingDetailsCollectionConfiguration = paymentMethodMetadata.billingDetailsCollectionConfiguration;
        }
        if ((n & 4) != 0) {
            bl = paymentMethodMetadata.allowsDelayedPaymentMethods;
        }
        if ((n & 8) != 0) {
            bl2 = paymentMethodMetadata.allowsPaymentMethodsRequiringShippingAddress;
        }
        if ((n & 0x10) != 0) {
            list = paymentMethodMetadata.paymentMethodOrder;
        }
        if ((n & 0x20) != 0) {
            cardBrandChoiceEligibility = paymentMethodMetadata.cbcEligibility;
        }
        if ((n & 0x40) != 0) {
            string2 = paymentMethodMetadata.merchantName;
        }
        if ((n & 0x80) != 0) {
            billingDetails = paymentMethodMetadata.defaultBillingDetails;
        }
        if ((n & 0x100) != 0) {
            addressDetails = paymentMethodMetadata.shippingDetails;
        }
        if ((n & 0x200) != 0) {
            list2 = paymentMethodMetadata.sharedDataSpecs;
        }
        if ((n & 0x400) != 0) {
            list3 = paymentMethodMetadata.externalPaymentMethodSpecs;
        }
        if ((n & 0x800) != 0) {
            bl3 = paymentMethodMetadata.hasCustomerConfiguration;
        }
        if ((n & 0x1000) != 0) {
            bl4 = paymentMethodMetadata.isGooglePayReady;
        }
        if ((n & 0x2000) != 0) {
            linkInlineConfiguration = paymentMethodMetadata.linkInlineConfiguration;
        }
        if ((n & 0x4000) != 0) {
            paymentMethodSaveConsentBehavior = paymentMethodMetadata.paymentMethodSaveConsentBehavior;
        }
        if ((n & 0x8000) != 0) {
            linkMode = paymentMethodMetadata.linkMode;
        }
        if ((n & 0x10000) != 0) {
            bl5 = paymentMethodMetadata.financialConnectionsAvailable;
        }
        return paymentMethodMetadata.copy(stripeIntent, billingDetailsCollectionConfiguration, bl, bl2, list, cardBrandChoiceEligibility, string2, billingDetails, addressDetails, list2, list3, bl3, bl4, linkInlineConfiguration, paymentMethodSaveConsentBehavior, linkMode, bl5);
    }

    @NotNull
    public String toString() {
        return "PaymentMethodMetadata(stripeIntent=" + this.stripeIntent + ", billingDetailsCollectionConfiguration=" + this.billingDetailsCollectionConfiguration + ", allowsDelayedPaymentMethods=" + this.allowsDelayedPaymentMethods + ", allowsPaymentMethodsRequiringShippingAddress=" + this.allowsPaymentMethodsRequiringShippingAddress + ", paymentMethodOrder=" + this.paymentMethodOrder + ", cbcEligibility=" + this.cbcEligibility + ", merchantName=" + this.merchantName + ", defaultBillingDetails=" + this.defaultBillingDetails + ", shippingDetails=" + this.shippingDetails + ", sharedDataSpecs=" + this.sharedDataSpecs + ", externalPaymentMethodSpecs=" + this.externalPaymentMethodSpecs + ", hasCustomerConfiguration=" + this.hasCustomerConfiguration + ", isGooglePayReady=" + this.isGooglePayReady + ", linkInlineConfiguration=" + this.linkInlineConfiguration + ", paymentMethodSaveConsentBehavior=" + this.paymentMethodSaveConsentBehavior + ", linkMode=" + this.linkMode + ", financialConnectionsAvailable=" + this.financialConnectionsAvailable + ")";
    }

    public int hashCode() {
        int result2 = this.stripeIntent.hashCode();
        result2 = result2 * 31 + this.billingDetailsCollectionConfiguration.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.allowsDelayedPaymentMethods);
        result2 = result2 * 31 + Boolean.hashCode(this.allowsPaymentMethodsRequiringShippingAddress);
        result2 = result2 * 31 + ((Object)this.paymentMethodOrder).hashCode();
        result2 = result2 * 31 + this.cbcEligibility.hashCode();
        result2 = result2 * 31 + this.merchantName.hashCode();
        result2 = result2 * 31 + (this.defaultBillingDetails == null ? 0 : this.defaultBillingDetails.hashCode());
        result2 = result2 * 31 + (this.shippingDetails == null ? 0 : this.shippingDetails.hashCode());
        result2 = result2 * 31 + ((Object)this.sharedDataSpecs).hashCode();
        result2 = result2 * 31 + ((Object)this.externalPaymentMethodSpecs).hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.hasCustomerConfiguration);
        result2 = result2 * 31 + Boolean.hashCode(this.isGooglePayReady);
        result2 = result2 * 31 + (this.linkInlineConfiguration == null ? 0 : this.linkInlineConfiguration.hashCode());
        result2 = result2 * 31 + this.paymentMethodSaveConsentBehavior.hashCode();
        result2 = result2 * 31 + (this.linkMode == null ? 0 : this.linkMode.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.financialConnectionsAvailable);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PaymentMethodMetadata)) {
            return false;
        }
        PaymentMethodMetadata paymentMethodMetadata = (PaymentMethodMetadata)other;
        if (!Intrinsics.areEqual((Object)this.stripeIntent, (Object)paymentMethodMetadata.stripeIntent)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.billingDetailsCollectionConfiguration, (Object)paymentMethodMetadata.billingDetailsCollectionConfiguration)) {
            return false;
        }
        if (this.allowsDelayedPaymentMethods != paymentMethodMetadata.allowsDelayedPaymentMethods) {
            return false;
        }
        if (this.allowsPaymentMethodsRequiringShippingAddress != paymentMethodMetadata.allowsPaymentMethodsRequiringShippingAddress) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paymentMethodOrder, paymentMethodMetadata.paymentMethodOrder)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cbcEligibility, (Object)paymentMethodMetadata.cbcEligibility)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.merchantName, (Object)paymentMethodMetadata.merchantName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultBillingDetails, (Object)paymentMethodMetadata.defaultBillingDetails)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shippingDetails, (Object)paymentMethodMetadata.shippingDetails)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.sharedDataSpecs, paymentMethodMetadata.sharedDataSpecs)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.externalPaymentMethodSpecs, paymentMethodMetadata.externalPaymentMethodSpecs)) {
            return false;
        }
        if (this.hasCustomerConfiguration != paymentMethodMetadata.hasCustomerConfiguration) {
            return false;
        }
        if (this.isGooglePayReady != paymentMethodMetadata.isGooglePayReady) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.linkInlineConfiguration, (Object)paymentMethodMetadata.linkInlineConfiguration)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.paymentMethodSaveConsentBehavior, (Object)paymentMethodMetadata.paymentMethodSaveConsentBehavior)) {
            return false;
        }
        if (this.linkMode != paymentMethodMetadata.linkMode) {
            return false;
        }
        return this.financialConnectionsAvailable == paymentMethodMetadata.financialConnectionsAvailable;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeParcelable((Parcelable)this.stripeIntent, flags);
        this.billingDetailsCollectionConfiguration.writeToParcel(out, flags);
        out.writeInt(this.allowsDelayedPaymentMethods ? 1 : 0);
        out.writeInt(this.allowsPaymentMethodsRequiringShippingAddress ? 1 : 0);
        out.writeStringList(this.paymentMethodOrder);
        out.writeParcelable((Parcelable)this.cbcEligibility, flags);
        out.writeString(this.merchantName);
        Object object = this.defaultBillingDetails;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            ((PaymentSheet.BillingDetails)object).writeToParcel(out, flags);
        }
        object = this.shippingDetails;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            ((AddressDetails)object).writeToParcel(out, flags);
        }
        object = this.sharedDataSpecs;
        out.writeInt(object.size());
        Iterator<Object> iterator = object.iterator();
        while (iterator.hasNext()) {
            out.writeParcelable((Parcelable)iterator.next(), flags);
        }
        object = this.externalPaymentMethodSpecs;
        out.writeInt(object.size());
        iterator = object.iterator();
        while (iterator.hasNext()) {
            out.writeParcelable((Parcelable)iterator.next(), flags);
        }
        out.writeInt(this.hasCustomerConfiguration ? 1 : 0);
        out.writeInt(this.isGooglePayReady ? 1 : 0);
        object = this.linkInlineConfiguration;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            ((LinkInlineConfiguration)object).writeToParcel(out, flags);
        }
        out.writeParcelable((Parcelable)this.paymentMethodSaveConsentBehavior, flags);
        object = this.linkMode;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            out.writeString(object.name());
        }
        out.writeInt(this.financialConnectionsAvailable ? 1 : 0);
    }

    static {
        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<PaymentMethodMetadata> {
            @NotNull
            public final PaymentMethodMetadata[] newArray(int size) {
                return new PaymentMethodMetadata[size];
            }

            @NotNull
            public final PaymentMethodMetadata createFromParcel(@NotNull Parcel parcel) {
                int n;
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n2 = parcel.readInt();
                ArrayList<Parcelable> arrayList = new ArrayList<Parcelable>(n2);
                AddressDetails addressDetails = (AddressDetails)(parcel.readInt() == 0 ? null : AddressDetails.CREATOR.createFromParcel(parcel));
                PaymentSheet.BillingDetails billingDetails = (PaymentSheet.BillingDetails)(parcel.readInt() == 0 ? null : PaymentSheet.BillingDetails.CREATOR.createFromParcel(parcel));
                String string2 = parcel.readString();
                CardBrandChoiceEligibility cardBrandChoiceEligibility = (CardBrandChoiceEligibility)parcel.readParcelable(PaymentMethodMetadata.class.getClassLoader());
                List list = parcel.createStringArrayList();
                boolean bl = parcel.readInt() != 0;
                boolean bl2 = parcel.readInt() != 0;
                PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = (PaymentSheet.BillingDetailsCollectionConfiguration)PaymentSheet.BillingDetailsCollectionConfiguration.CREATOR.createFromParcel(parcel);
                StripeIntent stripeIntent = (StripeIntent)parcel.readParcelable(PaymentMethodMetadata.class.getClassLoader());
                for (n = 0; n != n2; ++n) {
                    arrayList.add(parcel.readParcelable(PaymentMethodMetadata.class.getClassLoader()));
                }
                List list2 = arrayList;
                n2 = parcel.readInt();
                arrayList = new ArrayList(n2);
                List list3 = list2;
                for (n = 0; n != n2; ++n) {
                    arrayList.add(parcel.readParcelable(PaymentMethodMetadata.class.getClassLoader()));
                }
                boolean bl3 = parcel.readInt() != 0;
                LinkMode linkMode = parcel.readInt() == 0 ? null : LinkMode.valueOf((String)parcel.readString());
                PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior = (PaymentMethodSaveConsentBehavior)parcel.readParcelable(PaymentMethodMetadata.class.getClassLoader());
                LinkInlineConfiguration linkInlineConfiguration = (LinkInlineConfiguration)(parcel.readInt() == 0 ? null : LinkInlineConfiguration.CREATOR.createFromParcel(parcel));
                boolean bl4 = parcel.readInt() != 0;
                boolean bl5 = parcel.readInt() != 0;
                List list4 = arrayList;
                List list5 = list3;
                AddressDetails addressDetails2 = addressDetails;
                PaymentSheet.BillingDetails billingDetails2 = billingDetails;
                String string3 = string2;
                CardBrandChoiceEligibility cardBrandChoiceEligibility2 = cardBrandChoiceEligibility;
                List list6 = list;
                boolean bl6 = bl;
                boolean bl7 = bl2;
                PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration2 = billingDetailsCollectionConfiguration;
                StripeIntent stripeIntent2 = stripeIntent;
                return new PaymentMethodMetadata(stripeIntent2, billingDetailsCollectionConfiguration2, bl7, bl6, list6, cardBrandChoiceEligibility2, string3, billingDetails2, addressDetails2, list5, list4, bl5, bl4, linkInlineConfiguration, paymentMethodSaveConsentBehavior, linkMode, bl3);
            }
        }
        CREATOR = new Creator();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JC\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012JK\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00132\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0000\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata$Companion;", "", "()V", "create", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "elementsSession", "Lcom/stripe/android/model/ElementsSession;", "configuration", "Lcom/stripe/android/customersheet/CustomerSheet$Configuration;", "paymentMethodSaveConsentBehavior", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodSaveConsentBehavior;", "sharedDataSpecs", "", "Lcom/stripe/android/ui/core/elements/SharedDataSpec;", "isGooglePayReady", "", "isFinancialConnectionsAvailable", "Lcom/stripe/android/payments/financialconnections/IsFinancialConnectionsAvailable;", "create$paymentsheet_release", "Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "externalPaymentMethodSpecs", "Lcom/stripe/android/ui/core/elements/ExternalPaymentMethodSpec;", "linkInlineConfiguration", "Lcom/stripe/android/lpmfoundations/paymentmethod/link/LinkInlineConfiguration;", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PaymentMethodMetadata create$paymentsheet_release(@NotNull ElementsSession elementsSession, @NotNull PaymentSheet.Configuration configuration, @NotNull List<SharedDataSpec> sharedDataSpecs, @NotNull List<ExternalPaymentMethodSpec> externalPaymentMethodSpecs, boolean isGooglePayReady2, @Nullable LinkInlineConfiguration linkInlineConfiguration) {
            Intrinsics.checkNotNullParameter((Object)elementsSession, (String)"elementsSession");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter(sharedDataSpecs, (String)"sharedDataSpecs");
            Intrinsics.checkNotNullParameter(externalPaymentMethodSpecs, (String)"externalPaymentMethodSpecs");
            StripeIntent stripeIntent = elementsSession.getStripeIntent();
            PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = configuration.getBillingDetailsCollectionConfiguration();
            boolean bl = configuration.getAllowsDelayedPaymentMethods();
            boolean bl2 = configuration.getAllowsPaymentMethodsRequiringShippingAddress();
            List<String> list = configuration.getPaymentMethodOrder$paymentsheet_release();
            ElementsSession.CardBrandChoice cardBrandChoice = elementsSession.getCardBrandChoice();
            CardBrandChoiceEligibility cardBrandChoiceEligibility = CardBrandChoiceEligibility.Companion.create(cardBrandChoice != null ? cardBrandChoice.getEligible() : false, configuration.getPreferredNetworks());
            String string2 = configuration.getMerchantDisplayName();
            PaymentSheet.BillingDetails billingDetails = configuration.getDefaultBillingDetails();
            AddressDetails addressDetails = configuration.getShippingDetails();
            boolean bl3 = configuration.getCustomer() != null;
            PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior = PaymentMethodMetadataKtxKt.toPaymentSheetSaveConsentBehavior(elementsSession);
            ElementsSession.LinkSettings linkSettings = elementsSession.getLinkSettings();
            LinkMode linkMode = linkSettings != null ? linkSettings.getLinkMode() : null;
            return new PaymentMethodMetadata(stripeIntent, billingDetailsCollectionConfiguration, bl, bl2, list, cardBrandChoiceEligibility, string2, billingDetails, addressDetails, sharedDataSpecs, externalPaymentMethodSpecs, bl3, isGooglePayReady2, linkInlineConfiguration, paymentMethodSaveConsentBehavior, linkMode, false, 65536, null);
        }

        @NotNull
        public final PaymentMethodMetadata create$paymentsheet_release(@NotNull ElementsSession elementsSession, @NotNull CustomerSheet.Configuration configuration, @NotNull PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior, @NotNull List<SharedDataSpec> sharedDataSpecs, boolean isGooglePayReady2, @NotNull IsFinancialConnectionsAvailable isFinancialConnectionsAvailable) {
            Intrinsics.checkNotNullParameter((Object)elementsSession, (String)"elementsSession");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)paymentMethodSaveConsentBehavior, (String)"paymentMethodSaveConsentBehavior");
            Intrinsics.checkNotNullParameter(sharedDataSpecs, (String)"sharedDataSpecs");
            Intrinsics.checkNotNullParameter((Object)isFinancialConnectionsAvailable, (String)"isFinancialConnectionsAvailable");
            StripeIntent stripeIntent = elementsSession.getStripeIntent();
            PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = configuration.getBillingDetailsCollectionConfiguration();
            List<String> list = configuration.getPaymentMethodOrder$paymentsheet_release();
            ElementsSession.CardBrandChoice cardBrandChoice = elementsSession.getCardBrandChoice();
            CardBrandChoiceEligibility cardBrandChoiceEligibility = CardBrandChoiceEligibility.Companion.create(cardBrandChoice != null ? cardBrandChoice.getEligible() : false, configuration.getPreferredNetworks());
            String string2 = configuration.getMerchantDisplayName();
            PaymentSheet.BillingDetails billingDetails = configuration.getDefaultBillingDetails();
            boolean bl = isFinancialConnectionsAvailable.invoke();
            ElementsSession.LinkSettings linkSettings = elementsSession.getLinkSettings();
            LinkMode linkMode = linkSettings != null ? linkSettings.getLinkMode() : null;
            List list2 = CollectionsKt.emptyList();
            return new PaymentMethodMetadata(stripeIntent, billingDetailsCollectionConfiguration, true, false, list, cardBrandChoiceEligibility, string2, billingDetails, null, sharedDataSpecs, list2, true, isGooglePayReady2, null, paymentMethodSaveConsentBehavior, linkMode, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

