/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.model;

import androidx.annotation.DrawableRes;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.elements.FormItemSpec;
import com.stripe.android.paymentsheet.elements.LayoutFormDescriptor;
import com.stripe.android.paymentsheet.elements.LayoutSpec;
import com.stripe.android.paymentsheet.elements.SaveForFutureUseSpec;
import com.stripe.android.paymentsheet.forms.AfterpayClearpaySpecKt;
import com.stripe.android.paymentsheet.forms.BancontactSpecKt;
import com.stripe.android.paymentsheet.forms.CardRequirementKt;
import com.stripe.android.paymentsheet.forms.Delayed;
import com.stripe.android.paymentsheet.forms.EpsSpecKt;
import com.stripe.android.paymentsheet.forms.GiropaySpecKt;
import com.stripe.android.paymentsheet.forms.IdealSpecKt;
import com.stripe.android.paymentsheet.forms.P24SpecKt;
import com.stripe.android.paymentsheet.forms.PaymentMethodRequirements;
import com.stripe.android.paymentsheet.forms.Requirement;
import com.stripe.android.paymentsheet.forms.SepaDebitSpecKt;
import com.stripe.android.paymentsheet.forms.SofortSpecKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b\u0080\u0001\u0018\u0000 92\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00019BK\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u001cH\u0002J\"\u0010\u001d\u001a\u00020\u001a2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010!\u001a\u0004\u0018\u00010\"J!\u0010'\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0000\u00a2\u0006\u0002\b(J\u0006\u0010)\u001a\u00020\u001aJ\u0012\u0010*\u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0012\u0010+\u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u001a\u0010,\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020-2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0012\u0010.\u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\b\u0010/\u001a\u00020\u000bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u001f\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8\u00a8\u0006:"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "", "type", "Lcom/stripe/android/model/PaymentMethod$Type;", "displayNameResource", "", "iconResource", "requirement", "Lcom/stripe/android/paymentsheet/forms/PaymentMethodRequirements;", "paramKey", "", "", "", "formSpec", "Lcom/stripe/android/paymentsheet/elements/LayoutSpec;", "(Ljava/lang/String;ILcom/stripe/android/model/PaymentMethod$Type;IILcom/stripe/android/paymentsheet/forms/PaymentMethodRequirements;Ljava/util/Map;Lcom/stripe/android/paymentsheet/elements/LayoutSpec;)V", "getDisplayNameResource", "()I", "getFormSpec", "()Lcom/stripe/android/paymentsheet/elements/LayoutSpec;", "getIconResource", "getParamKey", "()Ljava/util/Map;", "getType", "()Lcom/stripe/android/model/PaymentMethod$Type;", "allHaveKnownReuseSupport", "", "paymentMethodsInIntent", "", "checkRequirements", "requirements", "", "Lcom/stripe/android/paymentsheet/forms/Requirement;", "config", "Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "getPMAddForm", "Lcom/stripe/android/paymentsheet/elements/LayoutFormDescriptor;", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "getSpecWithFullfilledRequirements", "getSpecWithFullfilledRequirements$paymentsheet_release", "supportsCustomerSavedPM", "supportsPaymentIntentSfuNotSettable", "supportsPaymentIntentSfuSet", "supportsPaymentIntentSfuSettable", "Lcom/stripe/android/model/PaymentIntent;", "supportsSetupIntent", "toString", "Card", "Bancontact", "Sofort", "Ideal", "SepaDebit", "Eps", "P24", "Giropay", "AfterpayClearpay", "Companion", "paymentsheet_release"})
public final class SupportedPaymentMethod
extends Enum<SupportedPaymentMethod> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final PaymentMethod.Type type;
    private final int displayNameResource;
    private final int iconResource;
    @NotNull
    private final PaymentMethodRequirements requirement;
    @NotNull
    private final Map<String, Object> paramKey;
    @Nullable
    private final LayoutSpec formSpec;
    @NotNull
    private static final List<SupportedPaymentMethod> exposedPaymentMethods;
    public static final /* enum */ SupportedPaymentMethod Card;
    public static final /* enum */ SupportedPaymentMethod Bancontact;
    public static final /* enum */ SupportedPaymentMethod Sofort;
    public static final /* enum */ SupportedPaymentMethod Ideal;
    public static final /* enum */ SupportedPaymentMethod SepaDebit;
    public static final /* enum */ SupportedPaymentMethod Eps;
    public static final /* enum */ SupportedPaymentMethod P24;
    public static final /* enum */ SupportedPaymentMethod Giropay;
    public static final /* enum */ SupportedPaymentMethod AfterpayClearpay;
    private static final /* synthetic */ SupportedPaymentMethod[] $VALUES;

    private SupportedPaymentMethod(@DrawableRes PaymentMethod.Type type, int displayNameResource, int iconResource, PaymentMethodRequirements requirement, Map<String, Object> paramKey, LayoutSpec formSpec) {
        this.type = type;
        this.displayNameResource = displayNameResource;
        this.iconResource = iconResource;
        this.requirement = requirement;
        this.paramKey = paramKey;
        this.formSpec = formSpec;
    }

    @NotNull
    public final PaymentMethod.Type getType() {
        return this.type;
    }

    public final int getDisplayNameResource() {
        return this.displayNameResource;
    }

    public final int getIconResource() {
        return this.iconResource;
    }

    @NotNull
    public final Map<String, Object> getParamKey() {
        return this.paramKey;
    }

    @Nullable
    public final LayoutSpec getFormSpec() {
        return this.formSpec;
    }

    @NotNull
    public final LayoutFormDescriptor getPMAddForm(@NotNull StripeIntent stripeIntent, @Nullable PaymentSheet.Configuration config) {
        Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
        LayoutFormDescriptor layoutFormDescriptor = this.getSpecWithFullfilledRequirements$paymentsheet_release(stripeIntent, config);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (layoutFormDescriptor == null) {
            boolean bl4 = false;
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return layoutFormDescriptor;
    }

    @Nullable
    public final LayoutFormDescriptor getSpecWithFullfilledRequirements$paymentsheet_release(@NotNull StripeIntent stripeIntent, @Nullable PaymentSheet.Configuration config) {
        LayoutFormDescriptor layoutFormDescriptor;
        Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
        LayoutSpec formSpec = this.formSpec;
        LayoutFormDescriptor oneTimeUse = new LayoutFormDescriptor(formSpec, false, false);
        LayoutFormDescriptor merchantRequestedSave = new LayoutFormDescriptor(formSpec, false, true);
        LayoutFormDescriptor userSelectableSave = new LayoutFormDescriptor(formSpec, true, true);
        if (!stripeIntent.getPaymentMethodTypes().contains(this.type.code)) {
            return null;
        }
        StripeIntent stripeIntent2 = stripeIntent;
        if (stripeIntent2 instanceof PaymentIntent) {
            layoutFormDescriptor = ((PaymentIntent)stripeIntent).isSetupFutureUsageSet() ? (this.supportsPaymentIntentSfuSet(config) ? merchantRequestedSave : (LayoutFormDescriptor)null) : (this.supportsPaymentIntentSfuSettable((PaymentIntent)stripeIntent, config) ? userSelectableSave : (this.supportsPaymentIntentSfuNotSettable(config) ? oneTimeUse : null));
        } else if (stripeIntent2 instanceof SetupIntent) {
            layoutFormDescriptor = this.supportsSetupIntent(config) ? merchantRequestedSave : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return layoutFormDescriptor;
    }

    public final boolean supportsCustomerSavedPM() {
        return Intrinsics.areEqual((Object)this.requirement.getConfirmPMFromCustomer(), (Object)true);
    }

    private final boolean supportsSetupIntent(PaymentSheet.Configuration config) {
        return Intrinsics.areEqual((Object)this.requirement.getConfirmPMFromCustomer(), (Object)true) && this.checkRequirements(this.requirement.getSiRequirements(), config);
    }

    private final boolean supportsPaymentIntentSfuSet(PaymentSheet.Configuration config) {
        return Intrinsics.areEqual((Object)this.requirement.getConfirmPMFromCustomer(), (Object)true) && this.checkRequirements(this.requirement.getSiRequirements(), config) && this.checkRequirements(this.requirement.getPiRequirements(), config);
    }

    private final boolean supportsPaymentIntentSfuNotSettable(PaymentSheet.Configuration config) {
        return this.checkRequirements(this.requirement.getPiRequirements(), config);
    }

    private final boolean supportsPaymentIntentSfuSettable(PaymentIntent stripeIntent, PaymentSheet.Configuration config) {
        PaymentSheet.Configuration configuration;
        return this.allHaveKnownReuseSupport(stripeIntent.getPaymentMethodTypes()) && ((configuration = config) == null ? null : configuration.getCustomer()) != null && Intrinsics.areEqual((Object)this.requirement.getConfirmPMFromCustomer(), (Object)true) && this.checkRequirements(this.requirement.getPiRequirements(), config) && this.checkRequirements(this.requirement.getSiRequirements(), config);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkRequirements(Set<? extends Requirement> requirements, PaymentSheet.Configuration config) {
        boolean bl;
        Set<? extends Requirement> set = requirements;
        if (set == null) {
            bl = false;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void requirement;
                Requirement requirement2 = (Requirement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var14_13 = requirement;
                if (Intrinsics.areEqual((Object)var14_13, (Object)Delayed.INSTANCE)) {
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                PaymentSheet.Configuration configuration = config;
                Boolean bl3 = configuration == null ? false : configuration.getAllowsDelayedPaymentMethods();
                collection.add(bl3);
            }
            List list = (List)destination$iv$iv;
            bl = !list.contains(false);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean allHaveKnownReuseSupport(List<String> paymentMethodsInIntent) {
        void $this$filterNotTo$iv$iv;
        Object[] objectArray = new String[]{PaymentMethod.Type.Alipay.code, PaymentMethod.Type.Card.code, PaymentMethod.Type.SepaDebit.code, PaymentMethod.Type.AuBecsDebit.code, PaymentMethod.Type.Bancontact.code, PaymentMethod.Type.Sofort.code, PaymentMethod.Type.BacsDebit.code, PaymentMethod.Type.Ideal.code};
        Set knownReusable = SetsKt.setOf((Object[])objectArray);
        Iterable $this$filterNot$iv = paymentMethodsInIntent;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (CollectionsKt.contains((Iterable)knownReusable, (Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ((List)destination$iv$iv).isEmpty();
    }

    @NotNull
    public String toString() {
        return this.type.code;
    }

    public static SupportedPaymentMethod[] values() {
        return (SupportedPaymentMethod[])$VALUES.clone();
    }

    public static SupportedPaymentMethod valueOf(String value) {
        return Enum.valueOf(SupportedPaymentMethod.class, value);
    }

    static {
        boolean bl = false;
        Object[] objectArray = new FormItemSpec[]{new SaveForFutureUseSpec(CollectionsKt.emptyList())};
        Card = new SupportedPaymentMethod(PaymentMethod.Type.Card, R.string.stripe_paymentsheet_payment_method_card, R.drawable.stripe_ic_paymentsheet_pm_card, CardRequirementKt.getCardRequirement(), new LinkedHashMap(), LayoutSpec.Companion.create((FormItemSpec[])objectArray));
        Bancontact = new SupportedPaymentMethod(PaymentMethod.Type.Bancontact, R.string.stripe_paymentsheet_payment_method_bancontact, R.drawable.stripe_ic_paymentsheet_pm_bancontact, BancontactSpecKt.getBancontactRequirement(), BancontactSpecKt.getBancontactParamKey(), BancontactSpecKt.getBancontactForm());
        Sofort = new SupportedPaymentMethod(PaymentMethod.Type.Sofort, R.string.stripe_paymentsheet_payment_method_sofort, R.drawable.stripe_ic_paymentsheet_pm_klarna, SofortSpecKt.getSofortRequirement(), SofortSpecKt.getSofortParamKey(), SofortSpecKt.getSofortForm());
        Ideal = new SupportedPaymentMethod(PaymentMethod.Type.Ideal, R.string.stripe_paymentsheet_payment_method_ideal, R.drawable.stripe_ic_paymentsheet_pm_ideal, IdealSpecKt.getIdealRequirement(), IdealSpecKt.getIdealParamKey(), IdealSpecKt.getIdealForm());
        SepaDebit = new SupportedPaymentMethod(PaymentMethod.Type.SepaDebit, R.string.stripe_paymentsheet_payment_method_sepa_debit, R.drawable.stripe_ic_paymentsheet_pm_sepa_debit, SepaDebitSpecKt.getSepaDebitRequirement(), SepaDebitSpecKt.getSepaDebitParamKey(), SepaDebitSpecKt.getSepaDebitForm());
        Eps = new SupportedPaymentMethod(PaymentMethod.Type.Eps, R.string.stripe_paymentsheet_payment_method_eps, R.drawable.stripe_ic_paymentsheet_pm_eps, EpsSpecKt.getEpsRequirement(), EpsSpecKt.getEpsParamKey(), EpsSpecKt.getEpsForm());
        P24 = new SupportedPaymentMethod(PaymentMethod.Type.P24, R.string.stripe_paymentsheet_payment_method_p24, R.drawable.stripe_ic_paymentsheet_pm_p24, P24SpecKt.getP24Requirement(), P24SpecKt.getP24ParamKey(), P24SpecKt.getP24Form());
        Giropay = new SupportedPaymentMethod(PaymentMethod.Type.Giropay, R.string.stripe_paymentsheet_payment_method_giropay, R.drawable.stripe_ic_paymentsheet_pm_giropay, GiropaySpecKt.getGiropayRequirement(), GiropaySpecKt.getGiropayParamKey(), GiropaySpecKt.getGiropayForm());
        AfterpayClearpay = new SupportedPaymentMethod(PaymentMethod.Type.AfterpayClearpay, R.string.stripe_paymentsheet_payment_method_afterpay_clearpay, R.drawable.stripe_ic_paymentsheet_pm_afterpay_clearpay, AfterpayClearpaySpecKt.getAfterpayClearpayRequirement(), AfterpayClearpaySpecKt.getAfterpayClearpayParamKey(), AfterpayClearpaySpecKt.getAfterpayClearpayForm());
        $VALUES = supportedPaymentMethodArray = new SupportedPaymentMethod[]{SupportedPaymentMethod.Card, SupportedPaymentMethod.Bancontact, SupportedPaymentMethod.Sofort, SupportedPaymentMethod.Ideal, SupportedPaymentMethod.SepaDebit, SupportedPaymentMethod.Eps, SupportedPaymentMethod.P24, SupportedPaymentMethod.Giropay, SupportedPaymentMethod.AfterpayClearpay};
        Companion = new Companion(null);
        objectArray = new SupportedPaymentMethod[]{Card, Bancontact, Sofort, Ideal, SepaDebit};
        exposedPaymentMethods = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ'\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011J'\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0013R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod$Companion;", "", "()V", "exposedPaymentMethods", "", "Lcom/stripe/android/paymentsheet/model/SupportedPaymentMethod;", "getExposedPaymentMethods$paymentsheet_release$annotations", "getExposedPaymentMethods$paymentsheet_release", "()Ljava/util/List;", "fromCode", "code", "", "getPMsToAdd", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "config", "Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "getPMsToAdd$paymentsheet_release", "getSupportedSavedCustomerPMs", "getSupportedSavedCustomerPMs$paymentsheet_release", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<SupportedPaymentMethod> getExposedPaymentMethods$paymentsheet_release() {
            return exposedPaymentMethods;
        }

        @VisibleForTesting
        public static /* synthetic */ void getExposedPaymentMethods$paymentsheet_release$annotations() {
        }

        @Nullable
        public final SupportedPaymentMethod fromCode(@Nullable String code) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = this.getExposedPaymentMethods$paymentsheet_release();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SupportedPaymentMethod it = (SupportedPaymentMethod)((Object)element$iv);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType().code, (Object)code)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<SupportedPaymentMethod> getSupportedSavedCustomerPMs$paymentsheet_release(@Nullable StripeIntent stripeIntent, @Nullable PaymentSheet.Configuration config) {
            List list;
            StripeIntent stripeIntent2 = stripeIntent;
            if (stripeIntent2 == null) {
                list = null;
            } else {
                List list2 = stripeIntent2.getPaymentMethodTypes();
                if (list2 == null) {
                    list = null;
                } else {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = list2;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        SupportedPaymentMethod supportedPaymentMethod;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        String it = (String)element$iv$iv;
                        boolean bl2 = false;
                        if (Companion.fromCode(it) == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        SupportedPaymentMethod it$iv$iv = supportedPaymentMethod;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List list3 = (List)destination$iv$iv;
                    $this$mapNotNull$iv = list3;
                    boolean $i$f$filter = false;
                    $this$mapNotNullTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        SupportedPaymentMethod paymentMethod = (SupportedPaymentMethod)((Object)element$iv$iv);
                        boolean bl = false;
                        boolean bl6 = paymentMethod.supportsCustomerSavedPM() && paymentMethod.getSpecWithFullfilledRequirements$paymentsheet_release(stripeIntent, config) != null;
                        if (!bl6) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                }
            }
            List list4 = list;
            return list4 == null ? CollectionsKt.emptyList() : list4;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<SupportedPaymentMethod> getPMsToAdd$paymentsheet_release(@Nullable StripeIntent stripeIntent, @Nullable PaymentSheet.Configuration config) {
            List list;
            StripeIntent stripeIntent2 = stripeIntent;
            if (stripeIntent2 == null) {
                list = null;
            } else {
                List list2 = stripeIntent2.getPaymentMethodTypes();
                if (list2 == null) {
                    list = null;
                } else {
                    void $this$filterNotTo$iv$iv;
                    void $this$filterNot$iv;
                    SupportedPaymentMethod supportedPaymentMethod;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = list2;
                    boolean $i$f$mapNotNull22 = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        SupportedPaymentMethod supportedPaymentMethod2;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        String it = (String)element$iv$iv;
                        boolean bl2 = false;
                        if (Companion.fromCode(it) == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        SupportedPaymentMethod it$iv$iv = supportedPaymentMethod2;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List list3 = (List)destination$iv$iv;
                    Iterable $i$f$mapNotNull22 = list3;
                    boolean $i$f$filter = false;
                    destination$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        supportedPaymentMethod = (SupportedPaymentMethod)((Object)element$iv$iv);
                        boolean bl = false;
                        if (!(supportedPaymentMethod.getSpecWithFullfilledRequirements$paymentsheet_release(stripeIntent, config) != null)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List list4 = (List)destination$iv$iv2;
                    $this$filter$iv = list4;
                    boolean $i$f$filterNot = false;
                    $this$filterTo$iv$iv = $this$filterNot$iv;
                    destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterNotTo = false;
                    for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                        supportedPaymentMethod = (SupportedPaymentMethod)((Object)element$iv$iv);
                        boolean bl = false;
                        if (stripeIntent.isLiveMode() && stripeIntent.getUnactivatedPaymentMethods().contains(supportedPaymentMethod.getType().code)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv2;
                }
            }
            List list5 = list;
            return list5 == null ? CollectionsKt.emptyList() : list5;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

