/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.model;

import android.content.res.Resources;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.model.PaymentOption;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.ui.PaymentMethodsUiExtensionKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/paymentsheet/model/PaymentOptionFactory;", "", "resources", "Landroid/content/res/Resources;", "(Landroid/content/res/Resources;)V", "create", "Lcom/stripe/android/paymentsheet/model/PaymentOption;", "selection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "paymentsheet_release"})
public final class PaymentOptionFactory {
    @NotNull
    private final Resources resources;

    public PaymentOptionFactory(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        this.resources = resources;
    }

    @NotNull
    public final PaymentOption create(@NotNull PaymentSelection selection) {
        PaymentOption paymentOption;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        PaymentSelection paymentSelection = selection;
        if (Intrinsics.areEqual((Object)paymentSelection, (Object)PaymentSelection.GooglePay.INSTANCE)) {
            String string2 = this.resources.getString(R.string.google_pay);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.string.google_pay)");
            PaymentOption paymentOption2 = new PaymentOption(R.drawable.stripe_google_pay_mark, string2);
            paymentOption = paymentOption2;
        } else if (paymentSelection instanceof PaymentSelection.Saved) {
            Object object = PaymentMethodsUiExtensionKt.getSavedPaymentMethodIcon(((PaymentSelection.Saved)selection).getPaymentMethod());
            int n = object == null ? 0 : (Integer)object;
            object = PaymentMethodsUiExtensionKt.getLabel(((PaymentSelection.Saved)selection).getPaymentMethod(), this.resources);
            boolean bl = false;
            Object object2 = object;
            if (object2 == null) {
                object2 = "";
            }
            paymentOption = new PaymentOption(n, (String)object2);
        } else if (paymentSelection instanceof PaymentSelection.New.Card) {
            PaymentMethodCreateParams.Card card = ((PaymentSelection.New.Card)selection).getPaymentMethodCreateParams().getCard();
            String string3 = card == null ? null : card.getLast4();
            paymentOption = new PaymentOption(PaymentMethodsUiExtensionKt.getCardBrandIcon(((PaymentSelection.New.Card)selection).getBrand()), PaymentMethodsUiExtensionKt.createCardLabel(this.resources, string3));
        } else if (paymentSelection instanceof PaymentSelection.New.GenericPaymentMethod) {
            int n = ((PaymentSelection.New.GenericPaymentMethod)selection).getIconResource();
            String string4 = this.resources.getString(((PaymentSelection.New.GenericPaymentMethod)selection).getLabelResource());
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"resources.getString(selection.labelResource)");
            PaymentOption paymentOption3 = new PaymentOption(n, string4);
            paymentOption = paymentOption3;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return paymentOption;
    }
}

