/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.elements;

import androidx.annotation.StringRes;
import androidx.compose.ui.text.input.KeyboardCapitalization;
import androidx.compose.ui.text.input.KeyboardType;
import androidx.compose.ui.text.input.VisualTransformation;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.elements.TextFieldConfig;
import com.stripe.android.paymentsheet.elements.TextFieldState;
import com.stripe.android.paymentsheet.elements.TextFieldStateConstants;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0016R\u001f\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001f\u0010\f\u001a\u00020\rX\u0096\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u000e\u0010\u0006R\u0016\u0010\u000f\u001a\u00020\u00108\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006#"}, d2={"Lcom/stripe/android/paymentsheet/elements/EmailConfig;", "Lcom/stripe/android/paymentsheet/elements/TextFieldConfig;", "()V", "capitalization", "Landroidx/compose/ui/text/input/KeyboardCapitalization;", "getCapitalization-IUNYP9k", "()I", "I", "debugLabel", "", "getDebugLabel", "()Ljava/lang/String;", "keyboard", "Landroidx/compose/ui/text/input/KeyboardType;", "getKeyboard-PjHm6EE", "label", "", "getLabel", "visualTransformation", "Landroidx/compose/ui/text/input/VisualTransformation;", "getVisualTransformation", "()Landroidx/compose/ui/text/input/VisualTransformation;", "containsNameAndDomain", "", "str", "convertFromRaw", "rawValue", "convertToRaw", "displayName", "determineState", "Lcom/stripe/android/paymentsheet/elements/TextFieldState;", "input", "filter", "userTyped", "Companion", "paymentsheet_release"})
public final class EmailConfig
implements TextFieldConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int capitalization = KeyboardCapitalization.Companion.getNone-IUNYP9k();
    @NotNull
    private final String debugLabel;
    @StringRes
    private final int label = R.string.email;
    private final int keyboard = KeyboardType.Companion.getEmail-PjHm6EE();
    @Nullable
    private final VisualTransformation visualTransformation;
    @NotNull
    private static final Pattern PATTERN;

    public EmailConfig() {
        this.debugLabel = "email";
    }

    @Override
    public int getCapitalization-IUNYP9k() {
        return this.capitalization;
    }

    @Override
    @NotNull
    public String getDebugLabel() {
        return this.debugLabel;
    }

    @Override
    public int getLabel() {
        return this.label;
    }

    @Override
    public int getKeyboard-PjHm6EE() {
        return this.keyboard;
    }

    @Override
    @Nullable
    public VisualTransformation getVisualTransformation() {
        return this.visualTransformation;
    }

    @Override
    @NotNull
    public String filter(@NotNull String userTyped) {
        Intrinsics.checkNotNullParameter((Object)userTyped, (String)"userTyped");
        return userTyped;
    }

    @Override
    @NotNull
    public String convertToRaw(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        return displayName;
    }

    @Override
    @NotNull
    public String convertFromRaw(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        return rawValue;
    }

    @Override
    @NotNull
    public TextFieldState determineState(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        CharSequence charSequence = input;
        boolean bl = false;
        return charSequence.length() == 0 ? (TextFieldState)TextFieldStateConstants.Error.Blank.INSTANCE : (PATTERN.matcher(input).matches() ? (TextFieldState)TextFieldStateConstants.Valid.Limitless.INSTANCE : (this.containsNameAndDomain(input) ? (TextFieldState)new TextFieldStateConstants.Error.Invalid(R.string.email_is_invalid, null, 2, null) : (TextFieldState)new TextFieldStateConstants.Error.Incomplete(R.string.email_is_invalid)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsNameAndDomain(String str) {
        if (!StringsKt.contains$default((CharSequence)str, (CharSequence)"@", (boolean)false, (int)2, null)) return false;
        CharSequence charSequence = str;
        Regex regex = new Regex(".*@.*\\..+");
        boolean bl = false;
        if (!regex.matches(charSequence)) return false;
        return true;
    }

    static {
        Pattern pattern = Pattern.compile("[a-zA-Z0-9\\+\\.\\_\\%\\-\\+]{1,256}\\@[a-zA-Z0-9][a-zA-Z0-9\\-]{0,64}(\\.[a-zA-Z0-9][a-zA-Z0-9\\-]{0,25})+");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\n            \"[a-zA-Z0-9\\\\+\\\\.\\\\_\\\\%\\\\-\\\\+]{1,256}\" +\n                \"\\\\@\" +\n                \"[a-zA-Z0-9][a-zA-Z0-9\\\\-]{0,64}\" +\n                \"(\" +\n                \"\\\\.\" +\n                \"[a-zA-Z0-9][a-zA-Z0-9\\\\-]{0,25}\" +\n                \")+\"\n        )");
        PATTERN = pattern;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/paymentsheet/elements/EmailConfig$Companion;", "", "()V", "PATTERN", "Ljava/util/regex/Pattern;", "getPATTERN", "()Ljava/util/regex/Pattern;", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getPATTERN() {
            return PATTERN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

