/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.elements;

import androidx.annotation.StringRes;
import com.stripe.android.model.CountryCode;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.elements.DropdownConfig;
import com.stripe.android.view.Country;
import com.stripe.android.view.CountryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018H\u0016R\u0014\u0010\b\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00020\f8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/paymentsheet/elements/CountryConfig;", "Lcom/stripe/android/paymentsheet/elements/DropdownConfig;", "onlyShowCountryCodes", "", "", "locale", "Ljava/util/Locale;", "(Ljava/util/Set;Ljava/util/Locale;)V", "debugLabel", "getDebugLabel", "()Ljava/lang/String;", "label", "", "getLabel", "()I", "getLocale", "()Ljava/util/Locale;", "getOnlyShowCountryCodes", "()Ljava/util/Set;", "convertFromRaw", "rawValue", "convertToRaw", "displayName", "getDisplayItems", "", "paymentsheet_release"})
public final class CountryConfig
implements DropdownConfig {
    @NotNull
    private final Set<String> onlyShowCountryCodes;
    @NotNull
    private final Locale locale;
    @NotNull
    private final String debugLabel;
    @StringRes
    private final int label;

    public CountryConfig(@NotNull Set<String> onlyShowCountryCodes, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(onlyShowCountryCodes, (String)"onlyShowCountryCodes");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        this.onlyShowCountryCodes = onlyShowCountryCodes;
        this.locale = locale;
        this.debugLabel = "country";
        this.label = R.string.address_label_country;
    }

    public /* synthetic */ CountryConfig(Set set, Locale locale, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 2) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        this(set, locale);
    }

    @NotNull
    public final Set<String> getOnlyShowCountryCodes() {
        return this.onlyShowCountryCodes;
    }

    @NotNull
    public final Locale getLocale() {
        return this.locale;
    }

    @Override
    @NotNull
    public String getDebugLabel() {
        return this.debugLabel;
    }

    @Override
    public int getLabel() {
        return this.label;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public List<String> getDisplayItems() {
        $this$filter$iv = CountryUtils.INSTANCE.getOrderedCountries(this.locale);
        $i$f$filter = false;
        var3_3 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Country)element$iv$iv;
            $i$a$-filter-CountryConfig$getDisplayItems$1 = false;
            if (this.getOnlyShowCountryCodes().isEmpty()) ** GOTO lbl-1000
            var10_10 = this.getOnlyShowCountryCodes();
            var11_11 = false;
            if (var10_10.isEmpty() == false && this.getOnlyShowCountryCodes().contains(it.getCode().getValue())) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            if (!v0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (Country)item$iv$iv;
            var12_12 = destination$iv$iv;
            $i$a$-map-CountryConfig$getDisplayItems$2 = false;
            var13_13 = it.getName();
            var12_12.add(var13_13);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String convertFromRaw(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        CountryCode countryCode = CountryCode.Companion.create(rawValue);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        Country country = CountryUtils.INSTANCE.getCountryByCode(countryCode, locale);
        String string2 = country == null ? null : country.getName();
        return string2 == null ? this.getDisplayItems().get(0) : string2;
    }

    @Override
    @Nullable
    public String convertToRaw(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        CountryCode countryCode = CountryUtils.INSTANCE.getCountryCodeByName(displayName, locale);
        return countryCode == null ? null : countryCode.getValue();
    }

    public CountryConfig() {
        this(null, null, 3, null);
    }
}

