/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.elements;

import android.content.res.AssetManager;
import android.content.res.Resources;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.paymentsheet.elements.BankRepository;
import com.stripe.android.paymentsheet.elements.DropdownItemSpec;
import com.stripe.android.paymentsheet.elements.SupportedBankType;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u0081\b\u0018\u00002\u00020\u0001B\u0007\b\u0010\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u0015\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001b\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0015\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J#\u0010\u001d\u001a\u00020\u001e2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u001a0 H\u0001\u00a2\u0006\u0002\b!J\u001a\u0010\"\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\t\u0010#\u001a\u00020\u0018H\u00d6\u0001R\"\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lcom/stripe/android/paymentsheet/elements/BankRepository;", "", "()V", "resources", "Landroid/content/res/Resources;", "(Landroid/content/res/Resources;)V", "bankItemMap", "", "Lcom/stripe/android/paymentsheet/elements/SupportedBankType;", "", "Lcom/stripe/android/paymentsheet/elements/DropdownItemSpec;", "format", "Lkotlinx/serialization/json/Json;", "getResources", "()Landroid/content/res/Resources;", "component1", "copy", "equals", "", "other", "get", "bankType", "get$paymentsheet_release", "getJsonStringFromInputStream", "", "inputStream", "Ljava/io/InputStream;", "hashCode", "", "initialize", "", "supportedBankTypeInputStreamMap", "", "initialize$paymentsheet_release", "parseBank", "toString", "paymentsheet_release"})
public final class BankRepository {
    @Nullable
    private final Resources resources;
    @NotNull
    private final Map<SupportedBankType, List<DropdownItemSpec>> bankItemMap;
    @NotNull
    private final Json format;

    /*
     * WARNING - void declaration
     */
    @Inject
    public BankRepository(@Nullable Resources resources) {
        Map map2;
        void $this$associateWith$iv;
        this.resources = resources;
        boolean bl = false;
        this.bankItemMap = new LinkedHashMap();
        this.format = JsonKt.Json$default(null, (Function1)format.1.INSTANCE, (int)1, null);
        SupportedBankType[] supportedBankTypeArray = SupportedBankType.values();
        BankRepository bankRepository = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associateWith$iv).length), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        void var7_9 = $this$associateWithTo$iv$iv;
        int n = ((void)var7_9).length;
        for (int i = 0; i < n; ++i) {
            void bank;
            AssetManager assetManager;
            void element$iv$iv;
            void var11_13 = element$iv$iv = var7_9[i];
            void var17_18 = element$iv$iv;
            map2 = result$iv;
            boolean bl2 = false;
            Resources resources2 = this.getResources();
            InputStream inputStream = resources2 == null ? null : ((assetManager = resources2.getAssets()) == null ? null : assetManager.open(bank.getAssetFileName()));
            map2.put(var17_18, inputStream);
        }
        map2 = result$iv;
        bankRepository.initialize$paymentsheet_release(map2);
    }

    @Nullable
    public final Resources getResources() {
        return this.resources;
    }

    public BankRepository() {
        this(null);
    }

    @NotNull
    public final List<DropdownItemSpec> get$paymentsheet_release(@NotNull SupportedBankType bankType) {
        Intrinsics.checkNotNullParameter((Object)((Object)bankType), (String)"bankType");
        List<DropdownItemSpec> list = this.bankItemMap.get((Object)bankType);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (list == null) {
            boolean bl4 = false;
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return list;
    }

    @VisibleForTesting
    public final void initialize$paymentsheet_release(@NotNull Map<SupportedBankType, ? extends InputStream> supportedBankTypeInputStreamMap) {
        Intrinsics.checkNotNullParameter(supportedBankTypeInputStreamMap, (String)"supportedBankTypeInputStreamMap");
        Map<SupportedBankType, ? extends InputStream> $this$forEach$iv = supportedBankTypeInputStreamMap;
        boolean $i$f$forEach = false;
        Map<SupportedBankType, ? extends InputStream> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<SupportedBankType, ? extends InputStream>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<SupportedBankType, ? extends InputStream> element$iv;
            Map.Entry<SupportedBankType, ? extends InputStream> $dstr$bankType$banksOfType = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<SupportedBankType, ? extends InputStream> entry = $dstr$bankType$banksOfType;
            boolean bl3 = false;
            SupportedBankType bankType = entry.getKey();
            Object object = $dstr$bankType$banksOfType;
            boolean bl4 = false;
            InputStream banksOfType = object.getValue();
            object = this.bankItemMap;
            List<DropdownItemSpec> list = this.parseBank(banksOfType);
            boolean bl5 = false;
            object.put(bankType, list);
        }
    }

    private final List<DropdownItemSpec> parseBank(InputStream inputStream) {
        List list;
        String string2 = this.getJsonStringFromInputStream(inputStream);
        if (string2 == null) {
            list = null;
        } else {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            StringFormat $this$decodeFromString$iv = (StringFormat)this.format;
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(DropdownItemSpec.class))));
            boolean $i$f$cast = false;
            list = (List)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, it);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getJsonStringFromInputStream(InputStream inputStream) {
        String string2;
        BufferedReader bufferedReader;
        Closeable closeable = inputStream;
        if (closeable == null) {
            bufferedReader = null;
        } else {
            InputStream inputStream2 = closeable;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable2 = inputStream2;
            int n = 0;
            closeable2 = new InputStreamReader((InputStream)closeable2, charset);
            n = 8192;
            boolean bl2 = false;
            bufferedReader = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n);
        }
        closeable = bufferedReader;
        boolean bl = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl4 = false;
            BufferedReader bufferedReader2 = it;
            string2 = bufferedReader2 == null ? null : TextStreamsKt.readText((Reader)bufferedReader2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string2;
    }

    @Nullable
    public final Resources component1() {
        return this.resources;
    }

    @NotNull
    public final BankRepository copy(@Nullable Resources resources) {
        return new BankRepository(resources);
    }

    public static /* synthetic */ BankRepository copy$default(BankRepository bankRepository, Resources resources, int n, Object object) {
        if ((n & 1) != 0) {
            resources = bankRepository.resources;
        }
        return bankRepository.copy(resources);
    }

    @NotNull
    public String toString() {
        return "BankRepository(resources=" + this.resources + ')';
    }

    public int hashCode() {
        return this.resources == null ? 0 : this.resources.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BankRepository)) {
            return false;
        }
        BankRepository bankRepository = (BankRepository)other;
        return Intrinsics.areEqual((Object)this.resources, (Object)bankRepository.resources);
    }
}

