/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.annotation.RestrictTo;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.Token;
import com.stripe.android.model.parsers.BankAccountJsonParser;
import com.stripe.android.model.parsers.CardJsonParser;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/TokenJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Token;", "<init>", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-model_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class TokenJsonParser
implements ModelJsonParser<Token> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String FIELD_OBJECT = "object";
    @NotNull
    public static final String FIELD_CREATED = "created";
    @NotNull
    public static final String FIELD_ID = "id";
    @NotNull
    public static final String FIELD_LIVEMODE = "livemode";
    @NotNull
    public static final String FIELD_TYPE = "type";
    @NotNull
    public static final String FIELD_USED = "used";
    @NotNull
    public static final String FIELD_BANK_ACCOUNT = "bank_account";

    @Nullable
    public Token parse(@NotNull JSONObject json) {
        Token token;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String tokenId = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ID);
        Long createdTimeStamp = StripeJsonUtils.INSTANCE.optLong(json, FIELD_CREATED);
        Token.Type tokenType = Token.Type.Companion.fromCode(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_TYPE));
        if (tokenType == null || tokenId == null || createdTimeStamp == null) {
            return null;
        }
        boolean used = StripeJsonUtils.INSTANCE.optBoolean(json, FIELD_USED);
        boolean liveMode = StripeJsonUtils.INSTANCE.optBoolean(json, FIELD_LIVEMODE);
        Date date = new Date(TimeUnit.SECONDS.toMillis(createdTimeStamp));
        Token.Type type = tokenType;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                JSONObject jSONObject = json.optJSONObject(Token.Type.Card.getCode());
                if (jSONObject != null) {
                    JSONObject it = jSONObject;
                    boolean bl = false;
                    Token.Type type2 = Token.Type.Card;
                    Card card = new CardJsonParser().parse(it);
                    token = new Token(tokenId, type2, date, liveMode, used, null, card, 32, null);
                    break;
                }
                token = null;
                break;
            }
            case 2: {
                JSONObject jSONObject = json.optJSONObject(Token.Type.BankAccount.getCode());
                if (jSONObject != null) {
                    JSONObject it = jSONObject;
                    boolean bl = false;
                    Token.Type type3 = Token.Type.BankAccount;
                    BankAccount bankAccount = new BankAccountJsonParser().parse(it);
                    token = new Token(tokenId, type3, date, liveMode, used, bankAccount, null, 64, null);
                    break;
                }
                token = null;
                break;
            }
            default: {
                token = new Token(tokenId, tokenType, date, liveMode, used, null, null, 96, null);
            }
        }
        return token;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/parsers/TokenJsonParser$Companion;", "", "<init>", "()V", "FIELD_OBJECT", "", "FIELD_CREATED", "FIELD_ID", "FIELD_LIVEMODE", "FIELD_TYPE", "FIELD_USED", "FIELD_BANK_ACCOUNT", "payments-model_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Token.Type.values().length];
            try {
                nArray[Token.Type.Card.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Token.Type.BankAccount.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

