/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.annotation.RestrictTo;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.parsers.BankAccountJsonParser;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/model/parsers/BankAccountSerializer;", "Lkotlinx/serialization/KSerializer;", "Lcom/stripe/android/model/BankAccount;", "<init>", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "payments-model_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nBankAccountJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BankAccountJsonParser.kt\ncom/stripe/android/model/parsers/BankAccountSerializer\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,85:1\n29#2,3:86\n*S KotlinDebug\n*F\n+ 1 BankAccountJsonParser.kt\ncom/stripe/android/model/parsers/BankAccountSerializer\n*L\n66#1:86,3\n*E\n"})
public final class BankAccountSerializer
implements KSerializer<BankAccount> {
    @NotNull
    public static final BankAccountSerializer INSTANCE = new BankAccountSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = JsonObject.Companion.serializer().getDescriptor();

    private BankAccountSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public BankAccount deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        if (!(decoder instanceof JsonDecoder)) {
            throw new IllegalStateException("Check failed.");
        }
        JsonElement json = ((JsonDecoder)decoder).decodeJsonElement();
        return new BankAccountJsonParser().parse(new JSONObject(json.toString()));
    }

    /*
     * WARNING - void declaration
     */
    public void serialize(@NotNull Encoder encoder, @NotNull BankAccount value) {
        void $this$serialize_u24lambda_u240;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(encoder instanceof JsonEncoder)) {
            throw new IllegalStateException("Check failed.");
        }
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        JsonEncoder jsonEncoder = (JsonEncoder)encoder;
        boolean bl = false;
        $this$serialize_u24lambda_u240.put("object", (JsonElement)JsonElementKt.JsonPrimitive((String)"bank_account"));
        $this$serialize_u24lambda_u240.put("id", (JsonElement)JsonElementKt.JsonPrimitive((String)value.getId()));
        $this$serialize_u24lambda_u240.put("account_holder_name", (JsonElement)JsonElementKt.JsonPrimitive((String)value.getAccountHolderName()));
        BankAccount.Type type = value.getAccountHolderType();
        $this$serialize_u24lambda_u240.put("account_holder_type", (JsonElement)JsonElementKt.JsonPrimitive((String)(type != null ? type.getCode$payments_model_release() : null)));
        $this$serialize_u24lambda_u240.put("bank_name", (JsonElement)JsonElementKt.JsonPrimitive((String)value.getBankName()));
        $this$serialize_u24lambda_u240.put("country", (JsonElement)JsonElementKt.JsonPrimitive((String)value.getCountryCode()));
        $this$serialize_u24lambda_u240.put("currency", (JsonElement)JsonElementKt.JsonPrimitive((String)value.getCurrency()));
        $this$serialize_u24lambda_u240.put("fingerprint", (JsonElement)JsonElementKt.JsonPrimitive((String)value.getFingerprint()));
        $this$serialize_u24lambda_u240.put("last4", (JsonElement)JsonElementKt.JsonPrimitive((String)value.getLast4()));
        $this$serialize_u24lambda_u240.put("routing_number", (JsonElement)JsonElementKt.JsonPrimitive((String)value.getRoutingNumber()));
        BankAccount.Status status = value.getStatus();
        $this$serialize_u24lambda_u240.put("status", (JsonElement)JsonElementKt.JsonPrimitive((String)(status != null ? status.getCode$payments_model_release() : null)));
        jsonEncoder.encodeJsonElement((JsonElement)builder$iv.build());
    }
}

