/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.content.ContextCompat;
import com.stripe.android.R;
import com.stripe.android.databinding.StripeShippingMethodViewBinding;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.PaymentUtils;
import com.stripe.android.view.StripeColorUtils;
import java.util.Currency;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/view/ShippingMethodView;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "colorUtils", "Lcom/stripe/android/view/StripeColorUtils;", "selectedColorInt", "unselectedTextColorSecondaryInt", "unselectedTextColorPrimaryInt", "viewBinding", "Lcom/stripe/android/databinding/StripeShippingMethodViewBinding;", "setSelected", "", "selected", "", "setShippingMethod", "shippingMethod", "Lcom/stripe/android/model/ShippingMethod;", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class ShippingMethodView
extends RelativeLayout {
    @NotNull
    private final StripeColorUtils colorUtils;
    @ColorInt
    private final int selectedColorInt;
    @ColorInt
    private final int unselectedTextColorSecondaryInt;
    @ColorInt
    private final int unselectedTextColorPrimaryInt;
    @NotNull
    private final StripeShippingMethodViewBinding viewBinding;
    public static final int $stable = 8;

    @JvmOverloads
    public ShippingMethodView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.colorUtils = new StripeColorUtils(context);
        StripeShippingMethodViewBinding stripeShippingMethodViewBinding = StripeShippingMethodViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)stripeShippingMethodViewBinding, (String)"inflate(...)");
        this.viewBinding = stripeShippingMethodViewBinding;
        int rawSelectedColorInt = this.colorUtils.getColorAccent();
        int rawUnselectedTextColorPrimaryInt = this.colorUtils.getTextColorPrimary();
        int rawUnselectedTextColorSecondaryInt = this.colorUtils.getTextColorSecondary();
        this.selectedColorInt = StripeColorUtils.Companion.isColorTransparent(rawSelectedColorInt) ? ContextCompat.getColor((Context)context, (int)R.color.stripe_accent_color_default) : rawSelectedColorInt;
        this.unselectedTextColorPrimaryInt = StripeColorUtils.Companion.isColorTransparent(rawUnselectedTextColorPrimaryInt) ? ContextCompat.getColor((Context)context, (int)R.color.stripe_color_text_unselected_primary_default) : rawUnselectedTextColorPrimaryInt;
        this.unselectedTextColorSecondaryInt = StripeColorUtils.Companion.isColorTransparent(rawUnselectedTextColorSecondaryInt) ? ContextCompat.getColor((Context)context, (int)R.color.stripe_color_text_unselected_secondary_default) : rawUnselectedTextColorSecondaryInt;
    }

    public /* synthetic */ ShippingMethodView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.viewBinding.name.setTextColor(this.selectedColorInt);
            this.viewBinding.description.setTextColor(this.selectedColorInt);
            this.viewBinding.price.setTextColor(this.selectedColorInt);
            this.viewBinding.selectedIcon.setVisibility(0);
        } else {
            this.viewBinding.name.setTextColor(this.unselectedTextColorPrimaryInt);
            this.viewBinding.description.setTextColor(this.unselectedTextColorSecondaryInt);
            this.viewBinding.price.setTextColor(this.unselectedTextColorPrimaryInt);
            this.viewBinding.selectedIcon.setVisibility(4);
        }
    }

    public final void setShippingMethod(@NotNull ShippingMethod shippingMethod) {
        Intrinsics.checkNotNullParameter((Object)shippingMethod, (String)"shippingMethod");
        this.viewBinding.name.setText((CharSequence)shippingMethod.getLabel());
        this.viewBinding.description.setText((CharSequence)shippingMethod.getDetail());
        TextView textView = this.viewBinding.price;
        long l = shippingMethod.getAmount();
        Currency currency = shippingMethod.getCurrency();
        String string2 = this.getContext().getString(R.string.stripe_price_free);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        textView.setText((CharSequence)PaymentUtils.formatPriceStringUsingFree(l, currency, string2));
    }

    @JvmOverloads
    public ShippingMethodView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ShippingMethodView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

