/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Build;
import android.telephony.PhoneNumberFormattingTextWatcher;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.android.material.textfield.TextInputLayout;
import com.stripe.android.R;
import com.stripe.android.core.R;
import com.stripe.android.core.model.Country;
import com.stripe.android.core.model.CountryCode;
import com.stripe.android.core.model.CountryUtils;
import com.stripe.android.databinding.StripeAddressWidgetBinding;
import com.stripe.android.model.Address;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.uicore.R;
import com.stripe.android.view.CountryTextInputLayout;
import com.stripe.android.view.ErrorListener;
import com.stripe.android.view.PostalCodeValidator;
import com.stripe.android.view.StripeEditText;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0001PB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u00105\u001a\u0002062\b\u0010/\u001a\u0004\u0018\u000100J\u0010\u00107\u001a\u0002062\u0006\u00108\u001a\u000209H\u0002J\u0014\u0010:\u001a\u0002062\f\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<J\u0006\u0010>\u001a\u00020?J\u0010\u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020\u0014H\u0002J\u0010\u0010B\u001a\u00020?2\u0006\u0010A\u001a\u00020\u0014H\u0002J\u0010\u0010C\u001a\u00020?2\u0006\u0010A\u001a\u00020\u0014H\u0002J\b\u0010D\u001a\u000206H\u0002J\b\u0010E\u001a\u000206H\u0002J\b\u0010F\u001a\u000206H\u0002J\b\u0010G\u001a\u000206H\u0002J\u0010\u0010H\u001a\u0002062\u0006\u0010I\u001a\u00020JH\u0002J\u0010\u0010K\u001a\u0002062\u0006\u0010I\u001a\u00020JH\u0002J\b\u0010L\u001a\u000206H\u0002J\b\u0010M\u001a\u000206H\u0002J\b\u0010N\u001a\u000206H\u0002J\b\u0010O\u001a\u000206H\u0002R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R0\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010/\u001a\u0004\u0018\u0001008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00102\u00a8\u0006Q"}, d2={"Lcom/stripe/android/view/ShippingInfoWidget;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "viewBinding", "Lcom/stripe/android/databinding/StripeAddressWidgetBinding;", "getViewBinding", "()Lcom/stripe/android/databinding/StripeAddressWidgetBinding;", "viewBinding$delegate", "Lkotlin/Lazy;", "postalCodeValidator", "Lcom/stripe/android/view/PostalCodeValidator;", "value", "", "Lcom/stripe/android/view/ShippingInfoWidget$CustomizableShippingField;", "optionalFields", "getOptionalFields", "()Ljava/util/List;", "setOptionalFields", "(Ljava/util/List;)V", "hiddenFields", "getHiddenFields", "setHiddenFields", "countryAutoCompleteTextView", "Lcom/stripe/android/view/CountryTextInputLayout;", "addressLine1TextInputLayout", "Lcom/google/android/material/textfield/TextInputLayout;", "addressLine2TextInputLayout", "cityTextInputLayout", "nameTextInputLayout", "postalCodeTextInputLayout", "stateTextInputLayout", "phoneNumberTextInputLayout", "addressEditText", "Lcom/stripe/android/view/StripeEditText;", "addressEditText2", "cityEditText", "nameEditText", "postalCodeEditText", "stateEditText", "phoneNumberEditText", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "getShippingInformation", "()Lcom/stripe/android/model/ShippingInformation;", "rawShippingInformation", "getRawShippingInformation", "populateShippingInfo", "", "populateAddressFields", "address", "Lcom/stripe/android/model/Address;", "setAllowedCountryCodes", "allowedCountryCodes", "", "", "validateAllFields", "", "isFieldRequired", "field", "isFieldOptional", "isFieldHidden", "initView", "setupErrorHandling", "renderLabels", "hideHiddenFields", "updateConfigForCountry", "country", "Lcom/stripe/android/core/model/Country;", "updatePostalCodeInputFilter", "renderUSForm", "renderGreatBritainForm", "renderCanadianForm", "renderInternationalForm", "CustomizableShippingField", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nShippingInfoWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShippingInfoWidget.kt\ncom/stripe/android/view/ShippingInfoWidget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,438:1\n1#2:439\n*E\n"})
public final class ShippingInfoWidget
extends LinearLayout {
    @NotNull
    private final Lazy viewBinding$delegate;
    @NotNull
    private final PostalCodeValidator postalCodeValidator;
    @NotNull
    private List<? extends CustomizableShippingField> optionalFields;
    @NotNull
    private List<? extends CustomizableShippingField> hiddenFields;
    @NotNull
    private final CountryTextInputLayout countryAutoCompleteTextView;
    @NotNull
    private final TextInputLayout addressLine1TextInputLayout;
    @NotNull
    private final TextInputLayout addressLine2TextInputLayout;
    @NotNull
    private final TextInputLayout cityTextInputLayout;
    @NotNull
    private final TextInputLayout nameTextInputLayout;
    @NotNull
    private final TextInputLayout postalCodeTextInputLayout;
    @NotNull
    private final TextInputLayout stateTextInputLayout;
    @NotNull
    private final TextInputLayout phoneNumberTextInputLayout;
    @NotNull
    private final StripeEditText addressEditText;
    @NotNull
    private final StripeEditText addressEditText2;
    @NotNull
    private final StripeEditText cityEditText;
    @NotNull
    private final StripeEditText nameEditText;
    @NotNull
    private final StripeEditText postalCodeEditText;
    @NotNull
    private final StripeEditText stateEditText;
    @NotNull
    private final StripeEditText phoneNumberEditText;
    public static final int $stable = 8;

    @JvmOverloads
    public ShippingInfoWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.viewBinding$delegate = LazyKt.lazy(() -> ShippingInfoWidget.viewBinding_delegate$lambda$0(context, this));
        this.postalCodeValidator = new PostalCodeValidator();
        this.optionalFields = CollectionsKt.emptyList();
        this.hiddenFields = CollectionsKt.emptyList();
        CountryTextInputLayout countryTextInputLayout = this.getViewBinding().countryAutocompleteAaw;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)countryTextInputLayout), (String)"countryAutocompleteAaw");
        this.countryAutoCompleteTextView = countryTextInputLayout;
        TextInputLayout textInputLayout = this.getViewBinding().tlAddressLine1Aaw;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"tlAddressLine1Aaw");
        this.addressLine1TextInputLayout = textInputLayout;
        TextInputLayout textInputLayout2 = this.getViewBinding().tlAddressLine2Aaw;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout2, (String)"tlAddressLine2Aaw");
        this.addressLine2TextInputLayout = textInputLayout2;
        TextInputLayout textInputLayout3 = this.getViewBinding().tlCityAaw;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout3, (String)"tlCityAaw");
        this.cityTextInputLayout = textInputLayout3;
        TextInputLayout textInputLayout4 = this.getViewBinding().tlNameAaw;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout4, (String)"tlNameAaw");
        this.nameTextInputLayout = textInputLayout4;
        TextInputLayout textInputLayout5 = this.getViewBinding().tlPostalCodeAaw;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout5, (String)"tlPostalCodeAaw");
        this.postalCodeTextInputLayout = textInputLayout5;
        TextInputLayout textInputLayout6 = this.getViewBinding().tlStateAaw;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout6, (String)"tlStateAaw");
        this.stateTextInputLayout = textInputLayout6;
        TextInputLayout textInputLayout7 = this.getViewBinding().tlPhoneNumberAaw;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout7, (String)"tlPhoneNumberAaw");
        this.phoneNumberTextInputLayout = textInputLayout7;
        StripeEditText stripeEditText = this.getViewBinding().etAddressLineOneAaw;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)stripeEditText), (String)"etAddressLineOneAaw");
        this.addressEditText = stripeEditText;
        StripeEditText stripeEditText2 = this.getViewBinding().etAddressLineTwoAaw;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)stripeEditText2), (String)"etAddressLineTwoAaw");
        this.addressEditText2 = stripeEditText2;
        StripeEditText stripeEditText3 = this.getViewBinding().etCityAaw;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)stripeEditText3), (String)"etCityAaw");
        this.cityEditText = stripeEditText3;
        StripeEditText stripeEditText4 = this.getViewBinding().etNameAaw;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)stripeEditText4), (String)"etNameAaw");
        this.nameEditText = stripeEditText4;
        StripeEditText stripeEditText5 = this.getViewBinding().etPostalCodeAaw;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)stripeEditText5), (String)"etPostalCodeAaw");
        this.postalCodeEditText = stripeEditText5;
        StripeEditText stripeEditText6 = this.getViewBinding().etStateAaw;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)stripeEditText6), (String)"etStateAaw");
        this.stateEditText = stripeEditText6;
        StripeEditText stripeEditText7 = this.getViewBinding().etPhoneNumberAaw;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)stripeEditText7), (String)"etPhoneNumberAaw");
        this.phoneNumberEditText = stripeEditText7;
        this.setOrientation(1);
        if (Build.VERSION.SDK_INT >= 26) {
            String[] stringArray = new String[]{"name"};
            this.nameEditText.setAutofillHints(stringArray);
            stringArray = new String[]{"postalAddress"};
            this.addressLine1TextInputLayout.setAutofillHints(stringArray);
            stringArray = new String[]{"postalCode"};
            this.postalCodeEditText.setAutofillHints(stringArray);
            stringArray = new String[]{"phone"};
            this.phoneNumberEditText.setAutofillHints(stringArray);
        }
        this.initView();
    }

    public /* synthetic */ ShippingInfoWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final StripeAddressWidgetBinding getViewBinding() {
        Lazy lazy = this.viewBinding$delegate;
        return (StripeAddressWidgetBinding)lazy.getValue();
    }

    @NotNull
    public final List<CustomizableShippingField> getOptionalFields() {
        return this.optionalFields;
    }

    public final void setOptionalFields(@NotNull List<? extends CustomizableShippingField> value) {
        block0: {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.optionalFields = value;
            this.renderLabels();
            Country country = this.countryAutoCompleteTextView.getSelectedCountry$payments_core_release();
            if (country == null) break block0;
            Country p0 = country;
            boolean bl = false;
            this.updateConfigForCountry(p0);
        }
    }

    @NotNull
    public final List<CustomizableShippingField> getHiddenFields() {
        return this.hiddenFields;
    }

    public final void setHiddenFields(@NotNull List<? extends CustomizableShippingField> value) {
        block0: {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.hiddenFields = value;
            this.renderLabels();
            Country country = this.countryAutoCompleteTextView.getSelectedCountry$payments_core_release();
            if (country == null) break block0;
            Country p0 = country;
            boolean bl = false;
            this.updateConfigForCountry(p0);
        }
    }

    @Nullable
    public final ShippingInformation getShippingInformation() {
        return !this.validateAllFields() ? null : this.getRawShippingInformation();
    }

    private final ShippingInformation getRawShippingInformation() {
        Country country = this.countryAutoCompleteTextView.getSelectedCountry$payments_core_release();
        return new ShippingInformation(new Address.Builder().setCity(this.cityEditText.getFieldText$payments_core_release()).setCountryCode((CountryCode)(country != null ? country.getCode() : null)).setLine1(this.addressEditText.getFieldText$payments_core_release()).setLine2(this.addressEditText2.getFieldText$payments_core_release()).setPostalCode(this.postalCodeEditText.getFieldText$payments_core_release()).setState(this.stateEditText.getFieldText$payments_core_release()).build(), this.nameEditText.getFieldText$payments_core_release(), this.phoneNumberEditText.getFieldText$payments_core_release());
    }

    public final void populateShippingInfo(@Nullable ShippingInformation shippingInformation) {
        if (shippingInformation == null) {
            return;
        }
        Address address = shippingInformation.getAddress();
        if (address != null) {
            Address p0 = address;
            boolean bl = false;
            this.populateAddressFields(p0);
        }
        this.nameEditText.setText(shippingInformation.getName());
        this.phoneNumberEditText.setText(shippingInformation.getPhone());
    }

    private final void populateAddressFields(Address address) {
        this.cityEditText.setText(address.getCity());
        String string2 = address.getCountry();
        if (string2 != null) {
            String country = string2;
            boolean bl = false;
            if (((CharSequence)country).length() > 0) {
                this.countryAutoCompleteTextView.setCountrySelected$payments_core_release(country);
            }
        }
        this.addressEditText.setText(address.getLine1());
        this.addressEditText2.setText(address.getLine2());
        this.postalCodeEditText.setText(address.getPostalCode());
        this.stateEditText.setText(address.getState());
    }

    public final void setAllowedCountryCodes(@NotNull Set<String> allowedCountryCodes) {
        Intrinsics.checkNotNullParameter(allowedCountryCodes, (String)"allowedCountryCodes");
        this.countryAutoCompleteTextView.setAllowedCountryCodes$payments_core_release(allowedCountryCodes);
    }

    public final boolean validateAllFields() {
        Object object = this.addressEditText.getText();
        if (object == null || (object = object.toString()) == null) {
            return false;
        }
        Object address = object;
        Object object2 = this.nameEditText.getText();
        if (object2 == null || (object2 = object2.toString()) == null) {
            return false;
        }
        Object name = object2;
        Object object3 = this.cityEditText.getText();
        if (object3 == null || (object3 = object3.toString()) == null) {
            return false;
        }
        Object city = object3;
        Object object4 = this.stateEditText.getText();
        if (object4 == null || (object4 = object4.toString()) == null) {
            return false;
        }
        Object state = object4;
        Object object5 = this.postalCodeEditText.getText();
        if (object5 == null || (object5 = object5.toString()) == null) {
            return false;
        }
        Object postalCode = object5;
        Object object6 = this.phoneNumberEditText.getText();
        if (object6 == null || (object6 = object6.toString()) == null) {
            return false;
        }
        Object phoneNumber = object6;
        this.countryAutoCompleteTextView.validateCountry$payments_core_release();
        Country selectedCountry = this.countryAutoCompleteTextView.getSelectedCountry$payments_core_release();
        Country country = selectedCountry;
        boolean isPostalCodeValid = this.postalCodeValidator.isValid$payments_core_release((String)postalCode, country != null && (country = country.getCode()) != null ? country.getValue() : null, this.optionalFields, this.hiddenFields);
        this.postalCodeEditText.setShouldShowError(!isPostalCodeValid);
        boolean requiredAddressLine1Empty = StringsKt.isBlank((CharSequence)((CharSequence)address)) && this.isFieldRequired(CustomizableShippingField.Line1);
        this.addressEditText.setShouldShowError(requiredAddressLine1Empty);
        boolean requiredCityEmpty = StringsKt.isBlank((CharSequence)((CharSequence)city)) && this.isFieldRequired(CustomizableShippingField.City);
        this.cityEditText.setShouldShowError(requiredCityEmpty);
        boolean requiredNameEmpty = StringsKt.isBlank((CharSequence)((CharSequence)name));
        this.nameEditText.setShouldShowError(requiredNameEmpty);
        boolean requiredStateEmpty = StringsKt.isBlank((CharSequence)((CharSequence)state)) && this.isFieldRequired(CustomizableShippingField.State);
        this.stateEditText.setShouldShowError(requiredStateEmpty);
        boolean requiredPhoneNumberEmpty = StringsKt.isBlank((CharSequence)((CharSequence)phoneNumber)) && this.isFieldRequired(CustomizableShippingField.Phone);
        this.phoneNumberEditText.setShouldShowError(requiredPhoneNumberEmpty);
        return isPostalCodeValid && !requiredAddressLine1Empty && !requiredCityEmpty && !requiredStateEmpty && !requiredNameEmpty && !requiredPhoneNumberEmpty && selectedCountry != null;
    }

    private final boolean isFieldRequired(CustomizableShippingField field) {
        return !this.isFieldOptional(field) && !this.isFieldHidden(field);
    }

    private final boolean isFieldOptional(CustomizableShippingField field) {
        return this.optionalFields.contains((Object)field);
    }

    private final boolean isFieldHidden(CustomizableShippingField field) {
        return this.hiddenFields.contains((Object)field);
    }

    private final void initView() {
        block0: {
            this.countryAutoCompleteTextView.setCountryChangeCallback$payments_core_release((Function1<? super Country, Unit>)((Function1)new Function1<Country, Unit>((Object)this){

                public final void invoke(Country p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ShippingInfoWidget.access$updateConfigForCountry((ShippingInfoWidget)((Object)this.receiver), p0);
                }
            }));
            this.phoneNumberEditText.addTextChangedListener((TextWatcher)new PhoneNumberFormattingTextWatcher());
            this.setupErrorHandling();
            this.renderLabels();
            Country country = this.countryAutoCompleteTextView.getSelectedCountry$payments_core_release();
            if (country == null) break block0;
            Country p0 = country;
            boolean bl = false;
            this.updateConfigForCountry(p0);
        }
    }

    private final void setupErrorHandling() {
        this.addressEditText.setErrorMessageListener(new ErrorListener(this.addressLine1TextInputLayout));
        this.cityEditText.setErrorMessageListener(new ErrorListener(this.cityTextInputLayout));
        this.nameEditText.setErrorMessageListener(new ErrorListener(this.nameTextInputLayout));
        this.postalCodeEditText.setErrorMessageListener(new ErrorListener(this.postalCodeTextInputLayout));
        this.stateEditText.setErrorMessageListener(new ErrorListener(this.stateTextInputLayout));
        this.phoneNumberEditText.setErrorMessageListener(new ErrorListener(this.phoneNumberTextInputLayout));
        this.addressEditText.setErrorMessage(this.getResources().getString(R.string.stripe_address_required));
        this.cityEditText.setErrorMessage(this.getResources().getString(R.string.stripe_address_city_required));
        this.nameEditText.setErrorMessage(this.getResources().getString(R.string.stripe_address_name_required));
        this.phoneNumberEditText.setErrorMessage(this.getResources().getString(R.string.stripe_address_phone_number_required));
    }

    private final void renderLabels() {
        this.nameTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.stripe_address_label_full_name));
        this.cityTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.City) ? (CharSequence)this.getResources().getString(R.string.stripe_address_label_city_optional) : (CharSequence)this.getResources().getString(R.string.stripe_address_label_city));
        this.phoneNumberTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.Phone) ? (CharSequence)this.getResources().getString(R.string.stripe_address_label_phone_number_optional) : (CharSequence)this.getResources().getString(R.string.stripe_address_label_phone_number));
        this.hideHiddenFields();
    }

    private final void hideHiddenFields() {
        if (this.isFieldHidden(CustomizableShippingField.Line1)) {
            this.addressLine1TextInputLayout.setVisibility(8);
        }
        if (this.isFieldHidden(CustomizableShippingField.Line2)) {
            this.addressLine2TextInputLayout.setVisibility(8);
        }
        if (this.isFieldHidden(CustomizableShippingField.State)) {
            this.stateTextInputLayout.setVisibility(8);
        }
        if (this.isFieldHidden(CustomizableShippingField.City)) {
            this.cityTextInputLayout.setVisibility(8);
        }
        if (this.isFieldHidden(CustomizableShippingField.PostalCode)) {
            this.postalCodeTextInputLayout.setVisibility(8);
        }
        if (this.isFieldHidden(CustomizableShippingField.Phone)) {
            this.phoneNumberTextInputLayout.setVisibility(8);
        }
    }

    private final void updateConfigForCountry(Country country) {
        String string2 = country.getCode().getValue();
        if (Intrinsics.areEqual((Object)string2, (Object)Locale.US.getCountry())) {
            this.renderUSForm();
        } else if (Intrinsics.areEqual((Object)string2, (Object)Locale.UK.getCountry())) {
            this.renderGreatBritainForm();
        } else if (Intrinsics.areEqual((Object)string2, (Object)Locale.CANADA.getCountry())) {
            this.renderCanadianForm();
        } else {
            this.renderInternationalForm();
        }
        this.updatePostalCodeInputFilter(country);
        this.postalCodeTextInputLayout.setVisibility(CountryUtils.INSTANCE.doesCountryUsePostalCode(country.getCode()) && !this.isFieldHidden(CustomizableShippingField.PostalCode) ? 0 : 8);
    }

    private final void updatePostalCodeInputFilter(Country country) {
        InputFilter[] inputFilterArray;
        if (Intrinsics.areEqual((Object)country.getCode().getValue(), (Object)Locale.CANADA.getCountry())) {
            InputFilter[] inputFilterArray2 = new InputFilter[]{new InputFilter.AllCaps()};
            inputFilterArray = inputFilterArray2;
        } else {
            inputFilterArray = new InputFilter[]{};
        }
        this.postalCodeEditText.setFilters(inputFilterArray);
    }

    private final void renderUSForm() {
        this.addressLine1TextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.Line1) ? (CharSequence)this.getResources().getString(R.string.stripe_address_label_address_optional) : (CharSequence)this.getResources().getString(R.string.stripe_address_label_address));
        this.addressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.stripe_address_label_apt_optional));
        this.postalCodeTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.PostalCode) ? (CharSequence)this.getResources().getString(R.string.stripe_address_label_zip_code_optional) : (CharSequence)this.getResources().getString(R.string.stripe_address_label_zip_code));
        this.stateTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.State) ? (CharSequence)this.getResources().getString(R.string.stripe_address_label_state_optional) : (CharSequence)this.getResources().getString(R.string.stripe_address_label_state));
        this.postalCodeEditText.setErrorMessage(this.getResources().getString(R.string.stripe_address_zip_invalid));
        this.stateEditText.setErrorMessage(this.getResources().getString(R.string.stripe_address_state_required));
    }

    private final void renderGreatBritainForm() {
        this.addressLine1TextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.Line1) ? (CharSequence)this.getResources().getString(R.string.stripe_address_label_address_line1_optional) : (CharSequence)this.getResources().getString(R.string.stripe_address_label_address_line1));
        this.addressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.stripe_address_label_address_line2_optional));
        this.postalCodeTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.PostalCode) ? (CharSequence)this.getResources().getString(R.string.stripe_address_label_postcode_optional) : (CharSequence)this.getResources().getString(R.string.stripe_address_label_postcode));
        this.stateTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.State) ? (CharSequence)this.getResources().getString(R.string.stripe_address_label_county_optional) : (CharSequence)this.getResources().getString(R.string.stripe_address_label_county));
        this.postalCodeEditText.setErrorMessage(this.getResources().getString(R.string.stripe_address_postcode_invalid));
        this.stateEditText.setErrorMessage(this.getResources().getString(R.string.stripe_address_county_required));
    }

    private final void renderCanadianForm() {
        this.addressLine1TextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.Line1) ? (CharSequence)this.getResources().getString(R.string.stripe_address_label_address_optional) : (CharSequence)this.getResources().getString(R.string.stripe_address_label_address));
        this.addressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.stripe_address_label_apt_optional));
        this.postalCodeTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.PostalCode) ? (CharSequence)this.getResources().getString(R.string.stripe_address_label_postal_code_optional) : (CharSequence)this.getResources().getString(R.string.stripe_address_label_postal_code));
        this.stateTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.State) ? (CharSequence)this.getResources().getString(R.string.stripe_address_label_province_optional) : (CharSequence)this.getResources().getString(R.string.stripe_address_label_province));
        this.postalCodeEditText.setErrorMessage(this.getResources().getString(R.string.stripe_address_postal_code_invalid));
        this.stateEditText.setErrorMessage(this.getResources().getString(R.string.stripe_address_province_required));
    }

    private final void renderInternationalForm() {
        this.addressLine1TextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.Line1) ? (CharSequence)this.getResources().getString(R.string.stripe_address_label_address_line1_optional) : (CharSequence)this.getResources().getString(R.string.stripe_address_label_address_line1));
        this.addressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.stripe_address_label_address_line2_optional));
        this.postalCodeTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.PostalCode) ? (CharSequence)this.getResources().getString(R.string.stripe_address_label_zip_postal_code_optional) : (CharSequence)this.getResources().getString(R.string.stripe_address_label_zip_postal_code));
        this.stateTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.State) ? (CharSequence)this.getResources().getString(R.string.stripe_address_label_region_generic_optional) : (CharSequence)this.getResources().getString(R.string.stripe_address_label_region_generic));
        this.postalCodeEditText.setErrorMessage(this.getResources().getString(R.string.stripe_address_zip_postal_invalid));
        this.stateEditText.setErrorMessage(this.getResources().getString(R.string.stripe_address_region_generic_required));
    }

    @JvmOverloads
    public ShippingInfoWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ShippingInfoWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final StripeAddressWidgetBinding viewBinding_delegate$lambda$0(Context $context, ShippingInfoWidget this$0) {
        StripeAddressWidgetBinding stripeAddressWidgetBinding = StripeAddressWidgetBinding.inflate(LayoutInflater.from((Context)$context), (ViewGroup)this$0);
        Intrinsics.checkNotNullExpressionValue((Object)stripeAddressWidgetBinding, (String)"inflate(...)");
        return stripeAddressWidgetBinding;
    }

    public static final /* synthetic */ void access$updateConfigForCountry(ShippingInfoWidget $this, Country country) {
        $this.updateConfigForCountry(country);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/view/ShippingInfoWidget$CustomizableShippingField;", "", "<init>", "(Ljava/lang/String;I)V", "Line1", "Line2", "City", "PostalCode", "State", "Phone", "payments-core_release"})
    public static final class CustomizableShippingField
    extends Enum<CustomizableShippingField> {
        public static final /* enum */ CustomizableShippingField Line1 = new CustomizableShippingField();
        public static final /* enum */ CustomizableShippingField Line2 = new CustomizableShippingField();
        public static final /* enum */ CustomizableShippingField City = new CustomizableShippingField();
        public static final /* enum */ CustomizableShippingField PostalCode = new CustomizableShippingField();
        public static final /* enum */ CustomizableShippingField State = new CustomizableShippingField();
        public static final /* enum */ CustomizableShippingField Phone = new CustomizableShippingField();
        private static final /* synthetic */ CustomizableShippingField[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CustomizableShippingField[] values() {
            return (CustomizableShippingField[])$VALUES.clone();
        }

        public static CustomizableShippingField valueOf(String value) {
            return Enum.valueOf(CustomizableShippingField.class, value);
        }

        @NotNull
        public static EnumEntries<CustomizableShippingField> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = customizableShippingFieldArray = new CustomizableShippingField[]{CustomizableShippingField.Line1, CustomizableShippingField.Line2, CustomizableShippingField.City, CustomizableShippingField.PostalCode, CustomizableShippingField.State, CustomizableShippingField.Phone};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

