/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.CountryUtils;
import com.stripe.android.view.ShippingInfoWidget;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J;\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/view/PostalCodeValidator;", "", "<init>", "()V", "isValid", "", "postalCode", "", "countryCode", "optionalShippingInfoFields", "", "Lcom/stripe/android/view/ShippingInfoWidget$CustomizableShippingField;", "hiddenShippingInfoFields", "isValid$payments_core_release", "Companion", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=1)
public final class PostalCodeValidator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final Map<String, Pattern> POSTAL_CODE_PATTERNS;

    public final boolean isValid(@NotNull String postalCode, @NotNull String countryCode) {
        Intrinsics.checkNotNullParameter((Object)postalCode, (String)"postalCode");
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        Object object = POSTAL_CODE_PATTERNS.get(countryCode);
        return object != null && (object = ((Pattern)object).matcher(postalCode)) != null ? ((Matcher)object).matches() : !CountryUtils.INSTANCE.doesCountryUsePostalCode(countryCode) || !StringsKt.isBlank((CharSequence)postalCode);
    }

    public final boolean isValid$payments_core_release(@NotNull String postalCode, @Nullable String countryCode, @NotNull List<? extends ShippingInfoWidget.CustomizableShippingField> optionalShippingInfoFields, @NotNull List<? extends ShippingInfoWidget.CustomizableShippingField> hiddenShippingInfoFields) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)postalCode, (String)"postalCode");
        Intrinsics.checkNotNullParameter(optionalShippingInfoFields, (String)"optionalShippingInfoFields");
        Intrinsics.checkNotNullParameter(hiddenShippingInfoFields, (String)"hiddenShippingInfoFields");
        if (countryCode == null) {
            return false;
        }
        return StringsKt.isBlank((CharSequence)postalCode) && PostalCodeValidator.Companion.isPostalCodeNotRequired(optionalShippingInfoFields, hiddenShippingInfoFields) ? true : ((object = POSTAL_CODE_PATTERNS.get(countryCode)) != null && (object = ((Pattern)object).matcher(postalCode)) != null ? ((Matcher)object).matches() : !CountryUtils.INSTANCE.doesCountryUsePostalCode(countryCode) || !StringsKt.isBlank((CharSequence)postalCode));
    }

    static {
        POSTAL_CODE_PATTERNS = MapsKt.mapOf((Pair)TuplesKt.to((Object)Locale.US.getCountry(), (Object)Pattern.compile("^[0-9]{5}(?:-[0-9]{4})?$")));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002R*\u0010\u0004\u001a\u001e\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/view/PostalCodeValidator$Companion;", "", "<init>", "()V", "POSTAL_CODE_PATTERNS", "", "", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "isPostalCodeNotRequired", "", "optionalShippingInfoFields", "", "Lcom/stripe/android/view/ShippingInfoWidget$CustomizableShippingField;", "hiddenShippingInfoFields", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        private final boolean isPostalCodeNotRequired(List<? extends ShippingInfoWidget.CustomizableShippingField> optionalShippingInfoFields, List<? extends ShippingInfoWidget.CustomizableShippingField> hiddenShippingInfoFields) {
            return optionalShippingInfoFields.contains((Object)ShippingInfoWidget.CustomizableShippingField.PostalCode) || hiddenShippingInfoFields.contains((Object)ShippingInfoWidget.CustomizableShippingField.PostalCode);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

