/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import androidx.compose.runtime.internal.StabilityInferred;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u001d\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/view/PaymentUtils;", "", "<init>", "()V", "formatPriceStringUsingFree", "", "amount", "", "currency", "Ljava/util/Currency;", "free", "formatPriceString", "", "formatPriceString$payments_core_release", "payments-core_release"})
@StabilityInferred(parameters=1)
public final class PaymentUtils {
    @NotNull
    public static final PaymentUtils INSTANCE = new PaymentUtils();
    public static final int $stable;

    private PaymentUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String formatPriceStringUsingFree(long amount, @NotNull Currency currency, @NotNull String free) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)free, (String)"free");
        if (amount == 0L) {
            return free;
        }
        NumberFormat currencyFormat = NumberFormat.getCurrencyInstance();
        Intrinsics.checkNotNull((Object)currencyFormat, (String)"null cannot be cast to non-null type java.text.DecimalFormat");
        DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)currencyFormat).getDecimalFormatSymbols();
        decimalFormatSymbols.setCurrencySymbol(currency.getSymbol(Locale.getDefault()));
        ((DecimalFormat)currencyFormat).setDecimalFormatSymbols(decimalFormatSymbols);
        return INSTANCE.formatPriceString$payments_core_release(amount, currency);
    }

    public final /* synthetic */ String formatPriceString$payments_core_release(double amount, Currency currency) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        double majorUnitAmount = amount / Math.pow(10.0, currency.getDefaultFractionDigits());
        NumberFormat currencyFormat = NumberFormat.getCurrencyInstance();
        try {
            Intrinsics.checkNotNull((Object)currencyFormat, (String)"null cannot be cast to non-null type java.text.DecimalFormat");
            DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)currencyFormat).getDecimalFormatSymbols();
            decimalFormatSymbols.setCurrencySymbol(currency.getSymbol(Locale.getDefault()));
            ((DecimalFormat)currencyFormat).setDecimalFormatSymbols(decimalFormatSymbols);
            string2 = ((DecimalFormat)currencyFormat).format(majorUnitAmount);
            Intrinsics.checkNotNull((Object)string2);
        }
        catch (ClassCastException e) {
            String string3 = currencyFormat.format(majorUnitAmount);
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        }
        return string2;
    }
}

