/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import androidx.activity.ComponentActivity;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.OnBackPressedDispatcher;
import androidx.activity.OnBackPressedDispatcherKt;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AppCompatActivity;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ViewModelLazy;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.google.android.material.progressindicator.CircularProgressIndicator;
import com.stripe.android.R;
import com.stripe.android.auth.PaymentBrowserAuthContract;
import com.stripe.android.core.Logger;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.databinding.StripePaymentAuthWebViewActivityBinding;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import com.stripe.android.stripe3ds2.init.ui.Customization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;
import com.stripe.android.view.PaymentAuthWebChromeClient;
import com.stripe.android.view.PaymentAuthWebViewActivityViewModel;
import com.stripe.android.view.PaymentAuthWebViewClient;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014J\u0017\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0001\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\u001aH\u0014J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u001aH\u0002J\b\u0010*\u001a\u00020\u001aH\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\n\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\t\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\t\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006/"}, d2={"Lcom/stripe/android/view/PaymentAuthWebViewActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "<init>", "()V", "viewBinding", "Lcom/stripe/android/databinding/StripePaymentAuthWebViewActivityBinding;", "getViewBinding", "()Lcom/stripe/android/databinding/StripePaymentAuthWebViewActivityBinding;", "viewBinding$delegate", "Lkotlin/Lazy;", "_args", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "get_args", "()Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "_args$delegate", "logger", "Lcom/stripe/android/core/Logger;", "getLogger", "()Lcom/stripe/android/core/Logger;", "logger$delegate", "viewModel", "Lcom/stripe/android/view/PaymentAuthWebViewActivityViewModel;", "getViewModel", "()Lcom/stripe/android/view/PaymentAuthWebViewActivityViewModel;", "viewModel$delegate", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onAuthComplete", "error", "", "onAuthComplete$payments_core_release", "onDestroy", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "cancelIntentSource", "customizeToolbar", "createResultIntent", "Landroid/content/Intent;", "paymentFlowResult", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPaymentAuthWebViewActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentAuthWebViewActivity.kt\ncom/stripe/android/view/PaymentAuthWebViewActivity\n+ 2 ActivityViewModelLazy.kt\nandroidx/activity/ActivityViewModelLazyKt\n*L\n1#1,207:1\n75#2,13:208\n*S KotlinDebug\n*F\n+ 1 PaymentAuthWebViewActivity.kt\ncom/stripe/android/view/PaymentAuthWebViewActivity\n*L\n41#1:208,13\n*E\n"})
public final class PaymentAuthWebViewActivity
extends AppCompatActivity {
    @NotNull
    private final Lazy viewBinding$delegate = LazyKt.lazy(() -> PaymentAuthWebViewActivity.viewBinding_delegate$lambda$0(this));
    @NotNull
    private final Lazy _args$delegate = LazyKt.lazy(() -> PaymentAuthWebViewActivity._args_delegate$lambda$1(this));
    @NotNull
    private final Lazy logger$delegate = LazyKt.lazy(() -> PaymentAuthWebViewActivity.logger_delegate$lambda$2(this));
    @NotNull
    private final Lazy viewModel$delegate;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public PaymentAuthWebViewActivity() {
        void $this$viewModels_u24default$iv;
        ComponentActivity componentActivity = (ComponentActivity)this;
        Function0 factoryProducer$iv = () -> PaymentAuthWebViewActivity.viewModel_delegate$lambda$3(this);
        Function0 extrasProducer$iv = null;
        boolean $i$f$viewModels = false;
        Function0 function0 = factoryProducer$iv;
        if (function0 == null) {
            function0 = (Function0)new Function0<ViewModelProvider.Factory>((ComponentActivity)$this$viewModels_u24default$iv){
                final /* synthetic */ ComponentActivity $this_viewModels;
                {
                    this.$this_viewModels = $receiver;
                    super(0);
                }

                @NotNull
                public final ViewModelProvider.Factory invoke() {
                    return this.$this_viewModels.getDefaultViewModelProviderFactory();
                }
            };
        }
        Function0 factoryPromise$iv = function0;
        this.viewModel$delegate = (Lazy)new ViewModelLazy(Reflection.getOrCreateKotlinClass(PaymentAuthWebViewActivityViewModel.class), (Function0)new Function0<ViewModelStore>((ComponentActivity)$this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                return this.$this_viewModels.getViewModelStore();
            }
        }, factoryPromise$iv, (Function0)new Function0<CreationExtras>(extrasProducer$iv, (ComponentActivity)$this$viewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    function0 = this.$this_viewModels.getDefaultViewModelCreationExtras();
                }
                return function0;
            }
        });
    }

    private final StripePaymentAuthWebViewActivityBinding getViewBinding() {
        Lazy lazy = this.viewBinding$delegate;
        return (StripePaymentAuthWebViewActivityBinding)lazy.getValue();
    }

    private final PaymentBrowserAuthContract.Args get_args() {
        Lazy lazy = this._args$delegate;
        return (PaymentBrowserAuthContract.Args)lazy.getValue();
    }

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (Logger)lazy.getValue();
    }

    private final PaymentAuthWebViewActivityViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (PaymentAuthWebViewActivityViewModel)((Object)lazy.getValue());
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PaymentBrowserAuthContract.Args args = this.get_args();
        if (args == null) {
            this.setResult(0);
            this.finish();
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
            ErrorReporter.DefaultImpls.report$default(ErrorReporter.Companion.createFallbackInstance$default(ErrorReporter.Companion, context, null, 2, null), ErrorReporter.ExpectedErrorEvent.AUTH_WEB_VIEW_NULL_ARGS, null, null, 6, null);
            return;
        }
        this.getLogger().debug("PaymentAuthWebViewActivity#onCreate()");
        this.setContentView((View)this.getViewBinding().getRoot());
        this.setSupportActionBar(this.getViewBinding().toolbar);
        this.customizeToolbar();
        OnBackPressedDispatcherKt.addCallback$default((OnBackPressedDispatcher)this.getOnBackPressedDispatcher(), null, (boolean)false, arg_0 -> PaymentAuthWebViewActivity.onCreate$lambda$4(this, arg_0), (int)3, null);
        String clientSecret = args.getClientSecret();
        this.setResult(-1, this.createResultIntent(this.getViewModel().getPaymentResult$payments_core_release()));
        if (StringsKt.isBlank((CharSequence)clientSecret)) {
            this.getLogger().debug("PaymentAuthWebViewActivity#onCreate() - clientSecret is blank");
            this.finish();
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
            ErrorReporter.DefaultImpls.report$default(ErrorReporter.Companion.createFallbackInstance$default(ErrorReporter.Companion, context, null, 2, null), ErrorReporter.UnexpectedErrorEvent.AUTH_WEB_VIEW_BLANK_CLIENT_SECRET, null, null, 6, null);
            return;
        }
        this.getLogger().debug("PaymentAuthWebViewActivity#onCreate() - PaymentAuthWebView init and loadUrl");
        MutableStateFlow isPagedLoaded = StateFlowKt.MutableStateFlow((Object)false);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((MutableStateFlow<Boolean>)isPagedLoaded, this, null){
            int label;
            final /* synthetic */ MutableStateFlow<Boolean> $isPagedLoaded;
            final /* synthetic */ PaymentAuthWebViewActivity this$0;
            {
                this.$isPagedLoaded = $isPagedLoaded;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$isPagedLoaded.collect(new FlowCollector(this.this$0){
                            final /* synthetic */ PaymentAuthWebViewActivity this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object emit(boolean shouldHide, Continuation<? super Unit> $completion) {
                                if (shouldHide) {
                                    void $this$isGone$iv;
                                    CircularProgressIndicator circularProgressIndicator = PaymentAuthWebViewActivity.access$getViewBinding((PaymentAuthWebViewActivity)this.this$0).progressBar;
                                    Intrinsics.checkNotNullExpressionValue((Object)circularProgressIndicator, (String)"progressBar");
                                    View view = (View)circularProgressIndicator;
                                    boolean value$iv = true;
                                    boolean $i$f$setGone = false;
                                    $this$isGone$iv.setVisibility(8);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        PaymentAuthWebViewClient webViewClient2 = new PaymentAuthWebViewClient(this.getLogger(), (MutableStateFlow<Boolean>)isPagedLoaded, clientSecret, args.getReturnUrl(), (Function1<? super Intent, Unit>)((Function1)new Function1<Intent, Unit>((Object)this){

            public final void invoke(Intent p0) {
                ((PaymentAuthWebViewActivity)((Object)this.receiver)).startActivity(p0);
            }
        }), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>((Object)this){

            public final void invoke(Throwable p0) {
                ((PaymentAuthWebViewActivity)((Object)this.receiver)).onAuthComplete$payments_core_release(p0);
            }
        }));
        this.getViewBinding().webView.setOnLoadBlank$payments_core_release((Function0<Unit>)((Function0)() -> PaymentAuthWebViewActivity.onCreate$lambda$5(webViewClient2)));
        this.getViewBinding().webView.setWebViewClient(webViewClient2);
        this.getViewBinding().webView.setWebChromeClient(new PaymentAuthWebChromeClient((Activity)this, this.getLogger()));
        this.getViewModel().logStart();
        this.getViewBinding().webView.loadUrl(args.getUrl(), this.getViewModel().getExtraHeaders());
    }

    @VisibleForTesting
    public final void onAuthComplete$payments_core_release(@Nullable Throwable error) {
        if (error != null) {
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
            ErrorReporter.DefaultImpls.report$default(ErrorReporter.Companion.createFallbackInstance$default(ErrorReporter.Companion, context, null, 2, null), ErrorReporter.ExpectedErrorEvent.AUTH_WEB_VIEW_FAILURE, StripeException.Companion.create(error), null, 4, null);
            this.getViewModel().logError();
            PaymentFlowResult.Unvalidated unvalidated = this.getViewModel().getPaymentResult$payments_core_release();
            StripeException stripeException = StripeException.Companion.create(error);
            this.setResult(-1, this.createResultIntent(PaymentFlowResult.Unvalidated.copy$default(unvalidated, null, 2, stripeException, true, null, null, null, 113, null)));
        } else {
            this.getViewModel().logComplete();
        }
        this.finish();
    }

    protected void onDestroy() {
        this.getViewBinding().webViewContainer.removeAllViews();
        this.getViewBinding().webView.destroy();
        super.onDestroy();
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
            this.getLogger().debug("PaymentAuthWebViewActivity#onCreateOptionsMenu()");
            this.getMenuInflater().inflate(R.menu.stripe_payment_auth_web_view_menu, menu2);
            String string2 = this.getViewModel().getButtonText$payments_core_release();
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            this.getLogger().debug("PaymentAuthWebViewActivity#customizeToolbar() - updating close button text");
            menu2.findItem(R.id.action_close).setTitle((CharSequence)it);
        }
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.getLogger().debug("PaymentAuthWebViewActivity#onOptionsItemSelected()");
        if (item.getItemId() == R.id.action_close) {
            this.cancelIntentSource();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private final void cancelIntentSource() {
        this.setResult(-1, this.getViewModel().getCancellationResult$payments_core_release());
        this.finish();
    }

    private final void customizeToolbar() {
        block1: {
            this.getLogger().debug("PaymentAuthWebViewActivity#customizeToolbar()");
            PaymentAuthWebViewActivityViewModel.ToolbarTitleData toolbarTitleData = this.getViewModel().getToolbarTitle$payments_core_release();
            if (toolbarTitleData != null) {
                PaymentAuthWebViewActivityViewModel.ToolbarTitleData it = toolbarTitleData;
                boolean bl = false;
                this.getLogger().debug("PaymentAuthWebViewActivity#customizeToolbar() - updating toolbar title");
                this.getViewBinding().toolbar.setTitle((CharSequence)CustomizeUtils.INSTANCE.buildStyledText((Context)this, it.getText$payments_core_release(), (Customization)it.getToolbarCustomization$payments_core_release()));
            }
            String string2 = this.getViewModel().getToolbarBackgroundColor$payments_core_release();
            if (string2 == null) break block1;
            String backgroundColor = string2;
            boolean bl = false;
            this.getLogger().debug("PaymentAuthWebViewActivity#customizeToolbar() - updating toolbar background color");
            int backgroundColorInt = Color.parseColor((String)backgroundColor);
            this.getViewBinding().toolbar.setBackgroundColor(backgroundColorInt);
            CustomizeUtils.INSTANCE.setStatusBarColor((AppCompatActivity)this, backgroundColorInt);
        }
    }

    private final Intent createResultIntent(PaymentFlowResult.Unvalidated paymentFlowResult) {
        Intent intent = new Intent().putExtras(paymentFlowResult.toBundle());
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"putExtras(...)");
        return intent;
    }

    private static final StripePaymentAuthWebViewActivityBinding viewBinding_delegate$lambda$0(PaymentAuthWebViewActivity this$0) {
        StripePaymentAuthWebViewActivityBinding stripePaymentAuthWebViewActivityBinding = StripePaymentAuthWebViewActivityBinding.inflate(this$0.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)stripePaymentAuthWebViewActivityBinding, (String)"inflate(...)");
        return stripePaymentAuthWebViewActivityBinding;
    }

    private static final PaymentBrowserAuthContract.Args _args_delegate$lambda$1(PaymentAuthWebViewActivity this$0) {
        Intent intent = this$0.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getIntent(...)");
        return PaymentBrowserAuthContract.Companion.parseArgs$payments_core_release(intent);
    }

    private static final Logger logger_delegate$lambda$2(PaymentAuthWebViewActivity this$0) {
        PaymentBrowserAuthContract.Args args = this$0.get_args();
        return Logger.Companion.getInstance(args != null ? args.getEnableLogging() : false);
    }

    private static final ViewModelProvider.Factory viewModel_delegate$lambda$3(PaymentAuthWebViewActivity this$0) {
        Application application = this$0.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        PaymentBrowserAuthContract.Args args = this$0.get_args();
        if (args == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        return new PaymentAuthWebViewActivityViewModel.Factory(application, this$0.getLogger(), args);
    }

    private static final Unit onCreate$lambda$4(PaymentAuthWebViewActivity this$0, OnBackPressedCallback $this$addCallback) {
        Intrinsics.checkNotNullParameter((Object)$this$addCallback, (String)"$this$addCallback");
        if (this$0.getViewBinding().webView.canGoBack()) {
            this$0.getViewBinding().webView.goBack();
        } else {
            this$0.cancelIntentSource();
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$5(PaymentAuthWebViewClient $webViewClient) {
        $webViewClient.setHasLoadedBlank$payments_core_release(true);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ StripePaymentAuthWebViewActivityBinding access$getViewBinding(PaymentAuthWebViewActivity $this) {
        return $this.getViewBinding();
    }
}

