/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.R;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.RepeatOnLifecycleKt;
import androidx.lifecycle.ViewModelStoreOwner;
import com.stripe.android.CardBrandFilter;
import com.stripe.android.DefaultCardBrandFilter;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.R;
import com.stripe.android.cards.CardAccountRangeRepository;
import com.stripe.android.cards.CardAccountRangeService;
import com.stripe.android.cards.CardNumber;
import com.stripe.android.cards.DefaultCardAccountRangeRepositoryFactory;
import com.stripe.android.cards.DefaultStaticCardAccountRanges;
import com.stripe.android.cards.StaticCardAccountRanges;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.model.AccountRange;
import com.stripe.android.model.CardBrand;
import com.stripe.android.networking.PaymentAnalyticsEvent;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.view.CardWidgetViewModel;
import com.stripe.android.view.CardWidgetViewModelKt;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.StripeTextWatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Provider;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0002z{Bo\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018B'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0019BI\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u001dJ\b\u0010g\u001a\u000201H\u0014J\b\u0010k\u001a\u000201H\u0014J\u0017\u0010l\u001a\u0002012\b\b\u0002\u0010m\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\bnJ/\u0010o\u001a\u00020\u00072\u0006\u0010p\u001a\u00020\u00072\u0006\u0010q\u001a\u00020\u00072\u0006\u0010r\u001a\u00020\u00072\b\b\u0002\u0010K\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\bsJ\r\u0010t\u001a\u000201H\u0000\u00a2\u0006\u0002\buJ\b\u0010v\u001a\u00020wH\u0016J\u0012\u0010x\u001a\u0002012\b\u0010y\u001a\u0004\u0018\u00010wH\u0016R\u001c\u0010\n\u001a\u00020\t8GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020'8\u0006@@X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R<\u00102\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u000201002\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020100@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R$\u00107\u001a\u00020'2\u0006\u0010&\u001a\u00020'@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010,\"\u0004\b9\u0010.R<\u0010:\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u000201002\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020100@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00104\"\u0004\b<\u00106R0\u0010>\u001a\b\u0012\u0004\u0012\u00020'0=2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0=@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BRH\u0010C\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0=\u0012\u0004\u0012\u000201002\u0018\u0010/\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0=\u0012\u0004\u0012\u00020100@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u00104\"\u0004\bE\u00106R \u0010F\u001a\b\u0012\u0004\u0012\u0002010\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u0014\u0010K\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010MR\u0014\u0010N\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010MR\u001e\u0010Q\u001a\u00020P2\u0006\u0010&\u001a\u00020P@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010RR\u0016\u0010S\u001a\u0004\u0018\u00010T8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010VR\u0014\u0010W\u001a\u00020X8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bY\u0010ZR\u0014\u0010[\u001a\u00020P8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b[\u0010RR\u000e\u0010\\\u001a\u00020PX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010]\u001a\u00020^8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b_\u0010*\u001a\u0004\b`\u0010aR&\u0010b\u001a\u000e\u0012\u0004\u0012\u00020P\u0012\u0004\u0012\u00020100X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u00104\"\u0004\bd\u00106R\u0010\u0010e\u001a\u0004\u0018\u00010fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010h\u001a\u00020\u001c8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bi\u0010j\u00a8\u0006|"}, d2={"Lcom/stripe/android/view/CardNumberEditText;", "Lcom/stripe/android/view/StripeEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "uiContext", "Lkotlin/coroutines/CoroutineContext;", "workContext", "cardAccountRangeRepository", "Lcom/stripe/android/cards/CardAccountRangeRepository;", "staticCardAccountRanges", "Lcom/stripe/android/cards/StaticCardAccountRanges;", "analyticsRequestExecutor", "Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;", "paymentAnalyticsRequestFactory", "Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;", "viewModelStoreOwner", "Landroidx/lifecycle/ViewModelStoreOwner;", "cardBrandFilter", "Lcom/stripe/android/CardBrandFilter;", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;ILkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Lcom/stripe/android/cards/CardAccountRangeRepository;Lcom/stripe/android/cards/StaticCardAccountRanges;Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;Landroidx/lifecycle/ViewModelStoreOwner;Lcom/stripe/android/CardBrandFilter;)V", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "publishableKeySupplier", "Lkotlin/Function0;", "", "(Landroid/content/Context;Landroid/util/AttributeSet;ILkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;Lkotlin/jvm/functions/Function0;Lcom/stripe/android/CardBrandFilter;)V", "getWorkContext", "()Lkotlin/coroutines/CoroutineContext;", "setWorkContext", "(Lkotlin/coroutines/CoroutineContext;)V", "getViewModelStoreOwner$payments_core_release", "()Landroidx/lifecycle/ViewModelStoreOwner;", "setViewModelStoreOwner$payments_core_release", "(Landroidx/lifecycle/ViewModelStoreOwner;)V", "value", "Lcom/stripe/android/model/CardBrand;", "cardBrand", "getCardBrand$annotations", "()V", "getCardBrand", "()Lcom/stripe/android/model/CardBrand;", "setCardBrand$payments_core_release", "(Lcom/stripe/android/model/CardBrand;)V", "callback", "Lkotlin/Function1;", "", "brandChangeCallback", "getBrandChangeCallback$payments_core_release", "()Lkotlin/jvm/functions/Function1;", "setBrandChangeCallback$payments_core_release", "(Lkotlin/jvm/functions/Function1;)V", "implicitCardBrandForCbc", "getImplicitCardBrandForCbc$payments_core_release", "setImplicitCardBrandForCbc$payments_core_release", "implicitCardBrandChangeCallback", "getImplicitCardBrandChangeCallback$payments_core_release", "setImplicitCardBrandChangeCallback$payments_core_release", "", "possibleCardBrands", "getPossibleCardBrands$payments_core_release", "()Ljava/util/List;", "setPossibleCardBrands$payments_core_release", "(Ljava/util/List;)V", "possibleCardBrandsCallback", "getPossibleCardBrandsCallback$payments_core_release", "setPossibleCardBrandsCallback$payments_core_release", "completionCallback", "getCompletionCallback$payments_core_release", "()Lkotlin/jvm/functions/Function0;", "setCompletionCallback$payments_core_release", "(Lkotlin/jvm/functions/Function0;)V", "panLength", "getPanLength$payments_core_release", "()I", "formattedPanLength", "getFormattedPanLength", "", "isCardNumberValid", "()Z", "validatedCardNumber", "Lcom/stripe/android/cards/CardNumber$Validated;", "getValidatedCardNumber$payments_core_release", "()Lcom/stripe/android/cards/CardNumber$Validated;", "unvalidatedCardNumber", "Lcom/stripe/android/cards/CardNumber$Unvalidated;", "getUnvalidatedCardNumber", "()Lcom/stripe/android/cards/CardNumber$Unvalidated;", "isValid", "isCbcEligible", "accountRangeService", "Lcom/stripe/android/cards/CardAccountRangeService;", "getAccountRangeService$annotations", "getAccountRangeService", "()Lcom/stripe/android/cards/CardAccountRangeService;", "isLoadingCallback", "isLoadingCallback$payments_core_release", "setLoadingCallback$payments_core_release", "loadingJob", "Lkotlinx/coroutines/Job;", "onAttachedToWindow", "accessibilityText", "getAccessibilityText", "()Ljava/lang/String;", "onDetachedFromWindow", "updateLengthFilter", "maxLength", "updateLengthFilter$payments_core_release", "calculateCursorPosition", "newFormattedLength", "start", "addedDigits", "calculateCursorPosition$payments_core_release", "onCardMetadataLoadedTooSlow", "onCardMetadataLoadedTooSlow$payments_core_release", "onSaveInstanceState", "Landroid/os/Parcelable;", "onRestoreInstanceState", "state", "SavedState", "CardNumberTextWatcher", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCardNumberEditText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardNumberEditText.kt\ncom/stripe/android/view/CardNumberEditText\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CardWidgetViewModel.kt\ncom/stripe/android/view/CardWidgetViewModelKt\n*L\n1#1,459:1\n1782#2,4:460\n1755#2,3:464\n118#3,13:467\n*S KotlinDebug\n*F\n+ 1 CardNumberEditText.kt\ncom/stripe/android/view/CardNumberEditText\n*L\n295#1:460,4\n299#1:464,3\n241#1:467,13\n*E\n"})
public final class CardNumberEditText
extends StripeEditText {
    @NotNull
    private CoroutineContext workContext;
    @NotNull
    private final CardAccountRangeRepository cardAccountRangeRepository;
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory;
    @Nullable
    private ViewModelStoreOwner viewModelStoreOwner;
    @NotNull
    private CardBrandFilter cardBrandFilter;
    @NotNull
    private CardBrand cardBrand;
    private /* synthetic */ Function1<? super CardBrand, Unit> brandChangeCallback;
    @NotNull
    private CardBrand implicitCardBrandForCbc;
    @NotNull
    private Function1<? super CardBrand, Unit> implicitCardBrandChangeCallback;
    @NotNull
    private List<? extends CardBrand> possibleCardBrands;
    private /* synthetic */ Function1<? super List<? extends CardBrand>, Unit> possibleCardBrandsCallback;
    private /* synthetic */ Function0<Unit> completionCallback;
    private boolean isCardNumberValid;
    private boolean isCbcEligible;
    @NotNull
    private final CardAccountRangeService accountRangeService;
    private /* synthetic */ Function1<? super Boolean, Unit> isLoadingCallback;
    @Nullable
    private Job loadingJob;
    public static final int $stable = 8;

    public CardNumberEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @NotNull CoroutineContext uiContext, @NotNull CoroutineContext workContext, @NotNull CardAccountRangeRepository cardAccountRangeRepository, @NotNull StaticCardAccountRanges staticCardAccountRanges, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory, @Nullable ViewModelStoreOwner viewModelStoreOwner, @NotNull CardBrandFilter cardBrandFilter) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uiContext, (String)"uiContext");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)cardAccountRangeRepository, (String)"cardAccountRangeRepository");
        Intrinsics.checkNotNullParameter((Object)staticCardAccountRanges, (String)"staticCardAccountRanges");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)((Object)paymentAnalyticsRequestFactory), (String)"paymentAnalyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)cardBrandFilter, (String)"cardBrandFilter");
        super(context, attrs, defStyleAttr);
        this.workContext = workContext;
        this.cardAccountRangeRepository = cardAccountRangeRepository;
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.paymentAnalyticsRequestFactory = paymentAnalyticsRequestFactory;
        this.viewModelStoreOwner = viewModelStoreOwner;
        this.cardBrandFilter = cardBrandFilter;
        this.cardBrand = CardBrand.Unknown;
        this.brandChangeCallback = CardNumberEditText::brandChangeCallback$lambda$2;
        this.implicitCardBrandForCbc = CardBrand.Unknown;
        this.implicitCardBrandChangeCallback = CardNumberEditText::implicitCardBrandChangeCallback$lambda$3;
        this.possibleCardBrands = CollectionsKt.emptyList();
        this.possibleCardBrandsCallback = CardNumberEditText::possibleCardBrandsCallback$lambda$4;
        this.completionCallback = CardNumberEditText::completionCallback$lambda$5;
        String[] stringArray = this.cardAccountRangeRepository;
        CoroutineContext coroutineContext = this.workContext;
        CardAccountRangeService.AccountRangeResultListener accountRangeResultListener = new CardAccountRangeService.AccountRangeResultListener(this){
            final /* synthetic */ CardNumberEditText this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAccountRangesResult(List<AccountRange> accountRanges, List<AccountRange> unfilteredAccountRanges) {
                AccountRange it;
                Object object;
                Iterable $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(accountRanges, (String)"accountRanges");
                Intrinsics.checkNotNullParameter(unfilteredAccountRanges, (String)"unfilteredAccountRanges");
                CardNumberEditText.updateLengthFilter$payments_core_release$default(this.this$0, 0, 1, null);
                Iterable $this$map$iv = accountRanges;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    AccountRange accountRange = (AccountRange)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.add(it.getBrand());
                }
                List brands = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                CardBrand cardBrand = (CardBrand)CollectionsKt.singleOrNull((List)brands);
                if (cardBrand == null) {
                    cardBrand = CardBrand.Unknown;
                }
                this.this$0.setCardBrand$payments_core_release(cardBrand);
                if (CardNumberEditText.access$isCbcEligible$p(this.this$0)) {
                    CardBrand cardBrand2 = (CardBrand)CollectionsKt.firstOrNull((List)brands);
                    if (cardBrand2 == null) {
                        cardBrand2 = CardBrand.Unknown;
                    }
                    this.this$0.setImplicitCardBrandForCbc$payments_core_release(cardBrand2);
                    $this$map$iv = unfilteredAccountRanges;
                    object = this.this$0;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = (AccountRange)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getBrand());
                    }
                    ((CardNumberEditText)((Object)object)).setPossibleCardBrands$payments_core_release(CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
                }
            }
        };
        this.accountRangeService = new CardAccountRangeService((CardAccountRangeRepository)stringArray, uiContext, coroutineContext, staticCardAccountRanges, accountRangeResultListener, () -> CardNumberEditText.accountRangeService$lambda$6(this), null, 64, null);
        this.isLoadingCallback = CardNumberEditText::isLoadingCallback$lambda$7;
        this.setNumberOnlyInputType();
        this.setErrorMessage(this.getResources().getString(R.string.stripe_invalid_card_number));
        this.addTextChangedListener(new CardNumberTextWatcher());
        this.getInternalFocusChangeListeners().add((arg_0, arg_1) -> CardNumberEditText._init_$lambda$8(this, arg_0, arg_1));
        if (Build.VERSION.SDK_INT >= 26) {
            stringArray = new String[]{"creditCardNumber"};
            this.setAutofillHints(stringArray);
        }
        CardNumberEditText.updateLengthFilter$payments_core_release$default(this, 0, 1, null);
        this.setLayoutDirection(0);
    }

    public /* synthetic */ CardNumberEditText(Context context, AttributeSet attributeSet, int n, CoroutineContext coroutineContext, CoroutineContext coroutineContext2, CardAccountRangeRepository cardAccountRangeRepository, StaticCardAccountRanges staticCardAccountRanges, AnalyticsRequestExecutor analyticsRequestExecutor, PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory, ViewModelStoreOwner viewModelStoreOwner, CardBrandFilter cardBrandFilter, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        if ((n2 & 0x40) != 0) {
            staticCardAccountRanges = new DefaultStaticCardAccountRanges();
        }
        if ((n2 & 0x200) != 0) {
            viewModelStoreOwner = null;
        }
        if ((n2 & 0x400) != 0) {
            cardBrandFilter = DefaultCardBrandFilter.INSTANCE;
        }
        this(context, attributeSet, n, coroutineContext, coroutineContext2, cardAccountRangeRepository, staticCardAccountRanges, analyticsRequestExecutor, paymentAnalyticsRequestFactory, viewModelStoreOwner, cardBrandFilter);
    }

    @VisibleForTesting
    @NotNull
    public final CoroutineContext getWorkContext() {
        return this.workContext;
    }

    public final void setWorkContext(@NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"<set-?>");
        this.workContext = coroutineContext;
    }

    @Nullable
    public final ViewModelStoreOwner getViewModelStoreOwner$payments_core_release() {
        return this.viewModelStoreOwner;
    }

    public final void setViewModelStoreOwner$payments_core_release(@Nullable ViewModelStoreOwner viewModelStoreOwner) {
        this.viewModelStoreOwner = viewModelStoreOwner;
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, (CoroutineContext)Dispatchers.getMain(), (CoroutineContext)Dispatchers.getIO(), (Function0<String>)((Function0)() -> CardNumberEditText._init_$lambda$0(context)), DefaultCardBrandFilter.INSTANCE);
    }

    public /* synthetic */ CardNumberEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        this(context, attributeSet, n);
    }

    private CardNumberEditText(Context context, AttributeSet attrs, int defStyleAttr, CoroutineContext uiContext, CoroutineContext workContext, Function0<String> publishableKeySupplier, CardBrandFilter cardBrandFilter) {
        this(context, attrs, defStyleAttr, uiContext, workContext, new DefaultCardAccountRangeRepositoryFactory(context).create(), new DefaultStaticCardAccountRanges(), (AnalyticsRequestExecutor)new DefaultAnalyticsRequestExecutor(), new PaymentAnalyticsRequestFactory(context, (Provider<String>)((Provider)() -> CardNumberEditText._init_$lambda$1(publishableKeySupplier))), null, cardBrandFilter, 512, null);
    }

    @NotNull
    public final CardBrand getCardBrand() {
        return this.cardBrand;
    }

    public final void setCardBrand$payments_core_release(@NotNull CardBrand value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CardBrand prevBrand = this.cardBrand;
        this.cardBrand = value;
        if (value != prevBrand) {
            this.brandChangeCallback.invoke((Object)this.cardBrand);
            CardNumberEditText.updateLengthFilter$payments_core_release$default(this, 0, 1, null);
        }
    }

    @VisibleForTesting
    public static /* synthetic */ void getCardBrand$annotations() {
    }

    @NotNull
    public final Function1<CardBrand, Unit> getBrandChangeCallback$payments_core_release() {
        return this.brandChangeCallback;
    }

    public final void setBrandChangeCallback$payments_core_release(@NotNull Function1<? super CardBrand, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.brandChangeCallback = callback;
        callback.invoke((Object)this.cardBrand);
    }

    @NotNull
    public final CardBrand getImplicitCardBrandForCbc$payments_core_release() {
        return this.implicitCardBrandForCbc;
    }

    public final void setImplicitCardBrandForCbc$payments_core_release(@NotNull CardBrand value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CardBrand prevBrands = this.implicitCardBrandForCbc;
        this.implicitCardBrandForCbc = value;
        if (value != prevBrands) {
            this.implicitCardBrandChangeCallback.invoke((Object)value);
            CardNumberEditText.updateLengthFilter$payments_core_release$default(this, 0, 1, null);
        }
    }

    @NotNull
    public final Function1<CardBrand, Unit> getImplicitCardBrandChangeCallback$payments_core_release() {
        return this.implicitCardBrandChangeCallback;
    }

    public final void setImplicitCardBrandChangeCallback$payments_core_release(@NotNull Function1<? super CardBrand, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.implicitCardBrandChangeCallback = callback;
        callback.invoke((Object)this.implicitCardBrandForCbc);
    }

    @NotNull
    public final List<CardBrand> getPossibleCardBrands$payments_core_release() {
        return this.possibleCardBrands;
    }

    public final void setPossibleCardBrands$payments_core_release(@NotNull List<? extends CardBrand> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        List<? extends CardBrand> prevBrands = this.possibleCardBrands;
        this.possibleCardBrands = value;
        if (!Intrinsics.areEqual(value, prevBrands)) {
            this.possibleCardBrandsCallback.invoke(value);
            CardNumberEditText.updateLengthFilter$payments_core_release$default(this, 0, 1, null);
        }
    }

    @NotNull
    public final Function1<List<? extends CardBrand>, Unit> getPossibleCardBrandsCallback$payments_core_release() {
        return this.possibleCardBrandsCallback;
    }

    public final void setPossibleCardBrandsCallback$payments_core_release(@NotNull Function1<? super List<? extends CardBrand>, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.possibleCardBrandsCallback = callback;
        callback.invoke(this.possibleCardBrands);
    }

    @NotNull
    public final Function0<Unit> getCompletionCallback$payments_core_release() {
        return this.completionCallback;
    }

    public final void setCompletionCallback$payments_core_release(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.completionCallback = function0;
    }

    public final int getPanLength$payments_core_release() {
        int n;
        AccountRange accountRange = this.accountRangeService.getAccountRange();
        if (accountRange != null) {
            n = accountRange.getPanLength();
        } else {
            AccountRange accountRange2 = this.accountRangeService.getStaticCardAccountRanges().first(this.getUnvalidatedCardNumber());
            n = accountRange2 != null ? accountRange2.getPanLength() : 16;
        }
        return n;
    }

    private final int getFormattedPanLength() {
        return this.getPanLength$payments_core_release() + CardNumber.Companion.getSpacePositions(this.getPanLength$payments_core_release()).size();
    }

    public final boolean isCardNumberValid() {
        return this.isCardNumberValid;
    }

    @Nullable
    public final CardNumber.Validated getValidatedCardNumber$payments_core_release() {
        return this.getUnvalidatedCardNumber().validate(this.getPanLength$payments_core_release());
    }

    private final CardNumber.Unvalidated getUnvalidatedCardNumber() {
        return new CardNumber.Unvalidated(this.getFieldText$payments_core_release());
    }

    private final boolean isValid() {
        return this.getValidatedCardNumber$payments_core_release() != null;
    }

    @NotNull
    public final CardAccountRangeService getAccountRangeService() {
        return this.accountRangeService;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAccountRangeService$annotations() {
    }

    @NotNull
    public final Function1<Boolean, Unit> isLoadingCallback$payments_core_release() {
        return this.isLoadingCallback;
    }

    public final void setLoadingCallback$payments_core_release(@NotNull Function1<? super Boolean, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.isLoadingCallback = function1;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.loadingJob = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CardNumberEditText this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = CardNumberEditText.access$getCardAccountRangeRepository$p(this.this$0).getLoading().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ CardNumberEditText this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(boolean it, Continuation<? super Unit> $completion) {
                                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, it, null){
                                    int label;
                                    final /* synthetic */ CardNumberEditText this$0;
                                    final /* synthetic */ boolean $it;
                                    {
                                        this.this$0 = $receiver;
                                        this.$it = $it;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.this$0.isLoadingCallback$payments_core_release().invoke((Object)Boxing.boxBoolean((boolean)this.$it));
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        CardWidgetViewModelKt.doWithCardWidgetViewModel((View)this, this.viewModelStoreOwner, (Function2<? super LifecycleOwner, ? super CardWidgetViewModel, Unit>)((Function2)(arg_0, arg_1) -> CardNumberEditText.onAttachedToWindow$lambda$11(this, arg_0, arg_1)));
    }

    @Override
    @NotNull
    protected String getAccessibilityText() {
        Object[] objectArray = new Object[]{this.getText()};
        String string2 = this.getResources().getString(R.string.stripe_acc_label_card_number_node, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return string2;
    }

    protected void onDetachedFromWindow() {
        Job job = this.loadingJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.loadingJob = null;
        this.accountRangeService.cancelAccountRangeRepositoryJob();
        super.onDetachedFromWindow();
    }

    public final /* synthetic */ void updateLengthFilter$payments_core_release(int maxLength) {
        InputFilter[] inputFilterArray = new InputFilter[]{new InputFilter.LengthFilter(maxLength)};
        this.setFilters(inputFilterArray);
    }

    public static /* synthetic */ void updateLengthFilter$payments_core_release$default(CardNumberEditText cardNumberEditText, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = cardNumberEditText.getFormattedPanLength();
        }
        cardNumberEditText.updateLengthFilter$payments_core_release(n);
    }

    public final /* synthetic */ int calculateCursorPosition$payments_core_release(int newFormattedLength, int start, int addedDigits, int panLength) {
        boolean bl;
        int gapsJumped;
        block7: {
            int gap;
            int n;
            Set gapSet = CardNumber.Companion.getSpacePositions(panLength);
            Iterable $this$count$iv = gapSet;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    gap = ((Number)element$iv).intValue();
                    boolean bl2 = false;
                    if (!(start <= gap && start + addedDigits >= gap) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            gapsJumped = n;
            Iterable $this$any$iv = gapSet;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    gap = ((Number)element$iv).intValue();
                    boolean bl3 = false;
                    if (!(addedDigits == 0 && start == gap + 1)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean skipBack = bl;
        int newPosition = start + addedDigits + gapsJumped;
        if (skipBack && newPosition > 0) {
            --newPosition;
        }
        return newPosition <= newFormattedLength ? newPosition : newFormattedLength;
    }

    public static /* synthetic */ int calculateCursorPosition$payments_core_release$default(CardNumberEditText cardNumberEditText, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n4 = cardNumberEditText.getPanLength$payments_core_release();
        }
        return cardNumberEditText.calculateCursorPosition$payments_core_release(n, n2, n3, n4);
    }

    public final /* synthetic */ void onCardMetadataLoadedTooSlow$payments_core_release() {
        this.analyticsRequestExecutor.executeAsync(PaymentAnalyticsRequestFactory.createRequest$payments_core_release$default(this.paymentAnalyticsRequestFactory, PaymentAnalyticsEvent.CardMetadataLoadedTooSlow, null, null, null, null, null, 62, null));
    }

    @Override
    @NotNull
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.isCbcEligible);
    }

    @Override
    public void onRestoreInstanceState(@Nullable Parcelable state) {
        SavedState savedState;
        SavedState savedState2 = savedState = state instanceof SavedState ? (SavedState)state : null;
        this.isCbcEligible = savedState2 != null ? savedState2.isCbcEligible() : false;
        SavedState savedState3 = savedState;
        if (savedState3 == null || (savedState3 = savedState3.getSuperState()) == null) {
            savedState3 = state;
        }
        super.onRestoreInstanceState(savedState3);
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final String _init_$lambda$0(Context $context) {
        return PaymentConfiguration.Companion.getInstance($context).getPublishableKey();
    }

    private static final String _init_$lambda$1(Function0 $tmp0) {
        return (String)$tmp0.invoke();
    }

    private static final Unit brandChangeCallback$lambda$2(CardBrand it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit implicitCardBrandChangeCallback$lambda$3(CardBrand it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit possibleCardBrandsCallback$lambda$4(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit completionCallback$lambda$5() {
        return Unit.INSTANCE;
    }

    private static final boolean accountRangeService$lambda$6(CardNumberEditText this$0) {
        return this$0.isCbcEligible;
    }

    private static final Unit isLoadingCallback$lambda$7(boolean it) {
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$8(CardNumberEditText this$0, View view, boolean hasFocus) {
        if (!hasFocus && this$0.getUnvalidatedCardNumber().isPartialEntry(this$0.getPanLength$payments_core_release())) {
            this$0.setShouldShowError(true);
        }
    }

    private static final Unit onAttachedToWindow$lambda$11(CardNumberEditText this$0, LifecycleOwner $this$doWithCardWidgetViewModel, CardWidgetViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)$this$doWithCardWidgetViewModel, (String)"$this$doWithCardWidgetViewModel");
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Flow $this$launchAndCollect_u24default$iv = (Flow)viewModel.isCbcEligible();
        Lifecycle.State minActiveState$iv = Lifecycle.State.STARTED;
        boolean $i$f$launchAndCollect = false;
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)$this$doWithCardWidgetViewModel)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$doWithCardWidgetViewModel, minActiveState$iv, $this$launchAndCollect_u24default$iv, null, this$0){
            int label;
            final /* synthetic */ LifecycleOwner $$context_receiver_0;
            final /* synthetic */ Lifecycle.State $minActiveState;
            final /* synthetic */ Flow $this_launchAndCollect;
            final /* synthetic */ CardNumberEditText this$0;
            {
                this.$minActiveState = $minActiveState;
                this.$this_launchAndCollect = $receiver;
                this.this$0 = cardNumberEditText;
                this.$$context_receiver_0 = $$context_receiver_0;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = RepeatOnLifecycleKt.repeatOnLifecycle((LifecycleOwner)this.$$context_receiver_0, (Lifecycle.State)this.$minActiveState, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$this_launchAndCollect, null, this.this$0){
                            int label;
                            final /* synthetic */ Flow $this_launchAndCollect;
                            final /* synthetic */ CardNumberEditText this$0;
                            {
                                this.$this_launchAndCollect = $receiver;
                                this.this$0 = cardNumberEditText;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.$this_launchAndCollect.collect(new FlowCollector(this.this$0){
                                            final /* synthetic */ CardNumberEditText this$0;
                                            {
                                                this.this$0 = cardNumberEditText;
                                            }

                                            /*
                                             * WARNING - void declaration
                                             */
                                            public final Object emit(T it, Continuation<? super Unit> $completion) {
                                                void $this$mapTo$iv$iv;
                                                boolean isCbcEligible = (Boolean)it;
                                                boolean bl = false;
                                                CardNumberEditText.access$setCbcEligible$p(this.this$0, isCbcEligible);
                                                Iterable $this$map$iv = this.this$0.getAccountRangeService().getAccountRanges();
                                                boolean $i$f$map = false;
                                                Iterable iterable = $this$map$iv;
                                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                                boolean $i$f$mapTo = false;
                                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                                    void it2;
                                                    AccountRange accountRange = (AccountRange)item$iv$iv;
                                                    Collection collection = destination$iv$iv;
                                                    boolean bl2 = false;
                                                    collection.add(it2.getBrand());
                                                }
                                                List brands = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
                                                if (isCbcEligible) {
                                                    CardBrand cardBrand = (CardBrand)CollectionsKt.firstOrNull((List)brands);
                                                    if (cardBrand == null) {
                                                        cardBrand = CardBrand.Unknown;
                                                    }
                                                    this.this$0.setImplicitCardBrandForCbc$payments_core_release(cardBrand);
                                                    this.this$0.setPossibleCardBrands$payments_core_release(brands);
                                                } else {
                                                    CardBrand cardBrand = (CardBrand)CollectionsKt.singleOrNull((List)brands);
                                                    if (cardBrand == null) {
                                                        cardBrand = CardBrand.Unknown;
                                                    }
                                                    this.this$0.setCardBrand$payments_core_release(cardBrand);
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }, (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ CardAccountRangeRepository access$getCardAccountRangeRepository$p(CardNumberEditText $this) {
        return $this.cardAccountRangeRepository;
    }

    public static final /* synthetic */ void access$setCbcEligible$p(CardNumberEditText $this, boolean bl) {
        $this.isCbcEligible = bl;
    }

    public static final /* synthetic */ boolean access$isCbcEligible$p(CardNumberEditText $this) {
        return $this.isCbcEligible;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J*\u0010\u0016\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0012\u0010\u0018\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000eH\u0002J(\u0010\r\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006%"}, d2={"Lcom/stripe/android/view/CardNumberEditText$CardNumberTextWatcher;", "Lcom/stripe/android/view/StripeTextWatcher;", "<init>", "(Lcom/stripe/android/view/CardNumberEditText;)V", "latestChangeStart", "", "latestInsertionSize", "newCursorPosition", "Ljava/lang/Integer;", "formattedNumber", "", "beforeCardNumber", "Lcom/stripe/android/cards/CardNumber$Unvalidated;", "isPastedPan", "", "beforeTextChanged", "", "s", "", "start", "count", "after", "onTextChanged", "before", "afterTextChanged", "Landroid/text/Editable;", "shouldUpdateAfterChange", "getShouldUpdateAfterChange", "()Z", "digitsAdded", "getDigitsAdded", "isComplete", "wasCardNumberValid", "startPosition", "previousCount", "currentCount", "cardNumber", "payments-core_release"})
    private final class CardNumberTextWatcher
    extends StripeTextWatcher {
        private int latestChangeStart;
        private int latestInsertionSize;
        @Nullable
        private Integer newCursorPosition;
        @Nullable
        private String formattedNumber;
        @NotNull
        private CardNumber.Unvalidated beforeCardNumber;
        private boolean isPastedPan;

        public CardNumberTextWatcher() {
            this.beforeCardNumber = CardNumberEditText.this.getUnvalidatedCardNumber();
        }

        @Override
        public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
            this.isPastedPan = false;
            this.beforeCardNumber = CardNumberEditText.this.getUnvalidatedCardNumber();
            this.latestChangeStart = start;
            this.latestInsertionSize = after;
        }

        @Override
        public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
            CharSequence charSequence = s;
            String string2 = charSequence != null ? ((Object)charSequence).toString() : null;
            if (string2 == null) {
                string2 = "";
            }
            CardNumber.Unvalidated cardNumber = new CardNumber.Unvalidated(string2);
            CardNumberEditText.this.getAccountRangeService().onCardNumberChanged(cardNumber);
            this.isPastedPan = this.isPastedPan(start, before, count, cardNumber);
            if (this.isPastedPan) {
                CardNumberEditText.this.updateLengthFilter$payments_core_release(cardNumber.getFormatted(cardNumber.getLength()).length());
            }
            int n = this.isPastedPan ? cardNumber.getLength() : CardNumberEditText.this.getPanLength$payments_core_release();
            CardNumberEditText cardNumberEditText = CardNumberEditText.this;
            int maxPanLength = n;
            boolean bl = false;
            String formattedNumber = cardNumber.getFormatted(maxPanLength);
            this.newCursorPosition = cardNumberEditText.calculateCursorPosition$payments_core_release(formattedNumber.length(), this.latestChangeStart, this.latestInsertionSize, maxPanLength);
            this.formattedNumber = formattedNumber;
        }

        @Override
        public void afterTextChanged(@Nullable Editable s) {
            if (this.getShouldUpdateAfterChange()) {
                CardNumberEditText.this.setTextSilent$payments_core_release(this.formattedNumber);
                Integer n = this.newCursorPosition;
                if (n != null) {
                    Integer n2 = n;
                    CardNumberEditText cardNumberEditText = CardNumberEditText.this;
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    cardNumberEditText.setSelection(RangesKt.coerceIn((int)it, (int)0, (int)cardNumberEditText.getFieldText$payments_core_release().length()));
                }
            }
            this.formattedNumber = null;
            this.newCursorPosition = null;
            if (CardNumberEditText.this.getUnvalidatedCardNumber().getLength() == CardNumberEditText.this.getPanLength$payments_core_release()) {
                boolean wasCardNumberValid = CardNumberEditText.this.isCardNumberValid();
                CardNumberEditText.this.isCardNumberValid = CardNumberEditText.this.isValid();
                CardNumberEditText.this.setShouldShowError(!CardNumberEditText.this.isValid());
                if (CardNumberEditText.this.getAccountRangeService().getAccountRange() == null && CardNumberEditText.this.getUnvalidatedCardNumber().isValidLuhn()) {
                    CardNumberEditText.this.onCardMetadataLoadedTooSlow$payments_core_release();
                }
                if (this.isComplete(wasCardNumberValid)) {
                    CardNumberEditText.this.getCompletionCallback$payments_core_release().invoke();
                }
            } else if (CardNumberEditText.this.getUnvalidatedCardNumber().isPartialEntry(CardNumberEditText.this.getPanLength$payments_core_release()) && !CardNumberEditText.this.getUnvalidatedCardNumber().isPossibleCardBrand()) {
                CardNumberEditText.this.isCardNumberValid = CardNumberEditText.this.isValid();
                CardNumberEditText.this.setShouldShowError(true);
            } else {
                CardNumberEditText.this.isCardNumberValid = CardNumberEditText.this.isValid();
                CardNumberEditText.this.setShouldShowError(false);
            }
        }

        private final boolean getShouldUpdateAfterChange() {
            return (this.getDigitsAdded() || !CardNumberEditText.this.isLastKeyDelete$payments_core_release()) && this.formattedNumber != null;
        }

        private final boolean getDigitsAdded() {
            return CardNumberEditText.this.getUnvalidatedCardNumber().getLength() > this.beforeCardNumber.getLength();
        }

        private final boolean isComplete(boolean wasCardNumberValid) {
            return !wasCardNumberValid && (CardNumberEditText.this.getUnvalidatedCardNumber().isMaxLength() || CardNumberEditText.this.isValid() && CardNumberEditText.this.getAccountRangeService().getAccountRange() != null);
        }

        private final boolean isPastedPan(int startPosition, int previousCount, int currentCount, CardNumber.Unvalidated cardNumber) {
            return currentCount > previousCount && startPosition == 0 && cardNumber.getNormalized().length() >= 14;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/view/CardNumberEditText$SavedState;", "Landroid/view/View$BaseSavedState;", "Landroid/os/Parcelable;", "superSavedState", "isCbcEligible", "", "<init>", "(Landroid/os/Parcelable;Z)V", "getSuperSavedState", "()Landroid/os/Parcelable;", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class SavedState
    extends View.BaseSavedState
    implements Parcelable {
        @Nullable
        private final Parcelable superSavedState;
        private final boolean isCbcEligible;
        @NotNull
        public static final Parcelable.Creator<SavedState> CREATOR;
        public static final int $stable;

        public SavedState(@Nullable Parcelable superSavedState, boolean isCbcEligible) {
            super(superSavedState);
            this.superSavedState = superSavedState;
            this.isCbcEligible = isCbcEligible;
        }

        @Nullable
        public final Parcelable getSuperSavedState() {
            return this.superSavedState;
        }

        public final boolean isCbcEligible() {
            return this.isCbcEligible;
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeParcelable(this.superSavedState, flags);
            dest.writeInt(this.isCbcEligible ? 1 : 0);
        }

        @Nullable
        public final Parcelable component1() {
            return this.superSavedState;
        }

        public final boolean component2() {
            return this.isCbcEligible;
        }

        @NotNull
        public final SavedState copy(@Nullable Parcelable superSavedState, boolean isCbcEligible) {
            return new SavedState(superSavedState, isCbcEligible);
        }

        public static /* synthetic */ SavedState copy$default(SavedState savedState, Parcelable parcelable, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                parcelable = savedState.superSavedState;
            }
            if ((n & 2) != 0) {
                bl = savedState.isCbcEligible;
            }
            return savedState.copy(parcelable, bl);
        }

        @NotNull
        public String toString() {
            return "SavedState(superSavedState=" + this.superSavedState + ", isCbcEligible=" + this.isCbcEligible + ")";
        }

        public int hashCode() {
            int result = this.superSavedState == null ? 0 : this.superSavedState.hashCode();
            result = result * 31 + Boolean.hashCode(this.isCbcEligible);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SavedState)) {
                return false;
            }
            SavedState savedState = (SavedState)((Object)other);
            if (!Intrinsics.areEqual((Object)this.superSavedState, (Object)savedState.superSavedState)) {
                return false;
            }
            return this.isCbcEligible == savedState.isCbcEligible;
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<SavedState> {
                public final SavedState[] newArray(int size) {
                    return new SavedState[size];
                }

                public final SavedState createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new SavedState(parcel.readParcelable(SavedState.class.getClassLoader()), parcel.readInt() != 0);
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }
}

