/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.transition.TransitionManager;
import com.stripe.android.databinding.StripeCardBrandViewBinding;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.Networks;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.view.BrandAdapter;
import com.stripe.android.view.CardBrandSelectorKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001:\u0002JKB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u00104\u001a\u0004\u0018\u000105J\n\u00106\u001a\u0004\u0018\u000105H\u0002J\b\u00107\u001a\u0004\u0018\u000108J\n\u00109\u001a\u0004\u0018\u000108H\u0002J\u0017\u0010:\u001a\u00020;2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0001\u00a2\u0006\u0002\b<J\b\u0010=\u001a\u00020;H\u0002J\b\u0010>\u001a\u00020;H\u0002J\u0010\u0010?\u001a\u00020;2\u0006\u0010@\u001a\u00020\u001aH\u0002J\b\u0010A\u001a\u00020;H\u0002J\u0010\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020DH\u0002J\b\u0010E\u001a\u00020FH\u0014J\u0012\u0010G\u001a\u00020;2\b\u0010\u0015\u001a\u0004\u0018\u00010FH\u0014J\u000e\u0010H\u001a\u00020;*\u0004\u0018\u00010IH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00138B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010 \u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R0\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0%2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001f0%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R0\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001f0%2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001f0%8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*R$\u0010.\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010\u001c\"\u0004\b0\u0010\u001eR$\u00101\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010\u001c\"\u0004\b3\u0010\u001e\u00a8\u0006L"}, d2={"Lcom/stripe/android/view/CardBrandView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "viewBinding", "Lcom/stripe/android/databinding/StripeCardBrandViewBinding;", "iconView", "Landroid/widget/ImageView;", "chevron", "listPopup", "Landroid/widget/ListPopupWindow;", "stateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/android/view/CardBrandView$State;", "value", "state", "getState", "()Lcom/stripe/android/view/CardBrandView$State;", "setState", "(Lcom/stripe/android/view/CardBrandView$State;)V", "", "isCbcEligible", "()Z", "setCbcEligible", "(Z)V", "Lcom/stripe/android/model/CardBrand;", "brand", "getBrand", "()Lcom/stripe/android/model/CardBrand;", "setBrand", "(Lcom/stripe/android/model/CardBrand;)V", "", "possibleBrands", "getPossibleBrands", "()Ljava/util/List;", "setPossibleBrands", "(Ljava/util/List;)V", "merchantPreferredNetworks", "getMerchantPreferredNetworks", "setMerchantPreferredNetworks", "shouldShowCvc", "getShouldShowCvc", "setShouldShowCvc", "shouldShowErrorIcon", "getShouldShowErrorIcon", "setShouldShowErrorIcon", "paymentMethodCreateParamsNetworks", "Lcom/stripe/android/model/PaymentMethodCreateParams$Card$Networks;", "brandPaymentMethodCreateParamsNetworks", "cardParamsNetworks", "Lcom/stripe/android/model/Networks;", "brandCardParamsNetworks", "handleBrandSelected", "", "handleBrandSelected$payments_core_release", "setCardBrandIconAndTint", "determineCardBrandToDisplay", "updateBrandSpinner", "animate", "initListPopup", "measureContentWidth", "adapter", "Lcom/stripe/android/view/BrandAdapter;", "onSaveInstanceState", "Landroid/os/Parcelable;", "onRestoreInstanceState", "animateNextChanges", "Landroid/view/ViewGroup;", "State", "SavedState", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCardBrandView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CardBrandView.kt\ncom/stripe/android/view/CardBrandView\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,328:1\n230#2,5:329\n230#2,5:334\n230#2,5:339\n230#2,5:344\n230#2,5:349\n230#2,5:354\n230#2,5:360\n1#3:359\n*S KotlinDebug\n*F\n+ 1 CardBrandView.kt\ncom/stripe/android/view/CardBrandView\n*L\n61#1:329,5\n68#1:334,5\n76#1:339,5\n84#1:344,5\n91#1:349,5\n99#1:354,5\n157#1:360,5\n*E\n"})
public final class CardBrandView
extends FrameLayout {
    @NotNull
    private final StripeCardBrandViewBinding viewBinding;
    @NotNull
    private final ImageView iconView;
    @NotNull
    private final ImageView chevron;
    @NotNull
    private final ListPopupWindow listPopup;
    @NotNull
    private MutableStateFlow<State> stateFlow;
    public static final int $stable = 8;

    @JvmOverloads
    public CardBrandView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        StripeCardBrandViewBinding stripeCardBrandViewBinding = StripeCardBrandViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)stripeCardBrandViewBinding, (String)"inflate(...)");
        this.viewBinding = stripeCardBrandViewBinding;
        ImageView imageView = this.viewBinding.icon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"icon");
        this.iconView = imageView;
        ImageView imageView2 = this.viewBinding.chevron;
        Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"chevron");
        this.chevron = imageView2;
        this.listPopup = new ListPopupWindow(context);
        this.stateFlow = StateFlowKt.MutableStateFlow((Object)new State(false, false, null, null, null, null, false, false, 255, null));
        this.setClickable(false);
        this.setFocusable(false);
        this.determineCardBrandToDisplay();
        this.updateBrandSpinner(false);
    }

    public /* synthetic */ CardBrandView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final State getState() {
        return (State)this.stateFlow.getValue();
    }

    private final void setState(State value) {
        this.stateFlow.setValue((Object)value);
    }

    public final boolean isCbcEligible() {
        return this.getState().isCbcEligible();
    }

    public final void setCbcEligible(boolean value) {
        State it;
        State nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<State> $this$update$iv = this.stateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (State)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = State.copy$default(it, value, false, null, null, null, null, false, false, 254, null))));
        this.updateBrandSpinner(true);
    }

    @NotNull
    public final CardBrand getBrand() {
        return this.getState().getBrand();
    }

    public final void setBrand(@NotNull CardBrand value) {
        State it;
        State nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MutableStateFlow<State> $this$update$iv = this.stateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (State)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = State.copy$default(it, false, false, value, null, null, null, false, false, 251, null))));
        this.determineCardBrandToDisplay();
        this.updateBrandSpinner(true);
    }

    @NotNull
    public final List<CardBrand> getPossibleBrands() {
        return this.getState().getPossibleBrands();
    }

    public final void setPossibleBrands(@NotNull List<? extends CardBrand> value) {
        State it;
        State nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        MutableStateFlow<State> $this$update$iv = this.stateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (State)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = State.copy$default(it, false, false, null, null, value, null, false, false, 239, null))));
        this.determineCardBrandToDisplay();
        this.updateBrandSpinner(true);
    }

    @NotNull
    public final List<CardBrand> getMerchantPreferredNetworks() {
        return this.getState().getMerchantPreferredNetworks();
    }

    public final void setMerchantPreferredNetworks(@NotNull List<? extends CardBrand> value) {
        State it;
        State nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        MutableStateFlow<State> $this$update$iv = this.stateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (State)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = State.copy$default(it, false, false, null, null, null, value, false, false, 223, null))));
        this.determineCardBrandToDisplay();
    }

    public final boolean getShouldShowCvc() {
        return this.getState().getShouldShowCvc();
    }

    public final void setShouldShowCvc(boolean value) {
        State it;
        State nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<State> $this$update$iv = this.stateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (State)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = State.copy$default(it, false, false, null, null, null, null, value, false, 191, null))));
        this.setCardBrandIconAndTint();
        this.updateBrandSpinner(false);
    }

    public final boolean getShouldShowErrorIcon() {
        return this.getState().getShouldShowErrorIcon();
    }

    public final void setShouldShowErrorIcon(boolean value) {
        State it;
        State nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<State> $this$update$iv = this.stateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (State)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = State.copy$default(it, false, false, null, null, null, null, false, value, 127, null))));
        this.setCardBrandIconAndTint();
    }

    @Nullable
    public final PaymentMethodCreateParams.Card.Networks paymentMethodCreateParamsNetworks() {
        PaymentMethodCreateParams.Card.Networks networks;
        PaymentMethodCreateParams.Card.Networks defaultNetworkParam = this.brandPaymentMethodCreateParamsNetworks();
        if (defaultNetworkParam != null) {
            return defaultNetworkParam;
        }
        Object object = (CardBrand)CollectionsKt.firstOrNull(this.getMerchantPreferredNetworks());
        if (object != null && (object = object.getCode()) != null) {
            Object it = object;
            boolean bl = false;
            networks = new PaymentMethodCreateParams.Card.Networks((String)it);
        } else {
            networks = null;
        }
        return networks;
    }

    private final PaymentMethodCreateParams.Card.Networks brandPaymentMethodCreateParamsNetworks() {
        PaymentMethodCreateParams.Card.Networks networks;
        if (this.getBrand() == CardBrand.Unknown) {
            return null;
        }
        PaymentMethodCreateParams.Card.Networks it = networks = new PaymentMethodCreateParams.Card.Networks(this.getBrand().getCode());
        boolean bl = false;
        return this.isCbcEligible() && this.getPossibleBrands().size() > 1 ? networks : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Networks cardParamsNetworks() {
        CardBrand cardBrand;
        Networks brandPreferredNetwork;
        Networks networks = brandPreferredNetwork = this.brandCardParamsNetworks();
        if (networks != null) {
            return networks;
        }
        CardBrand cardBrand2 = (CardBrand)CollectionsKt.firstOrNull(this.getMerchantPreferredNetworks());
        if (cardBrand2 == null) return null;
        CardBrand it = cardBrand = cardBrand2;
        boolean bl = false;
        if (it == CardBrand.Unknown) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        CardBrand cardBrand3 = cardBrand;
        CardBrand cardBrand4 = cardBrand3;
        if (cardBrand4 == null) return null;
        String string2 = cardBrand4.getCode();
        if (string2 == null) return null;
        String string3 = string2;
        boolean bl3 = false;
        Networks networks2 = new Networks(string3);
        return networks2;
    }

    private final Networks brandCardParamsNetworks() {
        Networks networks;
        CardBrand cardBrand;
        Object object;
        CardBrand it = object = this.getBrand();
        boolean bl = false;
        Object object2 = cardBrand = it != CardBrand.Unknown ? object : null;
        if (cardBrand != null && (object = cardBrand.getCode()) != null) {
            Object network = object;
            boolean bl2 = false;
            networks = new Networks((String)network);
        } else {
            networks = null;
        }
        CardBrand it2 = cardBrand = networks;
        boolean bl3 = false;
        return this.isCbcEligible() && this.getPossibleBrands().size() > 1 ? cardBrand : null;
    }

    @VisibleForTesting
    public final void handleBrandSelected$payments_core_release(@Nullable CardBrand brand) {
        block1: {
            State it;
            State nextValue$iv;
            Object prevValue$iv;
            CardBrand cardBrand = brand;
            if (cardBrand == null) break block1;
            CardBrand it2 = cardBrand;
            boolean bl = false;
            MutableStateFlow<State> $this$update$iv = this.stateFlow;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                it = (State)prevValue$iv;
                boolean bl2 = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = State.copy$default(it, false, false, null, brand, null, null, false, false, 247, null))));
            this.determineCardBrandToDisplay();
        }
    }

    private final void setCardBrandIconAndTint() {
        this.iconView.setImageResource(this.getShouldShowErrorIcon() ? this.getState().getBrand().getErrorIcon() : (this.getShouldShowCvc() ? this.getState().getBrand().getCvcIcon() : this.getState().getBrand().getIcon()));
    }

    private final void determineCardBrandToDisplay() {
        CardBrand newBrand;
        CardBrand cardBrand = newBrand = this.getState().getPossibleBrands().size() > 1 ? CardBrandSelectorKt.selectCardBrandToDisplay(this.getState().getUserSelectedBrand(), this.getState().getPossibleBrands(), this.getState().getMerchantPreferredNetworks()) : this.getState().getBrand();
        if (this.getBrand() != newBrand) {
            this.setBrand(newBrand);
        }
        this.setCardBrandIconAndTint();
    }

    private final void updateBrandSpinner(boolean animate2) {
        ViewGroup parentViewGroup;
        boolean showDropdown = this.isCbcEligible() && this.getPossibleBrands().size() > 1 && !this.getShouldShowCvc() && !this.getShouldShowErrorIcon();
        ViewParent viewParent = this.getParent();
        ViewGroup viewGroup = parentViewGroup = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
        if (showDropdown) {
            this.initListPopup();
            this.setOnClickListener(arg_0 -> CardBrandView.updateBrandSpinner$lambda$15(this, arg_0));
            if (animate2) {
                this.animateNextChanges(parentViewGroup);
            }
            this.chevron.setVisibility(0);
        } else {
            this.setOnClickListener(null);
            if (animate2) {
                this.animateNextChanges(parentViewGroup);
            }
            this.chevron.setVisibility(8);
        }
    }

    private final void initListPopup() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        BrandAdapter adapter = new BrandAdapter(context, this.getPossibleBrands(), this.getBrand());
        this.listPopup.setAdapter((ListAdapter)adapter);
        this.listPopup.setModal(true);
        this.listPopup.setWidth(this.measureContentWidth(adapter));
        this.listPopup.setOnItemClickListener((arg_0, arg_1, arg_2, arg_3) -> CardBrandView.initListPopup$lambda$17(this, arg_0, arg_1, arg_2, arg_3));
        this.listPopup.setAnchorView((View)this.iconView);
    }

    private final int measureContentWidth(BrandAdapter adapter) {
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int count = adapter.getCount();
        int maxWidth = 0;
        for (int i = 0; i < count; ++i) {
            View itemView = adapter.getView(i, null, (ViewGroup)this);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            maxWidth = RangesKt.coerceAtLeast((int)maxWidth, (int)itemView.getMeasuredWidth());
        }
        return maxWidth;
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.getState());
    }

    protected void onRestoreInstanceState(@Nullable Parcelable state) {
        SavedState savedState = state instanceof SavedState ? (SavedState)state : null;
        Parcelable parcelable = savedState;
        if (parcelable == null || (parcelable = parcelable.getState()) == null) {
            parcelable = new State(false, false, null, null, null, null, false, false, 255, null);
        }
        this.setState((State)parcelable);
        this.determineCardBrandToDisplay();
        this.updateBrandSpinner(false);
        SavedState savedState2 = savedState;
        if (savedState2 == null || (savedState2 = savedState2.getSuperState()) == null) {
            savedState2 = state;
        }
        super.onRestoreInstanceState((Parcelable)savedState2);
    }

    private final void animateNextChanges(ViewGroup $this$animateNextChanges) {
        block0: {
            ViewGroup viewGroup = $this$animateNextChanges;
            if (viewGroup == null) break block0;
            ViewGroup it = viewGroup;
            boolean bl = false;
            TransitionManager.endTransitions((ViewGroup)$this$animateNextChanges);
            TransitionManager.beginDelayedTransition((ViewGroup)$this$animateNextChanges);
        }
    }

    @JvmOverloads
    public CardBrandView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardBrandView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void updateBrandSpinner$lambda$15(CardBrandView this$0, View it) {
        if (this$0.listPopup.isShowing()) {
            this$0.listPopup.dismiss();
        } else {
            this$0.listPopup.show();
        }
    }

    private static final void initListPopup$lambda$17(CardBrandView this$0, AdapterView adapterView, View view, int position, long l) {
        CardBrand cardBrand = (CardBrand)CollectionsKt.getOrNull(this$0.getPossibleBrands(), (int)(position - 1));
        if (cardBrand != null) {
            CardBrand it = cardBrand;
            boolean bl = false;
            this$0.handleBrandSelected$payments_core_release(it);
        }
        this$0.listPopup.dismiss();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/view/CardBrandView$SavedState;", "Landroid/view/View$BaseSavedState;", "Landroid/os/Parcelable;", "superSavedState", "state", "Lcom/stripe/android/view/CardBrandView$State;", "<init>", "(Landroid/os/Parcelable;Lcom/stripe/android/view/CardBrandView$State;)V", "getSuperSavedState", "()Landroid/os/Parcelable;", "getState", "()Lcom/stripe/android/view/CardBrandView$State;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class SavedState
    extends View.BaseSavedState
    implements Parcelable {
        @Nullable
        private final Parcelable superSavedState;
        @NotNull
        private final State state;
        @NotNull
        public static final Parcelable.Creator<SavedState> CREATOR;
        public static final int $stable;

        public SavedState(@Nullable Parcelable superSavedState, @NotNull State state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            super(superSavedState);
            this.superSavedState = superSavedState;
            this.state = state;
        }

        @Nullable
        public final Parcelable getSuperSavedState() {
            return this.superSavedState;
        }

        @NotNull
        public final State getState() {
            return this.state;
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeParcelable(this.superSavedState, flags);
            this.state.writeToParcel(dest, flags);
        }

        @Nullable
        public final Parcelable component1() {
            return this.superSavedState;
        }

        @NotNull
        public final State component2() {
            return this.state;
        }

        @NotNull
        public final SavedState copy(@Nullable Parcelable superSavedState, @NotNull State state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            return new SavedState(superSavedState, state);
        }

        public static /* synthetic */ SavedState copy$default(SavedState savedState, Parcelable parcelable, State state, int n, Object object) {
            if ((n & 1) != 0) {
                parcelable = savedState.superSavedState;
            }
            if ((n & 2) != 0) {
                state = savedState.state;
            }
            return savedState.copy(parcelable, state);
        }

        @NotNull
        public String toString() {
            return "SavedState(superSavedState=" + this.superSavedState + ", state=" + this.state + ")";
        }

        public int hashCode() {
            int result = this.superSavedState == null ? 0 : this.superSavedState.hashCode();
            result = result * 31 + this.state.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SavedState)) {
                return false;
            }
            SavedState savedState = (SavedState)((Object)other);
            if (!Intrinsics.areEqual((Object)this.superSavedState, (Object)savedState.superSavedState)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.state, (Object)savedState.state);
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<SavedState> {
                public final SavedState[] newArray(int size) {
                    return new SavedState[size];
                }

                public final SavedState createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new SavedState(parcel.readParcelable(SavedState.class.getClassLoader()), (State)State.CREATOR.createFromParcel(parcel));
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001Be\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003Jg\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u0003H\u00c6\u0001J\u0006\u0010!\u001a\u00020\"J\u0013\u0010#\u001a\u00020\u00032\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020\"H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000f\u00a8\u0006."}, d2={"Lcom/stripe/android/view/CardBrandView$State;", "Landroid/os/Parcelable;", "isCbcEligible", "", "isLoading", "brand", "Lcom/stripe/android/model/CardBrand;", "userSelectedBrand", "possibleBrands", "", "merchantPreferredNetworks", "shouldShowCvc", "shouldShowErrorIcon", "<init>", "(ZZLcom/stripe/android/model/CardBrand;Lcom/stripe/android/model/CardBrand;Ljava/util/List;Ljava/util/List;ZZ)V", "()Z", "getBrand", "()Lcom/stripe/android/model/CardBrand;", "getUserSelectedBrand", "getPossibleBrands", "()Ljava/util/List;", "getMerchantPreferredNetworks", "getShouldShowCvc", "getShouldShowErrorIcon", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class State
    implements Parcelable {
        private final boolean isCbcEligible;
        private final boolean isLoading;
        @NotNull
        private final CardBrand brand;
        @Nullable
        private final CardBrand userSelectedBrand;
        @NotNull
        private final List<CardBrand> possibleBrands;
        @NotNull
        private final List<CardBrand> merchantPreferredNetworks;
        private final boolean shouldShowCvc;
        private final boolean shouldShowErrorIcon;
        @NotNull
        public static final Parcelable.Creator<State> CREATOR;
        public static final int $stable;

        public State(boolean isCbcEligible, boolean isLoading, @NotNull CardBrand brand, @Nullable CardBrand userSelectedBrand, @NotNull List<? extends CardBrand> possibleBrands, @NotNull List<? extends CardBrand> merchantPreferredNetworks, boolean shouldShowCvc, boolean shouldShowErrorIcon) {
            Intrinsics.checkNotNullParameter((Object)brand, (String)"brand");
            Intrinsics.checkNotNullParameter(possibleBrands, (String)"possibleBrands");
            Intrinsics.checkNotNullParameter(merchantPreferredNetworks, (String)"merchantPreferredNetworks");
            this.isCbcEligible = isCbcEligible;
            this.isLoading = isLoading;
            this.brand = brand;
            this.userSelectedBrand = userSelectedBrand;
            this.possibleBrands = possibleBrands;
            this.merchantPreferredNetworks = merchantPreferredNetworks;
            this.shouldShowCvc = shouldShowCvc;
            this.shouldShowErrorIcon = shouldShowErrorIcon;
        }

        public /* synthetic */ State(boolean bl, boolean bl2, CardBrand cardBrand, CardBrand cardBrand2, List list, List list2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                cardBrand = CardBrand.Unknown;
            }
            if ((n & 8) != 0) {
                cardBrand2 = null;
            }
            if ((n & 0x10) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 0x20) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 0x40) != 0) {
                bl3 = false;
            }
            if ((n & 0x80) != 0) {
                bl4 = false;
            }
            this(bl, bl2, cardBrand, cardBrand2, list, list2, bl3, bl4);
        }

        public final boolean isCbcEligible() {
            return this.isCbcEligible;
        }

        public final boolean isLoading() {
            return this.isLoading;
        }

        @NotNull
        public final CardBrand getBrand() {
            return this.brand;
        }

        @Nullable
        public final CardBrand getUserSelectedBrand() {
            return this.userSelectedBrand;
        }

        @NotNull
        public final List<CardBrand> getPossibleBrands() {
            return this.possibleBrands;
        }

        @NotNull
        public final List<CardBrand> getMerchantPreferredNetworks() {
            return this.merchantPreferredNetworks;
        }

        public final boolean getShouldShowCvc() {
            return this.shouldShowCvc;
        }

        public final boolean getShouldShowErrorIcon() {
            return this.shouldShowErrorIcon;
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeInt(this.isCbcEligible ? 1 : 0);
            dest.writeInt(this.isLoading ? 1 : 0);
            dest.writeString(this.brand.name());
            Object object = this.userSelectedBrand;
            if (object == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                dest.writeString(object.name());
            }
            object = this.possibleBrands;
            dest.writeInt(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                dest.writeString(((CardBrand)iterator.next()).name());
            }
            object = this.merchantPreferredNetworks;
            dest.writeInt(object.size());
            iterator = object.iterator();
            while (iterator.hasNext()) {
                dest.writeString(((CardBrand)iterator.next()).name());
            }
            dest.writeInt(this.shouldShowCvc ? 1 : 0);
            dest.writeInt(this.shouldShowErrorIcon ? 1 : 0);
        }

        public final int describeContents() {
            return 0;
        }

        public final boolean component1() {
            return this.isCbcEligible;
        }

        public final boolean component2() {
            return this.isLoading;
        }

        @NotNull
        public final CardBrand component3() {
            return this.brand;
        }

        @Nullable
        public final CardBrand component4() {
            return this.userSelectedBrand;
        }

        @NotNull
        public final List<CardBrand> component5() {
            return this.possibleBrands;
        }

        @NotNull
        public final List<CardBrand> component6() {
            return this.merchantPreferredNetworks;
        }

        public final boolean component7() {
            return this.shouldShowCvc;
        }

        public final boolean component8() {
            return this.shouldShowErrorIcon;
        }

        @NotNull
        public final State copy(boolean isCbcEligible, boolean isLoading, @NotNull CardBrand brand, @Nullable CardBrand userSelectedBrand, @NotNull List<? extends CardBrand> possibleBrands, @NotNull List<? extends CardBrand> merchantPreferredNetworks, boolean shouldShowCvc, boolean shouldShowErrorIcon) {
            Intrinsics.checkNotNullParameter((Object)brand, (String)"brand");
            Intrinsics.checkNotNullParameter(possibleBrands, (String)"possibleBrands");
            Intrinsics.checkNotNullParameter(merchantPreferredNetworks, (String)"merchantPreferredNetworks");
            return new State(isCbcEligible, isLoading, brand, userSelectedBrand, possibleBrands, merchantPreferredNetworks, shouldShowCvc, shouldShowErrorIcon);
        }

        public static /* synthetic */ State copy$default(State state, boolean bl, boolean bl2, CardBrand cardBrand, CardBrand cardBrand2, List list, List list2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = state.isCbcEligible;
            }
            if ((n & 2) != 0) {
                bl2 = state.isLoading;
            }
            if ((n & 4) != 0) {
                cardBrand = state.brand;
            }
            if ((n & 8) != 0) {
                cardBrand2 = state.userSelectedBrand;
            }
            if ((n & 0x10) != 0) {
                list = state.possibleBrands;
            }
            if ((n & 0x20) != 0) {
                list2 = state.merchantPreferredNetworks;
            }
            if ((n & 0x40) != 0) {
                bl3 = state.shouldShowCvc;
            }
            if ((n & 0x80) != 0) {
                bl4 = state.shouldShowErrorIcon;
            }
            return state.copy(bl, bl2, cardBrand, cardBrand2, list, list2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "State(isCbcEligible=" + this.isCbcEligible + ", isLoading=" + this.isLoading + ", brand=" + this.brand + ", userSelectedBrand=" + this.userSelectedBrand + ", possibleBrands=" + this.possibleBrands + ", merchantPreferredNetworks=" + this.merchantPreferredNetworks + ", shouldShowCvc=" + this.shouldShowCvc + ", shouldShowErrorIcon=" + this.shouldShowErrorIcon + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.isCbcEligible);
            result = result * 31 + Boolean.hashCode(this.isLoading);
            result = result * 31 + this.brand.hashCode();
            result = result * 31 + (this.userSelectedBrand == null ? 0 : this.userSelectedBrand.hashCode());
            result = result * 31 + ((Object)this.possibleBrands).hashCode();
            result = result * 31 + ((Object)this.merchantPreferredNetworks).hashCode();
            result = result * 31 + Boolean.hashCode(this.shouldShowCvc);
            result = result * 31 + Boolean.hashCode(this.shouldShowErrorIcon);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (this.isCbcEligible != state.isCbcEligible) {
                return false;
            }
            if (this.isLoading != state.isLoading) {
                return false;
            }
            if (this.brand != state.brand) {
                return false;
            }
            if (this.userSelectedBrand != state.userSelectedBrand) {
                return false;
            }
            if (!Intrinsics.areEqual(this.possibleBrands, state.possibleBrands)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.merchantPreferredNetworks, state.merchantPreferredNetworks)) {
                return false;
            }
            if (this.shouldShowCvc != state.shouldShowCvc) {
                return false;
            }
            return this.shouldShowErrorIcon == state.shouldShowErrorIcon;
        }

        public State() {
            this(false, false, null, null, null, null, false, false, 255, null);
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<State> {
                public final State[] newArray(int size) {
                    return new State[size];
                }

                public final State createFromParcel(Parcel parcel) {
                    int n;
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    int n2 = parcel.readInt();
                    ArrayList<CardBrand> arrayList = new ArrayList<CardBrand>(n2);
                    CardBrand cardBrand = parcel.readInt() == 0 ? null : CardBrand.valueOf((String)parcel.readString());
                    CardBrand cardBrand2 = CardBrand.valueOf((String)parcel.readString());
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    for (n = 0; n != n2; ++n) {
                        arrayList.add(CardBrand.valueOf((String)parcel.readString()));
                    }
                    List list = arrayList;
                    n2 = parcel.readInt();
                    arrayList = new ArrayList(n2);
                    List list2 = list;
                    for (n = 0; n != n2; ++n) {
                        arrayList.add(CardBrand.valueOf((String)parcel.readString()));
                    }
                    boolean bl3 = parcel.readInt() != 0;
                    boolean bl4 = parcel.readInt() != 0;
                    List list3 = arrayList;
                    List list4 = list2;
                    CardBrand cardBrand3 = cardBrand;
                    CardBrand cardBrand4 = cardBrand2;
                    boolean bl5 = bl;
                    boolean bl6 = bl2;
                    return new State(bl6, bl5, cardBrand4, cardBrand3, list4, list3, bl4, bl3);
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }
}

