/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.paymentlauncher;

import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.payments.paymentlauncher.PaymentLauncher;
import com.stripe.android.payments.paymentlauncher.PaymentLauncherContract;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import java.util.Set;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001Bk\b\u0001\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0010\b\u0001\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u000e\b\u0001\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\f\u0012\b\b\u0001\u0010\r\u001a\u00020\f\u0012\u000e\b\u0001\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/stripe/android/payments/paymentlauncher/StripePaymentLauncher;", "Lcom/stripe/android/payments/paymentlauncher/PaymentLauncher;", "publishableKeyProvider", "Lkotlin/Function0;", "", "stripeAccountIdProvider", "hostActivityLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/payments/paymentlauncher/PaymentLauncherContract$Args;", "statusBarColor", "", "includePaymentSheetNextHandlers", "", "enableLogging", "productUsage", "", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Landroidx/activity/result/ActivityResultLauncher;Ljava/lang/Integer;ZZLjava/util/Set;)V", "Ljava/lang/Integer;", "confirm", "", "params", "Lcom/stripe/android/model/ConfirmPaymentIntentParams;", "Lcom/stripe/android/model/ConfirmSetupIntentParams;", "handleNextActionForPaymentIntent", "clientSecret", "handleNextActionForSetupIntent", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class StripePaymentLauncher
implements PaymentLauncher {
    @NotNull
    private final Function0<String> publishableKeyProvider;
    @NotNull
    private final Function0<String> stripeAccountIdProvider;
    @NotNull
    private final ActivityResultLauncher<PaymentLauncherContract.Args> hostActivityLauncher;
    @Nullable
    private final Integer statusBarColor;
    private final boolean includePaymentSheetNextHandlers;
    private final boolean enableLogging;
    @NotNull
    private final Set<String> productUsage;
    public static final int $stable = 8;

    @AssistedInject
    public StripePaymentLauncher(@Assisted(value="publishableKey") @NotNull Function0<String> publishableKeyProvider, @Assisted(value="stripeAccountId") @NotNull Function0<String> stripeAccountIdProvider, @Assisted @NotNull ActivityResultLauncher<PaymentLauncherContract.Args> hostActivityLauncher, @Assisted(value="STATUS_BAR_COLOR") @Nullable Integer statusBarColor, @Assisted(value="INCLUDE_PAYMENT_SHEET_NEXT_ACTION_HANDLERS") boolean includePaymentSheetNextHandlers, @Named(value="enableLogging") boolean enableLogging, @Named(value="productUsage") @NotNull Set<String> productUsage) {
        Intrinsics.checkNotNullParameter(publishableKeyProvider, (String)"publishableKeyProvider");
        Intrinsics.checkNotNullParameter(stripeAccountIdProvider, (String)"stripeAccountIdProvider");
        Intrinsics.checkNotNullParameter(hostActivityLauncher, (String)"hostActivityLauncher");
        Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
        this.publishableKeyProvider = publishableKeyProvider;
        this.stripeAccountIdProvider = stripeAccountIdProvider;
        this.hostActivityLauncher = hostActivityLauncher;
        this.statusBarColor = statusBarColor;
        this.includePaymentSheetNextHandlers = includePaymentSheetNextHandlers;
        this.enableLogging = enableLogging;
        this.productUsage = productUsage;
    }

    @Override
    public void confirm(@NotNull ConfirmPaymentIntentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string2 = (String)this.publishableKeyProvider.invoke();
        String string3 = (String)this.stripeAccountIdProvider.invoke();
        boolean bl = this.enableLogging;
        Set<String> set = this.productUsage;
        boolean bl2 = this.includePaymentSheetNextHandlers;
        Integer n = this.statusBarColor;
        this.hostActivityLauncher.launch((Object)new PaymentLauncherContract.Args.IntentConfirmationArgs(string2, string3, bl, set, bl2, params, n));
    }

    @Override
    public void confirm(@NotNull ConfirmSetupIntentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.hostActivityLauncher.launch((Object)new PaymentLauncherContract.Args.IntentConfirmationArgs((String)this.publishableKeyProvider.invoke(), (String)this.stripeAccountIdProvider.invoke(), this.enableLogging, this.productUsage, this.includePaymentSheetNextHandlers, params, this.statusBarColor));
    }

    @Override
    public void handleNextActionForPaymentIntent(@NotNull String clientSecret) {
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        this.hostActivityLauncher.launch((Object)new PaymentLauncherContract.Args.PaymentIntentNextActionArgs((String)this.publishableKeyProvider.invoke(), (String)this.stripeAccountIdProvider.invoke(), this.enableLogging, this.productUsage, this.includePaymentSheetNextHandlers, clientSecret, this.statusBarColor));
    }

    @Override
    public void handleNextActionForSetupIntent(@NotNull String clientSecret) {
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        this.hostActivityLauncher.launch((Object)new PaymentLauncherContract.Args.SetupIntentNextActionArgs((String)this.publishableKeyProvider.invoke(), (String)this.stripeAccountIdProvider.invoke(), this.enableLogging, this.productUsage, this.includePaymentSheetNextHandlers, clientSecret, this.statusBarColor));
    }
}

