/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.bankaccount.ui;

import android.app.Application;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateHandleSupport;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.stripe.android.core.Logger;
import com.stripe.android.core.utils.CreationExtrasKtxKt;
import com.stripe.android.financialconnections.FinancialConnectionsSheetResult;
import com.stripe.android.financialconnections.launcher.FinancialConnectionsSheetInstantDebitsResult;
import com.stripe.android.financialconnections.model.FinancialConnectionsSession;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.parsers.PaymentMethodJsonParser;
import com.stripe.android.payments.bankaccount.CollectBankAccountConfiguration;
import com.stripe.android.payments.bankaccount.di.DaggerCollectBankAccountComponent;
import com.stripe.android.payments.bankaccount.domain.AttachFinancialConnectionsSession;
import com.stripe.android.payments.bankaccount.domain.CreateFinancialConnectionsSession;
import com.stripe.android.payments.bankaccount.domain.RetrieveStripeIntent;
import com.stripe.android.payments.bankaccount.navigation.CollectBankAccountContract;
import com.stripe.android.payments.bankaccount.navigation.CollectBankAccountResponseInternal;
import com.stripe.android.payments.bankaccount.navigation.CollectBankAccountResultInternal;
import com.stripe.android.payments.bankaccount.ui.CollectBankAccountViewEffect;
import com.stripe.android.payments.bankaccount.ui.CollectBankAccountViewModel;
import com.stripe.android.payments.bankaccount.ui.CollectBankAccountViewModelKt;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0001\u0018\u0000 ;2\u00020\u0001:\u0002:;BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u0010\u0007\u001a\u00020\u001eH\u0082@\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020$J\u0016\u0010%\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020&H\u0082@\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020,H\u0002J\u000e\u0010-\u001a\u0004\u0018\u00010.*\u00020/H\u0002J\u001e\u00100\u001a\u00020\u001e2\u0014\u00101\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u000103\u0012\u0004\u0012\u00020402H\u0002J\u0010\u00105\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*H\u0002J\u0016\u00106\u001a\u00020\u001e2\u0006\u00107\u001a\u000208H\u0082@\u00a2\u0006\u0002\u00109R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00148B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006<"}, d2={"Lcom/stripe/android/payments/bankaccount/ui/CollectBankAccountViewModel;", "Landroidx/lifecycle/ViewModel;", "args", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args;", "_viewEffect", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/stripe/android/payments/bankaccount/ui/CollectBankAccountViewEffect;", "createFinancialConnectionsSession", "Lcom/stripe/android/payments/bankaccount/domain/CreateFinancialConnectionsSession;", "attachFinancialConnectionsSession", "Lcom/stripe/android/payments/bankaccount/domain/AttachFinancialConnectionsSession;", "retrieveStripeIntent", "Lcom/stripe/android/payments/bankaccount/domain/RetrieveStripeIntent;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "logger", "Lcom/stripe/android/core/Logger;", "<init>", "(Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args;Lkotlinx/coroutines/flow/MutableSharedFlow;Lcom/stripe/android/payments/bankaccount/domain/CreateFinancialConnectionsSession;Lcom/stripe/android/payments/bankaccount/domain/AttachFinancialConnectionsSession;Lcom/stripe/android/payments/bankaccount/domain/RetrieveStripeIntent;Landroidx/lifecycle/SavedStateHandle;Lcom/stripe/android/core/Logger;)V", "value", "", "hasLaunched", "getHasLaunched", "()Z", "setHasLaunched", "(Z)V", "viewEffect", "Lkotlinx/coroutines/flow/SharedFlow;", "getViewEffect", "()Lkotlinx/coroutines/flow/SharedFlow;", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onConnectionsForACHResult", "result", "Lcom/stripe/android/financialconnections/FinancialConnectionsSheetResult;", "onConnectionsForInstantDebitsResult", "Lcom/stripe/android/financialconnections/launcher/FinancialConnectionsSheetInstantDebitsResult;", "finishWithResult", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountResultInternal;", "(Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountResultInternal;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "finishWithSession", "financialConnectionsSession", "Lcom/stripe/android/financialconnections/model/FinancialConnectionsSession;", "finishWithPaymentMethodId", "Lcom/stripe/android/financialconnections/launcher/FinancialConnectionsSheetInstantDebitsResult$Completed;", "parsePaymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "", "finishWithRefreshedIntent", "action", "Lkotlin/Function1;", "Lcom/stripe/android/model/StripeIntent;", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountResponseInternal;", "attachSessionToIntent", "finishWithError", "throwable", "", "(Ljava/lang/Throwable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Factory", "Companion", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCollectBankAccountViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectBankAccountViewModel.kt\ncom/stripe/android/payments/bankaccount/ui/CollectBankAccountViewModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,316:1\n1#2:317\n*E\n"})
public final class CollectBankAccountViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CollectBankAccountContract.Args args;
    @NotNull
    private final MutableSharedFlow<CollectBankAccountViewEffect> _viewEffect;
    @NotNull
    private final CreateFinancialConnectionsSession createFinancialConnectionsSession;
    @NotNull
    private final AttachFinancialConnectionsSession attachFinancialConnectionsSession;
    @NotNull
    private final RetrieveStripeIntent retrieveStripeIntent;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final Logger logger;
    @NotNull
    private final SharedFlow<CollectBankAccountViewEffect> viewEffect;
    public static final int $stable = 8;
    @NotNull
    private static final String KEY_HAS_LAUNCHED = "key_has_launched";

    @Inject
    public CollectBankAccountViewModel(@NotNull CollectBankAccountContract.Args args, @NotNull MutableSharedFlow<CollectBankAccountViewEffect> _viewEffect, @NotNull CreateFinancialConnectionsSession createFinancialConnectionsSession2, @NotNull AttachFinancialConnectionsSession attachFinancialConnectionsSession, @NotNull RetrieveStripeIntent retrieveStripeIntent2, @NotNull SavedStateHandle savedStateHandle, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(_viewEffect, (String)"_viewEffect");
        Intrinsics.checkNotNullParameter((Object)createFinancialConnectionsSession2, (String)"createFinancialConnectionsSession");
        Intrinsics.checkNotNullParameter((Object)attachFinancialConnectionsSession, (String)"attachFinancialConnectionsSession");
        Intrinsics.checkNotNullParameter((Object)retrieveStripeIntent2, (String)"retrieveStripeIntent");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.args = args;
        this._viewEffect = _viewEffect;
        this.createFinancialConnectionsSession = createFinancialConnectionsSession2;
        this.attachFinancialConnectionsSession = attachFinancialConnectionsSession;
        this.retrieveStripeIntent = retrieveStripeIntent2;
        this.savedStateHandle = savedStateHandle;
        this.logger = logger;
        this.viewEffect = (SharedFlow)this._viewEffect;
        if (!this.getHasLaunched()) {
            BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ CollectBankAccountViewModel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.createFinancialConnectionsSession((Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final boolean getHasLaunched() {
        return Intrinsics.areEqual((Object)this.savedStateHandle.get(KEY_HAS_LAUNCHED), (Object)true);
    }

    private final void setHasLaunched(boolean value) {
        this.savedStateHandle.set(KEY_HAS_LAUNCHED, (Object)value);
    }

    @NotNull
    public final SharedFlow<CollectBankAccountViewEffect> getViewEffect() {
        return this.viewEffect;
    }

    /*
     * Unable to fully structure code
     */
    private final Object createFinancialConnectionsSession(Continuation<? super Unit> $completion) {
        block23: {
            block26: {
                block25: {
                    block24: {
                        if (!($completion instanceof createFinancialConnectionsSession.1)) ** GOTO lbl-1000
                        var16_2 = $completion;
                        if ((var16_2.label & -2147483648) != 0) {
                            var16_2.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                Object L$0;
                                Object L$1;
                                /* synthetic */ Object result;
                                final /* synthetic */ CollectBankAccountViewModel this$0;
                                int label;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return CollectBankAccountViewModel.access$createFinancialConnectionsSession(this.this$0, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var17_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var2_5 = this.args;
                                if (!(var2_5 instanceof CollectBankAccountContract.Args.ForDeferredPaymentIntent)) break;
                                elementsSessionContext = CollectBankAccountViewModelKt.access$retrieveElementsSessionContext(((CollectBankAccountContract.Args.ForDeferredPaymentIntent)this.args).getConfiguration());
                                var4_8 = this.createFinancialConnectionsSession;
                                var5_11 = ((CollectBankAccountContract.Args.ForDeferredPaymentIntent)this.args).getPublishableKey();
                                var6_15 = ((CollectBankAccountContract.Args.ForDeferredPaymentIntent)this.args).getStripeAccountId();
                                var7_18 = ((CollectBankAccountContract.Args.ForDeferredPaymentIntent)this.args).getHostedSurface();
                                var8_19 = ((CollectBankAccountContract.Args.ForDeferredPaymentIntent)this.args).getElementsSessionId();
                                var9_20 = ((CollectBankAccountContract.Args.ForDeferredPaymentIntent)this.args).getCustomerId();
                                var10_21 = ((CollectBankAccountContract.Args.ForDeferredPaymentIntent)this.args).getOnBehalfOf();
                                v0 = elementsSessionContext;
                                var11_22 = v0 != null ? v0.getLinkMode() : null;
                                var12_23 = ((CollectBankAccountContract.Args.ForDeferredPaymentIntent)this.args).getAmount();
                                var13_24 = ((CollectBankAccountContract.Args.ForDeferredPaymentIntent)this.args).getCurrency();
                                var14_25 = this.args.getProduct();
                                $continuation.L$0 = this;
                                $continuation.label = 1;
                                v1 = var4_8.forDeferredIntent-5p_uFSQ(var5_11, var6_15, (String)var8_19, var9_20, var10_21, var7_18, var11_22, (Integer)var12_23, var13_24, var14_25, (Continuation<? super Result<com.stripe.android.model.FinancialConnectionsSession>>)$continuation);
                                if (v1 == var17_4) {
                                    return var17_4;
                                }
                                break block23;
                            }
                            case 1: {
                                this = (CollectBankAccountViewModel)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = ((Result)$result).unbox-impl();
                                break block23;
                            }
                        }
                        if (!(var2_5 instanceof CollectBankAccountContract.Args.ForDeferredSetupIntent)) break block24;
                        elementsSessionContext = CollectBankAccountViewModelKt.access$retrieveElementsSessionContext(((CollectBankAccountContract.Args.ForDeferredSetupIntent)this.args).getConfiguration());
                        var4_8 = this.createFinancialConnectionsSession;
                        var5_11 = ((CollectBankAccountContract.Args.ForDeferredSetupIntent)this.args).getPublishableKey();
                        var6_15 = ((CollectBankAccountContract.Args.ForDeferredSetupIntent)this.args).getStripeAccountId();
                        var7_18 = ((CollectBankAccountContract.Args.ForDeferredSetupIntent)this.args).getHostedSurface();
                        var8_19 = ((CollectBankAccountContract.Args.ForDeferredSetupIntent)this.args).getElementsSessionId();
                        var9_20 = ((CollectBankAccountContract.Args.ForDeferredSetupIntent)this.args).getCustomerId();
                        var10_21 = ((CollectBankAccountContract.Args.ForDeferredSetupIntent)this.args).getOnBehalfOf();
                        v2 = elementsSessionContext;
                        var11_22 = v2 != null ? v2.getLinkMode() : null;
                        var12_23 = this.args.getProduct();
                        $continuation.L$0 = this;
                        $continuation.label = 2;
                        v1 = var4_8.forDeferredIntent-5p_uFSQ(var5_11, var6_15, (String)var8_19, var9_20, var10_21, var7_18, var11_22, null, null, (String)var12_23, (Continuation<? super Result<com.stripe.android.model.FinancialConnectionsSession>>)$continuation);
                        if (v1 == var17_4) {
                            return var17_4;
                        }
                        break block23;
                        {
                            case 2: {
                                this = (CollectBankAccountViewModel)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = ((Result)$result).unbox-impl();
                                break block23;
                            }
                        }
                    }
                    if (!(var2_5 instanceof CollectBankAccountContract.Args.ForPaymentIntent)) break block25;
                    elementsSessionContext = this.createFinancialConnectionsSession;
                    var4_8 = ((CollectBankAccountContract.Args.ForPaymentIntent)this.args).getPublishableKey();
                    var5_11 = ((CollectBankAccountContract.Args.ForPaymentIntent)this.args).getStripeAccountId();
                    var6_15 = ((CollectBankAccountContract.Args.ForPaymentIntent)this.args).getHostedSurface();
                    var7_18 = ((CollectBankAccountContract.Args.ForPaymentIntent)this.args).getClientSecret();
                    var8_19 = ((CollectBankAccountContract.Args.ForPaymentIntent)this.args).getConfiguration();
                    $continuation.L$0 = this;
                    $continuation.label = 3;
                    v1 = elementsSessionContext.forPaymentIntent-hUnOzRk((String)var4_8, var7_18, var5_11, var6_15, (CollectBankAccountConfiguration)var8_19, (Continuation<? super Result<com.stripe.android.model.FinancialConnectionsSession>>)$continuation);
                    if (v1 == var17_4) {
                        return var17_4;
                    }
                    break block23;
                    {
                        case 3: {
                            this = (CollectBankAccountViewModel)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = ((Result)$result).unbox-impl();
                            break block23;
                        }
                    }
                }
                if (!(var2_5 instanceof CollectBankAccountContract.Args.ForSetupIntent)) break block26;
                elementsSessionContext = this.createFinancialConnectionsSession;
                var4_8 = ((CollectBankAccountContract.Args.ForSetupIntent)this.args).getPublishableKey();
                var5_11 = ((CollectBankAccountContract.Args.ForSetupIntent)this.args).getStripeAccountId();
                var6_15 = ((CollectBankAccountContract.Args.ForSetupIntent)this.args).getHostedSurface();
                var7_18 = ((CollectBankAccountContract.Args.ForSetupIntent)this.args).getClientSecret();
                var8_19 = ((CollectBankAccountContract.Args.ForSetupIntent)this.args).getConfiguration();
                $continuation.L$0 = this;
                $continuation.label = 4;
                v1 = elementsSessionContext.forSetupIntent-hUnOzRk((String)var4_8, var7_18, var5_11, var6_15, (CollectBankAccountConfiguration)var8_19, (Continuation<? super Result<com.stripe.android.model.FinancialConnectionsSession>>)$continuation);
                if (v1 == var17_4) {
                    return var17_4;
                }
                break block23;
                {
                    case 4: {
                        this = (CollectBankAccountViewModel)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = ((Result)$result).unbox-impl();
                        break block23;
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        var2_5 = v1;
        if (Result.isSuccess-impl((Object)var2_5)) {
            elementsSessionContext = var2_5;
            try {
                var4_8 = elementsSessionContext;
                it = (com.stripe.android.model.FinancialConnectionsSession)var4_8;
                $i$a$-mapCatching-CollectBankAccountViewModel$createFinancialConnectionsSession$2 = false;
                v3 = it.getClientSecret();
                if (v3 == null) {
                    var7_18 = "Required value was null.";
                    throw new IllegalArgumentException(var7_18.toString());
                }
                var4_8 = Result.constructor-impl((Object)v3);
            }
            catch (Throwable it) {
                var4_8 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it));
            }
            v4 = var4_8;
        } else {
            v4 = var2_5 = Result.constructor-impl((Object)var2_5);
        }
        if (Result.isSuccess-impl((Object)var2_5)) {
            financialConnectionsSessionSecret = (String)var2_5;
            $i$a$-onSuccess-CollectBankAccountViewModel$createFinancialConnectionsSession$3 = false;
            this.logger.debug("Bank account session created! " + financialConnectionsSessionSecret + ".");
            this.setHasLaunched(true);
            elementsSessionContext = CollectBankAccountViewModelKt.access$retrieveElementsSessionContext(this.args.getConfiguration());
            var6_17 = this.args.getPublishableKey();
            var7_18 = this.args.getStripeAccountId();
            $continuation.L$0 = this;
            $continuation.L$1 = var2_5;
            $continuation.label = 5;
            v5 = this._viewEffect.emit((Object)new CollectBankAccountViewEffect.OpenConnectionsFlow(var6_17, (String)var3_7, var7_18, elementsSessionContext), (Continuation)$continuation);
            if (v5 == var17_4) {
                return var17_4;
            }
        }
        ** GOTO lbl144
        {
            case 5: {
                $i$a$-onSuccess-CollectBankAccountViewModel$createFinancialConnectionsSession$3 = false;
                var2_5 = $continuation.L$1;
                this = (CollectBankAccountViewModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl144:
                // 2 sources

                v6 = Result.exceptionOrNull-impl((Object)var2_5);
                if (v6 == null) break;
                it = var3_7 = v6;
                $i$a$-onFailure-CollectBankAccountViewModel$createFinancialConnectionsSession$4 = false;
                $continuation.L$0 = var2_5;
                $continuation.L$1 = null;
                $continuation.label = 6;
                v7 = this.finishWithError(it, (Continuation<? super Unit>)$continuation);
                if (v7 == var17_4) {
                    return var17_4;
                }
                break;
            }
            case 6: {
                $i$a$-onFailure-CollectBankAccountViewModel$createFinancialConnectionsSession$4 = false;
                var2_6 = $continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
                break;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void onConnectionsForACHResult(@NotNull FinancialConnectionsSheetResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.setHasLaunched(false);
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(result, this, null){
            int label;
            final /* synthetic */ FinancialConnectionsSheetResult $result;
            final /* synthetic */ CollectBankAccountViewModel this$0;
            {
                this.$result = $result;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                block11: {
                    FinancialConnectionsSheetResult financialConnectionsSheetResult;
                    block12: {
                        void $result;
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                financialConnectionsSheetResult = this.$result;
                                if (!(financialConnectionsSheetResult instanceof FinancialConnectionsSheetResult.Canceled)) break;
                                this.label = 1;
                                Object object3 = CollectBankAccountViewModel.access$finishWithResult(this.this$0, CollectBankAccountResultInternal.Cancelled.INSTANCE, (Continuation)this);
                                if (object3 == object2) {
                                    return object2;
                                }
                                break block11;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                break block11;
                            }
                        }
                        if (!(financialConnectionsSheetResult instanceof FinancialConnectionsSheetResult.Failed)) break block12;
                        this.label = 2;
                        Object object4 = CollectBankAccountViewModel.access$finishWithError(this.this$0, ((FinancialConnectionsSheetResult.Failed)this.$result).getError(), (Continuation)this);
                        if (object4 == object2) {
                            return object2;
                        }
                        break block11;
                        {
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                object4 = $result;
                                break block11;
                            }
                        }
                    }
                    if (financialConnectionsSheetResult instanceof FinancialConnectionsSheetResult.Completed) {
                        if (CollectBankAccountViewModel.access$getArgs$p(this.this$0).getAttachToIntent()) {
                            CollectBankAccountViewModel.access$attachSessionToIntent(this.this$0, ((FinancialConnectionsSheetResult.Completed)this.$result).getFinancialConnectionsSession());
                        } else {
                            CollectBankAccountViewModel.access$finishWithSession(this.this$0, ((FinancialConnectionsSheetResult.Completed)this.$result).getFinancialConnectionsSession());
                        }
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void onConnectionsForInstantDebitsResult(@NotNull FinancialConnectionsSheetInstantDebitsResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.setHasLaunched(false);
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(result, this, null){
            int label;
            final /* synthetic */ FinancialConnectionsSheetInstantDebitsResult $result;
            final /* synthetic */ CollectBankAccountViewModel this$0;
            {
                this.$result = $result;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                block9: {
                    FinancialConnectionsSheetInstantDebitsResult financialConnectionsSheetInstantDebitsResult;
                    block10: {
                        void $result;
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                financialConnectionsSheetInstantDebitsResult = this.$result;
                                if (!(financialConnectionsSheetInstantDebitsResult instanceof FinancialConnectionsSheetInstantDebitsResult.Canceled)) break;
                                this.label = 1;
                                Object object3 = CollectBankAccountViewModel.access$finishWithResult(this.this$0, CollectBankAccountResultInternal.Cancelled.INSTANCE, (Continuation)this);
                                if (object3 == object2) {
                                    return object2;
                                }
                                break block9;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                break block9;
                            }
                        }
                        if (!(financialConnectionsSheetInstantDebitsResult instanceof FinancialConnectionsSheetInstantDebitsResult.Failed)) break block10;
                        this.label = 2;
                        Object object4 = CollectBankAccountViewModel.access$finishWithError(this.this$0, ((FinancialConnectionsSheetInstantDebitsResult.Failed)this.$result).getError(), (Continuation)this);
                        if (object4 == object2) {
                            return object2;
                        }
                        break block9;
                        {
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                object4 = $result;
                                break block9;
                            }
                        }
                    }
                    if (financialConnectionsSheetInstantDebitsResult instanceof FinancialConnectionsSheetInstantDebitsResult.Completed) {
                        CollectBankAccountViewModel.access$finishWithPaymentMethodId(this.this$0, (FinancialConnectionsSheetInstantDebitsResult.Completed)this.$result);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object finishWithResult(CollectBankAccountResultInternal result, Continuation<? super Unit> $completion) {
        Object object = this._viewEffect.emit((Object)new CollectBankAccountViewEffect.FinishWithResult(result), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void finishWithSession(FinancialConnectionsSession financialConnectionsSession) {
        this.finishWithRefreshedIntent((Function1<? super StripeIntent, CollectBankAccountResponseInternal>)((Function1)arg_0 -> CollectBankAccountViewModel.finishWithSession$lambda$3(financialConnectionsSession, arg_0)));
    }

    private final void finishWithPaymentMethodId(FinancialConnectionsSheetInstantDebitsResult.Completed result) {
        this.finishWithRefreshedIntent((Function1<? super StripeIntent, CollectBankAccountResponseInternal>)((Function1)arg_0 -> CollectBankAccountViewModel.finishWithPaymentMethodId$lambda$5(this, result, arg_0)));
    }

    private final PaymentMethod parsePaymentMethod(String $this$parsePaymentMethod) {
        PaymentMethod paymentMethod;
        try {
            PaymentMethod paymentMethod2;
            JSONObject json = new JSONObject($this$parsePaymentMethod);
            paymentMethod = paymentMethod2 = new PaymentMethodJsonParser().parse(json);
        }
        catch (Exception e) {
            this.logger.error("Failed to parse PaymentMethod", (Throwable)e);
            paymentMethod = null;
        }
        return paymentMethod;
    }

    private final void finishWithRefreshedIntent(Function1<? super StripeIntent, CollectBankAccountResponseInternal> action) {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, action, null){
            Object L$0;
            int label;
            final /* synthetic */ CollectBankAccountViewModel this$0;
            final /* synthetic */ Function1<StripeIntent, CollectBankAccountResponseInternal> $action;
            {
                this.this$0 = $receiver;
                this.$action = $action;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        clientSecret = CollectBankAccountViewModel.access$getArgs$p(this.this$0).getClientSecret();
                        if (clientSecret == null) {
                            v0 = Result.constructor-impl(null);
                        } else {
                            this.label = 1;
                            v0 = CollectBankAccountViewModel.access$getRetrieveStripeIntent$p(this.this$0).invoke-0E7RQCE(CollectBankAccountViewModel.access$getArgs$p(this.this$0).getPublishableKey(), clientSecret, (Continuation<? super Result<? extends StripeIntent>>)((Continuation)this));
                            if (v0 == var10_2) {
                                return var10_2;
                            }
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = ((Result)$result).unbox-impl();
lbl18:
                        // 3 sources

                        var4_5 = retrieveIntentResult = v0;
                        var5_7 = this.this$0;
                        v1 = Result.exceptionOrNull-impl((Object)var4_5);
                        if (v1 == null) break;
                        it = var6_8 /* !! */  = v1;
                        $i$a$-onFailure-CollectBankAccountViewModel$finishWithRefreshedIntent$1$1 = false;
                        this.L$0 = var4_5;
                        this.label = 2;
                        v2 = CollectBankAccountViewModel.access$finishWithError(var5_7, it, (Continuation)this);
                        if (v2 == var10_2) {
                            return var10_2;
                        }
                        break;
                    }
                    case 2: {
                        $i$a$-onFailure-CollectBankAccountViewModel$finishWithRefreshedIntent$1$1 = false;
                        var4_5 = this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break;
                    }
                }
                var5_7 = this.$action;
                var6_8 /* !! */  = this.this$0;
                if (Result.isSuccess-impl((Object)var4_5)) {
                    intent = (StripeIntent)var4_5;
                    $i$a$-onSuccess-CollectBankAccountViewModel$finishWithRefreshedIntent$1$2 = false;
                    response = (CollectBankAccountResponseInternal)var5_7.invoke((Object)intent);
                    this.L$0 = var4_5;
                    this.label = 3;
                    v3 = CollectBankAccountViewModel.access$finishWithResult((CollectBankAccountViewModel)var6_8 /* !! */ , new CollectBankAccountResultInternal.Completed(response), (Continuation)this);
                    if (v3 == var10_2) {
                        return var10_2;
                    }
                }
                ** GOTO lbl54
                {
                    case 3: {
                        $i$a$-onSuccess-CollectBankAccountViewModel$finishWithRefreshedIntent$1$2 = false;
                        var4_6 = this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl54:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void attachSessionToIntent(FinancialConnectionsSession financialConnectionsSession) {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, financialConnectionsSession, null){
            Object L$0;
            int label;
            final /* synthetic */ CollectBankAccountViewModel this$0;
            final /* synthetic */ FinancialConnectionsSession $financialConnectionsSession;
            {
                this.this$0 = $receiver;
                this.$financialConnectionsSession = $financialConnectionsSession;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block17: {
                    block18: {
                        var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                var2_3 = CollectBankAccountViewModel.access$getArgs$p(this.this$0);
                                if (var2_3 instanceof CollectBankAccountContract.Args.ForDeferredPaymentIntent || var2_3 instanceof CollectBankAccountContract.Args.ForDeferredSetupIntent) {
                                    throw new IllegalStateException("Attach requires client secret".toString());
                                }
                                if (!(var2_3 instanceof CollectBankAccountContract.Args.ForPaymentIntent)) break;
                                var3_5 = CollectBankAccountViewModel.access$getAttachFinancialConnectionsSession$p(this.this$0);
                                var4_6 = ((CollectBankAccountContract.Args.ForPaymentIntent)CollectBankAccountViewModel.access$getArgs$p(this.this$0)).getPublishableKey();
                                var5_7 = ((CollectBankAccountContract.Args.ForPaymentIntent)CollectBankAccountViewModel.access$getArgs$p(this.this$0)).getStripeAccountId();
                                var6_10 = ((CollectBankAccountContract.Args.ForPaymentIntent)CollectBankAccountViewModel.access$getArgs$p(this.this$0)).getClientSecret();
                                var7_14 = this.$financialConnectionsSession.getId();
                                this.label = 1;
                                v0 = var3_5.forPaymentIntent-yxL6bBk((String)var4_6, var7_14, var6_10, (String)var5_7, (Continuation<? super Result<PaymentIntent>>)((Continuation)this));
                                if (v0 == var8_2) {
                                    return var8_2;
                                }
                                break block17;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = ((Result)$result).unbox-impl();
                                break block17;
                            }
                        }
                        if (!(var2_3 instanceof CollectBankAccountContract.Args.ForSetupIntent)) break block18;
                        var3_5 = CollectBankAccountViewModel.access$getAttachFinancialConnectionsSession$p(this.this$0);
                        var4_6 = ((CollectBankAccountContract.Args.ForSetupIntent)CollectBankAccountViewModel.access$getArgs$p(this.this$0)).getPublishableKey();
                        var5_7 = ((CollectBankAccountContract.Args.ForSetupIntent)CollectBankAccountViewModel.access$getArgs$p(this.this$0)).getStripeAccountId();
                        var6_10 = ((CollectBankAccountContract.Args.ForSetupIntent)CollectBankAccountViewModel.access$getArgs$p(this.this$0)).getClientSecret();
                        var7_14 = this.$financialConnectionsSession.getId();
                        this.label = 2;
                        v0 = var3_5.forSetupIntent-yxL6bBk((String)var4_6, var7_14, var6_10, (String)var5_7, (Continuation<? super Result<SetupIntent>>)((Continuation)this));
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        break block17;
                        {
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = ((Result)$result).unbox-impl();
                                break block17;
                            }
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                var2_3 = v0;
                var3_5 = this.$financialConnectionsSession;
                if (Result.isSuccess-impl((Object)var2_3)) {
                    var4_6 = var2_3;
                    try {
                        var5_7 = var4_6;
                        stripeIntent = (StripeIntent)var5_7;
                        $i$a$-mapCatching-CollectBankAccountViewModel$attachSessionToIntent$1$1 = false;
                        var5_7 = Result.constructor-impl((Object)new CollectBankAccountResultInternal.Completed(new CollectBankAccountResponseInternal(stripeIntent, new CollectBankAccountResponseInternal.USBankAccountData((FinancialConnectionsSession)var3_5), null)));
                    }
                    catch (Throwable stripeIntent) {
                        var5_7 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)stripeIntent));
                    }
                    v1 = var5_7;
                } else {
                    v1 = Result.constructor-impl((Object)var2_3);
                }
                var2_3 = v1;
                var3_5 = this.this$0;
                if (Result.isSuccess-impl((Object)var2_3)) {
                    result = (CollectBankAccountResultInternal.Completed)var2_3;
                    $i$a$-onSuccess-CollectBankAccountViewModel$attachSessionToIntent$1$2 = false;
                    CollectBankAccountViewModel.access$getLogger$p((CollectBankAccountViewModel)var3_5).debug("Bank account session attached to intent!!");
                    this.L$0 = var2_3;
                    this.label = 3;
                    v2 = CollectBankAccountViewModel.access$finishWithResult((CollectBankAccountViewModel)var3_5, result, (Continuation)this);
                    if (v2 == var8_2) {
                        return var8_2;
                    }
                }
                ** GOTO lbl77
                {
                    case 3: {
                        $i$a$-onSuccess-CollectBankAccountViewModel$attachSessionToIntent$1$2 = false;
                        var2_3 = this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl77:
                        // 2 sources

                        var3_5 = this.this$0;
                        v3 = Result.exceptionOrNull-impl((Object)var2_3);
                        if (v3 == null) break;
                        it = var4_6 = v3;
                        $i$a$-onFailure-CollectBankAccountViewModel$attachSessionToIntent$1$3 = false;
                        this.L$0 = var2_3;
                        this.label = 4;
                        v4 = CollectBankAccountViewModel.access$finishWithError((CollectBankAccountViewModel)var3_5, (Throwable)it, (Continuation)this);
                        if (v4 == var8_2) {
                            return var8_2;
                        }
                        break;
                    }
                    case 4: {
                        $i$a$-onFailure-CollectBankAccountViewModel$attachSessionToIntent$1$3 = false;
                        var2_4 = this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object finishWithError(Throwable throwable, Continuation<? super Unit> $completion) {
        this.logger.error("Error", (Throwable)new Exception(throwable));
        Object object = this.finishWithResult(new CollectBankAccountResultInternal.Failed(throwable), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final CollectBankAccountResponseInternal finishWithSession$lambda$3(FinancialConnectionsSession $financialConnectionsSession, StripeIntent intent) {
        return new CollectBankAccountResponseInternal(intent, new CollectBankAccountResponseInternal.USBankAccountData($financialConnectionsSession), null);
    }

    /*
     * WARNING - void declaration
     */
    private static final CollectBankAccountResponseInternal finishWithPaymentMethodId$lambda$5(CollectBankAccountViewModel this$0, FinancialConnectionsSheetInstantDebitsResult.Completed $result, StripeIntent intent) {
        CollectBankAccountResponseInternal.InstantDebitsData instantDebitsData;
        PaymentMethod paymentMethod = this$0.parsePaymentMethod($result.getEncodedPaymentMethod());
        StripeIntent stripeIntent = intent;
        CollectBankAccountResponseInternal.USBankAccountData uSBankAccountData = null;
        PaymentMethod paymentMethod2 = paymentMethod;
        if (paymentMethod2 != null) {
            void it;
            PaymentMethod paymentMethod3 = paymentMethod2;
            CollectBankAccountResponseInternal.USBankAccountData uSBankAccountData2 = uSBankAccountData;
            StripeIntent stripeIntent2 = stripeIntent;
            boolean bl = false;
            CollectBankAccountResponseInternal.InstantDebitsData instantDebitsData2 = new CollectBankAccountResponseInternal.InstantDebitsData((PaymentMethod)it, $result.getLast4(), $result.getBankName(), $result.getEligibleForIncentive());
            stripeIntent = stripeIntent2;
            uSBankAccountData = uSBankAccountData2;
            instantDebitsData = instantDebitsData2;
        } else {
            instantDebitsData = null;
        }
        CollectBankAccountResponseInternal.InstantDebitsData instantDebitsData3 = instantDebitsData;
        CollectBankAccountResponseInternal.USBankAccountData uSBankAccountData3 = uSBankAccountData;
        StripeIntent stripeIntent3 = stripeIntent;
        return new CollectBankAccountResponseInternal(stripeIntent3, uSBankAccountData3, instantDebitsData3);
    }

    public static final /* synthetic */ Object access$finishWithResult(CollectBankAccountViewModel $this, CollectBankAccountResultInternal result, Continuation $completion) {
        return $this.finishWithResult(result, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$finishWithError(CollectBankAccountViewModel $this, Throwable throwable, Continuation $completion) {
        return $this.finishWithError(throwable, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ CollectBankAccountContract.Args access$getArgs$p(CollectBankAccountViewModel $this) {
        return $this.args;
    }

    public static final /* synthetic */ void access$attachSessionToIntent(CollectBankAccountViewModel $this, FinancialConnectionsSession financialConnectionsSession) {
        $this.attachSessionToIntent(financialConnectionsSession);
    }

    public static final /* synthetic */ void access$finishWithSession(CollectBankAccountViewModel $this, FinancialConnectionsSession financialConnectionsSession) {
        $this.finishWithSession(financialConnectionsSession);
    }

    public static final /* synthetic */ void access$finishWithPaymentMethodId(CollectBankAccountViewModel $this, FinancialConnectionsSheetInstantDebitsResult.Completed result) {
        $this.finishWithPaymentMethodId(result);
    }

    public static final /* synthetic */ RetrieveStripeIntent access$getRetrieveStripeIntent$p(CollectBankAccountViewModel $this) {
        return $this.retrieveStripeIntent;
    }

    public static final /* synthetic */ AttachFinancialConnectionsSession access$getAttachFinancialConnectionsSession$p(CollectBankAccountViewModel $this) {
        return $this.attachFinancialConnectionsSession;
    }

    public static final /* synthetic */ Logger access$getLogger$p(CollectBankAccountViewModel $this) {
        return $this.logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/payments/bankaccount/ui/CollectBankAccountViewModel$Companion;", "", "<init>", "()V", "KEY_HAS_LAUNCHED", "", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J-\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/payments/bankaccount/ui/CollectBankAccountViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "argsSupplier", "Lkotlin/Function0;", "Lcom/stripe/android/payments/bankaccount/navigation/CollectBankAccountContract$Args;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "extras", "Landroidx/lifecycle/viewmodel/CreationExtras;", "(Ljava/lang/Class;Landroidx/lifecycle/viewmodel/CreationExtras;)Landroidx/lifecycle/ViewModel;", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class Factory
    implements ViewModelProvider.Factory {
        @NotNull
        private final Function0<CollectBankAccountContract.Args> argsSupplier;
        public static final int $stable;

        public Factory(@NotNull Function0<? extends CollectBankAccountContract.Args> argsSupplier) {
            Intrinsics.checkNotNullParameter(argsSupplier, (String)"argsSupplier");
            this.argsSupplier = argsSupplier;
        }

        @NotNull
        public <T extends ViewModel> T create(@NotNull Class<T> modelClass, @NotNull CreationExtras extras) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
            Application application = CreationExtrasKtxKt.requireApplication((CreationExtras)extras);
            SavedStateHandle savedStateHandle = SavedStateHandleSupport.createSavedStateHandle((CreationExtras)extras);
            CollectBankAccountViewModel collectBankAccountViewModel = DaggerCollectBankAccountComponent.builder().savedStateHandle(savedStateHandle).application(application).viewEffect((MutableSharedFlow<CollectBankAccountViewEffect>)SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null)).configuration((CollectBankAccountContract.Args)this.argsSupplier.invoke()).build().getViewModel();
            Intrinsics.checkNotNull((Object)((Object)collectBankAccountViewModel), (String)"null cannot be cast to non-null type T of com.stripe.android.payments.bankaccount.ui.CollectBankAccountViewModel.Factory.create");
            return (T)((Object)collectBankAccountViewModel);
        }
    }
}

