/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.DeferredIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.StripeIntent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B/\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/model/parsers/DeferredPaymentIntentJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentIntent;", "elementsSessionId", "", "paymentMode", "Lcom/stripe/android/model/DeferredIntentParams$Mode$Payment;", "isLiveMode", "", "timeProvider", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Lcom/stripe/android/model/DeferredIntentParams$Mode$Payment;ZLkotlin/jvm/functions/Function0;)V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDeferredPaymentIntentJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeferredPaymentIntentJsonParser.kt\ncom/stripe/android/model/parsers/DeferredPaymentIntentJsonParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1557#2:62\n1628#2,3:63\n1557#2:66\n1628#2,3:67\n*S KotlinDebug\n*F\n+ 1 DeferredPaymentIntentJsonParser.kt\ncom/stripe/android/model/parsers/DeferredPaymentIntentJsonParser\n*L\n25#1:62\n25#1:63,3\n28#1:66\n28#1:67,3\n*E\n"})
public final class DeferredPaymentIntentJsonParser
implements ModelJsonParser<PaymentIntent> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final String elementsSessionId;
    @NotNull
    private final DeferredIntentParams.Mode.Payment paymentMode;
    private final boolean isLiveMode;
    @NotNull
    private final Function0<Long> timeProvider;
    public static final int $stable = 8;
    @NotNull
    private static final String FIELD_COUNTRY_CODE = "country_code";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_TYPES = "payment_method_types";
    @NotNull
    private static final String FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES = "unactivated_payment_method_types";
    @NotNull
    private static final String FIELD_LINK_FUNDING_SOURCES = "link_funding_sources";

    public DeferredPaymentIntentJsonParser(@Nullable String elementsSessionId, @NotNull DeferredIntentParams.Mode.Payment paymentMode, boolean isLiveMode, @NotNull Function0<Long> timeProvider) {
        Intrinsics.checkNotNullParameter((Object)paymentMode, (String)"paymentMode");
        Intrinsics.checkNotNullParameter(timeProvider, (String)"timeProvider");
        this.elementsSessionId = elementsSessionId;
        this.paymentMode = paymentMode;
        this.isLiveMode = isLiveMode;
        this.timeProvider = timeProvider;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PaymentIntent parse(@NotNull JSONObject json) {
        PaymentIntent.CaptureMethod captureMethod;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        Object object;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        List paymentMethodTypes = ModelJsonParser.Companion.jsonArrayToList(json.optJSONArray(FIELD_PAYMENT_METHOD_TYPES));
        Iterable iterable = ModelJsonParser.Companion.jsonArrayToList(json.optJSONArray(FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES));
        boolean $i$f$map22 = false;
        void var6_6 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            object = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            collection.add(string2);
        }
        List unactivatedPaymentMethods = (List)destination$iv$iv;
        Iterable $i$f$map22 = ModelJsonParser.Companion.jsonArrayToList(json.optJSONArray(FIELD_LINK_FUNDING_SOURCES));
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string3 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            collection.add(string3);
        }
        List linkFundingSources = (List)destination$iv$iv2;
        String countryCode = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_COUNTRY_CODE);
        switch (WhenMappings.$EnumSwitchMapping$0[this.paymentMode.getCaptureMethod().ordinal()]) {
            case 1: {
                captureMethod = PaymentIntent.CaptureMethod.Automatic;
                break;
            }
            case 2: {
                captureMethod = PaymentIntent.CaptureMethod.AutomaticAsync;
                break;
            }
            case 3: {
                captureMethod = PaymentIntent.CaptureMethod.Manual;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PaymentIntent.CaptureMethod captureMethod2 = captureMethod;
        String string4 = this.elementsSessionId;
        boolean bl = this.isLiveMode;
        long l = ((Number)this.timeProvider.invoke()).longValue();
        object = this.paymentMode.getSetupFutureUsage();
        long l2 = this.paymentMode.getAmount();
        String string5 = this.paymentMode.getCurrency();
        return new PaymentIntent(string4, paymentMethodTypes, l2, 0L, null, captureMethod2, null, null, countryCode, l, string5, null, bl, null, null, null, null, (StripeIntent.Usage)((Object)object), null, null, unactivatedPaymentMethods, linkFundingSources, null, null, 13494424, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/DeferredPaymentIntentJsonParser$Companion;", "", "<init>", "()V", "FIELD_COUNTRY_CODE", "", "FIELD_PAYMENT_METHOD_TYPES", "FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES", "FIELD_LINK_FUNDING_SOURCES", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaymentIntent.CaptureMethod.values().length];
            try {
                nArray[PaymentIntent.CaptureMethod.Automatic.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentIntent.CaptureMethod.AutomaticAsync.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentIntent.CaptureMethod.Manual.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

