/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.StripeModel;
import com.stripe.android.model.Address;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.parsers.PaymentIntentJsonParser;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b)\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0087\b\u0018\u0000 \u008c\u00012\u00020\u0001:\u000e\u0086\u0001\u0087\u0001\u0088\u0001\u0089\u0001\u008a\u0001\u008b\u0001\u008c\u0001B\u0099\u0002\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0007\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u0012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u0012\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u0012\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!\u0012\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%\u0012\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b'\u0010(J\u0016\u0010N\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010P0OH\u0016J\b\u0010Z\u001a\u00020\u0015H\u0016J\b\u0010[\u001a\u00020\u0015H\u0016J\u0014\u0010\\\u001a\u00020\u00152\n\u0010]\u001a\u00060\u0003j\u0002`^H\u0007J\b\u0010_\u001a\u00020\u0015H\u0002J\u0014\u0010`\u001a\u00020\u00152\n\u0010]\u001a\u00060\u0003j\u0002`^H\u0002J\u000b\u0010a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u0010\u0010c\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010.J\t\u0010d\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010e\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010f\u001a\u00020\fH\u00c6\u0003J\u000b\u0010g\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010h\u001a\u00020\u000fH\u00c6\u0003J\u000b\u0010i\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010j\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010k\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010l\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010m\u001a\u00020\u0015H\u00c6\u0003J\u000b\u0010n\u001a\u0004\u0018\u00010\u0017H\u00c6\u0003J\u000b\u0010o\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010p\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010q\u001a\u0004\u0018\u00010\u001bH\u00c6\u0003J\u000b\u0010r\u001a\u0004\u0018\u00010\u001dH\u00c6\u0003J\u000b\u0010s\u001a\u0004\u0018\u00010\u001fH\u00c6\u0003J\u000b\u0010t\u001a\u0004\u0018\u00010!H\u00c6\u0003J\u000f\u0010u\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010v\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000b\u0010w\u001a\u0004\u0018\u00010%H\u00c6\u0003J\u000b\u0010x\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u00b0\u0002\u0010y\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u00072\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010zJ\u0006\u0010{\u001a\u00020|J\u0013\u0010}\u001a\u00020\u00152\b\u0010~\u001a\u0004\u0018\u00010PH\u00d6\u0003J\t\u0010\u007f\u001a\u00020|H\u00d6\u0001J\n\u0010\u0080\u0001\u001a\u00020\u0003H\u00d6\u0001J\u001b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0085\u0001\u001a\u00020|R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010/\u001a\u0004\b-\u0010.R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0016\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010*R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00038WX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010*R\u0014\u0010\u0011\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u00101R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010*R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010*R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010=R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010*R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010*R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0013\u0010 \u001a\u0004\u0018\u00010!\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010,R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010,R\u0016\u0010$\u001a\u0004\u0018\u00010%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010MR\u0010\u0010&\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010Q\u001a\u0004\u0018\u00010R8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR\u0014\u0010U\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010=R\u0016\u0010V\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010*R\u0011\u0010X\u001a\u00020\u00158G\u00a2\u0006\u0006\u001a\u0004\bY\u0010=\u00a8\u0006\u008d\u0001"}, d2={"Lcom/stripe/android/model/PaymentIntent;", "Lcom/stripe/android/model/StripeIntent;", "id", "", "paymentMethodTypes", "", "amount", "", "canceledAt", "cancellationReason", "Lcom/stripe/android/model/PaymentIntent$CancellationReason;", "captureMethod", "Lcom/stripe/android/model/PaymentIntent$CaptureMethod;", "clientSecret", "confirmationMethod", "Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod;", "countryCode", "created", "currency", "description", "isLiveMode", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "paymentMethodId", "receiptEmail", "status", "Lcom/stripe/android/model/StripeIntent$Status;", "setupFutureUsage", "Lcom/stripe/android/model/StripeIntent$Usage;", "lastPaymentError", "Lcom/stripe/android/model/PaymentIntent$Error;", "shipping", "Lcom/stripe/android/model/PaymentIntent$Shipping;", "unactivatedPaymentMethods", "linkFundingSources", "nextActionData", "Lcom/stripe/android/model/StripeIntent$NextActionData;", "paymentMethodOptionsJsonString", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/Long;JLcom/stripe/android/model/PaymentIntent$CancellationReason;Lcom/stripe/android/model/PaymentIntent$CaptureMethod;Ljava/lang/String;Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;ZLcom/stripe/android/model/PaymentMethod;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/model/StripeIntent$Status;Lcom/stripe/android/model/StripeIntent$Usage;Lcom/stripe/android/model/PaymentIntent$Error;Lcom/stripe/android/model/PaymentIntent$Shipping;Ljava/util/List;Ljava/util/List;Lcom/stripe/android/model/StripeIntent$NextActionData;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getPaymentMethodTypes", "()Ljava/util/List;", "getAmount", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getCanceledAt", "()J", "getCancellationReason", "()Lcom/stripe/android/model/PaymentIntent$CancellationReason;", "getCaptureMethod", "()Lcom/stripe/android/model/PaymentIntent$CaptureMethod;", "getClientSecret", "getConfirmationMethod", "()Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod;", "getCountryCode", "getCreated", "getCurrency", "getDescription", "()Z", "getPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "getPaymentMethodId", "getReceiptEmail", "getStatus", "()Lcom/stripe/android/model/StripeIntent$Status;", "getSetupFutureUsage", "()Lcom/stripe/android/model/StripeIntent$Usage;", "getLastPaymentError", "()Lcom/stripe/android/model/PaymentIntent$Error;", "getShipping", "()Lcom/stripe/android/model/PaymentIntent$Shipping;", "getUnactivatedPaymentMethods", "getLinkFundingSources", "getNextActionData", "()Lcom/stripe/android/model/StripeIntent$NextActionData;", "getPaymentMethodOptions", "", "", "nextActionType", "Lcom/stripe/android/model/StripeIntent$NextActionType;", "getNextActionType", "()Lcom/stripe/android/model/StripeIntent$NextActionType;", "isConfirmed", "lastErrorMessage", "getLastErrorMessage", "requireCvcRecollection", "getRequireCvcRecollection", "requiresAction", "requiresConfirmation", "isSetupFutureUsageSet", "code", "Lcom/stripe/android/model/PaymentMethodCode;", "isTopLevelSetupFutureUsageSet", "isLpmLevelSetupFutureUsageSet", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component20", "component21", "component22", "component23", "component24", "copy", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/Long;JLcom/stripe/android/model/PaymentIntent$CancellationReason;Lcom/stripe/android/model/PaymentIntent$CaptureMethod;Ljava/lang/String;Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;ZLcom/stripe/android/model/PaymentMethod;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/model/StripeIntent$Status;Lcom/stripe/android/model/StripeIntent$Usage;Lcom/stripe/android/model/PaymentIntent$Error;Lcom/stripe/android/model/PaymentIntent$Shipping;Ljava/util/List;Ljava/util/List;Lcom/stripe/android/model/StripeIntent$NextActionData;Ljava/lang/String;)Lcom/stripe/android/model/PaymentIntent;", "describeContents", "", "equals", "other", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "Error", "Shipping", "ClientSecret", "CancellationReason", "CaptureMethod", "ConfirmationMethod", "Companion", "payments-core_release"})
@Parcelize
@StabilityInferred(parameters=0)
public final class PaymentIntent
implements StripeIntent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String id;
    @NotNull
    private final List<String> paymentMethodTypes;
    @Nullable
    private final Long amount;
    private final long canceledAt;
    @Nullable
    private final CancellationReason cancellationReason;
    @NotNull
    private final CaptureMethod captureMethod;
    @Nullable
    private final String clientSecret;
    @NotNull
    private final ConfirmationMethod confirmationMethod;
    @Nullable
    private final String countryCode;
    private final long created;
    @Nullable
    private final String currency;
    @Nullable
    private final String description;
    private final boolean isLiveMode;
    @Nullable
    private final PaymentMethod paymentMethod;
    @Nullable
    private final String paymentMethodId;
    @Nullable
    private final String receiptEmail;
    @Nullable
    private final StripeIntent.Status status;
    @Nullable
    private final StripeIntent.Usage setupFutureUsage;
    @Nullable
    private final Error lastPaymentError;
    @Nullable
    private final Shipping shipping;
    @NotNull
    private final List<String> unactivatedPaymentMethods;
    @NotNull
    private final List<String> linkFundingSources;
    @Nullable
    private final StripeIntent.NextActionData nextActionData;
    @Nullable
    private final String paymentMethodOptionsJsonString;
    @NotNull
    public static final Parcelable.Creator<PaymentIntent> CREATOR;
    public static final int $stable;
    @NotNull
    public static final String CARD = "card";
    @NotNull
    public static final String REQUIRE_CVC_RECOLLECTION = "require_cvc_recollection";

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public PaymentIntent(@Nullable String id2, @NotNull List<String> paymentMethodTypes, @Nullable Long amount, long canceledAt, @Nullable CancellationReason cancellationReason, @NotNull CaptureMethod captureMethod, @Nullable String clientSecret, @NotNull ConfirmationMethod confirmationMethod, @Nullable String countryCode, long created, @Nullable String currency, @Nullable String description, boolean isLiveMode, @Nullable PaymentMethod paymentMethod, @Nullable String paymentMethodId, @Nullable String receiptEmail, @Nullable StripeIntent.Status status, @Nullable StripeIntent.Usage setupFutureUsage, @Nullable Error lastPaymentError, @Nullable Shipping shipping, @NotNull List<String> unactivatedPaymentMethods, @NotNull List<String> linkFundingSources, @Nullable StripeIntent.NextActionData nextActionData, @Nullable String paymentMethodOptionsJsonString) {
        Intrinsics.checkNotNullParameter(paymentMethodTypes, (String)"paymentMethodTypes");
        Intrinsics.checkNotNullParameter((Object)((Object)captureMethod), (String)"captureMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)confirmationMethod), (String)"confirmationMethod");
        Intrinsics.checkNotNullParameter(unactivatedPaymentMethods, (String)"unactivatedPaymentMethods");
        Intrinsics.checkNotNullParameter(linkFundingSources, (String)"linkFundingSources");
        this.id = id2;
        this.paymentMethodTypes = paymentMethodTypes;
        this.amount = amount;
        this.canceledAt = canceledAt;
        this.cancellationReason = cancellationReason;
        this.captureMethod = captureMethod;
        this.clientSecret = clientSecret;
        this.confirmationMethod = confirmationMethod;
        this.countryCode = countryCode;
        this.created = created;
        this.currency = currency;
        this.description = description;
        this.isLiveMode = isLiveMode;
        this.paymentMethod = paymentMethod;
        this.paymentMethodId = paymentMethodId;
        this.receiptEmail = receiptEmail;
        this.status = status;
        this.setupFutureUsage = setupFutureUsage;
        this.lastPaymentError = lastPaymentError;
        this.shipping = shipping;
        this.unactivatedPaymentMethods = unactivatedPaymentMethods;
        this.linkFundingSources = linkFundingSources;
        this.nextActionData = nextActionData;
        this.paymentMethodOptionsJsonString = paymentMethodOptionsJsonString;
    }

    public /* synthetic */ PaymentIntent(String string2, List list, Long l, long l2, CancellationReason cancellationReason, CaptureMethod captureMethod, String string3, ConfirmationMethod confirmationMethod, String string4, long l3, String string5, String string6, boolean bl, PaymentMethod paymentMethod, String string7, String string8, StripeIntent.Status status, StripeIntent.Usage usage, Error error, Shipping shipping, List list2, List list3, StripeIntent.NextActionData nextActionData, String string9, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l2 = 0L;
        }
        if ((n & 0x10) != 0) {
            cancellationReason = null;
        }
        if ((n & 0x20) != 0) {
            captureMethod = CaptureMethod.Automatic;
        }
        if ((n & 0x80) != 0) {
            confirmationMethod = ConfirmationMethod.Automatic;
        }
        if ((n & 0x800) != 0) {
            string6 = null;
        }
        if ((n & 0x2000) != 0) {
            paymentMethod = null;
        }
        if ((n & 0x4000) != 0) {
            string7 = null;
        }
        if ((n & 0x8000) != 0) {
            string8 = null;
        }
        if ((n & 0x10000) != 0) {
            status = null;
        }
        if ((n & 0x20000) != 0) {
            usage = null;
        }
        if ((n & 0x40000) != 0) {
            error = null;
        }
        if ((n & 0x80000) != 0) {
            shipping = null;
        }
        if ((n & 0x200000) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x400000) != 0) {
            nextActionData = null;
        }
        if ((n & 0x800000) != 0) {
            string9 = null;
        }
        this(string2, list, l, l2, cancellationReason, captureMethod, string3, confirmationMethod, string4, l3, string5, string6, bl, paymentMethod, string7, string8, status, usage, error, shipping, list2, list3, nextActionData, string9);
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Nullable
    public final Long getAmount() {
        return this.amount;
    }

    public final long getCanceledAt() {
        return this.canceledAt;
    }

    @Nullable
    public final CancellationReason getCancellationReason() {
        return this.cancellationReason;
    }

    @NotNull
    public final CaptureMethod getCaptureMethod() {
        return this.captureMethod;
    }

    @Override
    @Nullable
    public String getClientSecret() {
        return this.clientSecret;
    }

    @NotNull
    public final ConfirmationMethod getConfirmationMethod() {
        return this.confirmationMethod;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    @Nullable
    public final String getCurrency() {
        return this.currency;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isLiveMode() {
        return this.isLiveMode;
    }

    @Override
    @Nullable
    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @Override
    @Nullable
    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    @Nullable
    public final String getReceiptEmail() {
        return this.receiptEmail;
    }

    @Override
    @Nullable
    public StripeIntent.Status getStatus() {
        return this.status;
    }

    @Nullable
    public final StripeIntent.Usage getSetupFutureUsage() {
        return this.setupFutureUsage;
    }

    @Nullable
    public final Error getLastPaymentError() {
        return this.lastPaymentError;
    }

    @Nullable
    public final Shipping getShipping() {
        return this.shipping;
    }

    @Override
    @NotNull
    public List<String> getUnactivatedPaymentMethods() {
        return this.unactivatedPaymentMethods;
    }

    @Override
    @NotNull
    public List<String> getLinkFundingSources() {
        return this.linkFundingSources;
    }

    @Override
    @Nullable
    public StripeIntent.NextActionData getNextActionData() {
        return this.nextActionData;
    }

    @Override
    @NotNull
    public Map<String, Object> getPaymentMethodOptions() {
        Object object;
        block3: {
            block2: {
                object = this.paymentMethodOptionsJsonString;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                Map map = StripeJsonUtils.INSTANCE.jsonObjectToMap(new JSONObject(it));
                object = map;
                if (map != null) break block3;
            }
            object = MapsKt.emptyMap();
        }
        return object;
    }

    @Override
    @Nullable
    public StripeIntent.NextActionType getNextActionType() {
        StripeIntent.NextActionType nextActionType;
        StripeIntent.NextActionData nextActionData = this.getNextActionData();
        if (nextActionData instanceof StripeIntent.NextActionData.SdkData) {
            nextActionType = StripeIntent.NextActionType.UseStripeSdk;
        } else if (nextActionData instanceof StripeIntent.NextActionData.RedirectToUrl) {
            nextActionType = StripeIntent.NextActionType.RedirectToUrl;
        } else if (nextActionData instanceof StripeIntent.NextActionData.DisplayOxxoDetails) {
            nextActionType = StripeIntent.NextActionType.DisplayOxxoDetails;
        } else if (nextActionData instanceof StripeIntent.NextActionData.DisplayBoletoDetails) {
            nextActionType = StripeIntent.NextActionType.DisplayBoletoDetails;
        } else if (nextActionData instanceof StripeIntent.NextActionData.DisplayKonbiniDetails) {
            nextActionType = StripeIntent.NextActionType.DisplayKonbiniDetails;
        } else if (nextActionData instanceof StripeIntent.NextActionData.DisplayMultibancoDetails) {
            nextActionType = StripeIntent.NextActionType.DisplayMultibancoDetails;
        } else if (nextActionData instanceof StripeIntent.NextActionData.VerifyWithMicrodeposits) {
            nextActionType = StripeIntent.NextActionType.VerifyWithMicrodeposits;
        } else if (nextActionData instanceof StripeIntent.NextActionData.UpiAwaitNotification) {
            nextActionType = StripeIntent.NextActionType.UpiAwaitNotification;
        } else if (nextActionData instanceof StripeIntent.NextActionData.CashAppRedirect) {
            nextActionType = StripeIntent.NextActionType.CashAppRedirect;
        } else if (nextActionData instanceof StripeIntent.NextActionData.BlikAuthorize) {
            nextActionType = StripeIntent.NextActionType.BlikAuthorize;
        } else if (nextActionData instanceof StripeIntent.NextActionData.SwishRedirect) {
            nextActionType = StripeIntent.NextActionType.SwishRedirect;
        } else if (nextActionData instanceof StripeIntent.NextActionData.AlipayRedirect || nextActionData instanceof StripeIntent.NextActionData.WeChatPayRedirect || nextActionData == null) {
            nextActionType = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return nextActionType;
    }

    @Override
    public boolean isConfirmed() {
        StripeIntent.Status[] statusArray = new StripeIntent.Status[]{StripeIntent.Status.Processing, StripeIntent.Status.RequiresCapture, StripeIntent.Status.Succeeded};
        return CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])statusArray), (Object)((Object)this.getStatus()));
    }

    @Override
    @Nullable
    public String getLastErrorMessage() {
        Error error = this.lastPaymentError;
        return error != null ? error.getMessage() : null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean getRequireCvcRecollection() {
        boolean bl;
        String string2 = this.paymentMethodOptionsJsonString;
        if (string2 != null) {
            String json = string2;
            boolean bl2 = false;
            JSONObject jSONObject = new JSONObject(json).optJSONObject(CARD);
            bl = jSONObject != null ? jSONObject.optBoolean(REQUIRE_CVC_RECOLLECTION) : false;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean requiresAction() {
        return this.getStatus() == StripeIntent.Status.RequiresAction;
    }

    @Override
    public boolean requiresConfirmation() {
        return this.getStatus() == StripeIntent.Status.RequiresConfirmation;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean isSetupFutureUsageSet(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return this.isTopLevelSetupFutureUsageSet() || this.isLpmLevelSetupFutureUsageSet(code);
    }

    private final boolean isTopLevelSetupFutureUsageSet() {
        boolean bl;
        StripeIntent.Usage usage = this.setupFutureUsage;
        switch (usage == null ? -1 : WhenMappings.$EnumSwitchMapping$0[usage.ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            case -1: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean isLpmLevelSetupFutureUsageSet(String code) {
        boolean bl;
        String string2 = this.paymentMethodOptionsJsonString;
        if (string2 != null) {
            JSONObject pmOptions;
            String json = string2;
            boolean bl2 = false;
            JSONObject jSONObject = pmOptions = new JSONObject(json).optJSONObject(code);
            bl = jSONObject != null ? jSONObject.has("setup_future_usage") : false;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeString(this.id);
        dest.writeStringList(this.paymentMethodTypes);
        Object object = this.amount;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeLong(((Long)object).longValue());
        }
        dest.writeLong(this.canceledAt);
        object = this.cancellationReason;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeString(((Enum)object).name());
        }
        dest.writeString(this.captureMethod.name());
        dest.writeString(this.clientSecret);
        dest.writeString(this.confirmationMethod.name());
        dest.writeString(this.countryCode);
        dest.writeLong(this.created);
        dest.writeString(this.currency);
        dest.writeString(this.description);
        dest.writeInt(this.isLiveMode ? 1 : 0);
        object = this.paymentMethod;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            ((PaymentMethod)object).writeToParcel(dest, flags);
        }
        dest.writeString(this.paymentMethodId);
        dest.writeString(this.receiptEmail);
        object = this.status;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeString(((Enum)object).name());
        }
        object = this.setupFutureUsage;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            dest.writeString(((Enum)object).name());
        }
        object = this.lastPaymentError;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            ((Error)object).writeToParcel(dest, flags);
        }
        object = this.shipping;
        if (object == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            ((Shipping)object).writeToParcel(dest, flags);
        }
        dest.writeStringList(this.unactivatedPaymentMethods);
        dest.writeStringList(this.linkFundingSources);
        dest.writeParcelable((Parcelable)this.nextActionData, flags);
        dest.writeString(this.paymentMethodOptionsJsonString);
    }

    public final int describeContents() {
        return 0;
    }

    @Nullable
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final List<String> component2() {
        return this.paymentMethodTypes;
    }

    @Nullable
    public final Long component3() {
        return this.amount;
    }

    public final long component4() {
        return this.canceledAt;
    }

    @Nullable
    public final CancellationReason component5() {
        return this.cancellationReason;
    }

    @NotNull
    public final CaptureMethod component6() {
        return this.captureMethod;
    }

    @Nullable
    public final String component7() {
        return this.clientSecret;
    }

    @NotNull
    public final ConfirmationMethod component8() {
        return this.confirmationMethod;
    }

    @Nullable
    public final String component9() {
        return this.countryCode;
    }

    public final long component10() {
        return this.created;
    }

    @Nullable
    public final String component11() {
        return this.currency;
    }

    @Nullable
    public final String component12() {
        return this.description;
    }

    public final boolean component13() {
        return this.isLiveMode;
    }

    @Nullable
    public final PaymentMethod component14() {
        return this.paymentMethod;
    }

    @Nullable
    public final String component15() {
        return this.paymentMethodId;
    }

    @Nullable
    public final String component16() {
        return this.receiptEmail;
    }

    @Nullable
    public final StripeIntent.Status component17() {
        return this.status;
    }

    @Nullable
    public final StripeIntent.Usage component18() {
        return this.setupFutureUsage;
    }

    @Nullable
    public final Error component19() {
        return this.lastPaymentError;
    }

    @Nullable
    public final Shipping component20() {
        return this.shipping;
    }

    @NotNull
    public final List<String> component21() {
        return this.unactivatedPaymentMethods;
    }

    @NotNull
    public final List<String> component22() {
        return this.linkFundingSources;
    }

    @Nullable
    public final StripeIntent.NextActionData component23() {
        return this.nextActionData;
    }

    private final String component24() {
        return this.paymentMethodOptionsJsonString;
    }

    @NotNull
    public final PaymentIntent copy(@Nullable String id2, @NotNull List<String> paymentMethodTypes, @Nullable Long amount, long canceledAt, @Nullable CancellationReason cancellationReason, @NotNull CaptureMethod captureMethod, @Nullable String clientSecret, @NotNull ConfirmationMethod confirmationMethod, @Nullable String countryCode, long created, @Nullable String currency, @Nullable String description, boolean isLiveMode, @Nullable PaymentMethod paymentMethod, @Nullable String paymentMethodId, @Nullable String receiptEmail, @Nullable StripeIntent.Status status, @Nullable StripeIntent.Usage setupFutureUsage, @Nullable Error lastPaymentError, @Nullable Shipping shipping, @NotNull List<String> unactivatedPaymentMethods, @NotNull List<String> linkFundingSources, @Nullable StripeIntent.NextActionData nextActionData, @Nullable String paymentMethodOptionsJsonString) {
        Intrinsics.checkNotNullParameter(paymentMethodTypes, (String)"paymentMethodTypes");
        Intrinsics.checkNotNullParameter((Object)((Object)captureMethod), (String)"captureMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)confirmationMethod), (String)"confirmationMethod");
        Intrinsics.checkNotNullParameter(unactivatedPaymentMethods, (String)"unactivatedPaymentMethods");
        Intrinsics.checkNotNullParameter(linkFundingSources, (String)"linkFundingSources");
        return new PaymentIntent(id2, paymentMethodTypes, amount, canceledAt, cancellationReason, captureMethod, clientSecret, confirmationMethod, countryCode, created, currency, description, isLiveMode, paymentMethod, paymentMethodId, receiptEmail, status, setupFutureUsage, lastPaymentError, shipping, unactivatedPaymentMethods, linkFundingSources, nextActionData, paymentMethodOptionsJsonString);
    }

    public static /* synthetic */ PaymentIntent copy$default(PaymentIntent paymentIntent, String string2, List list, Long l, long l2, CancellationReason cancellationReason, CaptureMethod captureMethod, String string3, ConfirmationMethod confirmationMethod, String string4, long l3, String string5, String string6, boolean bl, PaymentMethod paymentMethod, String string7, String string8, StripeIntent.Status status, StripeIntent.Usage usage, Error error, Shipping shipping, List list2, List list3, StripeIntent.NextActionData nextActionData, String string9, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = paymentIntent.id;
        }
        if ((n & 2) != 0) {
            list = paymentIntent.paymentMethodTypes;
        }
        if ((n & 4) != 0) {
            l = paymentIntent.amount;
        }
        if ((n & 8) != 0) {
            l2 = paymentIntent.canceledAt;
        }
        if ((n & 0x10) != 0) {
            cancellationReason = paymentIntent.cancellationReason;
        }
        if ((n & 0x20) != 0) {
            captureMethod = paymentIntent.captureMethod;
        }
        if ((n & 0x40) != 0) {
            string3 = paymentIntent.clientSecret;
        }
        if ((n & 0x80) != 0) {
            confirmationMethod = paymentIntent.confirmationMethod;
        }
        if ((n & 0x100) != 0) {
            string4 = paymentIntent.countryCode;
        }
        if ((n & 0x200) != 0) {
            l3 = paymentIntent.created;
        }
        if ((n & 0x400) != 0) {
            string5 = paymentIntent.currency;
        }
        if ((n & 0x800) != 0) {
            string6 = paymentIntent.description;
        }
        if ((n & 0x1000) != 0) {
            bl = paymentIntent.isLiveMode;
        }
        if ((n & 0x2000) != 0) {
            paymentMethod = paymentIntent.paymentMethod;
        }
        if ((n & 0x4000) != 0) {
            string7 = paymentIntent.paymentMethodId;
        }
        if ((n & 0x8000) != 0) {
            string8 = paymentIntent.receiptEmail;
        }
        if ((n & 0x10000) != 0) {
            status = paymentIntent.status;
        }
        if ((n & 0x20000) != 0) {
            usage = paymentIntent.setupFutureUsage;
        }
        if ((n & 0x40000) != 0) {
            error = paymentIntent.lastPaymentError;
        }
        if ((n & 0x80000) != 0) {
            shipping = paymentIntent.shipping;
        }
        if ((n & 0x100000) != 0) {
            list2 = paymentIntent.unactivatedPaymentMethods;
        }
        if ((n & 0x200000) != 0) {
            list3 = paymentIntent.linkFundingSources;
        }
        if ((n & 0x400000) != 0) {
            nextActionData = paymentIntent.nextActionData;
        }
        if ((n & 0x800000) != 0) {
            string9 = paymentIntent.paymentMethodOptionsJsonString;
        }
        return paymentIntent.copy(string2, list, l, l2, cancellationReason, captureMethod, string3, confirmationMethod, string4, l3, string5, string6, bl, paymentMethod, string7, string8, status, usage, error, shipping, list2, list3, nextActionData, string9);
    }

    @NotNull
    public String toString() {
        return "PaymentIntent(id=" + this.id + ", paymentMethodTypes=" + this.paymentMethodTypes + ", amount=" + this.amount + ", canceledAt=" + this.canceledAt + ", cancellationReason=" + this.cancellationReason + ", captureMethod=" + this.captureMethod + ", clientSecret=" + this.clientSecret + ", confirmationMethod=" + this.confirmationMethod + ", countryCode=" + this.countryCode + ", created=" + this.created + ", currency=" + this.currency + ", description=" + this.description + ", isLiveMode=" + this.isLiveMode + ", paymentMethod=" + this.paymentMethod + ", paymentMethodId=" + this.paymentMethodId + ", receiptEmail=" + this.receiptEmail + ", status=" + this.status + ", setupFutureUsage=" + this.setupFutureUsage + ", lastPaymentError=" + this.lastPaymentError + ", shipping=" + this.shipping + ", unactivatedPaymentMethods=" + this.unactivatedPaymentMethods + ", linkFundingSources=" + this.linkFundingSources + ", nextActionData=" + this.nextActionData + ", paymentMethodOptionsJsonString=" + this.paymentMethodOptionsJsonString + ")";
    }

    public int hashCode() {
        int result = this.id == null ? 0 : this.id.hashCode();
        result = result * 31 + ((Object)this.paymentMethodTypes).hashCode();
        result = result * 31 + (this.amount == null ? 0 : ((Object)this.amount).hashCode());
        result = result * 31 + Long.hashCode(this.canceledAt);
        result = result * 31 + (this.cancellationReason == null ? 0 : this.cancellationReason.hashCode());
        result = result * 31 + this.captureMethod.hashCode();
        result = result * 31 + (this.clientSecret == null ? 0 : this.clientSecret.hashCode());
        result = result * 31 + this.confirmationMethod.hashCode();
        result = result * 31 + (this.countryCode == null ? 0 : this.countryCode.hashCode());
        result = result * 31 + Long.hashCode(this.created);
        result = result * 31 + (this.currency == null ? 0 : this.currency.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + Boolean.hashCode(this.isLiveMode);
        result = result * 31 + (this.paymentMethod == null ? 0 : this.paymentMethod.hashCode());
        result = result * 31 + (this.paymentMethodId == null ? 0 : this.paymentMethodId.hashCode());
        result = result * 31 + (this.receiptEmail == null ? 0 : this.receiptEmail.hashCode());
        result = result * 31 + (this.status == null ? 0 : this.status.hashCode());
        result = result * 31 + (this.setupFutureUsage == null ? 0 : this.setupFutureUsage.hashCode());
        result = result * 31 + (this.lastPaymentError == null ? 0 : this.lastPaymentError.hashCode());
        result = result * 31 + (this.shipping == null ? 0 : this.shipping.hashCode());
        result = result * 31 + ((Object)this.unactivatedPaymentMethods).hashCode();
        result = result * 31 + ((Object)this.linkFundingSources).hashCode();
        result = result * 31 + (this.nextActionData == null ? 0 : this.nextActionData.hashCode());
        result = result * 31 + (this.paymentMethodOptionsJsonString == null ? 0 : this.paymentMethodOptionsJsonString.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PaymentIntent)) {
            return false;
        }
        PaymentIntent paymentIntent = (PaymentIntent)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)paymentIntent.id)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paymentMethodTypes, paymentIntent.paymentMethodTypes)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.amount, (Object)paymentIntent.amount)) {
            return false;
        }
        if (this.canceledAt != paymentIntent.canceledAt) {
            return false;
        }
        if (this.cancellationReason != paymentIntent.cancellationReason) {
            return false;
        }
        if (this.captureMethod != paymentIntent.captureMethod) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clientSecret, (Object)paymentIntent.clientSecret)) {
            return false;
        }
        if (this.confirmationMethod != paymentIntent.confirmationMethod) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.countryCode, (Object)paymentIntent.countryCode)) {
            return false;
        }
        if (this.created != paymentIntent.created) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.currency, (Object)paymentIntent.currency)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)paymentIntent.description)) {
            return false;
        }
        if (this.isLiveMode != paymentIntent.isLiveMode) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.paymentMethod, (Object)paymentIntent.paymentMethod)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.paymentMethodId, (Object)paymentIntent.paymentMethodId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.receiptEmail, (Object)paymentIntent.receiptEmail)) {
            return false;
        }
        if (this.status != paymentIntent.status) {
            return false;
        }
        if (this.setupFutureUsage != paymentIntent.setupFutureUsage) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastPaymentError, (Object)paymentIntent.lastPaymentError)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shipping, (Object)paymentIntent.shipping)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.unactivatedPaymentMethods, paymentIntent.unactivatedPaymentMethods)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.linkFundingSources, paymentIntent.linkFundingSources)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.nextActionData, (Object)paymentIntent.nextActionData)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.paymentMethodOptionsJsonString, (Object)paymentIntent.paymentMethodOptionsJsonString);
    }

    @JvmStatic
    @Nullable
    public static final PaymentIntent fromJson(@Nullable JSONObject jsonObject) {
        return Companion.fromJson(jsonObject);
    }

    static {
        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<PaymentIntent> {
            public final PaymentIntent[] newArray(int size) {
                return new PaymentIntent[size];
            }

            public final PaymentIntent createFromParcel(Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new PaymentIntent(parcel.readString(), parcel.createStringArrayList(), parcel.readInt() == 0 ? null : Long.valueOf(parcel.readLong()), parcel.readLong(), parcel.readInt() == 0 ? null : CancellationReason.valueOf(parcel.readString()), CaptureMethod.valueOf(parcel.readString()), parcel.readString(), ConfirmationMethod.valueOf(parcel.readString()), parcel.readString(), parcel.readLong(), parcel.readString(), parcel.readString(), parcel.readInt() != 0, (PaymentMethod)(parcel.readInt() == 0 ? null : PaymentMethod.CREATOR.createFromParcel(parcel)), parcel.readString(), parcel.readString(), parcel.readInt() == 0 ? null : StripeIntent.Status.valueOf(parcel.readString()), parcel.readInt() == 0 ? null : StripeIntent.Usage.valueOf(parcel.readString()), (Error)(parcel.readInt() == 0 ? null : Error.CREATOR.createFromParcel(parcel)), (Shipping)(parcel.readInt() == 0 ? null : Shipping.CREATOR.createFromParcel(parcel)), parcel.createStringArrayList(), parcel.createStringArrayList(), (StripeIntent.NextActionData)parcel.readParcelable(PaymentIntent.class.getClassLoader()), parcel.readString());
            }
        }
        CREATOR = new Creator();
        $stable = 8;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/model/PaymentIntent$CancellationReason;", "", "code", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Duplicate", "Fraudulent", "RequestedByCustomer", "Abandoned", "FailedInvoice", "VoidInvoice", "Automatic", "Companion", "payments-core_release"})
    public static final class CancellationReason
    extends Enum<CancellationReason> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String code;
        public static final /* enum */ CancellationReason Duplicate;
        public static final /* enum */ CancellationReason Fraudulent;
        public static final /* enum */ CancellationReason RequestedByCustomer;
        public static final /* enum */ CancellationReason Abandoned;
        public static final /* enum */ CancellationReason FailedInvoice;
        public static final /* enum */ CancellationReason VoidInvoice;
        public static final /* enum */ CancellationReason Automatic;
        private static final /* synthetic */ CancellationReason[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CancellationReason(String code) {
            this.code = code;
        }

        public static CancellationReason[] values() {
            return (CancellationReason[])$VALUES.clone();
        }

        public static CancellationReason valueOf(String value) {
            return Enum.valueOf(CancellationReason.class, value);
        }

        @NotNull
        public static EnumEntries<CancellationReason> getEntries() {
            return $ENTRIES;
        }

        static {
            Duplicate = new CancellationReason("duplicate");
            Fraudulent = new CancellationReason("fraudulent");
            RequestedByCustomer = new CancellationReason("requested_by_customer");
            Abandoned = new CancellationReason("abandoned");
            FailedInvoice = new CancellationReason("failed_invoice");
            VoidInvoice = new CancellationReason("void_invoice");
            Automatic = new CancellationReason("automatic");
            $VALUES = cancellationReasonArray = new CancellationReason[]{CancellationReason.Duplicate, CancellationReason.Fraudulent, CancellationReason.RequestedByCustomer, CancellationReason.Abandoned, CancellationReason.FailedInvoice, CancellationReason.VoidInvoice, CancellationReason.Automatic};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/PaymentIntent$CancellationReason$Companion;", "", "<init>", "()V", "fromCode", "Lcom/stripe/android/model/PaymentIntent$CancellationReason;", "code", "", "payments-core_release"})
        @SourceDebugExtension(value={"SMAP\nPaymentIntent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentIntent.kt\ncom/stripe/android/model/PaymentIntent$CancellationReason$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,468:1\n295#2,2:469\n*S KotlinDebug\n*F\n+ 1 PaymentIntent.kt\ncom/stripe/android/model/PaymentIntent$CancellationReason$Companion\n*L\n403#1:469,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final CancellationReason fromCode(@Nullable String code) {
                Object v0;
                block1: {
                    Iterable $this$firstOrNull$iv = (Iterable)CancellationReason.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        CancellationReason it = (CancellationReason)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.code, (Object)code)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u00020\u00038G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/PaymentIntent$CaptureMethod;", "", "code", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "Automatic", "AutomaticAsync", "Manual", "Companion", "payments-core_release"})
    public static final class CaptureMethod
    extends Enum<CaptureMethod> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String code;
        public static final /* enum */ CaptureMethod Automatic;
        public static final /* enum */ CaptureMethod AutomaticAsync;
        public static final /* enum */ CaptureMethod Manual;
        private static final /* synthetic */ CaptureMethod[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CaptureMethod(String code) {
            this.code = code;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final String getCode() {
            return this.code;
        }

        public static CaptureMethod[] values() {
            return (CaptureMethod[])$VALUES.clone();
        }

        public static CaptureMethod valueOf(String value) {
            return Enum.valueOf(CaptureMethod.class, value);
        }

        @NotNull
        public static EnumEntries<CaptureMethod> getEntries() {
            return $ENTRIES;
        }

        static {
            Automatic = new CaptureMethod("automatic");
            AutomaticAsync = new CaptureMethod("automatic_async");
            Manual = new CaptureMethod("manual");
            $VALUES = captureMethodArray = new CaptureMethod[]{CaptureMethod.Automatic, CaptureMethod.AutomaticAsync, CaptureMethod.Manual};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/PaymentIntent$CaptureMethod$Companion;", "", "<init>", "()V", "fromCode", "Lcom/stripe/android/model/PaymentIntent$CaptureMethod;", "code", "", "payments-core_release"})
        @SourceDebugExtension(value={"SMAP\nPaymentIntent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentIntent.kt\ncom/stripe/android/model/PaymentIntent$CaptureMethod$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,468:1\n295#2,2:469\n*S KotlinDebug\n*F\n+ 1 PaymentIntent.kt\ncom/stripe/android/model/PaymentIntent$CaptureMethod$Companion\n*L\n433#1:469,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CaptureMethod fromCode(@Nullable String code) {
                CaptureMethod captureMethod;
                Object v0;
                block2: {
                    Iterable $this$firstOrNull$iv = (Iterable)CaptureMethod.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        CaptureMethod it = (CaptureMethod)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getCode(), (Object)code)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                if ((captureMethod = (CaptureMethod)v0) == null) {
                    captureMethod = Automatic;
                }
                return captureMethod;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0081\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u000bJ\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/model/PaymentIntent$ClientSecret;", "", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue$payments_core_release", "()Ljava/lang/String;", "paymentIntentId", "getPaymentIntentId$payments_core_release", "component1", "component1$payments_core_release", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    @SourceDebugExtension(value={"SMAP\nPaymentIntent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentIntent.kt\ncom/stripe/android/model/PaymentIntent$ClientSecret\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,468:1\n739#2,9:469\n37#3:478\n36#3,3:479\n*S KotlinDebug\n*F\n+ 1 PaymentIntent.kt\ncom/stripe/android/model/PaymentIntent$ClientSecret\n*L\n373#1:469,9\n373#1:478\n373#1:479,3\n*E\n"})
    public static final class ClientSecret {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String value;
        @NotNull
        private final String paymentIntentId;
        public static final int $stable;
        private static final Pattern PATTERN;

        /*
         * WARNING - void declaration
         */
        public ClientSecret(@NotNull String value) {
            List list;
            void $this$dropLastWhile$iv;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
            Object object = this.value;
            Regex regex = new Regex("_secret");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            ClientSecret clientSecret = this;
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            clientSecret.paymentIntentId = thisCollection$iv.toArray(new String[0])[0];
            if (!Companion.isMatch(this.value)) {
                boolean bl = false;
                String string2 = "Invalid Payment Intent client secret: " + this.value;
                throw new IllegalArgumentException(string2.toString());
            }
        }

        @NotNull
        public final String getValue$payments_core_release() {
            return this.value;
        }

        @NotNull
        public final String getPaymentIntentId$payments_core_release() {
            return this.paymentIntentId;
        }

        @NotNull
        public final String component1$payments_core_release() {
            return this.value;
        }

        @NotNull
        public final ClientSecret copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new ClientSecret(value);
        }

        public static /* synthetic */ ClientSecret copy$default(ClientSecret clientSecret, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = clientSecret.value;
            }
            return clientSecret.copy(string2);
        }

        @NotNull
        public String toString() {
            return "ClientSecret(value=" + this.value + ")";
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClientSecret)) {
                return false;
            }
            ClientSecret clientSecret = (ClientSecret)other;
            return Intrinsics.areEqual((Object)this.value, (Object)clientSecret.value);
        }

        static {
            PATTERN = Pattern.compile("^pi_[^_]+_secret_[^_]+$");
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/PaymentIntent$ClientSecret$Companion;", "", "<init>", "()V", "PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "isMatch", "", "value", "", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean isMatch(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return PATTERN.matcher(value).matches();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/model/PaymentIntent$Companion;", "", "<init>", "()V", "fromJson", "Lcom/stripe/android/model/PaymentIntent;", "jsonObject", "Lorg/json/JSONObject;", "CARD", "", "REQUIRE_CVC_RECOLLECTION", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final PaymentIntent fromJson(@Nullable JSONObject jsonObject) {
            PaymentIntent paymentIntent;
            JSONObject jSONObject = jsonObject;
            if (jSONObject != null) {
                JSONObject it = jSONObject;
                boolean bl = false;
                paymentIntent = new PaymentIntentJsonParser().parse(it);
            } else {
                paymentIntent = null;
            }
            return paymentIntent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\bB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod;", "", "code", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Automatic", "Manual", "Companion", "payments-core_release"})
    public static final class ConfirmationMethod
    extends Enum<ConfirmationMethod> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String code;
        public static final /* enum */ ConfirmationMethod Automatic;
        public static final /* enum */ ConfirmationMethod Manual;
        private static final /* synthetic */ ConfirmationMethod[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ConfirmationMethod(String code) {
            this.code = code;
        }

        public static ConfirmationMethod[] values() {
            return (ConfirmationMethod[])$VALUES.clone();
        }

        public static ConfirmationMethod valueOf(String value) {
            return Enum.valueOf(ConfirmationMethod.class, value);
        }

        @NotNull
        public static EnumEntries<ConfirmationMethod> getEntries() {
            return $ENTRIES;
        }

        static {
            Automatic = new ConfirmationMethod("automatic");
            Manual = new ConfirmationMethod("manual");
            $VALUES = confirmationMethodArray = new ConfirmationMethod[]{ConfirmationMethod.Automatic, ConfirmationMethod.Manual};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod$Companion;", "", "<init>", "()V", "fromCode", "Lcom/stripe/android/model/PaymentIntent$ConfirmationMethod;", "code", "", "payments-core_release"})
        @SourceDebugExtension(value={"SMAP\nPaymentIntent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentIntent.kt\ncom/stripe/android/model/PaymentIntent$ConfirmationMethod$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,468:1\n295#2,2:469\n*S KotlinDebug\n*F\n+ 1 PaymentIntent.kt\ncom/stripe/android/model/PaymentIntent$ConfirmationMethod$Companion\n*L\n452#1:469,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ConfirmationMethod fromCode(@Nullable String code) {
                ConfirmationMethod confirmationMethod;
                Object v0;
                block2: {
                    Iterable $this$firstOrNull$iv = (Iterable)ConfirmationMethod.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ConfirmationMethod it = (ConfirmationMethod)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.code, (Object)code)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                if ((confirmationMethod = (ConfirmationMethod)v0) == null) {
                    confirmationMethod = Automatic;
                }
                return confirmationMethod;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 22\u00020\u0001:\u000212BY\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\fH\u00c6\u0003Jn\u0010\"\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c0\u0001\u00a2\u0006\u0002\b#J\u0006\u0010$\u001a\u00020%J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020%H\u00d6\u0001J\t\u0010+\u001a\u00020\u0003H\u00d6\u0001J\u0016\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020%R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00063"}, d2={"Lcom/stripe/android/model/PaymentIntent$Error;", "Lcom/stripe/android/core/model/StripeModel;", "charge", "", "code", "declineCode", "docUrl", "message", "param", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "type", "Lcom/stripe/android/model/PaymentIntent$Error$Type;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/model/PaymentMethod;Lcom/stripe/android/model/PaymentIntent$Error$Type;)V", "getCharge", "()Ljava/lang/String;", "getCode", "getDeclineCode", "getDocUrl", "getMessage", "getParam", "getPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "getType", "()Lcom/stripe/android/model/PaymentIntent$Error$Type;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "copy$payments_core_release", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "Type", "Companion", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Error
    implements StripeModel {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String charge;
        @Nullable
        private final String code;
        @Nullable
        private final String declineCode;
        @Nullable
        private final String docUrl;
        @Nullable
        private final String message;
        @Nullable
        private final String param;
        @Nullable
        private final PaymentMethod paymentMethod;
        @Nullable
        private final Type type;
        @NotNull
        public static final Parcelable.Creator<Error> CREATOR;
        public static final int $stable;
        @NotNull
        public static final String CODE_AUTHENTICATION_ERROR = "payment_intent_authentication_failure";

        public Error(@Nullable String charge, @Nullable String code, @Nullable String declineCode, @Nullable String docUrl, @Nullable String message, @Nullable String param, @Nullable PaymentMethod paymentMethod, @Nullable Type type) {
            this.charge = charge;
            this.code = code;
            this.declineCode = declineCode;
            this.docUrl = docUrl;
            this.message = message;
            this.param = param;
            this.paymentMethod = paymentMethod;
            this.type = type;
        }

        @Nullable
        public final String getCharge() {
            return this.charge;
        }

        @Nullable
        public final String getCode() {
            return this.code;
        }

        @Nullable
        public final String getDeclineCode() {
            return this.declineCode;
        }

        @Nullable
        public final String getDocUrl() {
            return this.docUrl;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final String getParam() {
            return this.param;
        }

        @Nullable
        public final PaymentMethod getPaymentMethod() {
            return this.paymentMethod;
        }

        @Nullable
        public final Type getType() {
            return this.type;
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeString(this.charge);
            dest.writeString(this.code);
            dest.writeString(this.declineCode);
            dest.writeString(this.docUrl);
            dest.writeString(this.message);
            dest.writeString(this.param);
            Object object = this.paymentMethod;
            if (object == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                ((PaymentMethod)object).writeToParcel(dest, flags);
            }
            object = this.type;
            if (object == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                dest.writeString(((Enum)object).name());
            }
        }

        public final int describeContents() {
            return 0;
        }

        @Nullable
        public final String component1() {
            return this.charge;
        }

        @Nullable
        public final String component2() {
            return this.code;
        }

        @Nullable
        public final String component3() {
            return this.declineCode;
        }

        @Nullable
        public final String component4() {
            return this.docUrl;
        }

        @Nullable
        public final String component5() {
            return this.message;
        }

        @Nullable
        public final String component6() {
            return this.param;
        }

        @Nullable
        public final PaymentMethod component7() {
            return this.paymentMethod;
        }

        @Nullable
        public final Type component8() {
            return this.type;
        }

        @NotNull
        public final Error copy$payments_core_release(@Nullable String charge, @Nullable String code, @Nullable String declineCode, @Nullable String docUrl, @Nullable String message, @Nullable String param, @Nullable PaymentMethod paymentMethod, @Nullable Type type) {
            return new Error(charge, code, declineCode, docUrl, message, param, paymentMethod, type);
        }

        public static /* synthetic */ Error copy$payments_core_release$default(Error error, String string2, String string3, String string4, String string5, String string6, String string7, PaymentMethod paymentMethod, Type type, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = error.charge;
            }
            if ((n & 2) != 0) {
                string3 = error.code;
            }
            if ((n & 4) != 0) {
                string4 = error.declineCode;
            }
            if ((n & 8) != 0) {
                string5 = error.docUrl;
            }
            if ((n & 0x10) != 0) {
                string6 = error.message;
            }
            if ((n & 0x20) != 0) {
                string7 = error.param;
            }
            if ((n & 0x40) != 0) {
                paymentMethod = error.paymentMethod;
            }
            if ((n & 0x80) != 0) {
                type = error.type;
            }
            return error.copy$payments_core_release(string2, string3, string4, string5, string6, string7, paymentMethod, type);
        }

        @NotNull
        public String toString() {
            return "Error(charge=" + this.charge + ", code=" + this.code + ", declineCode=" + this.declineCode + ", docUrl=" + this.docUrl + ", message=" + this.message + ", param=" + this.param + ", paymentMethod=" + this.paymentMethod + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result = this.charge == null ? 0 : this.charge.hashCode();
            result = result * 31 + (this.code == null ? 0 : this.code.hashCode());
            result = result * 31 + (this.declineCode == null ? 0 : this.declineCode.hashCode());
            result = result * 31 + (this.docUrl == null ? 0 : this.docUrl.hashCode());
            result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
            result = result * 31 + (this.param == null ? 0 : this.param.hashCode());
            result = result * 31 + (this.paymentMethod == null ? 0 : this.paymentMethod.hashCode());
            result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Error)) {
                return false;
            }
            Error error = (Error)other;
            if (!Intrinsics.areEqual((Object)this.charge, (Object)error.charge)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.code, (Object)error.code)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.declineCode, (Object)error.declineCode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.docUrl, (Object)error.docUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)error.message)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.param, (Object)error.param)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.paymentMethod, (Object)error.paymentMethod)) {
                return false;
            }
            return this.type == error.type;
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Error> {
                public final Error[] newArray(int size) {
                    return new Error[size];
                }

                public final Error createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Error(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), (PaymentMethod)(parcel.readInt() == 0 ? null : PaymentMethod.CREATOR.createFromParcel(parcel)), parcel.readInt() == 0 ? null : Type.valueOf(parcel.readString()));
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/PaymentIntent$Error$Companion;", "", "<init>", "()V", "CODE_AUTHENTICATION_ERROR", "", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/model/PaymentIntent$Error$Type;", "", "code", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "ApiConnectionError", "ApiError", "AuthenticationError", "CardError", "IdempotencyError", "InvalidRequestError", "RateLimitError", "Companion", "payments-core_release"})
        public static final class Type
        extends Enum<Type> {
            @NotNull
            public static final Companion Companion;
            @NotNull
            private final String code;
            public static final /* enum */ Type ApiConnectionError;
            public static final /* enum */ Type ApiError;
            public static final /* enum */ Type AuthenticationError;
            public static final /* enum */ Type CardError;
            public static final /* enum */ Type IdempotencyError;
            public static final /* enum */ Type InvalidRequestError;
            public static final /* enum */ Type RateLimitError;
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Type(String code) {
                this.code = code;
            }

            @NotNull
            public final String getCode() {
                return this.code;
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            @NotNull
            public static EnumEntries<Type> getEntries() {
                return $ENTRIES;
            }

            static {
                ApiConnectionError = new Type("api_connection_error");
                ApiError = new Type("api_error");
                AuthenticationError = new Type("authentication_error");
                CardError = new Type("card_error");
                IdempotencyError = new Type("idempotency_error");
                InvalidRequestError = new Type("invalid_request_error");
                RateLimitError = new Type("rate_limit_error");
                $VALUES = typeArray = new Type[]{Type.ApiConnectionError, Type.ApiError, Type.AuthenticationError, Type.CardError, Type.IdempotencyError, Type.InvalidRequestError, Type.RateLimitError};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/PaymentIntent$Error$Type$Companion;", "", "<init>", "()V", "fromCode", "Lcom/stripe/android/model/PaymentIntent$Error$Type;", "typeCode", "", "payments-core_release"})
            @SourceDebugExtension(value={"SMAP\nPaymentIntent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentIntent.kt\ncom/stripe/android/model/PaymentIntent$Error$Type$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,468:1\n295#2,2:469\n*S KotlinDebug\n*F\n+ 1 PaymentIntent.kt\ncom/stripe/android/model/PaymentIntent$Error$Type$Companion\n*L\n316#1:469,2\n*E\n"})
            public static final class Companion {
                private Companion() {
                }

                @Nullable
                public final Type fromCode(@Nullable String typeCode) {
                    Object v0;
                    block1: {
                        Iterable $this$firstOrNull$iv = (Iterable)Type.getEntries();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Type it = (Type)((Object)element$iv);
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getCode(), (Object)typeCode)) continue;
                            v0 = element$iv;
                            break block1;
                        }
                        v0 = null;
                    }
                    return v0;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003JC\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0006\u0010\u0018\u001a\u00020\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001J\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/stripe/android/model/PaymentIntent$Shipping;", "Lcom/stripe/android/core/model/StripeModel;", "address", "Lcom/stripe/android/model/Address;", "carrier", "", "name", "phone", "trackingNumber", "<init>", "(Lcom/stripe/android/model/Address;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAddress", "()Lcom/stripe/android/model/Address;", "getCarrier", "()Ljava/lang/String;", "getName", "getPhone", "getTrackingNumber", "component1", "component2", "component3", "component4", "component5", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "payments-core_release"})
    @Parcelize
    @StabilityInferred(parameters=1)
    public static final class Shipping
    implements StripeModel {
        @NotNull
        private final Address address;
        @Nullable
        private final String carrier;
        @Nullable
        private final String name;
        @Nullable
        private final String phone;
        @Nullable
        private final String trackingNumber;
        @NotNull
        public static final Parcelable.Creator<Shipping> CREATOR;
        public static final int $stable;

        public Shipping(@NotNull Address address, @Nullable String carrier, @Nullable String name, @Nullable String phone, @Nullable String trackingNumber) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            this.address = address;
            this.carrier = carrier;
            this.name = name;
            this.phone = phone;
            this.trackingNumber = trackingNumber;
        }

        public /* synthetic */ Shipping(Address address, String string2, String string3, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            if ((n & 0x10) != 0) {
                string5 = null;
            }
            this(address, string2, string3, string4, string5);
        }

        @NotNull
        public final Address getAddress() {
            return this.address;
        }

        @Nullable
        public final String getCarrier() {
            return this.carrier;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getPhone() {
            return this.phone;
        }

        @Nullable
        public final String getTrackingNumber() {
            return this.trackingNumber;
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            this.address.writeToParcel(dest, flags);
            dest.writeString(this.carrier);
            dest.writeString(this.name);
            dest.writeString(this.phone);
            dest.writeString(this.trackingNumber);
        }

        public final int describeContents() {
            return 0;
        }

        @NotNull
        public final Address component1() {
            return this.address;
        }

        @Nullable
        public final String component2() {
            return this.carrier;
        }

        @Nullable
        public final String component3() {
            return this.name;
        }

        @Nullable
        public final String component4() {
            return this.phone;
        }

        @Nullable
        public final String component5() {
            return this.trackingNumber;
        }

        @NotNull
        public final Shipping copy(@NotNull Address address, @Nullable String carrier, @Nullable String name, @Nullable String phone, @Nullable String trackingNumber) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            return new Shipping(address, carrier, name, phone, trackingNumber);
        }

        public static /* synthetic */ Shipping copy$default(Shipping shipping, Address address, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                address = shipping.address;
            }
            if ((n & 2) != 0) {
                string2 = shipping.carrier;
            }
            if ((n & 4) != 0) {
                string3 = shipping.name;
            }
            if ((n & 8) != 0) {
                string4 = shipping.phone;
            }
            if ((n & 0x10) != 0) {
                string5 = shipping.trackingNumber;
            }
            return shipping.copy(address, string2, string3, string4, string5);
        }

        @NotNull
        public String toString() {
            return "Shipping(address=" + this.address + ", carrier=" + this.carrier + ", name=" + this.name + ", phone=" + this.phone + ", trackingNumber=" + this.trackingNumber + ")";
        }

        public int hashCode() {
            int result = this.address.hashCode();
            result = result * 31 + (this.carrier == null ? 0 : this.carrier.hashCode());
            result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
            result = result * 31 + (this.phone == null ? 0 : this.phone.hashCode());
            result = result * 31 + (this.trackingNumber == null ? 0 : this.trackingNumber.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Shipping)) {
                return false;
            }
            Shipping shipping = (Shipping)other;
            if (!Intrinsics.areEqual((Object)this.address, (Object)shipping.address)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.carrier, (Object)shipping.carrier)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)shipping.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.phone, (Object)shipping.phone)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.trackingNumber, (Object)shipping.trackingNumber);
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Shipping> {
                public final Shipping[] newArray(int size) {
                    return new Shipping[size];
                }

                public final Shipping createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Shipping((Address)Address.CREATOR.createFromParcel(parcel), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString());
                }
            }
            CREATOR = new Creator();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StripeIntent.Usage.values().length];
            try {
                nArray[StripeIntent.Usage.OnSession.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.Usage.OffSession.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StripeIntent.Usage.OneTime.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

