/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.cards.Bin;
import com.stripe.android.core.model.StripeModel;
import com.stripe.android.model.AccountRange;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J(\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c0\u0001\u00a2\u0006\u0002\b\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/model/CardMetadata;", "Lcom/stripe/android/core/model/StripeModel;", "bin", "Lcom/stripe/android/cards/Bin;", "accountRanges", "", "Lcom/stripe/android/model/AccountRange;", "<init>", "(Lcom/stripe/android/cards/Bin;Ljava/util/List;)V", "getBin", "()Lcom/stripe/android/cards/Bin;", "getAccountRanges", "()Ljava/util/List;", "component1", "component2", "copy", "copy$payments_core_release", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "payments-core_release"})
@Parcelize
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class CardMetadata
implements StripeModel {
    @NotNull
    private final Bin bin;
    @NotNull
    private final List<AccountRange> accountRanges;
    @NotNull
    public static final Parcelable.Creator<CardMetadata> CREATOR;
    public static final int $stable;

    public CardMetadata(@NotNull Bin bin, @NotNull List<AccountRange> accountRanges) {
        Intrinsics.checkNotNullParameter((Object)bin, (String)"bin");
        Intrinsics.checkNotNullParameter(accountRanges, (String)"accountRanges");
        this.bin = bin;
        this.accountRanges = accountRanges;
    }

    @NotNull
    public final Bin getBin() {
        return this.bin;
    }

    @NotNull
    public final List<AccountRange> getAccountRanges() {
        return this.accountRanges;
    }

    public final void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeParcelable((Parcelable)this.bin, flags);
        List<AccountRange> list = this.accountRanges;
        dest.writeInt(list.size());
        Iterator<AccountRange> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next().writeToParcel(dest, flags);
        }
    }

    public final int describeContents() {
        return 0;
    }

    @NotNull
    public final Bin component1() {
        return this.bin;
    }

    @NotNull
    public final List<AccountRange> component2() {
        return this.accountRanges;
    }

    @NotNull
    public final CardMetadata copy$payments_core_release(@NotNull Bin bin, @NotNull List<AccountRange> accountRanges) {
        Intrinsics.checkNotNullParameter((Object)bin, (String)"bin");
        Intrinsics.checkNotNullParameter(accountRanges, (String)"accountRanges");
        return new CardMetadata(bin, accountRanges);
    }

    public static /* synthetic */ CardMetadata copy$payments_core_release$default(CardMetadata cardMetadata, Bin bin, List list, int n, Object object) {
        if ((n & 1) != 0) {
            bin = cardMetadata.bin;
        }
        if ((n & 2) != 0) {
            list = cardMetadata.accountRanges;
        }
        return cardMetadata.copy$payments_core_release(bin, list);
    }

    @NotNull
    public String toString() {
        return "CardMetadata(bin=" + this.bin + ", accountRanges=" + this.accountRanges + ")";
    }

    public int hashCode() {
        int result = this.bin.hashCode();
        result = result * 31 + ((Object)this.accountRanges).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CardMetadata)) {
            return false;
        }
        CardMetadata cardMetadata = (CardMetadata)other;
        if (!Intrinsics.areEqual((Object)this.bin, (Object)cardMetadata.bin)) {
            return false;
        }
        return Intrinsics.areEqual(this.accountRanges, cardMetadata.accountRanges);
    }

    static {
        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<CardMetadata> {
            public final CardMetadata[] newArray(int size) {
                return new CardMetadata[size];
            }

            public final CardMetadata createFromParcel(Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n = parcel.readInt();
                ArrayList<Object> arrayList = new ArrayList<Object>(n);
                Bin bin = (Bin)parcel.readParcelable(CardMetadata.class.getClassLoader());
                for (int i = 0; i != n; ++i) {
                    arrayList.add(AccountRange.CREATOR.createFromParcel(parcel));
                }
                List list = arrayList;
                Bin bin2 = bin;
                return new CardMetadata(bin2, list);
            }
        }
        CREATOR = new Creator();
        $stable = 8;
    }
}

