/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.activity.result.ActivityResultLauncher;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.Source;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.view.AuthActivityStarter;
import com.stripe.android.view.AuthActivityStarterHost;
import com.stripe.android.view.PaymentRelayActivity;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parceler;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b`\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0003\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/PaymentRelayStarter;", "Lcom/stripe/android/view/AuthActivityStarter;", "Lcom/stripe/android/PaymentRelayStarter$Args;", "Legacy", "Modern", "Args", "payments-core_release"})
public interface PaymentRelayStarter
extends AuthActivityStarter<Args> {

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u000e2\u00020\u0001:\u0005\n\u000b\f\r\u000eB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0004\u000f\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/PaymentRelayStarter$Args;", "Landroid/os/Parcelable;", "<init>", "()V", "requestCode", "", "getRequestCode", "()I", "toResult", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "PaymentIntentArgs", "SetupIntentArgs", "SourceArgs", "ErrorArgs", "Companion", "Lcom/stripe/android/PaymentRelayStarter$Args$ErrorArgs;", "Lcom/stripe/android/PaymentRelayStarter$Args$PaymentIntentArgs;", "Lcom/stripe/android/PaymentRelayStarter$Args$SetupIntentArgs;", "Lcom/stripe/android/PaymentRelayStarter$Args$SourceArgs;", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static abstract class Args
    implements Parcelable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final int $stable;

        private Args() {
        }

        public abstract int getRequestCode();

        @NotNull
        public abstract PaymentFlowResult.Unvalidated toResult();

        public /* synthetic */ Args(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/PaymentRelayStarter$Args$Companion;", "", "<init>", "()V", "create", "Lcom/stripe/android/PaymentRelayStarter$Args;", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "stripeAccountId", "", "payments-core_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Args create(@NotNull StripeIntent stripeIntent, @Nullable String stripeAccountId) {
                Args args;
                Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
                StripeIntent stripeIntent2 = stripeIntent;
                if (stripeIntent2 instanceof PaymentIntent) {
                    args = new PaymentIntentArgs((PaymentIntent)stripeIntent, stripeAccountId);
                } else if (stripeIntent2 instanceof SetupIntent) {
                    args = new SetupIntentArgs((SetupIntent)stripeIntent, stripeAccountId);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return args;
            }

            public static /* synthetic */ Args create$default(Companion companion, StripeIntent stripeIntent, String string, int n, Object object) {
                if ((n & 2) != 0) {
                    string = null;
                }
                return companion.create(stripeIntent, string);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u000fJ\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0006\u0010\u0012\u001a\u00020\u0005J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/stripe/android/PaymentRelayStarter$Args$ErrorArgs;", "Lcom/stripe/android/PaymentRelayStarter$Args;", "exception", "Lcom/stripe/android/core/exception/StripeException;", "requestCode", "", "<init>", "(Lcom/stripe/android/core/exception/StripeException;I)V", "getException$payments_core_release", "()Lcom/stripe/android/core/exception/StripeException;", "getRequestCode", "()I", "toResult", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "component1", "component1$payments_core_release", "component2", "copy", "describeContents", "equals", "", "other", "", "hashCode", "toString", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "Companion", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class ErrorArgs
        extends Args {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final StripeException exception;
            private final int requestCode;
            @NotNull
            public static final Parcelable.Creator<ErrorArgs> CREATOR;
            public static final int $stable;

            public ErrorArgs(@NotNull StripeException exception, int requestCode) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                super(null);
                this.exception = exception;
                this.requestCode = requestCode;
            }

            @NotNull
            public final StripeException getException$payments_core_release() {
                return this.exception;
            }

            @Override
            public int getRequestCode() {
                return this.requestCode;
            }

            @Override
            @NotNull
            public PaymentFlowResult.Unvalidated toResult() {
                return new PaymentFlowResult.Unvalidated(null, 0, this.exception, false, null, null, null, 123, null);
            }

            public final void writeToParcel(@NotNull Parcel dest, int flags) {
                Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
                Companion.write(this, dest, flags);
            }

            public final int describeContents() {
                return 0;
            }

            @NotNull
            public final StripeException component1$payments_core_release() {
                return this.exception;
            }

            public final int component2() {
                return this.requestCode;
            }

            @NotNull
            public final ErrorArgs copy(@NotNull StripeException exception, int requestCode) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new ErrorArgs(exception, requestCode);
            }

            public static /* synthetic */ ErrorArgs copy$default(ErrorArgs errorArgs, StripeException stripeException, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    stripeException = errorArgs.exception;
                }
                if ((n2 & 2) != 0) {
                    n = errorArgs.requestCode;
                }
                return errorArgs.copy(stripeException, n);
            }

            @NotNull
            public String toString() {
                return "ErrorArgs(exception=" + this.exception + ", requestCode=" + this.requestCode + ")";
            }

            public int hashCode() {
                int result = this.exception.hashCode();
                result = result * 31 + Integer.hashCode(this.requestCode);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ErrorArgs)) {
                    return false;
                }
                ErrorArgs errorArgs = (ErrorArgs)other;
                if (!Intrinsics.areEqual((Object)this.exception, (Object)errorArgs.exception)) {
                    return false;
                }
                return this.requestCode == errorArgs.requestCode;
            }

            static {
                @Metadata(mv={2, 1, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<ErrorArgs> {
                    public final ErrorArgs[] newArray(int size) {
                        return new ErrorArgs[size];
                    }

                    public final ErrorArgs createFromParcel(Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return Companion.create(parcel);
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\b\u001a\u00020\t*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/stripe/android/PaymentRelayStarter$Args$ErrorArgs$Companion;", "Lkotlinx/parcelize/Parceler;", "Lcom/stripe/android/PaymentRelayStarter$Args$ErrorArgs;", "<init>", "()V", "create", "parcel", "Landroid/os/Parcel;", "write", "", "flags", "", "payments-core_release"})
            public static final class Companion
            implements Parceler<ErrorArgs> {
                private Companion() {
                }

                @NotNull
                public ErrorArgs create(@NotNull Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    Serializable serializable = parcel.readSerializable();
                    Intrinsics.checkNotNull((Object)serializable, (String)"null cannot be cast to non-null type com.stripe.android.core.exception.StripeException");
                    return new ErrorArgs((StripeException)serializable, parcel.readInt());
                }

                public void write(@NotNull ErrorArgs $this$write, @NotNull Parcel parcel, int flags) {
                    Intrinsics.checkNotNullParameter((Object)$this$write, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.writeSerializable((Serializable)$this$write.getException$payments_core_release());
                    parcel.writeInt($this$write.getRequestCode());
                }

                @NotNull
                public ErrorArgs[] newArray(int size) {
                    return (ErrorArgs[])Parceler.DefaultImpls.newArray((Parceler)this, (int)size);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u0015J\u001f\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0006\u0010\u0017\u001a\u00020\rJ\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\rH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lcom/stripe/android/PaymentRelayStarter$Args$PaymentIntentArgs;", "Lcom/stripe/android/PaymentRelayStarter$Args;", "paymentIntent", "Lcom/stripe/android/model/PaymentIntent;", "stripeAccountId", "", "<init>", "(Lcom/stripe/android/model/PaymentIntent;Ljava/lang/String;)V", "getPaymentIntent$payments_core_release", "()Lcom/stripe/android/model/PaymentIntent;", "getStripeAccountId$payments_core_release", "()Ljava/lang/String;", "requestCode", "", "getRequestCode", "()I", "toResult", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "component1", "component1$payments_core_release", "component2", "component2$payments_core_release", "copy", "describeContents", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class PaymentIntentArgs
        extends Args {
            @NotNull
            private final PaymentIntent paymentIntent;
            @Nullable
            private final String stripeAccountId;
            @NotNull
            public static final Parcelable.Creator<PaymentIntentArgs> CREATOR;
            public static final int $stable;

            public PaymentIntentArgs(@NotNull PaymentIntent paymentIntent, @Nullable String stripeAccountId) {
                Intrinsics.checkNotNullParameter((Object)paymentIntent, (String)"paymentIntent");
                super(null);
                this.paymentIntent = paymentIntent;
                this.stripeAccountId = stripeAccountId;
            }

            public /* synthetic */ PaymentIntentArgs(PaymentIntent paymentIntent, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    string = null;
                }
                this(paymentIntent, string);
            }

            @NotNull
            public final PaymentIntent getPaymentIntent$payments_core_release() {
                return this.paymentIntent;
            }

            @Nullable
            public final String getStripeAccountId$payments_core_release() {
                return this.stripeAccountId;
            }

            @Override
            public int getRequestCode() {
                return 50000;
            }

            @Override
            @NotNull
            public PaymentFlowResult.Unvalidated toResult() {
                return new PaymentFlowResult.Unvalidated(this.paymentIntent.getClientSecret(), 0, null, false, null, null, this.stripeAccountId, 62, null);
            }

            public final void writeToParcel(@NotNull Parcel dest, int flags) {
                Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
                this.paymentIntent.writeToParcel(dest, flags);
                dest.writeString(this.stripeAccountId);
            }

            public final int describeContents() {
                return 0;
            }

            @NotNull
            public final PaymentIntent component1$payments_core_release() {
                return this.paymentIntent;
            }

            @Nullable
            public final String component2$payments_core_release() {
                return this.stripeAccountId;
            }

            @NotNull
            public final PaymentIntentArgs copy(@NotNull PaymentIntent paymentIntent, @Nullable String stripeAccountId) {
                Intrinsics.checkNotNullParameter((Object)paymentIntent, (String)"paymentIntent");
                return new PaymentIntentArgs(paymentIntent, stripeAccountId);
            }

            public static /* synthetic */ PaymentIntentArgs copy$default(PaymentIntentArgs paymentIntentArgs, PaymentIntent paymentIntent, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    paymentIntent = paymentIntentArgs.paymentIntent;
                }
                if ((n & 2) != 0) {
                    string = paymentIntentArgs.stripeAccountId;
                }
                return paymentIntentArgs.copy(paymentIntent, string);
            }

            @NotNull
            public String toString() {
                return "PaymentIntentArgs(paymentIntent=" + this.paymentIntent + ", stripeAccountId=" + this.stripeAccountId + ")";
            }

            public int hashCode() {
                int result = this.paymentIntent.hashCode();
                result = result * 31 + (this.stripeAccountId == null ? 0 : this.stripeAccountId.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PaymentIntentArgs)) {
                    return false;
                }
                PaymentIntentArgs paymentIntentArgs = (PaymentIntentArgs)other;
                if (!Intrinsics.areEqual((Object)this.paymentIntent, (Object)paymentIntentArgs.paymentIntent)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.stripeAccountId, (Object)paymentIntentArgs.stripeAccountId);
            }

            static {
                @Metadata(mv={2, 1, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<PaymentIntentArgs> {
                    public final PaymentIntentArgs[] newArray(int size) {
                        return new PaymentIntentArgs[size];
                    }

                    public final PaymentIntentArgs createFromParcel(Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new PaymentIntentArgs((PaymentIntent)PaymentIntent.CREATOR.createFromParcel(parcel), parcel.readString());
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u0015J\u001f\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0006\u0010\u0017\u001a\u00020\rJ\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\rH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lcom/stripe/android/PaymentRelayStarter$Args$SetupIntentArgs;", "Lcom/stripe/android/PaymentRelayStarter$Args;", "setupIntent", "Lcom/stripe/android/model/SetupIntent;", "stripeAccountId", "", "<init>", "(Lcom/stripe/android/model/SetupIntent;Ljava/lang/String;)V", "getSetupIntent$payments_core_release", "()Lcom/stripe/android/model/SetupIntent;", "getStripeAccountId$payments_core_release", "()Ljava/lang/String;", "requestCode", "", "getRequestCode", "()I", "toResult", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "component1", "component1$payments_core_release", "component2", "component2$payments_core_release", "copy", "describeContents", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class SetupIntentArgs
        extends Args {
            @NotNull
            private final SetupIntent setupIntent;
            @Nullable
            private final String stripeAccountId;
            @NotNull
            public static final Parcelable.Creator<SetupIntentArgs> CREATOR;
            public static final int $stable;

            public SetupIntentArgs(@NotNull SetupIntent setupIntent, @Nullable String stripeAccountId) {
                Intrinsics.checkNotNullParameter((Object)setupIntent, (String)"setupIntent");
                super(null);
                this.setupIntent = setupIntent;
                this.stripeAccountId = stripeAccountId;
            }

            public /* synthetic */ SetupIntentArgs(SetupIntent setupIntent, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    string = null;
                }
                this(setupIntent, string);
            }

            @NotNull
            public final SetupIntent getSetupIntent$payments_core_release() {
                return this.setupIntent;
            }

            @Nullable
            public final String getStripeAccountId$payments_core_release() {
                return this.stripeAccountId;
            }

            @Override
            public int getRequestCode() {
                return 50001;
            }

            @Override
            @NotNull
            public PaymentFlowResult.Unvalidated toResult() {
                return new PaymentFlowResult.Unvalidated(this.setupIntent.getClientSecret(), 0, null, false, null, null, this.stripeAccountId, 62, null);
            }

            public final void writeToParcel(@NotNull Parcel dest, int flags) {
                Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
                this.setupIntent.writeToParcel(dest, flags);
                dest.writeString(this.stripeAccountId);
            }

            public final int describeContents() {
                return 0;
            }

            @NotNull
            public final SetupIntent component1$payments_core_release() {
                return this.setupIntent;
            }

            @Nullable
            public final String component2$payments_core_release() {
                return this.stripeAccountId;
            }

            @NotNull
            public final SetupIntentArgs copy(@NotNull SetupIntent setupIntent, @Nullable String stripeAccountId) {
                Intrinsics.checkNotNullParameter((Object)setupIntent, (String)"setupIntent");
                return new SetupIntentArgs(setupIntent, stripeAccountId);
            }

            public static /* synthetic */ SetupIntentArgs copy$default(SetupIntentArgs setupIntentArgs, SetupIntent setupIntent, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    setupIntent = setupIntentArgs.setupIntent;
                }
                if ((n & 2) != 0) {
                    string = setupIntentArgs.stripeAccountId;
                }
                return setupIntentArgs.copy(setupIntent, string);
            }

            @NotNull
            public String toString() {
                return "SetupIntentArgs(setupIntent=" + this.setupIntent + ", stripeAccountId=" + this.stripeAccountId + ")";
            }

            public int hashCode() {
                int result = this.setupIntent.hashCode();
                result = result * 31 + (this.stripeAccountId == null ? 0 : this.stripeAccountId.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SetupIntentArgs)) {
                    return false;
                }
                SetupIntentArgs setupIntentArgs = (SetupIntentArgs)other;
                if (!Intrinsics.areEqual((Object)this.setupIntent, (Object)setupIntentArgs.setupIntent)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.stripeAccountId, (Object)setupIntentArgs.stripeAccountId);
            }

            static {
                @Metadata(mv={2, 1, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<SetupIntentArgs> {
                    public final SetupIntentArgs[] newArray(int size) {
                        return new SetupIntentArgs[size];
                    }

                    public final SetupIntentArgs createFromParcel(Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new SetupIntentArgs((SetupIntent)SetupIntent.CREATOR.createFromParcel(parcel), parcel.readString());
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u0015J\u001f\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0006\u0010\u0017\u001a\u00020\rJ\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\rH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lcom/stripe/android/PaymentRelayStarter$Args$SourceArgs;", "Lcom/stripe/android/PaymentRelayStarter$Args;", "source", "Lcom/stripe/android/model/Source;", "stripeAccountId", "", "<init>", "(Lcom/stripe/android/model/Source;Ljava/lang/String;)V", "getSource$payments_core_release", "()Lcom/stripe/android/model/Source;", "getStripeAccountId$payments_core_release", "()Ljava/lang/String;", "requestCode", "", "getRequestCode", "()I", "toResult", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "component1", "component1$payments_core_release", "component2", "component2$payments_core_release", "copy", "describeContents", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "payments-core_release"})
        @Parcelize
        @StabilityInferred(parameters=0)
        public static final class SourceArgs
        extends Args {
            @NotNull
            private final Source source;
            @Nullable
            private final String stripeAccountId;
            @NotNull
            public static final Parcelable.Creator<SourceArgs> CREATOR;
            public static final int $stable;

            public SourceArgs(@NotNull Source source, @Nullable String stripeAccountId) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                super(null);
                this.source = source;
                this.stripeAccountId = stripeAccountId;
            }

            public /* synthetic */ SourceArgs(Source source, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    string = null;
                }
                this(source, string);
            }

            @NotNull
            public final Source getSource$payments_core_release() {
                return this.source;
            }

            @Nullable
            public final String getStripeAccountId$payments_core_release() {
                return this.stripeAccountId;
            }

            @Override
            public int getRequestCode() {
                return 50002;
            }

            @Override
            @NotNull
            public PaymentFlowResult.Unvalidated toResult() {
                return new PaymentFlowResult.Unvalidated(null, 0, null, false, null, this.source, this.stripeAccountId, 31, null);
            }

            public final void writeToParcel(@NotNull Parcel dest, int flags) {
                Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
                this.source.writeToParcel(dest, flags);
                dest.writeString(this.stripeAccountId);
            }

            public final int describeContents() {
                return 0;
            }

            @NotNull
            public final Source component1$payments_core_release() {
                return this.source;
            }

            @Nullable
            public final String component2$payments_core_release() {
                return this.stripeAccountId;
            }

            @NotNull
            public final SourceArgs copy(@NotNull Source source, @Nullable String stripeAccountId) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                return new SourceArgs(source, stripeAccountId);
            }

            public static /* synthetic */ SourceArgs copy$default(SourceArgs sourceArgs, Source source, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    source = sourceArgs.source;
                }
                if ((n & 2) != 0) {
                    string = sourceArgs.stripeAccountId;
                }
                return sourceArgs.copy(source, string);
            }

            @NotNull
            public String toString() {
                return "SourceArgs(source=" + this.source + ", stripeAccountId=" + this.stripeAccountId + ")";
            }

            public int hashCode() {
                int result = this.source.hashCode();
                result = result * 31 + (this.stripeAccountId == null ? 0 : this.stripeAccountId.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SourceArgs)) {
                    return false;
                }
                SourceArgs sourceArgs = (SourceArgs)other;
                if (!Intrinsics.areEqual((Object)this.source, (Object)sourceArgs.source)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.stripeAccountId, (Object)sourceArgs.stripeAccountId);
            }

            static {
                @Metadata(mv={2, 1, 0}, k=3, xi=48)
                public final class Creator
                implements Parcelable.Creator<SourceArgs> {
                    public final SourceArgs[] newArray(int size) {
                        return new SourceArgs[size];
                    }

                    public final SourceArgs createFromParcel(Parcel parcel) {
                        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                        return new SourceArgs((Source)Source.CREATOR.createFromParcel(parcel), parcel.readString());
                    }
                }
                CREATOR = new Creator();
                $stable = 8;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/PaymentRelayStarter$Legacy;", "Lcom/stripe/android/PaymentRelayStarter;", "host", "Lcom/stripe/android/view/AuthActivityStarterHost;", "<init>", "(Lcom/stripe/android/view/AuthActivityStarterHost;)V", "start", "", "args", "Lcom/stripe/android/PaymentRelayStarter$Args;", "payments-core_release"})
    @StabilityInferred(parameters=0)
    public static final class Legacy
    implements PaymentRelayStarter {
        @NotNull
        private final AuthActivityStarterHost host;
        public static final int $stable = 8;

        public Legacy(@NotNull AuthActivityStarterHost host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            this.host = host;
        }

        @Override
        public void start(@NotNull Args args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.host.startActivityForResult(PaymentRelayActivity.class, args.toResult().toBundle(), args.getRequestCode());
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/PaymentRelayStarter$Modern;", "Lcom/stripe/android/PaymentRelayStarter;", "launcher", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/PaymentRelayStarter$Args;", "<init>", "(Landroidx/activity/result/ActivityResultLauncher;)V", "start", "", "args", "payments-core_release"})
    @StabilityInferred(parameters=0)
    public static final class Modern
    implements PaymentRelayStarter {
        @NotNull
        private final ActivityResultLauncher<Args> launcher;
        public static final int $stable = 8;

        public Modern(@NotNull ActivityResultLauncher<Args> launcher) {
            Intrinsics.checkNotNullParameter(launcher, (String)"launcher");
            this.launcher = launcher;
        }

        @Override
        public void start(@NotNull Args args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.launcher.launch((Object)args);
        }
    }
}

