/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.EphemeralKey;
import com.stripe.android.EphemeralKeyManager;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.EphemeralOperation;
import com.stripe.android.OperationIdFactory;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.Stripe;
import com.stripe.android.StripeOperationIdFactory;
import com.stripe.android.core.StripeError;
import com.stripe.android.core.exception.InvalidRequestException;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeRepository;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Please use Issuing Elements instead: https://stripe.com/docs/issuing/elements")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 /2\u00020\u0001:\u0005+,-./B9\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0010J.\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0012J \u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J\u001e\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u0010H\u0082@\u00a2\u0006\u0002\u0010%J \u0010&\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u001e\u0010(\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/stripe/android/IssuingCardPinService;", "", "keyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "operationIdFactory", "Lcom/stripe/android/OperationIdFactory;", "stripeAccountId", "", "workContext", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lcom/stripe/android/EphemeralKeyProvider;Lcom/stripe/android/networking/StripeRepository;Lcom/stripe/android/OperationIdFactory;Ljava/lang/String;Lkotlin/coroutines/CoroutineContext;)V", "retrievalListeners", "", "Lcom/stripe/android/IssuingCardPinService$IssuingCardPinRetrievalListener;", "updateListeners", "Lcom/stripe/android/IssuingCardPinService$IssuingCardPinUpdateListener;", "ephemeralKeyManager", "Lcom/stripe/android/EphemeralKeyManager;", "retrievePin", "", "cardId", "verificationId", "userOneTimeCode", "listener", "updatePin", "newPin", "fireRetrievePinRequest", "ephemeralKey", "Lcom/stripe/android/EphemeralKey;", "operation", "Lcom/stripe/android/EphemeralOperation$Issuing$RetrievePin;", "onRetrievePinError", "throwable", "", "(Ljava/lang/Throwable;Lcom/stripe/android/IssuingCardPinService$IssuingCardPinRetrievalListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fireUpdatePinRequest", "Lcom/stripe/android/EphemeralOperation$Issuing$UpdatePin;", "onUpdatePinError", "(Ljava/lang/Throwable;Lcom/stripe/android/IssuingCardPinService$IssuingCardPinUpdateListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logMissingListener", "CardPinActionError", "IssuingCardPinRetrievalListener", "IssuingCardPinUpdateListener", "Listener", "Companion", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class IssuingCardPinService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StripeRepository stripeRepository;
    @NotNull
    private final OperationIdFactory operationIdFactory;
    @Nullable
    private final String stripeAccountId;
    @NotNull
    private final CoroutineContext workContext;
    @NotNull
    private final Map<String, IssuingCardPinRetrievalListener> retrievalListeners;
    @NotNull
    private final Map<String, IssuingCardPinUpdateListener> updateListeners;
    @NotNull
    private final EphemeralKeyManager ephemeralKeyManager;
    public static final int $stable = 8;
    private static final String TAG = IssuingCardPinService.class.getName();

    @VisibleForTesting
    public IssuingCardPinService(@NotNull EphemeralKeyProvider keyProvider, @NotNull StripeRepository stripeRepository, @NotNull OperationIdFactory operationIdFactory, @Nullable String stripeAccountId, @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        Intrinsics.checkNotNullParameter((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkNotNullParameter((Object)operationIdFactory, (String)"operationIdFactory");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this.stripeRepository = stripeRepository;
        this.operationIdFactory = operationIdFactory;
        this.stripeAccountId = stripeAccountId;
        this.workContext = workContext;
        this.retrievalListeners = new LinkedHashMap();
        this.updateListeners = new LinkedHashMap();
        this.ephemeralKeyManager = new EphemeralKeyManager(keyProvider, new EphemeralKeyManager.KeyManagerListener(this){
            final /* synthetic */ IssuingCardPinService this$0;
            {
                this.this$0 = $receiver;
            }

            public void onKeyUpdate(EphemeralKey ephemeralKey, EphemeralOperation operation) {
                Intrinsics.checkNotNullParameter((Object)ephemeralKey, (String)"ephemeralKey");
                Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                EphemeralOperation ephemeralOperation = operation;
                if (ephemeralOperation instanceof EphemeralOperation.Issuing.RetrievePin) {
                    IssuingCardPinRetrievalListener issuingCardPinRetrievalListener = (IssuingCardPinRetrievalListener)IssuingCardPinService.access$getRetrievalListeners$p(this.this$0).remove(((EphemeralOperation.Issuing.RetrievePin)operation).getId$payments_core_release());
                    if (issuingCardPinRetrievalListener != null) {
                        IssuingCardPinRetrievalListener issuingCardPinRetrievalListener2 = issuingCardPinRetrievalListener;
                        IssuingCardPinService issuingCardPinService = this.this$0;
                        IssuingCardPinRetrievalListener listener = issuingCardPinRetrievalListener2;
                        boolean bl = false;
                        IssuingCardPinService.access$fireRetrievePinRequest(issuingCardPinService, ephemeralKey, (EphemeralOperation.Issuing.RetrievePin)operation, listener);
                    } else {
                        IssuingCardPinService.access$logMissingListener(this.this$0);
                    }
                } else if (ephemeralOperation instanceof EphemeralOperation.Issuing.UpdatePin) {
                    IssuingCardPinUpdateListener issuingCardPinUpdateListener = (IssuingCardPinUpdateListener)IssuingCardPinService.access$getUpdateListeners$p(this.this$0).remove(((EphemeralOperation.Issuing.UpdatePin)operation).getId$payments_core_release());
                    if (issuingCardPinUpdateListener != null) {
                        IssuingCardPinUpdateListener issuingCardPinUpdateListener2 = issuingCardPinUpdateListener;
                        IssuingCardPinService issuingCardPinService = this.this$0;
                        IssuingCardPinUpdateListener listener = issuingCardPinUpdateListener2;
                        boolean bl = false;
                        IssuingCardPinService.access$fireUpdatePinRequest(issuingCardPinService, ephemeralKey, (EphemeralOperation.Issuing.UpdatePin)operation, listener);
                    } else {
                        IssuingCardPinService.access$logMissingListener(this.this$0);
                    }
                }
            }

            public void onKeyError(String operationId, int errorCode, String errorMessage, Throwable throwable) {
                block1: {
                    IssuingCardPinUpdateListener updateListener;
                    block0: {
                        IssuingCardPinRetrievalListener retrievalListener;
                        Intrinsics.checkNotNullParameter((Object)operationId, (String)"operationId");
                        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                        updateListener = (IssuingCardPinUpdateListener)IssuingCardPinService.access$getUpdateListeners$p(this.this$0).remove(operationId);
                        IssuingCardPinRetrievalListener issuingCardPinRetrievalListener = retrievalListener = (IssuingCardPinRetrievalListener)IssuingCardPinService.access$getRetrievalListeners$p(this.this$0).remove(operationId);
                        if (issuingCardPinRetrievalListener == null) break block0;
                        issuingCardPinRetrievalListener.onError(CardPinActionError.EPHEMERAL_KEY_ERROR, errorMessage, null);
                        break block1;
                    }
                    IssuingCardPinUpdateListener issuingCardPinUpdateListener = updateListener;
                    if (issuingCardPinUpdateListener == null) break block1;
                    issuingCardPinUpdateListener.onError(CardPinActionError.EPHEMERAL_KEY_ERROR, errorMessage, null);
                }
            }
        }, this.operationIdFactory, true, null, 0L, 48, null);
    }

    public /* synthetic */ IssuingCardPinService(EphemeralKeyProvider ephemeralKeyProvider, StripeRepository stripeRepository, OperationIdFactory operationIdFactory, String string, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            operationIdFactory = new StripeOperationIdFactory();
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getIO();
        }
        this(ephemeralKeyProvider, stripeRepository, operationIdFactory, string, coroutineContext);
    }

    public final void retrievePin(@NotNull String cardId, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull IssuingCardPinRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter((Object)verificationId, (String)"verificationId");
        Intrinsics.checkNotNullParameter((Object)userOneTimeCode, (String)"userOneTimeCode");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        String operationId = this.operationIdFactory.create();
        this.retrievalListeners.put(operationId, listener);
        this.ephemeralKeyManager.retrieveEphemeralKey$payments_core_release(new EphemeralOperation.Issuing.RetrievePin(cardId, verificationId, userOneTimeCode, operationId));
    }

    public final void updatePin(@NotNull String cardId, @NotNull String newPin, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull IssuingCardPinUpdateListener listener) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter((Object)newPin, (String)"newPin");
        Intrinsics.checkNotNullParameter((Object)verificationId, (String)"verificationId");
        Intrinsics.checkNotNullParameter((Object)userOneTimeCode, (String)"userOneTimeCode");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        String operationId = this.operationIdFactory.create();
        this.updateListeners.put(operationId, listener);
        this.ephemeralKeyManager.retrieveEphemeralKey$payments_core_release(new EphemeralOperation.Issuing.UpdatePin(cardId, newPin, verificationId, userOneTimeCode, operationId));
    }

    private final void fireRetrievePinRequest(EphemeralKey ephemeralKey, EphemeralOperation.Issuing.RetrievePin operation, IssuingCardPinRetrievalListener listener) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, operation, ephemeralKey, listener, null){
            int label;
            final /* synthetic */ IssuingCardPinService this$0;
            final /* synthetic */ EphemeralOperation.Issuing.RetrievePin $operation;
            final /* synthetic */ EphemeralKey $ephemeralKey;
            final /* synthetic */ IssuingCardPinRetrievalListener $listener;
            {
                this.this$0 = $receiver;
                this.$operation = $operation;
                this.$ephemeralKey = $ephemeralKey;
                this.$listener = $listener;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = IssuingCardPinService.access$getStripeRepository$p(this.this$0).retrieveIssuingCardPin-yxL6bBk(this.$operation.getCardId(), this.$operation.getVerificationId(), this.$operation.getUserOneTimeCode(), new ApiRequest.Options(this.$ephemeralKey.getSecret(), IssuingCardPinService.access$getStripeAccountId$p(this.this$0), null, 4, null), (Continuation<? super Result<String>>)((Continuation)this));
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = ((Result)$result).unbox-impl();
lbl13:
                        // 2 sources

                        var2_3 = v0;
                        var3_4 = this.$listener;
                        var4_5 = this.this$0;
                        var5_6 = this.$listener;
                        v1 = Result.exceptionOrNull-impl((Object)var2_3);
                        if (v1 != null) break;
                        pin = (String)var2_3;
                        $i$a$-fold-IssuingCardPinService$fireRetrievePinRequest$1$1 = false;
                        this.label = 2;
                        v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(var3_4, pin, null){
                            int label;
                            final /* synthetic */ IssuingCardPinRetrievalListener $listener;
                            final /* synthetic */ String $pin;
                            {
                                this.$listener = $listener;
                                this.$pin = $pin;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.$listener.onIssuingCardPinRetrieved(this.$pin);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        if (v2 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl43
                    }
                    case 2: {
                        $i$a$-fold-IssuingCardPinService$fireRetrievePinRequest$1$1 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        ** GOTO lbl43
                    }
                }
                it = v1;
                $i$a$-fold-IssuingCardPinService$fireRetrievePinRequest$1$2 = false;
                this.label = 3;
                v3 = IssuingCardPinService.access$onRetrievePinError(var4_5, it, var5_6, (Continuation)this);
                if (v3 == var8_2) {
                    return var8_2;
                }
                ** GOTO lbl43
                {
                    case 3: {
                        $i$a$-fold-IssuingCardPinService$fireRetrievePinRequest$1$2 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl43:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object onRetrievePinError(Throwable throwable, IssuingCardPinRetrievalListener listener, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(throwable, listener, null){
            int label;
            final /* synthetic */ Throwable $throwable;
            final /* synthetic */ IssuingCardPinRetrievalListener $listener;
            {
                this.$throwable = $throwable;
                this.$listener = $listener;
                super(2, $completion);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String string;
                        ResultKt.throwOnFailure((Object)object);
                        if (!(this.$throwable instanceof InvalidRequestException)) {
                            this.$listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred while retrieving the PIN.", this.$throwable);
                            return Unit.INSTANCE;
                        }
                        StripeError stripeError = ((InvalidRequestException)this.$throwable).getStripeError();
                        String string2 = string = stripeError != null ? stripeError.getCode() : null;
                        if (string != null) {
                            int n = -1;
                            switch (string.hashCode()) {
                                case -1309235419: {
                                    if (!string.equals("expired")) break;
                                    n = 1;
                                    break;
                                }
                                case 830217595: {
                                    if (!string.equals("too_many_attempts")) break;
                                    n = 2;
                                    break;
                                }
                                case 1888170818: {
                                    if (!string.equals("already_redeemed")) break;
                                    n = 3;
                                    break;
                                }
                                case -1266028985: {
                                    if (!string.equals("incorrect_code")) break;
                                    n = 4;
                                    break;
                                }
                            }
                            switch (n) {
                                case 1: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_EXPIRED, "The one-time code has expired", null);
                                    return Unit.INSTANCE;
                                }
                                case 4: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_INCORRECT, "The one-time code was incorrect.", null);
                                    return Unit.INSTANCE;
                                }
                                case 2: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_TOO_MANY_ATTEMPTS, "The verification challenge was attempted too many times.", null);
                                    return Unit.INSTANCE;
                                }
                                case 3: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_ALREADY_REDEEMED, "The verification challenge was already redeemed.", null);
                                    return Unit.INSTANCE;
                                }
                            }
                        }
                        this.$listener.onError(CardPinActionError.UNKNOWN_ERROR, "The call to retrieve the PIN failed, possibly an error with the verification.", this.$throwable);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void fireUpdatePinRequest(EphemeralKey ephemeralKey, EphemeralOperation.Issuing.UpdatePin operation, IssuingCardPinUpdateListener listener) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, operation, ephemeralKey, listener, null){
            int label;
            final /* synthetic */ IssuingCardPinService this$0;
            final /* synthetic */ EphemeralOperation.Issuing.UpdatePin $operation;
            final /* synthetic */ EphemeralKey $ephemeralKey;
            final /* synthetic */ IssuingCardPinUpdateListener $listener;
            {
                this.this$0 = $receiver;
                this.$operation = $operation;
                this.$ephemeralKey = $ephemeralKey;
                this.$listener = $listener;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = IssuingCardPinService.access$getStripeRepository$p(this.this$0).updateIssuingCardPin(this.$operation.getCardId(), this.$operation.getNewPin(), this.$operation.getVerificationId(), this.$operation.getUserOneTimeCode(), new ApiRequest.Options(this.$ephemeralKey.getSecret(), IssuingCardPinService.access$getStripeAccountId$p(this.this$0), null, 4, null), (Continuation<? super Throwable>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        error = (Throwable)v0;
                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(error, this.this$0, this.$listener, null){
                            int label;
                            final /* synthetic */ Throwable $error;
                            final /* synthetic */ IssuingCardPinService this$0;
                            final /* synthetic */ IssuingCardPinUpdateListener $listener;
                            {
                                this.$error = $error;
                                this.this$0 = $receiver;
                                this.$listener = $listener;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object object) {
                                block5: {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            if (this.$error == null) break;
                                            this.label = 1;
                                            Object object3 = IssuingCardPinService.access$onUpdatePinError(this.this$0, this.$error, this.$listener, (Continuation)this);
                                            if (object3 == object2) {
                                                return object2;
                                            }
                                            break block5;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            break block5;
                                        }
                                    }
                                    this.$listener.onIssuingCardPinUpdated();
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl22
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object onUpdatePinError(Throwable throwable, IssuingCardPinUpdateListener listener, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(throwable, listener, null){
            int label;
            final /* synthetic */ Throwable $throwable;
            final /* synthetic */ IssuingCardPinUpdateListener $listener;
            {
                this.$throwable = $throwable;
                this.$listener = $listener;
                super(2, $completion);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String string;
                        ResultKt.throwOnFailure((Object)object);
                        if (!(this.$throwable instanceof InvalidRequestException)) {
                            this.$listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred while updating the PIN.", this.$throwable);
                            return Unit.INSTANCE;
                        }
                        StripeError stripeError = ((InvalidRequestException)this.$throwable).getStripeError();
                        String string2 = string = stripeError != null ? stripeError.getCode() : null;
                        if (string != null) {
                            int n = -1;
                            switch (string.hashCode()) {
                                case -1309235419: {
                                    if (!string.equals("expired")) break;
                                    n = 1;
                                    break;
                                }
                                case 830217595: {
                                    if (!string.equals("too_many_attempts")) break;
                                    n = 2;
                                    break;
                                }
                                case 1888170818: {
                                    if (!string.equals("already_redeemed")) break;
                                    n = 3;
                                    break;
                                }
                                case -1266028985: {
                                    if (!string.equals("incorrect_code")) break;
                                    n = 4;
                                    break;
                                }
                            }
                            switch (n) {
                                case 1: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_EXPIRED, "The one-time code has expired.", null);
                                    return Unit.INSTANCE;
                                }
                                case 4: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_INCORRECT, "The one-time code was incorrect.", null);
                                    return Unit.INSTANCE;
                                }
                                case 2: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_TOO_MANY_ATTEMPTS, "The verification challenge was attempted too many times.", null);
                                    return Unit.INSTANCE;
                                }
                                case 3: {
                                    this.$listener.onError(CardPinActionError.ONE_TIME_CODE_ALREADY_REDEEMED, "The verification challenge was already redeemed.", null);
                                    return Unit.INSTANCE;
                                }
                            }
                        }
                        this.$listener.onError(CardPinActionError.UNKNOWN_ERROR, "The call to update the PIN failed, possibly an error with the verification.", this.$throwable);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void logMissingListener() {
        Log.e((String)TAG, (String)(this.getClass().getName() + " was called without a listener"));
    }

    @JvmStatic
    @NotNull
    public static final IssuingCardPinService create(@NotNull Context context, @NotNull EphemeralKeyProvider keyProvider) {
        return Companion.create(context, keyProvider);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final IssuingCardPinService create(@NotNull Context context, @NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull EphemeralKeyProvider keyProvider) {
        return Companion.create(context, publishableKey, stripeAccountId, keyProvider);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final IssuingCardPinService create(@NotNull Context context, @NotNull String publishableKey, @NotNull EphemeralKeyProvider keyProvider) {
        return Companion.create(context, publishableKey, keyProvider);
    }

    public static final /* synthetic */ StripeRepository access$getStripeRepository$p(IssuingCardPinService $this) {
        return $this.stripeRepository;
    }

    public static final /* synthetic */ String access$getStripeAccountId$p(IssuingCardPinService $this) {
        return $this.stripeAccountId;
    }

    public static final /* synthetic */ Object access$onRetrievePinError(IssuingCardPinService $this, Throwable throwable, IssuingCardPinRetrievalListener listener, Continuation $completion) {
        return $this.onRetrievePinError(throwable, listener, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$onUpdatePinError(IssuingCardPinService $this, Throwable throwable, IssuingCardPinUpdateListener listener, Continuation $completion) {
        return $this.onUpdatePinError(throwable, listener, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Map access$getRetrievalListeners$p(IssuingCardPinService $this) {
        return $this.retrievalListeners;
    }

    public static final /* synthetic */ void access$logMissingListener(IssuingCardPinService $this) {
        $this.logMissingListener();
    }

    public static final /* synthetic */ Map access$getUpdateListeners$p(IssuingCardPinService $this) {
        return $this.updateListeners;
    }

    public static final /* synthetic */ void access$fireRetrievePinRequest(IssuingCardPinService $this, EphemeralKey ephemeralKey, EphemeralOperation.Issuing.RetrievePin operation, IssuingCardPinRetrievalListener listener) {
        $this.fireRetrievePinRequest(ephemeralKey, operation, listener);
    }

    public static final /* synthetic */ void access$fireUpdatePinRequest(IssuingCardPinService $this, EphemeralKey ephemeralKey, EphemeralOperation.Issuing.UpdatePin operation, IssuingCardPinUpdateListener listener) {
        $this.fireUpdatePinRequest(ephemeralKey, operation, listener);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/IssuingCardPinService$CardPinActionError;", "", "<init>", "(Ljava/lang/String;I)V", "UNKNOWN_ERROR", "EPHEMERAL_KEY_ERROR", "ONE_TIME_CODE_INCORRECT", "ONE_TIME_CODE_EXPIRED", "ONE_TIME_CODE_TOO_MANY_ATTEMPTS", "ONE_TIME_CODE_ALREADY_REDEEMED", "payments-core_release"})
    public static final class CardPinActionError
    extends Enum<CardPinActionError> {
        public static final /* enum */ CardPinActionError UNKNOWN_ERROR = new CardPinActionError();
        public static final /* enum */ CardPinActionError EPHEMERAL_KEY_ERROR = new CardPinActionError();
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_INCORRECT = new CardPinActionError();
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_EXPIRED = new CardPinActionError();
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_TOO_MANY_ATTEMPTS = new CardPinActionError();
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_ALREADY_REDEEMED = new CardPinActionError();
        private static final /* synthetic */ CardPinActionError[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CardPinActionError[] values() {
            return (CardPinActionError[])$VALUES.clone();
        }

        public static CardPinActionError valueOf(String value) {
            return Enum.valueOf(CardPinActionError.class, value);
        }

        @NotNull
        public static EnumEntries<CardPinActionError> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = cardPinActionErrorArray = new CardPinActionError[]{CardPinActionError.UNKNOWN_ERROR, CardPinActionError.EPHEMERAL_KEY_ERROR, CardPinActionError.ONE_TIME_CODE_INCORRECT, CardPinActionError.ONE_TIME_CODE_EXPIRED, CardPinActionError.ONE_TIME_CODE_TOO_MANY_ATTEMPTS, CardPinActionError.ONE_TIME_CODE_ALREADY_REDEEMED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rH\u0007R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/IssuingCardPinService$Companion;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "create", "Lcom/stripe/android/IssuingCardPinService;", "context", "Landroid/content/Context;", "keyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "publishableKey", "stripeAccountId", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IssuingCardPinService create(@NotNull Context context, @NotNull EphemeralKeyProvider keyProvider) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
            PaymentConfiguration config2 = PaymentConfiguration.Companion.getInstance(context);
            return this.create(context, config2.getPublishableKey(), config2.getStripeAccountId(), keyProvider);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final IssuingCardPinService create(@NotNull Context context, @NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull EphemeralKeyProvider keyProvider) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
            Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
            Log.w((String)TAG, (String)"Please use Issuing Elements instead: https://stripe.com/docs/issuing/elements");
            return new IssuingCardPinService(keyProvider, new StripeApiRepository(context, () -> Companion.create$lambda$0(publishableKey), Stripe.Companion.getAppInfo(), null, null, null, null, null, null, null, new PaymentAnalyticsRequestFactory(context, (Function0<String>)((Function0)() -> Companion.create$lambda$1(publishableKey)), (Set<String>)SetsKt.setOf((Object)"IssuingCardPinService")), null, null, null, null, 31736, null), new StripeOperationIdFactory(), stripeAccountId, null, 16, null);
        }

        public static /* synthetic */ IssuingCardPinService create$default(Companion companion, Context context, String string, String string2, EphemeralKeyProvider ephemeralKeyProvider, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.create(context, string, string2, ephemeralKeyProvider);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final IssuingCardPinService create(@NotNull Context context, @NotNull String publishableKey, @NotNull EphemeralKeyProvider keyProvider) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
            Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
            return com.stripe.android.IssuingCardPinService$Companion.create$default(this, context, publishableKey, null, keyProvider, 4, null);
        }

        private static final String create$lambda$0(String $publishableKey) {
            return $publishableKey;
        }

        private static final String create$lambda$1(String $publishableKey) {
            return $publishableKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/IssuingCardPinService$IssuingCardPinRetrievalListener;", "Lcom/stripe/android/IssuingCardPinService$Listener;", "onIssuingCardPinRetrieved", "", "pin", "", "payments-core_release"})
    public static interface IssuingCardPinRetrievalListener
    extends Listener {
        public void onIssuingCardPinRetrieved(@NotNull String var1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/stripe/android/IssuingCardPinService$IssuingCardPinUpdateListener;", "Lcom/stripe/android/IssuingCardPinService$Listener;", "onIssuingCardPinUpdated", "", "payments-core_release"})
    public static interface IssuingCardPinUpdateListener
    extends Listener {
        public void onIssuingCardPinUpdated();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\bf\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lcom/stripe/android/IssuingCardPinService$Listener;", "", "onError", "", "errorCode", "Lcom/stripe/android/IssuingCardPinService$CardPinActionError;", "errorMessage", "", "exception", "", "payments-core_release"})
    public static interface Listener {
        public void onError(@NotNull CardPinActionError var1, @Nullable String var2, @Nullable Throwable var3);
    }
}

