/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import androidx.annotation.StringRes;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateHandleSupport;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.stripe.android.CustomerSession;
import com.stripe.android.R;
import com.stripe.android.analytics.PaymentSessionEventReporter;
import com.stripe.android.analytics.PaymentSessionEventReporterFactory;
import com.stripe.android.analytics.SessionSavedStateHandler;
import com.stripe.android.core.StripeError;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.CardDisplayTextFactory;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u00015BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010*\u001a\u0004\u0018\u00010\n2\u0006\u0010+\u001a\u00020\u00162\b\b\u0001\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\fH\u0002J\u0015\u00101\u001a\u00020/2\u0006\u0010+\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b2J\u0015\u00103\u001a\u00020/2\u0006\u0010+\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b4R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0013\u001a\u0016\u0012\u0012\u0012\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0018\u00010\u00070\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018R\u0016\u0010!\u001a\n #*\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001c\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0018R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00066"}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "customerSession", "Lkotlin/Result;", "Lcom/stripe/android/CustomerSession;", "selectedPaymentMethodId", "", "startedFromPaymentSession", "", "eventReporter", "Lcom/stripe/android/analytics/PaymentSessionEventReporter;", "(Landroid/app/Application;Landroidx/lifecycle/SavedStateHandle;Ljava/lang/Object;Ljava/lang/String;ZLcom/stripe/android/analytics/PaymentSessionEventReporter;)V", "cardDisplayTextFactory", "Lcom/stripe/android/view/CardDisplayTextFactory;", "Ljava/lang/Object;", "paymentMethodsData", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lcom/stripe/android/model/PaymentMethod;", "getPaymentMethodsData$payments_core_release", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "paymentMethodsJob", "Lkotlinx/coroutines/Job;", "productUsage", "", "getProductUsage$payments_core_release", "()Ljava/util/Set;", "progressData", "getProgressData$payments_core_release", "resources", "Landroid/content/res/Resources;", "kotlin.jvm.PlatformType", "getSelectedPaymentMethodId$payments_core_release", "()Ljava/lang/String;", "setSelectedPaymentMethodId$payments_core_release", "(Ljava/lang/String;)V", "snackbarData", "getSnackbarData$payments_core_release", "createSnackbarText", "paymentMethod", "stringRes", "", "getPaymentMethods", "", "isInitialFetch", "onPaymentMethodAdded", "onPaymentMethodAdded$payments_core_release", "onPaymentMethodRemoved", "onPaymentMethodRemoved$payments_core_release", "Factory", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPaymentMethodsViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentMethodsViewModel.kt\ncom/stripe/android/view/PaymentMethodsViewModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class PaymentMethodsViewModel
extends AndroidViewModel {
    @NotNull
    private final Object customerSession;
    @Nullable
    private String selectedPaymentMethodId;
    private final boolean startedFromPaymentSession;
    @NotNull
    private final PaymentSessionEventReporter eventReporter;
    private final Resources resources;
    @NotNull
    private final CardDisplayTextFactory cardDisplayTextFactory;
    @Nullable
    private volatile Job paymentMethodsJob;
    @NotNull
    private final Set<String> productUsage;
    @NotNull
    private final MutableStateFlow<Result<List<PaymentMethod>>> paymentMethodsData;
    @NotNull
    private final MutableStateFlow<String> snackbarData;
    @NotNull
    private final MutableStateFlow<Boolean> progressData;
    public static final int $stable = 8;

    public PaymentMethodsViewModel(@NotNull Application application, @NotNull SavedStateHandle savedStateHandle, @NotNull Object customerSession2, @Nullable String selectedPaymentMethodId, boolean startedFromPaymentSession2, @NotNull PaymentSessionEventReporter eventReporter) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter((Object)eventReporter, (String)"eventReporter");
        super(application);
        this.customerSession = customerSession2;
        this.selectedPaymentMethodId = selectedPaymentMethodId;
        this.startedFromPaymentSession = startedFromPaymentSession2;
        this.eventReporter = eventReporter;
        this.resources = application.getResources();
        this.cardDisplayTextFactory = new CardDisplayTextFactory((Context)application);
        Object[] objectArray = new String[2];
        String string3 = string2 = "PaymentSession";
        int n = 0;
        Object[] objectArray2 = objectArray;
        PaymentMethodsViewModel paymentMethodsViewModel = this;
        boolean bl = false;
        boolean bl2 = this.startedFromPaymentSession;
        objectArray2[n] = bl2 ? string2 : null;
        objectArray[1] = "PaymentMethodsActivity";
        paymentMethodsViewModel.productUsage = CollectionsKt.toSet((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
        this.paymentMethodsData = StateFlowKt.MutableStateFlow(null);
        this.snackbarData = StateFlowKt.MutableStateFlow(null);
        this.progressData = StateFlowKt.MutableStateFlow((Object)false);
        SessionSavedStateHandler.INSTANCE.attachTo((ViewModel)this, savedStateHandle);
        this.getPaymentMethods(true);
    }

    public /* synthetic */ PaymentMethodsViewModel(Application application, SavedStateHandle savedStateHandle, Object object, String string2, boolean bl, PaymentSessionEventReporter paymentSessionEventReporter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            Context context = application.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
            paymentSessionEventReporter = PaymentSessionEventReporterFactory.INSTANCE.create(context);
        }
        this(application, savedStateHandle, object, string2, bl, paymentSessionEventReporter);
    }

    @Nullable
    public final String getSelectedPaymentMethodId$payments_core_release() {
        return this.selectedPaymentMethodId;
    }

    public final void setSelectedPaymentMethodId$payments_core_release(@Nullable String string2) {
        this.selectedPaymentMethodId = string2;
    }

    @NotNull
    public final Set<String> getProductUsage$payments_core_release() {
        return this.productUsage;
    }

    @NotNull
    public final MutableStateFlow<Result<List<PaymentMethod>>> getPaymentMethodsData$payments_core_release() {
        return this.paymentMethodsData;
    }

    @NotNull
    public final MutableStateFlow<String> getSnackbarData$payments_core_release() {
        return this.snackbarData;
    }

    @NotNull
    public final MutableStateFlow<Boolean> getProgressData$payments_core_release() {
        return this.progressData;
    }

    public final void onPaymentMethodAdded$payments_core_release(@NotNull PaymentMethod paymentMethod) {
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        String string2 = this.createSnackbarText(paymentMethod, R.string.stripe_added);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            this.snackbarData.setValue((Object)it);
            this.snackbarData.setValue(null);
        }
        this.getPaymentMethods(false);
    }

    public final void onPaymentMethodRemoved$payments_core_release(@NotNull PaymentMethod paymentMethod) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
            String string2 = this.createSnackbarText(paymentMethod, R.string.stripe_removed);
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            this.snackbarData.setValue((Object)it);
            this.snackbarData.setValue(null);
        }
    }

    private final String createSnackbarText(PaymentMethod paymentMethod, @StringRes int stringRes) {
        String string2;
        PaymentMethod.Card card = paymentMethod.card;
        if (card != null) {
            PaymentMethod.Card paymentMethodId = card;
            boolean bl = false;
            Object[] objectArray = new Object[]{this.cardDisplayTextFactory.createUnstyled$payments_core_release(paymentMethodId)};
            string2 = this.resources.getString(stringRes, objectArray);
        } else {
            string2 = null;
        }
        return string2;
    }

    private final void getPaymentMethods(boolean isInitialFetch) {
        Job job = this.paymentMethodsJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        if (isInitialFetch) {
            this.eventReporter.onLoadStarted();
        }
        this.paymentMethodsJob = BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)((ViewModel)this)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, isInitialFetch, null){
            int label;
            final /* synthetic */ PaymentMethodsViewModel this$0;
            final /* synthetic */ boolean $isInitialFetch;
            {
                this.this$0 = $receiver;
                this.$isInitialFetch = $isInitialFetch;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.getProgressData$payments_core_release().setValue((Object)Boxing.boxBoolean((boolean)true));
                        Object object2 = PaymentMethodsViewModel.access$getCustomerSession$p(this.this$0);
                        PaymentMethodsViewModel paymentMethodsViewModel = this.this$0;
                        boolean bl = this.$isInitialFetch;
                        PaymentMethodsViewModel paymentMethodsViewModel2 = this.this$0;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                        if (throwable == null) {
                            CustomerSession it = (CustomerSession)object2;
                            boolean bl2 = false;
                            CustomerSession.getPaymentMethods$payments_core_release$default(it, PaymentMethod.Type.Card, null, null, null, paymentMethodsViewModel.getProductUsage$payments_core_release(), new CustomerSession.PaymentMethodsRetrievalWithExceptionListener(bl, paymentMethodsViewModel){
                                final /* synthetic */ boolean $isInitialFetch;
                                final /* synthetic */ PaymentMethodsViewModel this$0;
                                {
                                    this.$isInitialFetch = $isInitialFetch;
                                    this.this$0 = $receiver;
                                }

                                public void onPaymentMethodsRetrieved(@NotNull List<PaymentMethod> paymentMethods) {
                                    Intrinsics.checkNotNullParameter(paymentMethods, (String)"paymentMethods");
                                    if (this.$isInitialFetch) {
                                        PaymentMethodsViewModel.access$getEventReporter$p(this.this$0).onLoadSucceeded(this.this$0.getSelectedPaymentMethodId$payments_core_release());
                                        PaymentMethodsViewModel.access$getEventReporter$p(this.this$0).onOptionsShown();
                                    }
                                    this.this$0.getPaymentMethodsData$payments_core_release().setValue((Object)Result.box-impl((Object)Result.constructor-impl(paymentMethods)));
                                    this.this$0.getProgressData$payments_core_release().setValue((Object)false);
                                }

                                public void onError(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError, @NotNull Throwable throwable) {
                                    Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                                    if (this.$isInitialFetch) {
                                        PaymentMethodsViewModel.access$getEventReporter$p(this.this$0).onLoadFailed(throwable);
                                    }
                                    this.this$0.getPaymentMethodsData$payments_core_release().setValue((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable))));
                                    this.this$0.getProgressData$payments_core_release().setValue((Object)false);
                                }

                                public void onError(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
                                    CustomerSession.PaymentMethodsRetrievalWithExceptionListener.DefaultImpls.onError(this, errorCode, errorMessage, stripeError);
                                }
                            }, 14, null);
                        } else {
                            Throwable it = throwable;
                            boolean bl3 = false;
                            paymentMethodsViewModel2.getPaymentMethodsData$payments_core_release().setValue((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it))));
                            paymentMethodsViewModel2.getProgressData$payments_core_release().setValue((Object)Boxing.boxBoolean((boolean)false));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ Object access$getCustomerSession$p(PaymentMethodsViewModel $this) {
        return $this.customerSession;
    }

    public static final /* synthetic */ PaymentSessionEventReporter access$getEventReporter$p(PaymentMethodsViewModel $this) {
        return $this.eventReporter;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ-\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "application", "Landroid/app/Application;", "customerSession", "Lkotlin/Result;", "Lcom/stripe/android/CustomerSession;", "initialPaymentMethodId", "", "startedFromPaymentSession", "", "(Landroid/app/Application;Ljava/lang/Object;Ljava/lang/String;Z)V", "Ljava/lang/Object;", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "extras", "Landroidx/lifecycle/viewmodel/CreationExtras;", "(Ljava/lang/Class;Landroidx/lifecycle/viewmodel/CreationExtras;)Landroidx/lifecycle/ViewModel;", "payments-core_release"})
    @StabilityInferred(parameters=0)
    public static final class Factory
    implements ViewModelProvider.Factory {
        @NotNull
        private final Application application;
        @NotNull
        private final Object customerSession;
        @Nullable
        private final String initialPaymentMethodId;
        private final boolean startedFromPaymentSession;
        public static final int $stable = 8;

        public Factory(@NotNull Application application, @NotNull Object customerSession2, @Nullable String initialPaymentMethodId, boolean startedFromPaymentSession2) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            this.application = application;
            this.customerSession = customerSession2;
            this.initialPaymentMethodId = initialPaymentMethodId;
            this.startedFromPaymentSession = startedFromPaymentSession2;
        }

        @NotNull
        public <T extends ViewModel> T create(@NotNull Class<T> modelClass, @NotNull CreationExtras extras) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
            return (T)((ViewModel)new PaymentMethodsViewModel(this.application, SavedStateHandleSupport.createSavedStateHandle((CreationExtras)extras), this.customerSession, this.initialPaymentMethodId, this.startedFromPaymentSession, null, 32, null));
        }
    }
}

