/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import androidx.activity.ComponentActivity;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.OnBackPressedDispatcher;
import androidx.activity.OnBackPressedDispatcherKt;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AppCompatActivity;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ViewModelLazy;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.google.android.material.progressindicator.CircularProgressIndicator;
import com.stripe.android.R;
import com.stripe.android.auth.PaymentBrowserAuthContract;
import com.stripe.android.core.Logger;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.databinding.StripePaymentAuthWebViewActivityBinding;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import com.stripe.android.stripe3ds2.init.ui.Customization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;
import com.stripe.android.view.PaymentAuthWebChromeClient;
import com.stripe.android.view.PaymentAuthWebViewActivityViewModel;
import com.stripe.android.view.PaymentAuthWebViewClient;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0019H\u0002J\u0017\u0010\u001f\u001a\u00020\u00192\b\u0010 \u001a\u0004\u0018\u00010!H\u0001\u00a2\u0006\u0002\b\"J\u0012\u0010#\u001a\u00020\u00192\b\u0010$\u001a\u0004\u0018\u00010%H\u0014J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0019H\u0014J\u0010\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-H\u0016R\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\b\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\b\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006."}, d2={"Lcom/stripe/android/view/PaymentAuthWebViewActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "_args", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "get_args", "()Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "_args$delegate", "Lkotlin/Lazy;", "logger", "Lcom/stripe/android/core/Logger;", "getLogger", "()Lcom/stripe/android/core/Logger;", "logger$delegate", "viewBinding", "Lcom/stripe/android/databinding/StripePaymentAuthWebViewActivityBinding;", "getViewBinding", "()Lcom/stripe/android/databinding/StripePaymentAuthWebViewActivityBinding;", "viewBinding$delegate", "viewModel", "Lcom/stripe/android/view/PaymentAuthWebViewActivityViewModel;", "getViewModel", "()Lcom/stripe/android/view/PaymentAuthWebViewActivityViewModel;", "viewModel$delegate", "cancelIntentSource", "", "createResultIntent", "Landroid/content/Intent;", "paymentFlowResult", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "customizeToolbar", "onAuthComplete", "error", "", "onAuthComplete$payments_core_release", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onDestroy", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPaymentAuthWebViewActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentAuthWebViewActivity.kt\ncom/stripe/android/view/PaymentAuthWebViewActivity\n+ 2 ActivityViewModelLazy.kt\nandroidx/activity/ActivityViewModelLazyKt\n*L\n1#1,207:1\n75#2,13:208\n*S KotlinDebug\n*F\n+ 1 PaymentAuthWebViewActivity.kt\ncom/stripe/android/view/PaymentAuthWebViewActivity\n*L\n41#1:208,13\n*E\n"})
public final class PaymentAuthWebViewActivity
extends AppCompatActivity {
    @NotNull
    private final Lazy viewBinding$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StripePaymentAuthWebViewActivityBinding>(this){
        final /* synthetic */ PaymentAuthWebViewActivity this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final StripePaymentAuthWebViewActivityBinding invoke() {
            StripePaymentAuthWebViewActivityBinding stripePaymentAuthWebViewActivityBinding = StripePaymentAuthWebViewActivityBinding.inflate(this.this$0.getLayoutInflater());
            Intrinsics.checkNotNullExpressionValue((Object)stripePaymentAuthWebViewActivityBinding, (String)"inflate(...)");
            return stripePaymentAuthWebViewActivityBinding;
        }
    }));
    @NotNull
    private final Lazy _args$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PaymentBrowserAuthContract.Args>(this){
        final /* synthetic */ PaymentAuthWebViewActivity this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @Nullable
        public final PaymentBrowserAuthContract.Args invoke() {
            Intent intent = this.this$0.getIntent();
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getIntent(...)");
            return PaymentBrowserAuthContract.Companion.parseArgs$payments_core_release(intent);
        }
    }));
    @NotNull
    private final Lazy logger$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Logger>(this){
        final /* synthetic */ PaymentAuthWebViewActivity this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final Logger invoke() {
            PaymentBrowserAuthContract.Args args2 = PaymentAuthWebViewActivity.access$get_args(this.this$0);
            return Logger.Companion.getInstance(args2 != null ? args2.getEnableLogging() : false);
        }
    }));
    @NotNull
    private final Lazy viewModel$delegate;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public PaymentAuthWebViewActivity() {
        void $this$viewModels_u24default$iv;
        ComponentActivity componentActivity = (ComponentActivity)this;
        Function0 factoryProducer$iv = (Function0)new Function0<ViewModelProvider.Factory>(this){
            final /* synthetic */ PaymentAuthWebViewActivity this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                Application application = this.this$0.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
                PaymentBrowserAuthContract.Args args2 = PaymentAuthWebViewActivity.access$get_args(this.this$0);
                if (args2 == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
                return new PaymentAuthWebViewActivityViewModel.Factory(application, PaymentAuthWebViewActivity.access$getLogger(this.this$0), args2);
            }
        };
        Function0 extrasProducer$iv = null;
        boolean $i$f$viewModels = false;
        Function0 factoryPromise$iv = factoryProducer$iv;
        this.viewModel$delegate = (Lazy)new ViewModelLazy(Reflection.getOrCreateKotlinClass(PaymentAuthWebViewActivityViewModel.class), (Function0)new Function0<ViewModelStore>((ComponentActivity)$this$viewModels_u24default$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                return this.$this_viewModels.getViewModelStore();
            }
        }, factoryPromise$iv, (Function0)new Function0<CreationExtras>(extrasProducer$iv, (ComponentActivity)$this$viewModels_u24default$iv){
            final /* synthetic */ Function0 $extrasProducer;
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$extrasProducer = $extrasProducer;
                this.$this_viewModels = $receiver;
                super(0);
            }

            @NotNull
            public final CreationExtras invoke() {
                Function0 function0 = this.$extrasProducer;
                if (function0 == null || (function0 = (CreationExtras)function0.invoke()) == null) {
                    function0 = this.$this_viewModels.getDefaultViewModelCreationExtras();
                }
                return function0;
            }
        });
    }

    private final StripePaymentAuthWebViewActivityBinding getViewBinding() {
        Lazy lazy = this.viewBinding$delegate;
        return (StripePaymentAuthWebViewActivityBinding)lazy.getValue();
    }

    private final PaymentBrowserAuthContract.Args get_args() {
        Lazy lazy = this._args$delegate;
        return (PaymentBrowserAuthContract.Args)lazy.getValue();
    }

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (Logger)lazy.getValue();
    }

    private final PaymentAuthWebViewActivityViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (PaymentAuthWebViewActivityViewModel)((Object)lazy.getValue());
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PaymentBrowserAuthContract.Args args2 = this.get_args();
        if (args2 == null) {
            this.setResult(0);
            this.finish();
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
            ErrorReporter.DefaultImpls.report$default(ErrorReporter.Companion.createFallbackInstance$default(ErrorReporter.Companion, context, null, 2, null), ErrorReporter.ExpectedErrorEvent.AUTH_WEB_VIEW_NULL_ARGS, null, null, 6, null);
            return;
        }
        this.getLogger().debug("PaymentAuthWebViewActivity#onCreate()");
        this.setContentView((View)this.getViewBinding().getRoot());
        this.setSupportActionBar(this.getViewBinding().toolbar);
        this.customizeToolbar();
        OnBackPressedDispatcher onBackPressedDispatcher = this.getOnBackPressedDispatcher();
        Intrinsics.checkNotNullExpressionValue((Object)onBackPressedDispatcher, (String)"<get-onBackPressedDispatcher>(...)");
        OnBackPressedDispatcherKt.addCallback$default((OnBackPressedDispatcher)onBackPressedDispatcher, null, (boolean)false, (Function1)((Function1)new Function1<OnBackPressedCallback, Unit>(this){
            final /* synthetic */ PaymentAuthWebViewActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull OnBackPressedCallback $this$addCallback) {
                Intrinsics.checkNotNullParameter((Object)$this$addCallback, (String)"$this$addCallback");
                if (PaymentAuthWebViewActivity.access$getViewBinding((PaymentAuthWebViewActivity)this.this$0).webView.canGoBack()) {
                    PaymentAuthWebViewActivity.access$getViewBinding((PaymentAuthWebViewActivity)this.this$0).webView.goBack();
                } else {
                    PaymentAuthWebViewActivity.access$cancelIntentSource(this.this$0);
                }
            }
        }), (int)3, null);
        String clientSecret = args2.getClientSecret();
        this.setResult(-1, this.createResultIntent(this.getViewModel().getPaymentResult$payments_core_release()));
        if (StringsKt.isBlank((CharSequence)clientSecret)) {
            this.getLogger().debug("PaymentAuthWebViewActivity#onCreate() - clientSecret is blank");
            this.finish();
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
            ErrorReporter.DefaultImpls.report$default(ErrorReporter.Companion.createFallbackInstance$default(ErrorReporter.Companion, context, null, 2, null), ErrorReporter.UnexpectedErrorEvent.AUTH_WEB_VIEW_BLANK_CLIENT_SECRET, null, null, 6, null);
            return;
        }
        this.getLogger().debug("PaymentAuthWebViewActivity#onCreate() - PaymentAuthWebView init and loadUrl");
        MutableStateFlow isPagedLoaded = StateFlowKt.MutableStateFlow((Object)false);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((MutableStateFlow<Boolean>)isPagedLoaded, this, null){
            int label;
            final /* synthetic */ MutableStateFlow<Boolean> $isPagedLoaded;
            final /* synthetic */ PaymentAuthWebViewActivity this$0;
            {
                this.$isPagedLoaded = $isPagedLoaded;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$isPagedLoaded.collect(new FlowCollector(this.this$0){
                            final /* synthetic */ PaymentAuthWebViewActivity this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Nullable
                            public final Object emit(boolean shouldHide, @NotNull Continuation<? super Unit> $completion) {
                                if (shouldHide) {
                                    void $this$isGone$iv;
                                    CircularProgressIndicator circularProgressIndicator = PaymentAuthWebViewActivity.access$getViewBinding((PaymentAuthWebViewActivity)this.this$0).progressBar;
                                    Intrinsics.checkNotNullExpressionValue((Object)circularProgressIndicator, (String)"progressBar");
                                    View view = (View)circularProgressIndicator;
                                    boolean value$iv = true;
                                    boolean $i$f$setGone = false;
                                    $this$isGone$iv.setVisibility(8);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        PaymentAuthWebViewClient webViewClient2 = new PaymentAuthWebViewClient(this.getLogger(), (MutableStateFlow<Boolean>)isPagedLoaded, clientSecret, args2.getReturnUrl(), (Function1<? super Intent, Unit>)((Function1)new Function1<Intent, Unit>((Object)this){

            public final void invoke(Intent p0) {
                ((PaymentAuthWebViewActivity)((Object)this.receiver)).startActivity(p0);
            }
        }), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>((Object)this){

            public final void invoke(@Nullable Throwable p0) {
                ((PaymentAuthWebViewActivity)((Object)this.receiver)).onAuthComplete$payments_core_release(p0);
            }
        }));
        this.getViewBinding().webView.setOnLoadBlank$payments_core_release((Function0<Unit>)((Function0)new Function0<Unit>(webViewClient2){
            final /* synthetic */ PaymentAuthWebViewClient $webViewClient;
            {
                this.$webViewClient = $webViewClient;
                super(0);
            }

            public final void invoke() {
                this.$webViewClient.setHasLoadedBlank$payments_core_release(true);
            }
        }));
        this.getViewBinding().webView.setWebViewClient(webViewClient2);
        this.getViewBinding().webView.setWebChromeClient(new PaymentAuthWebChromeClient((Activity)this, this.getLogger()));
        this.getViewModel().logStart();
        this.getViewBinding().webView.loadUrl(args2.getUrl(), this.getViewModel().getExtraHeaders());
    }

    @VisibleForTesting
    public final void onAuthComplete$payments_core_release(@Nullable Throwable error) {
        if (error != null) {
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
            ErrorReporter.DefaultImpls.report$default(ErrorReporter.Companion.createFallbackInstance$default(ErrorReporter.Companion, context, null, 2, null), ErrorReporter.ExpectedErrorEvent.AUTH_WEB_VIEW_FAILURE, StripeException.Companion.create(error), null, 4, null);
            this.getViewModel().logError();
            PaymentFlowResult.Unvalidated unvalidated = this.getViewModel().getPaymentResult$payments_core_release();
            StripeException stripeException = StripeException.Companion.create(error);
            this.setResult(-1, this.createResultIntent(PaymentFlowResult.Unvalidated.copy$default(unvalidated, null, 2, stripeException, true, null, null, null, 113, null)));
        } else {
            this.getViewModel().logComplete();
        }
        this.finish();
    }

    protected void onDestroy() {
        this.getViewBinding().webViewContainer.removeAllViews();
        this.getViewBinding().webView.destroy();
        super.onDestroy();
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
            this.getLogger().debug("PaymentAuthWebViewActivity#onCreateOptionsMenu()");
            this.getMenuInflater().inflate(R.menu.stripe_payment_auth_web_view_menu, menu2);
            String string2 = this.getViewModel().getButtonText$payments_core_release();
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            this.getLogger().debug("PaymentAuthWebViewActivity#customizeToolbar() - updating close button text");
            menu2.findItem(R.id.action_close).setTitle((CharSequence)it);
        }
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.getLogger().debug("PaymentAuthWebViewActivity#onOptionsItemSelected()");
        if (item.getItemId() == R.id.action_close) {
            this.cancelIntentSource();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private final void cancelIntentSource() {
        this.setResult(-1, this.getViewModel().getCancellationResult$payments_core_release());
        this.finish();
    }

    private final void customizeToolbar() {
        block1: {
            this.getLogger().debug("PaymentAuthWebViewActivity#customizeToolbar()");
            PaymentAuthWebViewActivityViewModel.ToolbarTitleData toolbarTitleData = this.getViewModel().getToolbarTitle$payments_core_release();
            if (toolbarTitleData != null) {
                PaymentAuthWebViewActivityViewModel.ToolbarTitleData it = toolbarTitleData;
                boolean bl = false;
                this.getLogger().debug("PaymentAuthWebViewActivity#customizeToolbar() - updating toolbar title");
                this.getViewBinding().toolbar.setTitle((CharSequence)CustomizeUtils.INSTANCE.buildStyledText((Context)this, it.getText$payments_core_release(), (Customization)it.getToolbarCustomization$payments_core_release()));
            }
            String string2 = this.getViewModel().getToolbarBackgroundColor$payments_core_release();
            if (string2 == null) break block1;
            String backgroundColor = string2;
            boolean bl = false;
            this.getLogger().debug("PaymentAuthWebViewActivity#customizeToolbar() - updating toolbar background color");
            int backgroundColorInt = Color.parseColor((String)backgroundColor);
            this.getViewBinding().toolbar.setBackgroundColor(backgroundColorInt);
            CustomizeUtils.INSTANCE.setStatusBarColor((AppCompatActivity)this, backgroundColorInt);
        }
    }

    private final Intent createResultIntent(PaymentFlowResult.Unvalidated paymentFlowResult) {
        Intent intent = new Intent().putExtras(paymentFlowResult.toBundle());
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"putExtras(...)");
        return intent;
    }

    public static final /* synthetic */ StripePaymentAuthWebViewActivityBinding access$getViewBinding(PaymentAuthWebViewActivity $this) {
        return $this.getViewBinding();
    }

    public static final /* synthetic */ void access$cancelIntentSource(PaymentAuthWebViewActivity $this) {
        $this.cancelIntentSource();
    }

    public static final /* synthetic */ PaymentBrowserAuthContract.Args access$get_args(PaymentAuthWebViewActivity $this) {
        return $this.get_args();
    }

    public static final /* synthetic */ Logger access$getLogger(PaymentAuthWebViewActivity $this) {
        return $this.getLogger();
    }
}

