/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.core.analytics;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.core.networking.AnalyticsEvent;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.AnalyticsRequestFactory;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/payments/core/analytics/RealErrorReporter;", "Lcom/stripe/android/payments/core/analytics/ErrorReporter;", "analyticsRequestExecutor", "Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;", "analyticsRequestFactory", "Lcom/stripe/android/core/networking/AnalyticsRequestFactory;", "(Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;Lcom/stripe/android/core/networking/AnalyticsRequestFactory;)V", "report", "", "errorEvent", "Lcom/stripe/android/payments/core/analytics/ErrorReporter$ErrorEvent;", "stripeException", "Lcom/stripe/android/core/exception/StripeException;", "additionalNonPiiParams", "", "", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class RealErrorReporter
implements ErrorReporter {
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final AnalyticsRequestFactory analyticsRequestFactory;
    public static final int $stable = 8;

    @Inject
    public RealErrorReporter(@NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsRequestFactory analyticsRequestFactory) {
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory, (String)"analyticsRequestFactory");
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.analyticsRequestFactory = analyticsRequestFactory;
    }

    @Override
    public void report(@NotNull ErrorReporter.ErrorEvent errorEvent, @Nullable StripeException stripeException, @NotNull Map<String, String> additionalNonPiiParams) {
        Intrinsics.checkNotNullParameter((Object)errorEvent, (String)"errorEvent");
        Intrinsics.checkNotNullParameter(additionalNonPiiParams, (String)"additionalNonPiiParams");
        Map<String, String> paramsFromStripeException = stripeException == null ? MapsKt.emptyMap() : ErrorReporter.Companion.getAdditionalParamsFromStripeException(stripeException);
        Map additionalParams = MapsKt.plus(paramsFromStripeException, additionalNonPiiParams);
        this.analyticsRequestExecutor.executeAsync(this.analyticsRequestFactory.createRequest((AnalyticsEvent)errorEvent, additionalParams));
    }

    @Override
    public void reportFraudDetectionError(@NotNull StripeException error) {
        ErrorReporter.DefaultImpls.reportFraudDetectionError(this, error);
    }
}

