/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.browser.customtabs.CustomTabColorSchemeParams;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateHandleSupport;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.R;
import com.stripe.android.auth.PaymentBrowserAuthContract;
import com.stripe.android.core.browser.BrowserCapabilities;
import com.stripe.android.core.browser.BrowserCapabilitiesSupplier;
import com.stripe.android.core.exception.LocalStripeException;
import com.stripe.android.core.exception.StripeException;
import com.stripe.android.core.networking.AnalyticsRequestExecutor;
import com.stripe.android.core.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.core.utils.CreationExtrasKtxKt;
import com.stripe.android.networking.PaymentAnalyticsEvent;
import com.stripe.android.networking.PaymentAnalyticsRequestFactory;
import com.stripe.android.payments.PaymentFlowResult;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 !2\u00020\u0001:\u0002!\"B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/stripe/android/payments/StripeBrowserLauncherViewModel;", "Landroidx/lifecycle/ViewModel;", "analyticsRequestExecutor", "Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;", "paymentAnalyticsRequestFactory", "Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;", "browserCapabilities", "Lcom/stripe/android/core/browser/BrowserCapabilities;", "intentChooserTitle", "", "resolveErrorMessage", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "(Lcom/stripe/android/core/networking/AnalyticsRequestExecutor;Lcom/stripe/android/networking/PaymentAnalyticsRequestFactory;Lcom/stripe/android/core/browser/BrowserCapabilities;Ljava/lang/String;Ljava/lang/String;Landroidx/lifecycle/SavedStateHandle;)V", "value", "", "hasLaunched", "getHasLaunched", "()Z", "setHasLaunched", "(Z)V", "createCustomTabsIntent", "Landroidx/browser/customtabs/CustomTabsIntent;", "args", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "url", "Landroid/net/Uri;", "createLaunchIntent", "Landroid/content/Intent;", "getFailureIntent", "getResultIntent", "logBrowserCapabilities", "", "Companion", "Factory", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class StripeBrowserLauncherViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory;
    @NotNull
    private final BrowserCapabilities browserCapabilities;
    @NotNull
    private final String intentChooserTitle;
    @NotNull
    private final String resolveErrorMessage;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    public static final int $stable = 8;
    @NotNull
    public static final String KEY_HAS_LAUNCHED = "has_launched";

    public StripeBrowserLauncherViewModel(@NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory, @NotNull BrowserCapabilities browserCapabilities, @NotNull String intentChooserTitle, @NotNull String resolveErrorMessage, @NotNull SavedStateHandle savedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)((Object)paymentAnalyticsRequestFactory), (String)"paymentAnalyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)browserCapabilities, (String)"browserCapabilities");
        Intrinsics.checkNotNullParameter((Object)intentChooserTitle, (String)"intentChooserTitle");
        Intrinsics.checkNotNullParameter((Object)resolveErrorMessage, (String)"resolveErrorMessage");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.paymentAnalyticsRequestFactory = paymentAnalyticsRequestFactory;
        this.browserCapabilities = browserCapabilities;
        this.intentChooserTitle = intentChooserTitle;
        this.resolveErrorMessage = resolveErrorMessage;
        this.savedStateHandle = savedStateHandle;
    }

    public final boolean getHasLaunched() {
        Boolean bl = (Boolean)this.savedStateHandle.get(KEY_HAS_LAUNCHED);
        return bl != null ? bl : false;
    }

    public final void setHasLaunched(boolean value) {
        this.savedStateHandle.set(KEY_HAS_LAUNCHED, (Object)value);
    }

    @NotNull
    public final Intent createLaunchIntent(@NotNull PaymentBrowserAuthContract.Args args2) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Uri url = Uri.parse((String)args2.getUrl());
        this.logBrowserCapabilities();
        switch (WhenMappings.$EnumSwitchMapping$0[this.browserCapabilities.ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)url);
                CustomTabsIntent customTabsIntent = this.createCustomTabsIntent(args2, url);
                intent = customTabsIntent.intent;
                break;
            }
            case 2: {
                intent = new Intent("android.intent.action.VIEW", url);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Intent intent2 = intent;
        Intrinsics.checkNotNull((Object)intent2);
        Intent intent3 = intent2;
        Intent intent4 = Intent.createChooser((Intent)intent3, (CharSequence)this.intentChooserTitle);
        Intrinsics.checkNotNullExpressionValue((Object)intent4, (String)"createChooser(...)");
        return intent4;
    }

    private final CustomTabsIntent createCustomTabsIntent(PaymentBrowserAuthContract.Args args2, Uri url) {
        CustomTabsIntent customTabsIntent;
        CustomTabsIntent.Builder builder;
        CustomTabColorSchemeParams customTabColorSchemeParams;
        Integer n = args2.getStatusBarColor();
        if (n != null) {
            int statusBarColor = ((Number)n).intValue();
            boolean bl = false;
            customTabColorSchemeParams = new CustomTabColorSchemeParams.Builder().setToolbarColor(statusBarColor).build();
        } else {
            customTabColorSchemeParams = null;
        }
        CustomTabColorSchemeParams customTabColorSchemeParams2 = customTabColorSchemeParams;
        CustomTabsIntent.Builder it = builder = new CustomTabsIntent.Builder().setShareState(2);
        boolean bl = false;
        if (customTabColorSchemeParams2 != null) {
            it.setDefaultColorSchemeParams(customTabColorSchemeParams2);
        }
        CustomTabsIntent customTabsIntent2 = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabsIntent2, (String)"build(...)");
        CustomTabsIntent $this$createCustomTabsIntent_u24lambda_u242 = customTabsIntent = customTabsIntent2;
        boolean bl2 = false;
        $this$createCustomTabsIntent_u24lambda_u242.intent.setData(url);
        return customTabsIntent;
    }

    @NotNull
    public final Intent getResultIntent(@NotNull PaymentBrowserAuthContract.Args args2) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Uri url = Uri.parse((String)args2.getUrl());
        Intent intent = new Intent();
        String string2 = args2.getClientSecret();
        String string3 = url.getLastPathSegment();
        if (string3 == null) {
            string3 = "";
        }
        String string4 = string3;
        String string5 = args2.getStripeAccountId();
        boolean bl = args2.getShouldCancelSource();
        Intent intent2 = intent.putExtras(new PaymentFlowResult.Unvalidated(string2, 0, null, bl, string4, null, string5, 38, null).toBundle());
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"putExtras(...)");
        return intent2;
    }

    @NotNull
    public final Intent getFailureIntent(@NotNull PaymentBrowserAuthContract.Args args2) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Uri url = Uri.parse((String)args2.getUrl());
        LocalStripeException exception = new LocalStripeException(this.resolveErrorMessage, "failedBrowserLaunchError");
        Intent intent = new Intent();
        String string2 = args2.getClientSecret();
        String string3 = url.getLastPathSegment();
        if (string3 == null) {
            string3 = "";
        }
        String string4 = string3;
        String string5 = args2.getStripeAccountId();
        boolean bl = args2.getShouldCancelSource();
        Intent intent2 = intent.putExtras(new PaymentFlowResult.Unvalidated(string2, 2, (StripeException)exception, bl, string4, null, string5, 32, null).toBundle());
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"putExtras(...)");
        return intent2;
    }

    private final void logBrowserCapabilities() {
        PaymentAnalyticsEvent paymentAnalyticsEvent;
        switch (WhenMappings.$EnumSwitchMapping$0[this.browserCapabilities.ordinal()]) {
            case 1: {
                paymentAnalyticsEvent = PaymentAnalyticsEvent.AuthWithCustomTabs;
                break;
            }
            case 2: {
                paymentAnalyticsEvent = PaymentAnalyticsEvent.AuthWithDefaultBrowser;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PaymentAnalyticsEvent event = paymentAnalyticsEvent;
        this.analyticsRequestExecutor.executeAsync(PaymentAnalyticsRequestFactory.createRequest$payments_core_release$default(this.paymentAnalyticsRequestFactory, event, null, null, null, null, null, 62, null));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/payments/StripeBrowserLauncherViewModel$Companion;", "", "()V", "KEY_HAS_LAUNCHED", "", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u0002H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00040\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/payments/StripeBrowserLauncherViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "()V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "extras", "Landroidx/lifecycle/viewmodel/CreationExtras;", "(Ljava/lang/Class;Landroidx/lifecycle/viewmodel/CreationExtras;)Landroidx/lifecycle/ViewModel;", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class Factory
    implements ViewModelProvider.Factory {
        public static final int $stable;

        @NotNull
        public <T extends ViewModel> T create(@NotNull Class<T> modelClass, @NotNull CreationExtras extras) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
            Application application = CreationExtrasKtxKt.requireApplication((CreationExtras)extras);
            SavedStateHandle savedStateHandle = SavedStateHandleSupport.createSavedStateHandle((CreationExtras)extras);
            PaymentConfiguration config2 = PaymentConfiguration.Companion.getInstance((Context)application);
            BrowserCapabilitiesSupplier browserCapabilitiesSupplier = new BrowserCapabilitiesSupplier((Context)application);
            AnalyticsRequestExecutor analyticsRequestExecutor = (AnalyticsRequestExecutor)new DefaultAnalyticsRequestExecutor();
            PaymentAnalyticsRequestFactory paymentAnalyticsRequestFactory = new PaymentAnalyticsRequestFactory((Context)application, config2.getPublishableKey(), null, 4, null);
            BrowserCapabilities browserCapabilities = browserCapabilitiesSupplier.get();
            String string2 = application.getString(R.string.stripe_verify_your_payment);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            String string3 = application.getString(R.string.stripe_failure_reason_authentication);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            return (T)((Object)new StripeBrowserLauncherViewModel(analyticsRequestExecutor, paymentAnalyticsRequestFactory, browserCapabilities, string2, string3, savedStateHandle));
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BrowserCapabilities.values().length];
            try {
                nArray[BrowserCapabilities.CustomTabs.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrowserCapabilities.Unknown.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

