/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.annotation.RestrictTo;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.model.StripeJsonUtils;
import com.stripe.android.core.model.parsers.ModelJsonParser;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.parsers.NextActionDataParser;
import com.stripe.android.model.parsers.PaymentMethodJsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/SetupIntentJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/SetupIntent;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "ErrorJsonParser", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nSetupIntentJsonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetupIntentJsonParser.kt\ncom/stripe/android/model/parsers/SetupIntentJsonParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1549#2:114\n1620#2,3:115\n1549#2:118\n1620#2,3:119\n*S KotlinDebug\n*F\n+ 1 SetupIntentJsonParser.kt\ncom/stripe/android/model/parsers/SetupIntentJsonParser\n*L\n28#1:114\n28#1:115,3\n31#1:118\n31#1:119,3\n*E\n"})
public final class SetupIntentJsonParser
implements ModelJsonParser<SetupIntent> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final String VALUE_SETUP_INTENT = "setup_intent";
    @NotNull
    private static final String FIELD_ID = "id";
    @NotNull
    private static final String FIELD_OBJECT = "object";
    @NotNull
    private static final String FIELD_CANCELLATION_REASON = "cancellation_reason";
    @NotNull
    private static final String FIELD_CREATED = "created";
    @NotNull
    private static final String FIELD_CLIENT_SECRET = "client_secret";
    @NotNull
    private static final String FIELD_COUNTRY_CODE = "country_code";
    @NotNull
    private static final String FIELD_DESCRIPTION = "description";
    @NotNull
    private static final String FIELD_LAST_SETUP_ERROR = "last_setup_error";
    @NotNull
    private static final String FIELD_LIVEMODE = "livemode";
    @NotNull
    private static final String FIELD_NEXT_ACTION = "next_action";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_TYPES = "payment_method_types";
    @NotNull
    private static final String FIELD_STATUS = "status";
    @NotNull
    private static final String FIELD_USAGE = "usage";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD = "payment_method";
    @NotNull
    private static final String FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES = "unactivated_payment_method_types";
    @NotNull
    private static final String FIELD_LINK_FUNDING_SOURCES = "link_funding_sources";
    @NotNull
    private static final String FIELD_PAYMENT_METHOD_OPTIONS = "payment_method_options";

    /*
     * WARNING - void declaration
     */
    @Nullable
    public SetupIntent parse(@NotNull JSONObject json) {
        StripeIntent.NextActionData nextActionData;
        SetupIntent.Error error;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        String string2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        PaymentMethod paymentMethod;
        Object it;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        String objectType = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_OBJECT);
        if (!Intrinsics.areEqual((Object)VALUE_SETUP_INTENT, (Object)objectType)) {
            return null;
        }
        JSONObject jSONObject = json.optJSONObject(FIELD_PAYMENT_METHOD);
        if (jSONObject != null) {
            it = jSONObject;
            boolean bl = false;
            paymentMethod = new PaymentMethodJsonParser().parse((JSONObject)it);
        } else {
            paymentMethod = null;
        }
        PaymentMethod paymentMethod2 = paymentMethod;
        Object it2 = it = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PAYMENT_METHOD);
        boolean $i$a$-takeIf-SetupIntentJsonParser$parse$paymentMethodId$22 = false;
        Object object = paymentMethod2 == null ? it : null;
        if (object == null) {
            PaymentMethod paymentMethod3 = paymentMethod2;
            object = paymentMethod3 != null ? paymentMethod3.id : null;
        }
        Object paymentMethodId = object;
        it = ModelJsonParser.Companion.jsonArrayToList(json.optJSONArray(FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES));
        boolean $i$f$map22 = false;
        void $i$a$-takeIf-SetupIntentJsonParser$parse$paymentMethodId$22 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = it3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            collection.add(string3);
        }
        List unactivatedPaymentMethods = (List)destination$iv$iv;
        Iterable $i$f$map22 = ModelJsonParser.Companion.jsonArrayToList(json.optJSONArray(FIELD_LINK_FUNDING_SOURCES));
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it4;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string4 = it4.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            collection.add(string4);
        }
        List linkFundingSources = (List)destination$iv$iv2;
        JSONObject jSONObject2 = json.optJSONObject(FIELD_PAYMENT_METHOD_OPTIONS);
        String paymentMethodOptions = jSONObject2 != null ? jSONObject2.toString() : null;
        String string5 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_ID);
        long l = json.optLong(FIELD_CREATED);
        String string6 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CLIENT_SECRET);
        Object object2 = SetupIntent.CancellationReason.Companion.fromCode$payments_core_release(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CANCELLATION_REASON));
        string2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_COUNTRY_CODE);
        String string7 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_DESCRIPTION);
        boolean bl = json.optBoolean(FIELD_LIVEMODE);
        List list = ModelJsonParser.Companion.jsonArrayToList(json.optJSONArray(FIELD_PAYMENT_METHOD_TYPES));
        StripeIntent.Status status = StripeIntent.Status.Companion.fromCode$payments_core_release(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_STATUS));
        StripeIntent.Usage usage = StripeIntent.Usage.Companion.fromCode$payments_core_release(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_USAGE));
        JSONObject jSONObject3 = json.optJSONObject(FIELD_LAST_SETUP_ERROR);
        if (jSONObject3 != null) {
            JSONObject it5 = jSONObject3;
            boolean bl3 = false;
            error = new ErrorJsonParser().parse(it5);
        } else {
            error = null;
        }
        SetupIntent.Error error2 = error;
        JSONObject jSONObject4 = json.optJSONObject(FIELD_NEXT_ACTION);
        if (jSONObject4 != null) {
            JSONObject it6 = jSONObject4;
            boolean bl4 = false;
            nextActionData = new NextActionDataParser().parse(it6);
        } else {
            nextActionData = null;
        }
        StripeIntent.NextActionData nextActionData2 = nextActionData;
        return new SetupIntent(string5, (SetupIntent.CancellationReason)((Object)object2), l, string2, string6, string7, bl, paymentMethod2, (String)paymentMethodId, list, status, usage, error2, unactivatedPaymentMethods, linkFundingSources, nextActionData2, paymentMethodOptions);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/model/parsers/SetupIntentJsonParser$Companion;", "", "()V", "FIELD_CANCELLATION_REASON", "", "FIELD_CLIENT_SECRET", "FIELD_COUNTRY_CODE", "FIELD_CREATED", "FIELD_DESCRIPTION", "FIELD_ID", "FIELD_LAST_SETUP_ERROR", "FIELD_LINK_FUNDING_SOURCES", "FIELD_LIVEMODE", "FIELD_NEXT_ACTION", "FIELD_OBJECT", "FIELD_PAYMENT_METHOD", "FIELD_PAYMENT_METHOD_OPTIONS", "FIELD_PAYMENT_METHOD_TYPES", "FIELD_STATUS", "FIELD_UNACTIVATED_PAYMENT_METHOD_TYPES", "FIELD_USAGE", "VALUE_SETUP_INTENT", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SetupIntentJsonParser$ErrorJsonParser;", "Lcom/stripe/android/core/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/SetupIntent$Error;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "payments-core_release"})
    @StabilityInferred(parameters=1)
    public static final class ErrorJsonParser
    implements ModelJsonParser<SetupIntent.Error> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        public static final int $stable;
        @NotNull
        private static final String FIELD_CODE = "code";
        @NotNull
        private static final String FIELD_DECLINE_CODE = "decline_code";
        @NotNull
        private static final String FIELD_DOC_URL = "doc_url";
        @NotNull
        private static final String FIELD_MESSAGE = "message";
        @NotNull
        private static final String FIELD_PARAM = "param";
        @NotNull
        private static final String FIELD_PAYMENT_METHOD = "payment_method";
        @NotNull
        private static final String FIELD_TYPE = "type";

        /*
         * WARNING - void declaration
         */
        @NotNull
        public SetupIntent.Error parse(@NotNull JSONObject json) {
            PaymentMethod paymentMethod;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String string2 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_CODE);
            String string3 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_DECLINE_CODE);
            String string4 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_DOC_URL);
            String string5 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_MESSAGE);
            String string6 = StripeJsonUtils.optString((JSONObject)json, (String)FIELD_PARAM);
            JSONObject jSONObject = json.optJSONObject("payment_method");
            if (jSONObject != null) {
                void it;
                JSONObject jSONObject2 = jSONObject;
                String string7 = string6;
                String string8 = string5;
                String string9 = string4;
                String string10 = string3;
                String string11 = string2;
                boolean bl = false;
                PaymentMethod paymentMethod2 = new PaymentMethodJsonParser().parse((JSONObject)it);
                string2 = string11;
                string3 = string10;
                string4 = string9;
                string5 = string8;
                string6 = string7;
                paymentMethod = paymentMethod2;
            } else {
                paymentMethod = null;
            }
            SetupIntent.Error.Type type = SetupIntent.Error.Type.Companion.fromCode$payments_core_release(StripeJsonUtils.optString((JSONObject)json, (String)FIELD_TYPE));
            PaymentMethod paymentMethod3 = paymentMethod;
            String string12 = string6;
            String string13 = string5;
            String string14 = string4;
            String string15 = string3;
            String string16 = string2;
            return new SetupIntent.Error(string16, string15, string14, string13, string12, paymentMethod3, type);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/model/parsers/SetupIntentJsonParser$ErrorJsonParser$Companion;", "", "()V", "FIELD_CODE", "", "FIELD_DECLINE_CODE", "FIELD_DOC_URL", "FIELD_MESSAGE", "FIELD_PARAM", "FIELD_PAYMENT_METHOD", "FIELD_TYPE", "payments-core_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

