/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.googlepaylauncher;

import android.app.Application;
import android.content.Context;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.SavedStateHandleSupport;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.PaymentsClient;
import com.stripe.android.GooglePayJsonFactory;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.core.exception.APIConnectionException;
import com.stripe.android.core.exception.InvalidRequestException;
import com.stripe.android.core.networking.ApiRequest;
import com.stripe.android.core.utils.CreationExtrasKtxKt;
import com.stripe.android.googlepaylauncher.ConvertKt;
import com.stripe.android.googlepaylauncher.GooglePayPaymentMethodLauncher;
import com.stripe.android.googlepaylauncher.GooglePayPaymentMethodLauncherContractV2;
import com.stripe.android.googlepaylauncher.GooglePayPaymentMethodLauncherViewModel;
import com.stripe.android.googlepaylauncher.GooglePayRepository;
import com.stripe.android.googlepaylauncher.TasksKt;
import com.stripe.android.googlepaylauncher.injection.DaggerGooglePayPaymentMethodLauncherViewModelFactoryComponent;
import com.stripe.android.googlepaylauncher.injection.GooglePayPaymentMethodLauncherViewModelSubcomponent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.networking.StripeRepository;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 /2\u00020\u0001:\u0002/0B?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001f\u001a\u00020 H\u0007J\u0016\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#H\u0086@\u00a2\u0006\u0002\u0010$J\u0015\u0010%\u001a\u00020&2\u0006\u0010\u0006\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b'J\u000e\u0010(\u001a\u00020\u0019H\u0087@\u00a2\u0006\u0002\u0010)J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020#0+H\u0086@\u00a2\u0006\u0002\u0010)J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0013R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00198@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherViewModel;", "Landroidx/lifecycle/ViewModel;", "paymentsClient", "Lcom/google/android/gms/wallet/PaymentsClient;", "requestOptions", "Lcom/stripe/android/core/networking/ApiRequest$Options;", "args", "Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherContractV2$Args;", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "googlePayJsonFactory", "Lcom/stripe/android/GooglePayJsonFactory;", "googlePayRepository", "Lcom/stripe/android/googlepaylauncher/GooglePayRepository;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "(Lcom/google/android/gms/wallet/PaymentsClient;Lcom/stripe/android/core/networking/ApiRequest$Options;Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherContractV2$Args;Lcom/stripe/android/networking/StripeRepository;Lcom/stripe/android/GooglePayJsonFactory;Lcom/stripe/android/googlepaylauncher/GooglePayRepository;Landroidx/lifecycle/SavedStateHandle;)V", "_googleResult", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncher$Result;", "googlePayResult", "Lkotlinx/coroutines/flow/StateFlow;", "getGooglePayResult$payments_core_release", "()Lkotlinx/coroutines/flow/StateFlow;", "value", "", "hasLaunched", "getHasLaunched$payments_core_release", "()Z", "setHasLaunched$payments_core_release", "(Z)V", "createPaymentDataRequest", "Lorg/json/JSONObject;", "createPaymentMethod", "paymentData", "Lcom/google/android/gms/wallet/PaymentData;", "(Lcom/google/android/gms/wallet/PaymentData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createTransactionInfo", "Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo;", "createTransactionInfo$payments_core_release", "isReadyToPay", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadPaymentData", "Lcom/google/android/gms/tasks/Task;", "updateResult", "", "result", "Companion", "Factory", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class GooglePayPaymentMethodLauncherViewModel
extends ViewModel {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PaymentsClient paymentsClient;
    @NotNull
    private final ApiRequest.Options requestOptions;
    @NotNull
    private final GooglePayPaymentMethodLauncherContractV2.Args args;
    @NotNull
    private final StripeRepository stripeRepository;
    @NotNull
    private final GooglePayJsonFactory googlePayJsonFactory;
    @NotNull
    private final GooglePayRepository googlePayRepository;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final MutableStateFlow<GooglePayPaymentMethodLauncher.Result> _googleResult;
    @NotNull
    private final StateFlow<GooglePayPaymentMethodLauncher.Result> googlePayResult;
    public static final int $stable = 8;
    @NotNull
    private static final String HAS_LAUNCHED_KEY = "has_launched";

    @Inject
    public GooglePayPaymentMethodLauncherViewModel(@NotNull PaymentsClient paymentsClient, @NotNull ApiRequest.Options requestOptions, @NotNull GooglePayPaymentMethodLauncherContractV2.Args args2, @NotNull StripeRepository stripeRepository2, @NotNull GooglePayJsonFactory googlePayJsonFactory, @NotNull GooglePayRepository googlePayRepository, @NotNull SavedStateHandle savedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)paymentsClient, (String)"paymentsClient");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Intrinsics.checkNotNullParameter((Object)stripeRepository2, (String)"stripeRepository");
        Intrinsics.checkNotNullParameter((Object)googlePayJsonFactory, (String)"googlePayJsonFactory");
        Intrinsics.checkNotNullParameter((Object)googlePayRepository, (String)"googlePayRepository");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        this.paymentsClient = paymentsClient;
        this.requestOptions = requestOptions;
        this.args = args2;
        this.stripeRepository = stripeRepository2;
        this.googlePayJsonFactory = googlePayJsonFactory;
        this.googlePayRepository = googlePayRepository;
        this.savedStateHandle = savedStateHandle;
        this._googleResult = StateFlowKt.MutableStateFlow(null);
        this.googlePayResult = FlowKt.asStateFlow(this._googleResult);
    }

    public final boolean getHasLaunched$payments_core_release() {
        return Intrinsics.areEqual((Object)this.savedStateHandle.get(HAS_LAUNCHED_KEY), (Object)true);
    }

    public final void setHasLaunched$payments_core_release(boolean value) {
        this.savedStateHandle.set(HAS_LAUNCHED_KEY, (Object)value);
    }

    @NotNull
    public final StateFlow<GooglePayPaymentMethodLauncher.Result> getGooglePayResult$payments_core_release() {
        return this.googlePayResult;
    }

    public final void updateResult(@NotNull GooglePayPaymentMethodLauncher.Result result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this._googleResult.setValue((Object)result2);
    }

    @VisibleForTesting
    @Nullable
    public final Object isReadyToPay(@NotNull Continuation<? super Boolean> $completion) {
        return FlowKt.first(this.googlePayRepository.isReady(), $completion);
    }

    @VisibleForTesting
    @NotNull
    public final JSONObject createPaymentDataRequest() {
        GooglePayJsonFactory googlePayJsonFactory = this.googlePayJsonFactory;
        GooglePayJsonFactory.TransactionInfo transactionInfo = this.createTransactionInfo$payments_core_release(this.args);
        GooglePayJsonFactory.MerchantInfo merchantInfo = new GooglePayJsonFactory.MerchantInfo(this.args.getConfig$payments_core_release().getMerchantName());
        GooglePayJsonFactory.BillingAddressParameters billingAddressParameters = ConvertKt.convert(this.args.getConfig$payments_core_release().getBillingAddressConfig());
        boolean bl = this.args.getConfig$payments_core_release().isEmailRequired();
        boolean bl2 = this.args.getConfig$payments_core_release().getAllowCreditCards();
        return GooglePayJsonFactory.createPaymentDataRequest$default(googlePayJsonFactory, transactionInfo, billingAddressParameters, null, bl, merchantInfo, bl2, 4, null);
    }

    @VisibleForTesting
    @NotNull
    public final GooglePayJsonFactory.TransactionInfo createTransactionInfo$payments_core_release(@NotNull GooglePayPaymentMethodLauncherContractV2.Args args2) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        return new GooglePayJsonFactory.TransactionInfo(args2.getCurrencyCode$payments_core_release(), GooglePayJsonFactory.TransactionInfo.TotalPriceStatus.Estimated, args2.getConfig$payments_core_release().getMerchantCountryCode(), args2.getTransactionId$payments_core_release(), args2.getAmount$payments_core_release(), args2.getLabel$payments_core_release(), GooglePayJsonFactory.TransactionInfo.CheckoutOption.Default);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object loadPaymentData(@NotNull Continuation<? super Task<PaymentData>> var1_1) {
        if (!(var1_1 instanceof loadPaymentData.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GooglePayPaymentMethodLauncherViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.loadPaymentData((Continuation<? super Task<PaymentData>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.isReadyToPay((Continuation<? super Boolean>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (GooglePayPaymentMethodLauncherViewModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    $i$a$-check-GooglePayPaymentMethodLauncherViewModel$loadPaymentData$2 = false;
                    var2_6 = "Google Pay is unavailable.";
                    throw new IllegalStateException(var2_6.toString());
                }
                v1 = this.paymentsClient.loadPaymentData(PaymentDataRequest.fromJson((String)this.createPaymentDataRequest().toString()));
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"loadPaymentData(...)");
                $continuation.L$0 = null;
                $continuation.label = 2;
                v2 = TasksKt.awaitTask$default(v1, null, (Continuation)$continuation, 1, null);
                if (v2 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl37
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl37:
                // 2 sources

                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createPaymentMethod(@NotNull PaymentData var1_1, @NotNull Continuation<? super GooglePayPaymentMethodLauncher.Result> var2_2) {
        if (!(var2_2 instanceof createPaymentMethod.1)) ** GOTO lbl-1000
        var10_3 = var2_2;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ GooglePayPaymentMethodLauncherViewModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createPaymentMethod(null, (Continuation<? super GooglePayPaymentMethodLauncher.Result>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                paymentDataJson = new JSONObject(paymentData.toJson());
                params = PaymentMethodCreateParams.Companion.createFromGooglePay(paymentDataJson);
                $continuation.label = 1;
                v0 = this.stripeRepository.createPaymentMethod-0E7RQCE(params, this.requestOptions, (Continuation<? super Result<PaymentMethod>>)$continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = ((Result)$result).unbox-impl();
lbl22:
                // 2 sources

                var5_8 = v0;
                v1 = Result.exceptionOrNull-impl((Object)var5_8);
                if (v1 == null) {
                    it = (PaymentMethod)var5_8;
                    $i$a$-fold-GooglePayPaymentMethodLauncherViewModel$createPaymentMethod$2 = false;
                    v2 = new GooglePayPaymentMethodLauncher.Result.Completed(it);
                } else {
                    it = v1;
                    $i$a$-fold-GooglePayPaymentMethodLauncherViewModel$createPaymentMethod$3 = false;
                    var8_13 = it;
                    v2 = new GooglePayPaymentMethodLauncher.Result.Failed(it, var8_13 instanceof APIConnectionException != false ? 3 : (var8_13 instanceof InvalidRequestException != false ? 2 : 1));
                }
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherViewModel$Companion;", "", "()V", "HAS_LAUNCHED_KEY", "", "payments-core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\u0005\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "args", "Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherContractV2$Args;", "(Lcom/stripe/android/googlepaylauncher/GooglePayPaymentMethodLauncherContractV2$Args;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "extras", "Landroidx/lifecycle/viewmodel/CreationExtras;", "(Ljava/lang/Class;Landroidx/lifecycle/viewmodel/CreationExtras;)Landroidx/lifecycle/ViewModel;", "payments-core_release"})
    @StabilityInferred(parameters=0)
    public static final class Factory
    implements ViewModelProvider.Factory {
        @NotNull
        private final GooglePayPaymentMethodLauncherContractV2.Args args;
        public static final int $stable = 8;

        public Factory(@NotNull GooglePayPaymentMethodLauncherContractV2.Args args2) {
            Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
            this.args = args2;
        }

        @NotNull
        public <T extends ViewModel> T create(@NotNull Class<T> modelClass, @NotNull CreationExtras extras) {
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
            Application application = CreationExtrasKtxKt.requireApplication((CreationExtras)extras);
            SavedStateHandle savedStateHandle = SavedStateHandleSupport.createSavedStateHandle((CreationExtras)extras);
            GooglePayPaymentMethodLauncherViewModelSubcomponent.Builder subComponentBuilder2 = DaggerGooglePayPaymentMethodLauncherViewModelFactoryComponent.builder().context((Context)application).enableLogging(false).publishableKeyProvider((Function0<String>)((Function0)new Function0<String>(application){
                final /* synthetic */ Application $application;
                {
                    this.$application = $application;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return PaymentConfiguration.Companion.getInstance((Context)this.$application).getPublishableKey();
                }
            })).stripeAccountIdProvider((Function0<String>)((Function0)new Function0<String>(application){
                final /* synthetic */ Application $application;
                {
                    this.$application = $application;
                    super(0);
                }

                @Nullable
                public final String invoke() {
                    return PaymentConfiguration.Companion.getInstance((Context)this.$application).getStripeAccountId();
                }
            })).productUsage(SetsKt.setOf((Object)"GooglePayPaymentMethodLauncher")).googlePayConfig(this.args.getConfig$payments_core_release()).build().getSubcomponentBuilder();
            GooglePayPaymentMethodLauncherViewModel googlePayPaymentMethodLauncherViewModel = subComponentBuilder2.args(this.args).savedStateHandle(savedStateHandle).build().getViewModel();
            Intrinsics.checkNotNull((Object)((Object)googlePayPaymentMethodLauncherViewModel), (String)"null cannot be cast to non-null type T of com.stripe.android.googlepaylauncher.GooglePayPaymentMethodLauncherViewModel.Factory.create");
            return (T)((Object)googlePayPaymentMethodLauncherViewModel);
        }
    }
}

