/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.analytics;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import com.stripe.android.analytics.Session;
import com.stripe.android.core.networking.AnalyticsRequestFactory;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\nH\u0007J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/analytics/SessionSavedStateHandler;", "", "()V", "SESSION_KEY", "", "getSESSION_KEY$payments_core_release$annotations", "sessionLocked", "", "attachTo", "Lkotlin/Function0;", "", "viewModel", "Landroidx/lifecycle/ViewModel;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "clear", "clearSession", "restartSession", "startSession", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class SessionSavedStateHandler {
    @NotNull
    public static final SessionSavedStateHandler INSTANCE = new SessionSavedStateHandler();
    @NotNull
    public static final String SESSION_KEY = "STRIPE_ANALYTICS_LOCAL_SESSION";
    private static boolean sessionLocked;
    public static final int $stable;

    private SessionSavedStateHandler() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getSESSION_KEY$payments_core_release$annotations() {
    }

    @NotNull
    public final Function0<Unit> attachTo(@NotNull ViewModel viewModel2, @NotNull SavedStateHandle savedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)viewModel2, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        this.startSession(savedStateHandle);
        viewModel2.addCloseable(() -> SessionSavedStateHandler.attachTo$lambda$0(savedStateHandle));
        return (Function0)new Function0<Unit>(savedStateHandle){
            final /* synthetic */ SavedStateHandle $savedStateHandle;
            {
                this.$savedStateHandle = $savedStateHandle;
                super(0);
            }

            public final void invoke() {
                SessionSavedStateHandler.access$restartSession(SessionSavedStateHandler.INSTANCE, this.$savedStateHandle);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void startSession(SavedStateHandle savedStateHandle) {
        Session session = (Session)savedStateHandle.get(SESSION_KEY);
        if (session != null) {
            Session session2;
            Session session3 = session;
            boolean bl = false;
            Session storedSession = session2 = session3;
            boolean bl2 = false;
            Session session4 = storedSession;
            if (session4 instanceof Session.Owner) {
                UUID uUID = UUID.fromString(((Session.Owner)storedSession).getId());
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
                AnalyticsRequestFactory.Companion.setSessionId(uUID);
                sessionLocked = true;
                return;
            }
            if (!(session4 instanceof Session.Observer)) return;
            return;
        } else {
            Session session5;
            SessionSavedStateHandler $this$startSession_u24lambda_u243 = this;
            boolean bl = false;
            if (!sessionLocked) {
                sessionLocked = true;
                UUID id2 = UUID.randomUUID();
                Intrinsics.checkNotNull((Object)id2);
                AnalyticsRequestFactory.Companion.setSessionId(id2);
                String string2 = id2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                session5 = new Session.Owner(string2);
            } else {
                session5 = Session.Observer.INSTANCE;
            }
            Session session6 = session5;
            savedStateHandle.set(SESSION_KEY, (Object)session6);
        }
    }

    private final void restartSession(SavedStateHandle savedStateHandle) {
        Session session = (Session)savedStateHandle.get(SESSION_KEY);
        if (session != null) {
            Session session2;
            Session session3 = session;
            boolean bl = false;
            Session storedSession = session2 = session3;
            boolean bl2 = false;
            Session session4 = storedSession;
            if (session4 instanceof Session.Owner) {
                UUID id2 = UUID.randomUUID();
                Intrinsics.checkNotNull((Object)id2);
                AnalyticsRequestFactory.Companion.setSessionId(id2);
                String string2 = id2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                savedStateHandle.set(SESSION_KEY, (Object)new Session.Owner(string2));
            } else if (session4 instanceof Session.Observer) {
                // empty if block
            }
        }
    }

    private final void clearSession(SavedStateHandle savedStateHandle) {
        Session session = (Session)savedStateHandle.get(SESSION_KEY);
        if (session != null) {
            Session session2;
            Session session3 = session;
            boolean bl = false;
            Session storedSession = session2 = session3;
            boolean bl2 = false;
            Session session4 = storedSession;
            if (session4 instanceof Session.Owner) {
                sessionLocked = false;
            } else if (session4 instanceof Session.Observer) {
                // empty if block
            }
        }
    }

    @VisibleForTesting
    public final void clear() {
        sessionLocked = false;
    }

    private static final void attachTo$lambda$0(SavedStateHandle $savedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)$savedStateHandle, (String)"$savedStateHandle");
        INSTANCE.clearSession($savedStateHandle);
    }

    public static final /* synthetic */ void access$restartSession(SessionSavedStateHandler $this, SavedStateHandle savedStateHandle) {
        $this.restartSession(savedStateHandle);
    }

    static {
        $stable = 8;
    }
}

