/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import androidx.annotation.IntRange;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.CustomerSession;
import com.stripe.android.CustomerSessionOperationExecutor;
import com.stripe.android.EphemeralKey;
import com.stripe.android.EphemeralKeyManager;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.EphemeralOperation;
import com.stripe.android.OperationIdFactory;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.Stripe;
import com.stripe.android.StripeOperationIdFactory;
import com.stripe.android.core.StripeError;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeRepository;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Please use Mobile Payment Element instead. If you are already using Basic Integration, learn how to migrate here: https://docs.stripe.com/payments/mobile/migrating-to-mobile-payment-element-from-basic-integration")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 Z2\u00020\u0001:\bZ[\\]^_`aBQ\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0012\b\u0002\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/J3\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0005012\u0006\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b2J\u0016\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\u00052\u0006\u0010.\u001a\u000205J+\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0005012\u0006\u0010.\u001a\u000205H\u0000\u00a2\u0006\u0002\b6J\r\u00107\u001a\u00020+H\u0000\u00a2\u0006\u0002\b8J\u0016\u00109\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/J+\u00109\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0005012\u0006\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b:J\u0016\u0010;\u001a\u00020+2\u0006\u00104\u001a\u00020\u00052\u0006\u0010.\u001a\u000205J+\u0010;\u001a\u00020+2\u0006\u00104\u001a\u00020\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0005012\u0006\u0010.\u001a\u000205H\u0000\u00a2\u0006\u0002\b<J#\u0010=\u001a\u0004\u0018\u0001H>\"\n\b\u0000\u0010>*\u0004\u0018\u00010'2\u0006\u0010?\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010@J\u0016\u0010A\u001a\u00020+2\u0006\u0010B\u001a\u00020C2\u0006\u0010.\u001a\u00020DJA\u0010A\u001a\u00020+2\u0006\u0010B\u001a\u00020C2\n\b\u0001\u0010E\u001a\u0004\u0018\u00010F2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010H\u001a\u0004\u0018\u00010\u00052\u0006\u0010.\u001a\u00020DH\u0007\u00a2\u0006\u0002\u0010IJQ\u0010A\u001a\u00020+2\u0006\u0010B\u001a\u00020C2\n\b\u0003\u0010E\u001a\u0004\u0018\u00010F2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010H\u001a\u0004\u0018\u00010\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0005012\u0006\u0010.\u001a\u00020DH\u0000\u00a2\u0006\u0004\bJ\u0010KJ\u000e\u0010L\u001a\u00020+2\u0006\u0010.\u001a\u00020MJ#\u0010L\u001a\u00020+2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0005012\u0006\u0010.\u001a\u00020MH\u0000\u00a2\u0006\u0002\bNJ\u001e\u0010O\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020MJ3\u0010O\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0005012\u0006\u0010.\u001a\u00020MH\u0000\u00a2\u0006\u0002\bPJ\u0016\u0010Q\u001a\u00020+2\u0006\u0010R\u001a\u00020S2\u0006\u0010.\u001a\u00020MJ+\u0010Q\u001a\u00020+2\u0006\u0010R\u001a\u00020S2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0005012\u0006\u0010.\u001a\u00020MH\u0000\u00a2\u0006\u0002\bTJ\u001a\u0010U\u001a\u00020+2\u0006\u0010V\u001a\u00020W2\b\u0010.\u001a\u0004\u0018\u00010'H\u0002J\u000e\u0010X\u001a\u00020+2\u0006\u0010.\u001a\u00020MJ#\u0010X\u001a\u00020+2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0005012\u0006\u0010.\u001a\u00020MH\u0000\u00a2\u0006\u0002\bYR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0015\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lcom/stripe/android/CustomerSession;", "", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "publishableKey", "", "stripeAccountId", "workContext", "Lkotlin/coroutines/CoroutineContext;", "operationIdFactory", "Lcom/stripe/android/OperationIdFactory;", "timeSupplier", "Lkotlin/Function0;", "", "Lcom/stripe/android/TimeSupplier;", "ephemeralKeyManagerFactory", "Lcom/stripe/android/EphemeralKeyManager$Factory;", "(Lcom/stripe/android/networking/StripeRepository;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/CoroutineContext;Lcom/stripe/android/OperationIdFactory;Lkotlin/jvm/functions/Function0;Lcom/stripe/android/EphemeralKeyManager$Factory;)V", "cachedCustomer", "Lcom/stripe/android/model/Customer;", "getCachedCustomer", "()Lcom/stripe/android/model/Customer;", "canUseCachedCustomer", "", "getCanUseCachedCustomer", "()Z", "customer", "getCustomer$payments_core_release", "setCustomer$payments_core_release", "(Lcom/stripe/android/model/Customer;)V", "customerCacheTime", "getCustomerCacheTime$payments_core_release", "()J", "setCustomerCacheTime$payments_core_release", "(J)V", "ephemeralKeyManager", "Lcom/stripe/android/EphemeralKeyManager;", "listeners", "", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "operationExecutor", "Lcom/stripe/android/CustomerSessionOperationExecutor;", "addCustomerSource", "", "sourceId", "sourceType", "listener", "Lcom/stripe/android/CustomerSession$SourceRetrievalListener;", "productUsage", "", "addCustomerSource$payments_core_release", "attachPaymentMethod", "paymentMethodId", "Lcom/stripe/android/CustomerSession$PaymentMethodRetrievalListener;", "attachPaymentMethod$payments_core_release", "cancel", "cancel$payments_core_release", "deleteCustomerSource", "deleteCustomerSource$payments_core_release", "detachPaymentMethod", "detachPaymentMethod$payments_core_release", "getListener", "L", "operationId", "(Ljava/lang/String;)Lcom/stripe/android/CustomerSession$RetrievalListener;", "getPaymentMethods", "paymentMethodType", "Lcom/stripe/android/model/PaymentMethod$Type;", "Lcom/stripe/android/CustomerSession$PaymentMethodsRetrievalListener;", "limit", "", "endingBefore", "startingAfter", "(Lcom/stripe/android/model/PaymentMethod$Type;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/CustomerSession$PaymentMethodsRetrievalListener;)V", "getPaymentMethods$payments_core_release", "(Lcom/stripe/android/model/PaymentMethod$Type;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Lcom/stripe/android/CustomerSession$PaymentMethodsRetrievalListener;)V", "retrieveCurrentCustomer", "Lcom/stripe/android/CustomerSession$CustomerRetrievalListener;", "retrieveCurrentCustomer$payments_core_release", "setCustomerDefaultSource", "setCustomerDefaultSource$payments_core_release", "setCustomerShippingInformation", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "setCustomerShippingInformation$payments_core_release", "startOperation", "operation", "Lcom/stripe/android/EphemeralOperation;", "updateCurrentCustomer", "updateCurrentCustomer$payments_core_release", "Companion", "CustomerRetrievalListener", "PaymentMethodRetrievalListener", "PaymentMethodsRetrievalListener", "PaymentMethodsRetrievalWithExceptionListener", "RetrievalListener", "RetrievalWithExceptionListener", "SourceRetrievalListener", "payments-core_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCustomerSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomerSession.kt\ncom/stripe/android/CustomerSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,577:1\n1#2:578\n*E\n"})
public final class CustomerSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineContext workContext;
    @NotNull
    private final OperationIdFactory operationIdFactory;
    @NotNull
    private final Function0<Long> timeSupplier;
    private /* synthetic */ long customerCacheTime;
    private /* synthetic */ Customer customer;
    @NotNull
    private final Map<String, RetrievalListener> listeners;
    @NotNull
    private final CustomerSessionOperationExecutor operationExecutor;
    @NotNull
    private final EphemeralKeyManager ephemeralKeyManager;
    public static final int $stable = 8;
    private static final int THREAD_POOL_SIZE = 3;
    private static final int KEEP_ALIVE_TIME = 2;
    @NotNull
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private static final long CUSTOMER_CACHE_DURATION_MILLISECONDS = TimeUnit.MINUTES.toMillis(1L);
    private static /* synthetic */ CustomerSession instance;

    @VisibleForTesting
    public CustomerSession(@NotNull StripeRepository stripeRepository2, @NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull CoroutineContext workContext, @NotNull OperationIdFactory operationIdFactory, @NotNull Function0<Long> timeSupplier2, @NotNull EphemeralKeyManager.Factory ephemeralKeyManagerFactory) {
        Intrinsics.checkNotNullParameter((Object)stripeRepository2, (String)"stripeRepository");
        Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)operationIdFactory, (String)"operationIdFactory");
        Intrinsics.checkNotNullParameter(timeSupplier2, (String)"timeSupplier");
        Intrinsics.checkNotNullParameter((Object)ephemeralKeyManagerFactory, (String)"ephemeralKeyManagerFactory");
        this.workContext = workContext;
        this.operationIdFactory = operationIdFactory;
        this.timeSupplier = timeSupplier2;
        this.listeners = new LinkedHashMap();
        this.operationExecutor = new CustomerSessionOperationExecutor(stripeRepository2, publishableKey, stripeAccountId, this.listeners, (Function1<? super Customer, Unit>)((Function1)new Function1<Customer, Unit>(this){
            final /* synthetic */ CustomerSession this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Customer customer) {
                Intrinsics.checkNotNullParameter((Object)customer, (String)"customer");
                this.this$0.setCustomer$payments_core_release(customer);
                this.this$0.setCustomerCacheTime$payments_core_release(((Number)CustomerSession.access$getTimeSupplier$p(this.this$0).invoke()).longValue());
            }
        }));
        this.ephemeralKeyManager = ephemeralKeyManagerFactory.create(new EphemeralKeyManager.KeyManagerListener(this){
            final /* synthetic */ CustomerSession this$0;
            {
                this.this$0 = $receiver;
            }

            public void onKeyUpdate(@NotNull EphemeralKey ephemeralKey, @NotNull EphemeralOperation operation) {
                Intrinsics.checkNotNullParameter((Object)ephemeralKey, (String)"ephemeralKey");
                Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)CustomerSession.access$getWorkContext$p(this.this$0)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, ephemeralKey, operation, null){
                    int label;
                    final /* synthetic */ CustomerSession this$0;
                    final /* synthetic */ EphemeralKey $ephemeralKey;
                    final /* synthetic */ EphemeralOperation $operation;
                    {
                        this.this$0 = $receiver;
                        this.$ephemeralKey = $ephemeralKey;
                        this.$operation = $operation;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = CustomerSession.access$getOperationExecutor$p(this.this$0).execute$payments_core_release(this.$ephemeralKey, this.$operation, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }

            public void onKeyError(@NotNull String operationId, int errorCode, @NotNull String errorMessage, @NotNull Throwable throwable) {
                block1: {
                    RetrievalListener listener;
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)operationId, (String)"operationId");
                        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                        listener = (RetrievalListener)CustomerSession.access$getListeners$p(this.this$0).remove(operationId);
                        if (!(listener instanceof RetrievalWithExceptionListener)) break block0;
                        ((RetrievalWithExceptionListener)listener).onError(errorCode, errorMessage, null, throwable);
                        break block1;
                    }
                    RetrievalListener retrievalListener = listener;
                    if (retrievalListener == null) break block1;
                    retrievalListener.onError(errorCode, errorMessage, null);
                }
            }
        });
    }

    public /* synthetic */ CustomerSession(StripeRepository stripeRepository2, String string, String string2, CoroutineContext coroutineContext, OperationIdFactory operationIdFactory, Function0 function0, EphemeralKeyManager.Factory factory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            coroutineContext = CustomerSession.Companion.createCoroutineDispatcher();
        }
        if ((n & 0x10) != 0) {
            operationIdFactory = new StripeOperationIdFactory();
        }
        if ((n & 0x20) != 0) {
            function0 = 1.INSTANCE;
        }
        this(stripeRepository2, string, string2, coroutineContext, operationIdFactory, (Function0<Long>)function0, factory);
    }

    public final long getCustomerCacheTime$payments_core_release() {
        return this.customerCacheTime;
    }

    public final void setCustomerCacheTime$payments_core_release(long l) {
        this.customerCacheTime = l;
    }

    @Nullable
    public final Customer getCustomer$payments_core_release() {
        return this.customer;
    }

    public final void setCustomer$payments_core_release(@Nullable Customer customer) {
        this.customer = customer;
    }

    public final void retrieveCurrentCustomer(@NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.retrieveCurrentCustomer$payments_core_release(SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void retrieveCurrentCustomer$payments_core_release(Set productUsage, CustomerRetrievalListener listener) {
        block2: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)productUsage, (String)"productUsage");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Customer customer = this.getCachedCustomer();
            if (customer != null) {
                Customer it = customer;
                boolean bl = false;
                listener.onCustomerRetrieved(it);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            this.updateCurrentCustomer$payments_core_release(productUsage, listener);
        }
    }

    public final void updateCurrentCustomer(@NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.updateCurrentCustomer$payments_core_release(SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void updateCurrentCustomer$payments_core_release(Set productUsage, CustomerRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)productUsage, (String)"productUsage");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.customer = null;
        this.startOperation(new EphemeralOperation.RetrieveKey(this.operationIdFactory.create(), productUsage), listener);
    }

    @Nullable
    public final Customer getCachedCustomer() {
        Customer customer;
        Customer it = customer = this.customer;
        boolean bl = false;
        return this.getCanUseCachedCustomer() ? customer : null;
    }

    public final void addCustomerSource(@NotNull String sourceId, @NotNull String sourceType, @NotNull SourceRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.addCustomerSource$payments_core_release(sourceId, sourceType, SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void addCustomerSource$payments_core_release(String sourceId, String sourceType, Set productUsage, SourceRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
        Intrinsics.checkNotNullParameter((Object)productUsage, (String)"productUsage");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.startOperation(new EphemeralOperation.Customer.AddSource(sourceId, sourceType, this.operationIdFactory.create(), productUsage), listener);
    }

    public final void deleteCustomerSource(@NotNull String sourceId, @NotNull SourceRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.deleteCustomerSource$payments_core_release(sourceId, SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void deleteCustomerSource$payments_core_release(String sourceId, Set productUsage, SourceRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Intrinsics.checkNotNullParameter((Object)productUsage, (String)"productUsage");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.startOperation(new EphemeralOperation.Customer.DeleteSource(sourceId, this.operationIdFactory.create(), productUsage), listener);
    }

    public final void attachPaymentMethod(@NotNull String paymentMethodId, @NotNull PaymentMethodRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.attachPaymentMethod$payments_core_release(paymentMethodId, SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void attachPaymentMethod$payments_core_release(String paymentMethodId, Set productUsage, PaymentMethodRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkNotNullParameter((Object)productUsage, (String)"productUsage");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.startOperation(new EphemeralOperation.Customer.AttachPaymentMethod(paymentMethodId, this.operationIdFactory.create(), productUsage), listener);
    }

    public final void detachPaymentMethod(@NotNull String paymentMethodId, @NotNull PaymentMethodRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.detachPaymentMethod$payments_core_release(paymentMethodId, SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void detachPaymentMethod$payments_core_release(String paymentMethodId, Set productUsage, PaymentMethodRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkNotNullParameter((Object)productUsage, (String)"productUsage");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.startOperation(new EphemeralOperation.Customer.DetachPaymentMethod(paymentMethodId, this.operationIdFactory.create(), productUsage), listener);
    }

    @JvmOverloads
    public final void getPaymentMethods(@NotNull PaymentMethod.Type paymentMethodType2, @IntRange(from=1L, to=100L) @Nullable Integer limit, @Nullable String endingBefore, @Nullable String startingAfter, @NotNull PaymentMethodsRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)((Object)paymentMethodType2), (String)"paymentMethodType");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.getPaymentMethods$payments_core_release(paymentMethodType2, limit, endingBefore, startingAfter, SetsKt.emptySet(), listener);
    }

    public static /* synthetic */ void getPaymentMethods$default(CustomerSession customerSession2, PaymentMethod.Type type, Integer n, String string, String string2, PaymentMethodsRetrievalListener paymentMethodsRetrievalListener, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        customerSession2.getPaymentMethods(type, n, string, string2, paymentMethodsRetrievalListener);
    }

    public final /* synthetic */ void getPaymentMethods$payments_core_release(PaymentMethod.Type paymentMethodType2, @IntRange(from=1L, to=100L) Integer limit, String endingBefore, String startingAfter, Set productUsage, PaymentMethodsRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)((Object)paymentMethodType2), (String)"paymentMethodType");
        Intrinsics.checkNotNullParameter((Object)productUsage, (String)"productUsage");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.startOperation(new EphemeralOperation.Customer.GetPaymentMethods(paymentMethodType2, limit, endingBefore, startingAfter, this.operationIdFactory.create(), productUsage), listener);
    }

    public static /* synthetic */ void getPaymentMethods$payments_core_release$default(CustomerSession customerSession2, PaymentMethod.Type type, Integer n, String string, String string2, Set set, PaymentMethodsRetrievalListener paymentMethodsRetrievalListener, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        customerSession2.getPaymentMethods$payments_core_release(type, n, string, string2, set, paymentMethodsRetrievalListener);
    }

    public final void getPaymentMethods(@NotNull PaymentMethod.Type paymentMethodType2, @NotNull PaymentMethodsRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)((Object)paymentMethodType2), (String)"paymentMethodType");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        CustomerSession.getPaymentMethods$payments_core_release$default(this, paymentMethodType2, null, null, null, SetsKt.emptySet(), listener, 14, null);
    }

    public final void setCustomerShippingInformation(@NotNull ShippingInformation shippingInformation, @NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)shippingInformation, (String)"shippingInformation");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.setCustomerShippingInformation$payments_core_release(shippingInformation, SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void setCustomerShippingInformation$payments_core_release(ShippingInformation shippingInformation, Set productUsage, CustomerRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)shippingInformation, (String)"shippingInformation");
        Intrinsics.checkNotNullParameter((Object)productUsage, (String)"productUsage");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.startOperation(new EphemeralOperation.Customer.UpdateShipping(shippingInformation, this.operationIdFactory.create(), productUsage), listener);
    }

    public final void setCustomerDefaultSource(@NotNull String sourceId, @NotNull String sourceType, @NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.setCustomerDefaultSource$payments_core_release(sourceId, sourceType, SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void setCustomerDefaultSource$payments_core_release(String sourceId, String sourceType, Set productUsage, CustomerRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
        Intrinsics.checkNotNullParameter((Object)productUsage, (String)"productUsage");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.startOperation(new EphemeralOperation.Customer.UpdateDefaultSource(sourceId, sourceType, this.operationIdFactory.create(), productUsage), listener);
    }

    private final void startOperation(EphemeralOperation operation, RetrievalListener listener) {
        this.listeners.put(operation.getId$payments_core_release(), listener);
        this.ephemeralKeyManager.retrieveEphemeralKey$payments_core_release(operation);
    }

    private final boolean getCanUseCachedCustomer() {
        return this.customer != null && ((Number)this.timeSupplier.invoke()).longValue() - this.customerCacheTime < CUSTOMER_CACHE_DURATION_MILLISECONDS;
    }

    public final /* synthetic */ void cancel$payments_core_release() {
        this.listeners.clear();
        JobKt.cancelChildren$default((CoroutineContext)this.workContext, null, (int)1, null);
    }

    private final <L extends RetrievalListener> L getListener(String operationId) {
        return (L)this.listeners.remove(operationId);
    }

    @JvmOverloads
    public final void getPaymentMethods(@NotNull PaymentMethod.Type paymentMethodType2, @IntRange(from=1L, to=100L) @Nullable Integer limit, @Nullable String endingBefore, @NotNull PaymentMethodsRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)((Object)paymentMethodType2), (String)"paymentMethodType");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        CustomerSession.getPaymentMethods$default(this, paymentMethodType2, limit, endingBefore, null, listener, 8, null);
    }

    @JvmOverloads
    public final void getPaymentMethods(@NotNull PaymentMethod.Type paymentMethodType2, @IntRange(from=1L, to=100L) @Nullable Integer limit, @NotNull PaymentMethodsRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)((Object)paymentMethodType2), (String)"paymentMethodType");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        CustomerSession.getPaymentMethods$default(this, paymentMethodType2, limit, null, null, listener, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider, boolean shouldPrefetchEphemeralKey) {
        Companion.initCustomerSession(context, ephemeralKeyProvider, shouldPrefetchEphemeralKey);
    }

    @JvmStatic
    @NotNull
    public static final CustomerSession getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final void endCustomerSession() {
        Companion.endCustomerSession();
    }

    @JvmStatic
    public static final void cancelCallbacks() {
        Companion.cancelCallbacks();
    }

    @JvmStatic
    @JvmOverloads
    public static final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider) {
        Companion.initCustomerSession(context, ephemeralKeyProvider);
    }

    public static final /* synthetic */ Function0 access$getTimeSupplier$p(CustomerSession $this) {
        return $this.timeSupplier;
    }

    public static final /* synthetic */ CoroutineContext access$getWorkContext$p(CustomerSession $this) {
        return $this.workContext;
    }

    public static final /* synthetic */ CustomerSessionOperationExecutor access$getOperationExecutor$p(CustomerSession $this) {
        return $this.operationExecutor;
    }

    public static final /* synthetic */ Map access$getListeners$p(CustomerSession $this) {
        return $this.listeners;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\r\u0010\u0012\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0007J\b\u0010\u0017\u001a\u00020\u000bH\u0007J\"\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/CustomerSession$Companion;", "", "()V", "CUSTOMER_CACHE_DURATION_MILLISECONDS", "", "KEEP_ALIVE_TIME", "", "KEEP_ALIVE_TIME_UNIT", "Ljava/util/concurrent/TimeUnit;", "THREAD_POOL_SIZE", "instance", "Lcom/stripe/android/CustomerSession;", "getInstance$payments_core_release", "()Lcom/stripe/android/CustomerSession;", "setInstance$payments_core_release", "(Lcom/stripe/android/CustomerSession;)V", "cancelCallbacks", "", "clearInstance", "clearInstance$payments_core_release", "createCoroutineDispatcher", "Lkotlin/coroutines/CoroutineContext;", "endCustomerSession", "getInstance", "initCustomerSession", "context", "Landroid/content/Context;", "ephemeralKeyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "shouldPrefetchEphemeralKey", "", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        public final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider, boolean shouldPrefetchEphemeralKey) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)ephemeralKeyProvider, (String)"ephemeralKeyProvider");
            StripeOperationIdFactory operationIdFactory = new StripeOperationIdFactory();
            Function0 timeSupplier2 = initCustomerSession.timeSupplier.1.INSTANCE;
            EphemeralKeyManager.Factory.Default ephemeralKeyManagerFactory = new EphemeralKeyManager.Factory.Default(ephemeralKeyProvider, shouldPrefetchEphemeralKey, operationIdFactory, (Function0<Long>)timeSupplier2);
            PaymentConfiguration config2 = PaymentConfiguration.Companion.getInstance(context);
            this.setInstance$payments_core_release(new CustomerSession(new StripeApiRepository(context, (Function0)new Function0<String>(config2){
                final /* synthetic */ PaymentConfiguration $config;
                {
                    this.$config = $config;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$config.getPublishableKey();
                }
            }, Stripe.Companion.getAppInfo(), null, null, null, null, null, null, null, null, null, null, null, null, 32760, null), config2.getPublishableKey(), config2.getStripeAccountId(), this.createCoroutineDispatcher(), operationIdFactory, (Function0<Long>)timeSupplier2, ephemeralKeyManagerFactory));
        }

        public static /* synthetic */ void initCustomerSession$default(Companion companion, Context context, EphemeralKeyProvider ephemeralKeyProvider, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            companion.initCustomerSession(context, ephemeralKeyProvider, bl);
        }

        @Nullable
        public final CustomerSession getInstance$payments_core_release() {
            return instance;
        }

        public final void setInstance$payments_core_release(@Nullable CustomerSession customerSession2) {
            instance = customerSession2;
        }

        @JvmStatic
        @NotNull
        public final CustomerSession getInstance() {
            CustomerSession customerSession2 = this.getInstance$payments_core_release();
            if (customerSession2 == null) {
                boolean bl = false;
                String string = "Attempted to get instance of CustomerSession without initialization.";
                throw new IllegalStateException(string.toString());
            }
            return customerSession2;
        }

        @JvmStatic
        public final void endCustomerSession() {
            this.clearInstance$payments_core_release();
        }

        @VisibleForTesting
        public final /* synthetic */ void clearInstance$payments_core_release() {
            this.cancelCallbacks();
            this.setInstance$payments_core_release(null);
        }

        @JvmStatic
        public final void cancelCallbacks() {
            block0: {
                CustomerSession customerSession2 = this.getInstance$payments_core_release();
                if (customerSession2 == null) break block0;
                customerSession2.cancel$payments_core_release();
            }
        }

        private final CoroutineContext createCoroutineDispatcher() {
            return (CoroutineContext)ExecutorsKt.from((ExecutorService)new ThreadPoolExecutor(3, 3, 2L, KEEP_ALIVE_TIME_UNIT, new LinkedBlockingQueue()));
        }

        @JvmStatic
        @JvmOverloads
        public final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)ephemeralKeyProvider, (String)"ephemeralKeyProvider");
            com.stripe.android.CustomerSession$Companion.initCustomerSession$default(this, context, ephemeralKeyProvider, false, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/CustomerSession$CustomerRetrievalListener;", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "onCustomerRetrieved", "", "customer", "Lcom/stripe/android/model/Customer;", "payments-core_release"})
    public static interface CustomerRetrievalListener
    extends RetrievalListener {
        public void onCustomerRetrieved(@NotNull Customer var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/CustomerSession$PaymentMethodRetrievalListener;", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "onPaymentMethodRetrieved", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "payments-core_release"})
    public static interface PaymentMethodRetrievalListener
    extends RetrievalListener {
        public void onPaymentMethodRetrieved(@NotNull PaymentMethod var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/CustomerSession$PaymentMethodsRetrievalListener;", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "onPaymentMethodsRetrieved", "", "paymentMethods", "", "Lcom/stripe/android/model/PaymentMethod;", "payments-core_release"})
    public static interface PaymentMethodsRetrievalListener
    extends RetrievalListener {
        public void onPaymentMethodsRetrieved(@NotNull List<PaymentMethod> var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u00012\u00020\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/CustomerSession$PaymentMethodsRetrievalWithExceptionListener;", "Lcom/stripe/android/CustomerSession$PaymentMethodsRetrievalListener;", "Lcom/stripe/android/CustomerSession$RetrievalWithExceptionListener;", "payments-core_release"})
    public static interface PaymentMethodsRetrievalWithExceptionListener
    extends PaymentMethodsRetrievalListener,
    RetrievalWithExceptionListener {

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void onError(@NotNull PaymentMethodsRetrievalWithExceptionListener $this, int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                RetrievalWithExceptionListener.DefaultImpls.onError($this, errorCode, errorMessage, stripeError);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lcom/stripe/android/CustomerSession$RetrievalListener;", "", "onError", "", "errorCode", "", "errorMessage", "", "stripeError", "Lcom/stripe/android/core/StripeError;", "payments-core_release"})
    public static interface RetrievalListener {
        public void onError(int var1, @NotNull String var2, @Nullable StripeError var3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b`\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J*\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lcom/stripe/android/CustomerSession$RetrievalWithExceptionListener;", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "onError", "", "errorCode", "", "errorMessage", "", "stripeError", "Lcom/stripe/android/core/StripeError;", "throwable", "", "payments-core_release"})
    public static interface RetrievalWithExceptionListener
    extends RetrievalListener {
        public void onError(int var1, @NotNull String var2, @Nullable StripeError var3, @NotNull Throwable var4);

        @Override
        public void onError(int var1, @NotNull String var2, @Nullable StripeError var3);

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void onError(@NotNull RetrievalWithExceptionListener $this, int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                $this.onError(errorCode, errorMessage, stripeError, new Exception(errorMessage));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/CustomerSession$SourceRetrievalListener;", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "onSourceRetrieved", "", "source", "Lcom/stripe/android/model/Source;", "payments-core_release"})
    public static interface SourceRetrievalListener
    extends RetrievalListener {
        public void onSourceRetrieved(@NotNull Source var1);
    }
}

