/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Build;
import android.telephony.PhoneNumberFormattingTextWatcher;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.android.material.textfield.TextInputLayout;
import com.stripe.android.R;
import com.stripe.android.databinding.AddressWidgetBinding;
import com.stripe.android.model.Address;
import com.stripe.android.model.CountryCode;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.view.Country;
import com.stripe.android.view.CountryTextInputLayout;
import com.stripe.android.view.CountryUtils;
import com.stripe.android.view.ErrorListener;
import com.stripe.android.view.PostalCodeValidator;
import com.stripe.android.view.StripeEditText;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001OB%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u000205H\u0002J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0015H\u0002J\u0010\u0010:\u001a\u0002082\u0006\u00109\u001a\u00020\u0015H\u0002J\u0010\u0010;\u001a\u0002082\u0006\u00109\u001a\u00020\u0015H\u0002J\u0010\u0010<\u001a\u0002052\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u0002052\b\u0010*\u001a\u0004\u0018\u00010'J\b\u0010@\u001a\u000205H\u0002J\b\u0010A\u001a\u000205H\u0002J\b\u0010B\u001a\u000205H\u0002J\b\u0010C\u001a\u000205H\u0002J\b\u0010D\u001a\u000205H\u0002J\u0014\u0010E\u001a\u0002052\f\u0010F\u001a\b\u0012\u0004\u0012\u00020H0GJ\b\u0010I\u001a\u000205H\u0002J\u0010\u0010J\u001a\u0002052\u0006\u0010K\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u0002052\u0006\u0010K\u001a\u00020LH\u0002J\u0006\u0010N\u001a\u000208R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0018\"\u0004\b\u001f\u0010\u001aR\u000e\u0010 \u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0013\u0010*\u001a\u0004\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u000e\u0010,\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010.\u001a\u00020/8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b0\u00101\u00a8\u0006P"}, d2={"Lcom/stripe/android/view/ShippingInfoWidget;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "addressEditText", "Lcom/stripe/android/view/StripeEditText;", "addressEditText2", "addressLine1TextInputLayout", "Lcom/google/android/material/textfield/TextInputLayout;", "addressLine2TextInputLayout", "cityEditText", "cityTextInputLayout", "countryAutoCompleteTextView", "Lcom/stripe/android/view/CountryTextInputLayout;", "value", "", "Lcom/stripe/android/view/ShippingInfoWidget$CustomizableShippingField;", "hiddenFields", "getHiddenFields", "()Ljava/util/List;", "setHiddenFields", "(Ljava/util/List;)V", "nameEditText", "nameTextInputLayout", "optionalFields", "getOptionalFields", "setOptionalFields", "phoneNumberEditText", "phoneNumberTextInputLayout", "postalCodeEditText", "postalCodeTextInputLayout", "postalCodeValidator", "Lcom/stripe/android/view/PostalCodeValidator;", "rawShippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "getRawShippingInformation", "()Lcom/stripe/android/model/ShippingInformation;", "shippingInformation", "getShippingInformation", "stateEditText", "stateTextInputLayout", "viewBinding", "Lcom/stripe/android/databinding/AddressWidgetBinding;", "getViewBinding", "()Lcom/stripe/android/databinding/AddressWidgetBinding;", "viewBinding$delegate", "Lkotlin/Lazy;", "hideHiddenFields", "", "initView", "isFieldHidden", "", "field", "isFieldOptional", "isFieldRequired", "populateAddressFields", "address", "Lcom/stripe/android/model/Address;", "populateShippingInfo", "renderCanadianForm", "renderGreatBritainForm", "renderInternationalForm", "renderLabels", "renderUSForm", "setAllowedCountryCodes", "allowedCountryCodes", "", "", "setupErrorHandling", "updateConfigForCountry", "country", "Lcom/stripe/android/view/Country;", "updatePostalCodeInputFilter", "validateAllFields", "CustomizableShippingField", "payments-core_release"})
@StabilityInferred(parameters=0)
public final class ShippingInfoWidget
extends LinearLayout {
    @NotNull
    private final Lazy viewBinding$delegate;
    @NotNull
    private final PostalCodeValidator postalCodeValidator;
    @NotNull
    private List<? extends CustomizableShippingField> optionalFields;
    @NotNull
    private List<? extends CustomizableShippingField> hiddenFields;
    @NotNull
    private final CountryTextInputLayout countryAutoCompleteTextView;
    @NotNull
    private final TextInputLayout addressLine1TextInputLayout;
    @NotNull
    private final TextInputLayout addressLine2TextInputLayout;
    @NotNull
    private final TextInputLayout cityTextInputLayout;
    @NotNull
    private final TextInputLayout nameTextInputLayout;
    @NotNull
    private final TextInputLayout postalCodeTextInputLayout;
    @NotNull
    private final TextInputLayout stateTextInputLayout;
    @NotNull
    private final TextInputLayout phoneNumberTextInputLayout;
    @NotNull
    private final StripeEditText addressEditText;
    @NotNull
    private final StripeEditText addressEditText2;
    @NotNull
    private final StripeEditText cityEditText;
    @NotNull
    private final StripeEditText nameEditText;
    @NotNull
    private final StripeEditText postalCodeEditText;
    @NotNull
    private final StripeEditText stateEditText;
    @NotNull
    private final StripeEditText phoneNumberEditText;
    public static final int $stable = 8;

    @JvmOverloads
    public ShippingInfoWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.viewBinding$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AddressWidgetBinding>(context, this){
            final /* synthetic */ Context $context;
            final /* synthetic */ ShippingInfoWidget this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final AddressWidgetBinding invoke() {
                AddressWidgetBinding addressWidgetBinding = AddressWidgetBinding.inflate(LayoutInflater.from((Context)this.$context), (ViewGroup)this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)addressWidgetBinding, (String)"inflate(\n            LayoutInflater.from(context),\n            this\n        )");
                return addressWidgetBinding;
            }
        }));
        this.postalCodeValidator = new PostalCodeValidator();
        this.optionalFields = CollectionsKt.emptyList();
        this.hiddenFields = CollectionsKt.emptyList();
        String[] stringArray = this.getViewBinding().countryAutocompleteAaw;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"viewBinding.countryAutocompleteAaw");
        this.countryAutoCompleteTextView = stringArray;
        stringArray = this.getViewBinding().tlAddressLine1Aaw;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"viewBinding.tlAddressLine1Aaw");
        this.addressLine1TextInputLayout = stringArray;
        stringArray = this.getViewBinding().tlAddressLine2Aaw;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"viewBinding.tlAddressLine2Aaw");
        this.addressLine2TextInputLayout = stringArray;
        stringArray = this.getViewBinding().tlCityAaw;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"viewBinding.tlCityAaw");
        this.cityTextInputLayout = stringArray;
        stringArray = this.getViewBinding().tlNameAaw;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"viewBinding.tlNameAaw");
        this.nameTextInputLayout = stringArray;
        stringArray = this.getViewBinding().tlPostalCodeAaw;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"viewBinding.tlPostalCodeAaw");
        this.postalCodeTextInputLayout = stringArray;
        stringArray = this.getViewBinding().tlStateAaw;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"viewBinding.tlStateAaw");
        this.stateTextInputLayout = stringArray;
        stringArray = this.getViewBinding().tlPhoneNumberAaw;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"viewBinding.tlPhoneNumberAaw");
        this.phoneNumberTextInputLayout = stringArray;
        stringArray = this.getViewBinding().etAddressLineOneAaw;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"viewBinding.etAddressLineOneAaw");
        this.addressEditText = stringArray;
        stringArray = this.getViewBinding().etAddressLineTwoAaw;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"viewBinding.etAddressLineTwoAaw");
        this.addressEditText2 = stringArray;
        stringArray = this.getViewBinding().etCityAaw;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"viewBinding.etCityAaw");
        this.cityEditText = stringArray;
        stringArray = this.getViewBinding().etNameAaw;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"viewBinding.etNameAaw");
        this.nameEditText = stringArray;
        stringArray = this.getViewBinding().etPostalCodeAaw;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"viewBinding.etPostalCodeAaw");
        this.postalCodeEditText = stringArray;
        stringArray = this.getViewBinding().etStateAaw;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"viewBinding.etStateAaw");
        this.stateEditText = stringArray;
        stringArray = this.getViewBinding().etPhoneNumberAaw;
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"viewBinding.etPhoneNumberAaw");
        this.phoneNumberEditText = stringArray;
        this.setOrientation(1);
        if (Build.VERSION.SDK_INT >= 26) {
            stringArray = new String[]{"name"};
            this.nameEditText.setAutofillHints(stringArray);
            stringArray = new String[]{"postalAddress"};
            this.addressLine1TextInputLayout.setAutofillHints(stringArray);
            stringArray = new String[]{"postalCode"};
            this.postalCodeEditText.setAutofillHints(stringArray);
            stringArray = new String[]{"phone"};
            this.phoneNumberEditText.setAutofillHints(stringArray);
        }
        this.initView();
    }

    public /* synthetic */ ShippingInfoWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final AddressWidgetBinding getViewBinding() {
        Lazy lazy = this.viewBinding$delegate;
        boolean bl = false;
        return (AddressWidgetBinding)lazy.getValue();
    }

    @NotNull
    public final List<CustomizableShippingField> getOptionalFields() {
        return this.optionalFields;
    }

    public final void setOptionalFields(@NotNull List<? extends CustomizableShippingField> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.optionalFields = value;
        this.renderLabels();
        Country country = this.countryAutoCompleteTextView.getSelectedCountry$payments_core_release();
        if (country != null) {
            Country country2 = country;
            boolean bl = false;
            boolean bl2 = false;
            Country p0 = country2;
            boolean bl3 = false;
            this.updateConfigForCountry(p0);
        }
    }

    @NotNull
    public final List<CustomizableShippingField> getHiddenFields() {
        return this.hiddenFields;
    }

    public final void setHiddenFields(@NotNull List<? extends CustomizableShippingField> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.hiddenFields = value;
        this.renderLabels();
        Country country = this.countryAutoCompleteTextView.getSelectedCountry$payments_core_release();
        if (country != null) {
            Country country2 = country;
            boolean bl = false;
            boolean bl2 = false;
            Country p0 = country2;
            boolean bl3 = false;
            this.updateConfigForCountry(p0);
        }
    }

    @Nullable
    public final ShippingInformation getShippingInformation() {
        return !this.validateAllFields() ? (ShippingInformation)null : this.getRawShippingInformation();
    }

    private final ShippingInformation getRawShippingInformation() {
        Country country;
        return new ShippingInformation(new Address.Builder().setCity(this.cityEditText.getFieldText$payments_core_release()).setCountryCode((country = this.countryAutoCompleteTextView.getSelectedCountry$payments_core_release()) == null ? null : country.getCode()).setLine1(this.addressEditText.getFieldText$payments_core_release()).setLine2(this.addressEditText2.getFieldText$payments_core_release()).setPostalCode(this.postalCodeEditText.getFieldText$payments_core_release()).setState(this.stateEditText.getFieldText$payments_core_release()).build(), this.nameEditText.getFieldText$payments_core_release(), this.phoneNumberEditText.getFieldText$payments_core_release());
    }

    public final void populateShippingInfo(@Nullable ShippingInformation shippingInformation) {
        if (shippingInformation == null) {
            return;
        }
        Address address = shippingInformation.getAddress();
        if (address != null) {
            Address address2 = address;
            boolean bl = false;
            boolean bl2 = false;
            Address p0 = address2;
            boolean bl3 = false;
            this.populateAddressFields(p0);
        }
        this.nameEditText.setText(shippingInformation.getName());
        this.phoneNumberEditText.setText(shippingInformation.getPhone());
    }

    private final void populateAddressFields(Address address) {
        this.cityEditText.setText(address.getCity());
        String string2 = address.getCountry();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String country = string3;
            boolean bl3 = false;
            CharSequence charSequence = country;
            boolean bl4 = false;
            if (charSequence.length() > 0) {
                this.countryAutoCompleteTextView.setCountrySelected$payments_core_release(country);
            }
        }
        this.addressEditText.setText(address.getLine1());
        this.addressEditText2.setText(address.getLine2());
        this.postalCodeEditText.setText(address.getPostalCode());
        this.stateEditText.setText(address.getState());
    }

    public final void setAllowedCountryCodes(@NotNull Set<String> allowedCountryCodes) {
        Intrinsics.checkNotNullParameter(allowedCountryCodes, (String)"allowedCountryCodes");
        this.countryAutoCompleteTextView.setAllowedCountryCodes$payments_core_release(allowedCountryCodes);
    }

    public final boolean validateAllFields() {
        Object object;
        Country selectedCountry;
        String string2;
        Object object2 = this.addressEditText.getText();
        String string3 = string2 = object2 == null ? null : object2.toString();
        if (string2 == null) {
            return false;
        }
        String address = string2;
        Object object3 = this.nameEditText.getText();
        String string4 = object2 = object3 == null ? null : object3.toString();
        if (object2 == null) {
            return false;
        }
        Object name = object2;
        Object object4 = this.cityEditText.getText();
        String string5 = object3 = object4 == null ? null : object4.toString();
        if (object3 == null) {
            return false;
        }
        Object city = object3;
        Object object5 = this.stateEditText.getText();
        String string6 = object4 = object5 == null ? null : object5.toString();
        if (object4 == null) {
            return false;
        }
        Object state = object4;
        Object object6 = this.postalCodeEditText.getText();
        String string7 = object5 = object6 == null ? null : object6.toString();
        if (object5 == null) {
            return false;
        }
        Object postalCode = object5;
        Editable editable = this.phoneNumberEditText.getText();
        String string8 = object6 = editable == null ? null : editable.toString();
        if (object6 == null) {
            return false;
        }
        Object phoneNumber = object6;
        this.countryAutoCompleteTextView.validateCountry$payments_core_release();
        Country country = selectedCountry = this.countryAutoCompleteTextView.getSelectedCountry$payments_core_release();
        boolean isPostalCodeValid = this.postalCodeValidator.isValid$payments_core_release((String)postalCode, country == null ? null : ((object = country.getCode()) == null ? null : ((CountryCode)object).getValue()), this.optionalFields, this.hiddenFields);
        this.postalCodeEditText.setShouldShowError(!isPostalCodeValid);
        object = address;
        boolean bl = false;
        boolean requiredAddressLine1Empty = object.length() == 0 && this.isFieldRequired(CustomizableShippingField.Line1);
        this.addressEditText.setShouldShowError(requiredAddressLine1Empty);
        CharSequence charSequence = (CharSequence)city;
        boolean bl2 = false;
        boolean requiredCityEmpty = charSequence.length() == 0 && this.isFieldRequired(CustomizableShippingField.City);
        this.cityEditText.setShouldShowError(requiredCityEmpty);
        CharSequence charSequence2 = (CharSequence)name;
        boolean bl3 = false;
        boolean requiredNameEmpty = charSequence2.length() == 0;
        this.nameEditText.setShouldShowError(requiredNameEmpty);
        CharSequence charSequence3 = (CharSequence)state;
        boolean bl4 = false;
        boolean requiredStateEmpty = charSequence3.length() == 0 && this.isFieldRequired(CustomizableShippingField.State);
        this.stateEditText.setShouldShowError(requiredStateEmpty);
        CharSequence charSequence4 = (CharSequence)phoneNumber;
        boolean bl5 = false;
        boolean requiredPhoneNumberEmpty = charSequence4.length() == 0 && this.isFieldRequired(CustomizableShippingField.Phone);
        this.phoneNumberEditText.setShouldShowError(requiredPhoneNumberEmpty);
        return isPostalCodeValid && !requiredAddressLine1Empty && !requiredCityEmpty && !requiredStateEmpty && !requiredNameEmpty && !requiredPhoneNumberEmpty && selectedCountry != null;
    }

    private final boolean isFieldRequired(CustomizableShippingField field) {
        return !this.isFieldOptional(field) && !this.isFieldHidden(field);
    }

    private final boolean isFieldOptional(CustomizableShippingField field) {
        return this.optionalFields.contains((Object)field);
    }

    private final boolean isFieldHidden(CustomizableShippingField field) {
        return this.hiddenFields.contains((Object)field);
    }

    private final void initView() {
        this.countryAutoCompleteTextView.setCountryChangeCallback$payments_core_release((Function1<? super Country, Unit>)((Function1)new Function1<Country, Unit>(this){

            public final void invoke(@NotNull Country p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ShippingInfoWidget.access$updateConfigForCountry((ShippingInfoWidget)((Object)this.receiver), p0);
            }
        }));
        this.phoneNumberEditText.addTextChangedListener((TextWatcher)new PhoneNumberFormattingTextWatcher());
        this.setupErrorHandling();
        this.renderLabels();
        Country country = this.countryAutoCompleteTextView.getSelectedCountry$payments_core_release();
        if (country != null) {
            Country country2 = country;
            boolean bl = false;
            boolean bl2 = false;
            Country p0 = country2;
            boolean bl3 = false;
            this.updateConfigForCountry(p0);
        }
    }

    private final void setupErrorHandling() {
        this.addressEditText.setErrorMessageListener(new ErrorListener(this.addressLine1TextInputLayout));
        this.cityEditText.setErrorMessageListener(new ErrorListener(this.cityTextInputLayout));
        this.nameEditText.setErrorMessageListener(new ErrorListener(this.nameTextInputLayout));
        this.postalCodeEditText.setErrorMessageListener(new ErrorListener(this.postalCodeTextInputLayout));
        this.stateEditText.setErrorMessageListener(new ErrorListener(this.stateTextInputLayout));
        this.phoneNumberEditText.setErrorMessageListener(new ErrorListener(this.phoneNumberTextInputLayout));
        this.addressEditText.setErrorMessage(this.getResources().getString(R.string.address_required));
        this.cityEditText.setErrorMessage(this.getResources().getString(R.string.address_city_required));
        this.nameEditText.setErrorMessage(this.getResources().getString(R.string.address_name_required));
        this.phoneNumberEditText.setErrorMessage(this.getResources().getString(R.string.address_phone_number_required));
    }

    private final void renderLabels() {
        this.nameTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_name));
        this.cityTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.City) ? (CharSequence)this.getResources().getString(R.string.address_label_city_optional) : (CharSequence)this.getResources().getString(R.string.address_label_city));
        this.phoneNumberTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.Phone) ? (CharSequence)this.getResources().getString(R.string.address_label_phone_number_optional) : (CharSequence)this.getResources().getString(R.string.address_label_phone_number));
        this.hideHiddenFields();
    }

    private final void hideHiddenFields() {
        if (this.isFieldHidden(CustomizableShippingField.Line1)) {
            this.addressLine1TextInputLayout.setVisibility(8);
        }
        if (this.isFieldHidden(CustomizableShippingField.Line2)) {
            this.addressLine2TextInputLayout.setVisibility(8);
        }
        if (this.isFieldHidden(CustomizableShippingField.State)) {
            this.stateTextInputLayout.setVisibility(8);
        }
        if (this.isFieldHidden(CustomizableShippingField.City)) {
            this.cityTextInputLayout.setVisibility(8);
        }
        if (this.isFieldHidden(CustomizableShippingField.PostalCode)) {
            this.postalCodeTextInputLayout.setVisibility(8);
        }
        if (this.isFieldHidden(CustomizableShippingField.Phone)) {
            this.phoneNumberTextInputLayout.setVisibility(8);
        }
    }

    private final void updateConfigForCountry(Country country) {
        String string2 = country.getCode().getValue();
        if (Intrinsics.areEqual((Object)string2, (Object)Locale.US.getCountry())) {
            this.renderUSForm();
        } else if (Intrinsics.areEqual((Object)string2, (Object)Locale.UK.getCountry())) {
            this.renderGreatBritainForm();
        } else if (Intrinsics.areEqual((Object)string2, (Object)Locale.CANADA.getCountry())) {
            this.renderCanadianForm();
        } else {
            this.renderInternationalForm();
        }
        this.updatePostalCodeInputFilter(country);
        this.postalCodeTextInputLayout.setVisibility(CountryUtils.INSTANCE.doesCountryUsePostalCode(country.getCode()) && !this.isFieldHidden(CustomizableShippingField.PostalCode) ? 0 : 8);
    }

    private final void updatePostalCodeInputFilter(Country country) {
        InputFilter[] inputFilterArray;
        String string2 = country.getCode().getValue();
        if (Intrinsics.areEqual((Object)string2, (Object)Locale.CANADA.getCountry())) {
            InputFilter[] inputFilterArray2 = new InputFilter[]{(InputFilter)new InputFilter.AllCaps()};
            inputFilterArray = inputFilterArray2;
        } else {
            inputFilterArray = new InputFilter[]{};
        }
        this.postalCodeEditText.setFilters(inputFilterArray);
    }

    private final void renderUSForm() {
        this.addressLine1TextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.Line1) ? (CharSequence)this.getResources().getString(R.string.address_label_address_optional) : (CharSequence)this.getResources().getString(R.string.address_label_address));
        this.addressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_apt_optional));
        this.postalCodeTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.PostalCode) ? (CharSequence)this.getResources().getString(R.string.address_label_zip_code_optional) : (CharSequence)this.getResources().getString(R.string.address_label_zip_code));
        this.stateTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.State) ? (CharSequence)this.getResources().getString(R.string.address_label_state_optional) : (CharSequence)this.getResources().getString(R.string.address_label_state));
        this.postalCodeEditText.setErrorMessage(this.getResources().getString(R.string.address_zip_invalid));
        this.stateEditText.setErrorMessage(this.getResources().getString(R.string.address_state_required));
    }

    private final void renderGreatBritainForm() {
        this.addressLine1TextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.Line1) ? (CharSequence)this.getResources().getString(R.string.address_label_address_line1_optional) : (CharSequence)this.getResources().getString(R.string.address_label_address_line1));
        this.addressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_address_line2_optional));
        this.postalCodeTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.PostalCode) ? (CharSequence)this.getResources().getString(R.string.address_label_postcode_optional) : (CharSequence)this.getResources().getString(R.string.address_label_postcode));
        this.stateTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.State) ? (CharSequence)this.getResources().getString(R.string.address_label_county_optional) : (CharSequence)this.getResources().getString(R.string.address_label_county));
        this.postalCodeEditText.setErrorMessage(this.getResources().getString(R.string.address_postcode_invalid));
        this.stateEditText.setErrorMessage(this.getResources().getString(R.string.address_county_required));
    }

    private final void renderCanadianForm() {
        this.addressLine1TextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.Line1) ? (CharSequence)this.getResources().getString(R.string.address_label_address_optional) : (CharSequence)this.getResources().getString(R.string.address_label_address));
        this.addressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_apt_optional));
        this.postalCodeTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.PostalCode) ? (CharSequence)this.getResources().getString(R.string.address_label_postal_code_optional) : (CharSequence)this.getResources().getString(R.string.address_label_postal_code));
        this.stateTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.State) ? (CharSequence)this.getResources().getString(R.string.address_label_province_optional) : (CharSequence)this.getResources().getString(R.string.address_label_province));
        this.postalCodeEditText.setErrorMessage(this.getResources().getString(R.string.address_postal_code_invalid));
        this.stateEditText.setErrorMessage(this.getResources().getString(R.string.address_province_required));
    }

    private final void renderInternationalForm() {
        this.addressLine1TextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.Line1) ? (CharSequence)this.getResources().getString(R.string.address_label_address_line1_optional) : (CharSequence)this.getResources().getString(R.string.address_label_address_line1));
        this.addressLine2TextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.address_label_address_line2_optional));
        this.postalCodeTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.PostalCode) ? (CharSequence)this.getResources().getString(R.string.address_label_zip_postal_code_optional) : (CharSequence)this.getResources().getString(R.string.address_label_zip_postal_code));
        this.stateTextInputLayout.setHint(this.isFieldOptional(CustomizableShippingField.State) ? (CharSequence)this.getResources().getString(R.string.address_label_region_generic_optional) : (CharSequence)this.getResources().getString(R.string.address_label_region_generic));
        this.postalCodeEditText.setErrorMessage(this.getResources().getString(R.string.address_zip_postal_invalid));
        this.stateEditText.setErrorMessage(this.getResources().getString(R.string.address_region_generic_required));
    }

    @JvmOverloads
    public ShippingInfoWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ShippingInfoWidget(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$updateConfigForCountry(ShippingInfoWidget $this, Country country) {
        $this.updateConfigForCountry(country);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/view/ShippingInfoWidget$CustomizableShippingField;", "", "(Ljava/lang/String;I)V", "Line1", "Line2", "City", "PostalCode", "State", "Phone", "payments-core_release"})
    public static final class CustomizableShippingField
    extends Enum<CustomizableShippingField> {
        public static final /* enum */ CustomizableShippingField Line1 = new CustomizableShippingField();
        public static final /* enum */ CustomizableShippingField Line2 = new CustomizableShippingField();
        public static final /* enum */ CustomizableShippingField City = new CustomizableShippingField();
        public static final /* enum */ CustomizableShippingField PostalCode = new CustomizableShippingField();
        public static final /* enum */ CustomizableShippingField State = new CustomizableShippingField();
        public static final /* enum */ CustomizableShippingField Phone = new CustomizableShippingField();
        private static final /* synthetic */ CustomizableShippingField[] $VALUES;

        public static CustomizableShippingField[] values() {
            return (CustomizableShippingField[])$VALUES.clone();
        }

        public static CustomizableShippingField valueOf(String value) {
            return Enum.valueOf(CustomizableShippingField.class, value);
        }

        static {
            $VALUES = customizableShippingFieldArray = new CustomizableShippingField[]{CustomizableShippingField.Line1, CustomizableShippingField.Line2, CustomizableShippingField.City, CustomizableShippingField.PostalCode, CustomizableShippingField.State, CustomizableShippingField.Phone};
        }
    }
}

