/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityViewCommand;
import androidx.core.widget.ImageViewCompat;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.recyclerview.widget.RecyclerView;
import com.stripe.android.R;
import com.stripe.android.databinding.AddPaymentMethodRowBinding;
import com.stripe.android.databinding.GooglePayRowBinding;
import com.stripe.android.databinding.MaskedCardRowBinding;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.AddPaymentMethodActivityStarter;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import com.stripe.android.view.ThemeConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0019\b\u0000\u0018\u0000 W2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004WXYZBG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00102\u001a\u000203H\u0002J\u0010\u00106\u001a\u0002072\u0006\u00102\u001a\u000203H\u0002J\u0010\u00108\u001a\u0002092\u0006\u00102\u001a\u000203H\u0002J\u0015\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020%H\u0000\u00a2\u0006\u0002\b=J\u0010\u0010>\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020\u001cH\u0002J\b\u0010@\u001a\u00020\u001cH\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u0010?\u001a\u00020\u001cH\u0016J\u0010\u0010C\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020\u001cH\u0016J\u0015\u0010D\u001a\u00020%2\u0006\u0010?\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\bEJ\u0010\u0010F\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020\u001cH\u0002J\u0019\u0010G\u001a\u0004\u0018\u00010\u001c2\u0006\u0010<\u001a\u00020%H\u0000\u00a2\u0006\u0004\bH\u0010IJ\u0010\u0010J\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020\u001cH\u0002J\u0010\u0010K\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020\u001cH\u0002J\u0018\u0010L\u001a\u00020;2\u0006\u0010M\u001a\u00020\u00022\u0006\u0010?\u001a\u00020\u001cH\u0016J\u0018\u0010N\u001a\u00020\u00022\u0006\u00102\u001a\u0002032\u0006\u0010O\u001a\u00020\u001cH\u0016J\u0015\u0010P\u001a\u00020;2\u0006\u0010?\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\bQJ\u0015\u0010R\u001a\u00020;2\u0006\u0010<\u001a\u00020%H\u0000\u00a2\u0006\u0002\bSJ\u001b\u0010T\u001a\u00020;2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0\u0006H\u0000\u00a2\u0006\u0002\bUJ\u0010\u0010V\u001a\u00020;2\u0006\u0010?\u001a\u00020\u001cH\u0002R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0016\u0010(\u001a\u0004\u0018\u00010%8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001c\u0010+\u001a\u0004\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "intentArgs", "Lcom/stripe/android/view/PaymentMethodsActivityStarter$Args;", "addableTypes", "", "Lcom/stripe/android/model/PaymentMethod$Type;", "initiallySelectedPaymentMethodId", "", "shouldShowGooglePay", "", "useGooglePay", "canDeletePaymentMethods", "(Lcom/stripe/android/view/PaymentMethodsActivityStarter$Args;Ljava/util/List;Ljava/lang/String;ZZZ)V", "_addPaymentMethodArgs", "Landroidx/lifecycle/MutableLiveData;", "Lcom/stripe/android/view/AddPaymentMethodActivityStarter$Args;", "addCardArgs", "getAddCardArgs$payments_core_release", "()Lcom/stripe/android/view/AddPaymentMethodActivityStarter$Args;", "addFpxArgs", "getAddFpxArgs$payments_core_release", "addPaymentMethodArgs", "Landroidx/lifecycle/LiveData;", "getAddPaymentMethodArgs", "()Landroidx/lifecycle/LiveData;", "googlePayCount", "", "listener", "Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;", "getListener$payments_core_release", "()Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;", "setListener$payments_core_release", "(Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;)V", "paymentMethods", "", "Lcom/stripe/android/model/PaymentMethod;", "getPaymentMethods$payments_core_release", "()Ljava/util/List;", "selectedPaymentMethod", "getSelectedPaymentMethod$payments_core_release", "()Lcom/stripe/android/model/PaymentMethod;", "selectedPaymentMethodId", "getSelectedPaymentMethodId$payments_core_release", "()Ljava/lang/String;", "setSelectedPaymentMethodId$payments_core_release", "(Ljava/lang/String;)V", "createAddCardPaymentMethodViewHolder", "Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$AddCardPaymentMethodViewHolder;", "parent", "Landroid/view/ViewGroup;", "createAddFpxPaymentMethodViewHolder", "Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$AddFpxPaymentMethodViewHolder;", "createGooglePayViewHolder", "Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$GooglePayViewHolder;", "createPaymentMethodViewHolder", "Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$PaymentMethodViewHolder;", "deletePaymentMethod", "", "paymentMethod", "deletePaymentMethod$payments_core_release", "getAddableTypesPosition", "position", "getItemCount", "getItemId", "", "getItemViewType", "getPaymentMethodAtPosition", "getPaymentMethodAtPosition$payments_core_release", "getPaymentMethodIndex", "getPosition", "getPosition$payments_core_release", "(Lcom/stripe/android/model/PaymentMethod;)Ljava/lang/Integer;", "isGooglePayPosition", "isPaymentMethodsPosition", "onBindViewHolder", "holder", "onCreateViewHolder", "viewType", "onPositionClicked", "onPositionClicked$payments_core_release", "resetPaymentMethod", "resetPaymentMethod$payments_core_release", "setPaymentMethods", "setPaymentMethods$payments_core_release", "updateSelectedPaymentMethod", "Companion", "Listener", "ViewHolder", "ViewType", "payments-core_release"})
public final class PaymentMethodsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PaymentMethod.Type> addableTypes;
    private final boolean shouldShowGooglePay;
    private final boolean useGooglePay;
    private final boolean canDeletePaymentMethods;
    @NotNull
    private final List<PaymentMethod> paymentMethods;
    @Nullable
    private String selectedPaymentMethodId;
    @Nullable
    private Listener listener;
    private final int googlePayCount;
    @NotNull
    private final MutableLiveData<AddPaymentMethodActivityStarter.Args> _addPaymentMethodArgs;
    @NotNull
    private final LiveData<AddPaymentMethodActivityStarter.Args> addPaymentMethodArgs;
    @NotNull
    private final AddPaymentMethodActivityStarter.Args addCardArgs;
    @NotNull
    private final AddPaymentMethodActivityStarter.Args addFpxArgs;
    private static final long GOOGLE_PAY_ITEM_ID = "pm_google_pay".hashCode();

    public PaymentMethodsAdapter(@NotNull PaymentMethodsActivityStarter.Args intentArgs, @NotNull List<? extends PaymentMethod.Type> addableTypes, @Nullable String initiallySelectedPaymentMethodId, boolean shouldShowGooglePay, boolean useGooglePay, boolean canDeletePaymentMethods) {
        Intrinsics.checkNotNullParameter((Object)intentArgs, (String)"intentArgs");
        Intrinsics.checkNotNullParameter(addableTypes, (String)"addableTypes");
        this.addableTypes = addableTypes;
        this.shouldShowGooglePay = shouldShowGooglePay;
        this.useGooglePay = useGooglePay;
        this.canDeletePaymentMethods = canDeletePaymentMethods;
        boolean bl = false;
        this.paymentMethods = new ArrayList();
        this.selectedPaymentMethodId = initiallySelectedPaymentMethodId;
        Integer n = 1;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = ((Number)n).intValue();
        PaymentMethodsAdapter paymentMethodsAdapter = this;
        boolean bl4 = false;
        boolean bl5 = this.shouldShowGooglePay;
        Integer n3 = bl5 ? n : null;
        paymentMethodsAdapter.googlePayCount = n3 == null ? 0 : n3;
        this._addPaymentMethodArgs = new MutableLiveData();
        this.addPaymentMethodArgs = (LiveData)this._addPaymentMethodArgs;
        this.addCardArgs = new AddPaymentMethodActivityStarter.Args.Builder().setBillingAddressFields(intentArgs.getBillingAddressFields$payments_core_release()).setShouldAttachToCustomer(true).setIsPaymentSessionActive$payments_core_release(intentArgs.isPaymentSessionActive$payments_core_release()).setPaymentMethodType(PaymentMethod.Type.Card).setAddPaymentMethodFooter(intentArgs.getAddPaymentMethodFooterLayoutId()).setPaymentConfiguration(intentArgs.getPaymentConfiguration$payments_core_release()).setWindowFlags(intentArgs.getWindowFlags$payments_core_release()).build();
        this.addFpxArgs = new AddPaymentMethodActivityStarter.Args.Builder().setIsPaymentSessionActive$payments_core_release(intentArgs.isPaymentSessionActive$payments_core_release()).setPaymentMethodType(PaymentMethod.Type.Fpx).setPaymentConfiguration(intentArgs.getPaymentConfiguration$payments_core_release()).build();
        this.setHasStableIds(true);
    }

    public /* synthetic */ PaymentMethodsAdapter(PaymentMethodsActivityStarter.Args args2, List list, String string2, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.listOf((Object)((Object)PaymentMethod.Type.Card));
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = true;
        }
        this(args2, list, string2, bl, bl2, bl3);
    }

    @NotNull
    public final List<PaymentMethod> getPaymentMethods$payments_core_release() {
        return this.paymentMethods;
    }

    @Nullable
    public final String getSelectedPaymentMethodId$payments_core_release() {
        return this.selectedPaymentMethodId;
    }

    public final void setSelectedPaymentMethodId$payments_core_release(@Nullable String string2) {
        this.selectedPaymentMethodId = string2;
    }

    @Nullable
    public final PaymentMethod getSelectedPaymentMethod$payments_core_release() {
        PaymentMethod paymentMethod;
        String string2 = this.selectedPaymentMethodId;
        if (string2 == null) {
            paymentMethod = null;
        } else {
            Object v1;
            block3: {
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String selectedPaymentMethodId = string3;
                boolean bl3 = false;
                Iterable $this$firstOrNull$iv = this.getPaymentMethods$payments_core_release();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PaymentMethod it = (PaymentMethod)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.id, (Object)selectedPaymentMethodId)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            paymentMethod = v1;
        }
        return paymentMethod;
    }

    @Nullable
    public final Listener getListener$payments_core_release() {
        return this.listener;
    }

    public final void setListener$payments_core_release(@Nullable Listener listener) {
        this.listener = listener;
    }

    @NotNull
    public final LiveData<AddPaymentMethodActivityStarter.Args> getAddPaymentMethodArgs() {
        return this.addPaymentMethodArgs;
    }

    @NotNull
    public final AddPaymentMethodActivityStarter.Args getAddCardArgs$payments_core_release() {
        return this.addCardArgs;
    }

    @NotNull
    public final AddPaymentMethodActivityStarter.Args getAddFpxArgs$payments_core_release() {
        return this.addFpxArgs;
    }

    public final /* synthetic */ void setPaymentMethods$payments_core_release(List paymentMethods) {
        Intrinsics.checkNotNullParameter((Object)paymentMethods, (String)"paymentMethods");
        this.paymentMethods.clear();
        this.paymentMethods.addAll(paymentMethods);
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.paymentMethods.size() + this.addableTypes.size() + this.googlePayCount;
    }

    public int getItemViewType(int position) {
        int n;
        if (this.isGooglePayPosition(position)) {
            n = ViewType.GooglePay.ordinal();
        } else if (this.isPaymentMethodsPosition(position)) {
            PaymentMethod.Type type = this.getPaymentMethodAtPosition$payments_core_release((int)position).type;
            n = PaymentMethod.Type.Card == type ? ViewType.Card.ordinal() : super.getItemViewType(position);
        } else {
            int n2;
            PaymentMethod.Type paymentMethodType2;
            PaymentMethod.Type type = paymentMethodType2 = this.addableTypes.get(this.getAddableTypesPosition(position));
            int n3 = WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
            switch (n3) {
                case 1: {
                    n2 = ViewType.AddCard.ordinal();
                    break;
                }
                case 2: {
                    n2 = ViewType.AddFpx.ordinal();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unsupported PaymentMethod type: ", (Object)paymentMethodType2.code));
                }
            }
            return n2;
        }
        return n;
    }

    private final boolean isGooglePayPosition(int position) {
        return this.shouldShowGooglePay && position == 0;
    }

    private final boolean isPaymentMethodsPosition(int position) {
        IntRange range = this.shouldShowGooglePay ? new IntRange(1, this.paymentMethods.size()) : RangesKt.until((int)0, (int)this.paymentMethods.size());
        int n = range.getFirst();
        return position <= range.getLast() ? n <= position : false;
    }

    public long getItemId(int position) {
        return this.isGooglePayPosition(position) ? GOOGLE_PAY_ITEM_ID : (this.isPaymentMethodsPosition(position) ? (long)this.getPaymentMethodAtPosition$payments_core_release(position).hashCode() : (long)this.addableTypes.get((int)this.getAddableTypesPosition((int)position)).code.hashCode());
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        RecyclerView.ViewHolder viewHolder = holder;
        if (viewHolder instanceof ViewHolder.PaymentMethodViewHolder) {
            PaymentMethod paymentMethod = this.getPaymentMethodAtPosition$payments_core_release(position);
            ((ViewHolder.PaymentMethodViewHolder)holder).setPaymentMethod(paymentMethod);
            ((ViewHolder.PaymentMethodViewHolder)holder).setSelected(Intrinsics.areEqual((Object)paymentMethod.id, (Object)this.selectedPaymentMethodId));
            holder.itemView.setOnClickListener(arg_0 -> PaymentMethodsAdapter.onBindViewHolder$lambda-3(this, holder, arg_0));
        } else if (viewHolder instanceof ViewHolder.GooglePayViewHolder) {
            holder.itemView.setOnClickListener(arg_0 -> PaymentMethodsAdapter.onBindViewHolder$lambda-4(this, arg_0));
            ((ViewHolder.GooglePayViewHolder)holder).bind(this.useGooglePay);
        } else if (viewHolder instanceof ViewHolder.AddCardPaymentMethodViewHolder) {
            holder.itemView.setOnClickListener(arg_0 -> PaymentMethodsAdapter.onBindViewHolder$lambda-5(this, arg_0));
        } else if (viewHolder instanceof ViewHolder.AddFpxPaymentMethodViewHolder) {
            holder.itemView.setOnClickListener(arg_0 -> PaymentMethodsAdapter.onBindViewHolder$lambda-6(this, arg_0));
        }
    }

    public final /* synthetic */ void onPositionClicked$payments_core_release(int position) {
        this.updateSelectedPaymentMethod(position);
        Listener listener = this.listener;
        if (listener != null) {
            listener.onPaymentMethodClick(this.getPaymentMethodAtPosition$payments_core_release(position));
        }
    }

    private final void updateSelectedPaymentMethod(int position) {
        int currentlySelectedPosition;
        block3: {
            int n;
            List<PaymentMethod> $this$indexOfFirst$iv = this.paymentMethods;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<PaymentMethod> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                PaymentMethod item$iv;
                PaymentMethod it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.id, (Object)this.getSelectedPaymentMethodId$payments_core_release())) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = currentlySelectedPosition = -1;
        }
        if (currentlySelectedPosition != position) {
            this.notifyItemChanged(currentlySelectedPosition);
            PaymentMethod paymentMethod = (PaymentMethod)CollectionsKt.getOrNull(this.paymentMethods, (int)position);
            this.selectedPaymentMethodId = paymentMethod == null ? null : paymentMethod.id;
        }
        this.notifyItemChanged(position);
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ViewType viewType2 = ViewType.values()[viewType];
        int n = WhenMappings.$EnumSwitchMapping$1[viewType2.ordinal()];
        switch (n) {
            case 1: {
                viewHolder = this.createPaymentMethodViewHolder(parent);
                break;
            }
            case 2: {
                viewHolder = this.createAddCardPaymentMethodViewHolder(parent);
                break;
            }
            case 3: {
                viewHolder = this.createAddFpxPaymentMethodViewHolder(parent);
                break;
            }
            case 4: {
                viewHolder = this.createGooglePayViewHolder(parent);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return viewHolder;
    }

    private final ViewHolder.AddCardPaymentMethodViewHolder createAddCardPaymentMethodViewHolder(ViewGroup parent) {
        Context context = parent.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"parent.context");
        return new ViewHolder.AddCardPaymentMethodViewHolder(context, parent);
    }

    private final ViewHolder.AddFpxPaymentMethodViewHolder createAddFpxPaymentMethodViewHolder(ViewGroup parent) {
        Context context = parent.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"parent.context");
        return new ViewHolder.AddFpxPaymentMethodViewHolder(context, parent);
    }

    private final ViewHolder.PaymentMethodViewHolder createPaymentMethodViewHolder(ViewGroup parent) {
        ViewHolder.PaymentMethodViewHolder viewHolder = new ViewHolder.PaymentMethodViewHolder(parent);
        if (this.canDeletePaymentMethods) {
            ViewCompat.addAccessibilityAction((View)viewHolder.itemView, (CharSequence)parent.getContext().getString(R.string.delete_payment_method), (arg_0, arg_1) -> PaymentMethodsAdapter.createPaymentMethodViewHolder$lambda-8(this, viewHolder, arg_0, arg_1));
        }
        return viewHolder;
    }

    private final ViewHolder.GooglePayViewHolder createGooglePayViewHolder(ViewGroup parent) {
        Context context = parent.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"parent.context");
        return new ViewHolder.GooglePayViewHolder(context, parent);
    }

    public final /* synthetic */ void deletePaymentMethod$payments_core_release(PaymentMethod paymentMethod) {
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Integer n = this.getPosition$payments_core_release(paymentMethod);
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            this.getPaymentMethods$payments_core_release().remove(paymentMethod);
            this.notifyItemRemoved(it);
        }
    }

    public final /* synthetic */ void resetPaymentMethod$payments_core_release(PaymentMethod paymentMethod) {
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Integer n = this.getPosition$payments_core_release(paymentMethod);
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            this.notifyItemChanged(it);
        }
    }

    public final /* synthetic */ PaymentMethod getPaymentMethodAtPosition$payments_core_release(int position) {
        return this.paymentMethods.get(this.getPaymentMethodIndex(position));
    }

    private final int getPaymentMethodIndex(int position) {
        return position - this.googlePayCount;
    }

    @Nullable
    public final Integer getPosition$payments_core_release(@NotNull PaymentMethod paymentMethod) {
        Integer n;
        Integer n2;
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Integer n3 = this.paymentMethods.indexOf(paymentMethod);
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n3).intValue();
        boolean bl3 = false;
        Integer n4 = n2 = it >= 0 ? n3 : null;
        if (n2 == null) {
            n = null;
        } else {
            n3 = n2;
            bl = false;
            bl2 = false;
            it = ((Number)n3).intValue();
            boolean bl4 = false;
            n = it + this.googlePayCount;
        }
        return n;
    }

    private final int getAddableTypesPosition(int position) {
        return position - this.paymentMethods.size() - this.googlePayCount;
    }

    private static final void onBindViewHolder$lambda-3(PaymentMethodsAdapter this$0, RecyclerView.ViewHolder $holder, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$holder, (String)"$holder");
        this$0.onPositionClicked$payments_core_release(((ViewHolder.PaymentMethodViewHolder)$holder).getBindingAdapterPosition());
    }

    private static final void onBindViewHolder$lambda-4(PaymentMethodsAdapter this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.setSelectedPaymentMethodId$payments_core_release(null);
        Listener listener = this$0.getListener$payments_core_release();
        if (listener != null) {
            listener.onGooglePayClick();
        }
    }

    private static final void onBindViewHolder$lambda-5(PaymentMethodsAdapter this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0._addPaymentMethodArgs.setValue((Object)this$0.getAddCardArgs$payments_core_release());
    }

    private static final void onBindViewHolder$lambda-6(PaymentMethodsAdapter this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0._addPaymentMethodArgs.setValue((Object)this$0.getAddFpxArgs$payments_core_release());
    }

    private static final boolean createPaymentMethodViewHolder$lambda-8(PaymentMethodsAdapter this$0, ViewHolder.PaymentMethodViewHolder $viewHolder, View $noName_0, AccessibilityViewCommand.CommandArguments $noName_1) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$viewHolder), (String)"$viewHolder");
        Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
        Listener listener = this$0.getListener$payments_core_release();
        if (listener != null) {
            listener.onDeletePaymentMethodAction(this$0.getPaymentMethodAtPosition$payments_core_release($viewHolder.getBindingAdapterPosition()));
        }
        return true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0004\u0005\u0006\u0007\bB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u0082\u0001\u0001\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "AddCardPaymentMethodViewHolder", "AddFpxPaymentMethodViewHolder", "GooglePayViewHolder", "PaymentMethodViewHolder", "Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$PaymentMethodViewHolder;", "payments-core_release"})
    public static abstract class ViewHolder
    extends RecyclerView.ViewHolder {
        private ViewHolder(View itemView) {
            super(itemView);
        }

        public /* synthetic */ ViewHolder(View itemView, DefaultConstructorMarker $constructor_marker) {
            this(itemView);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$AddCardPaymentMethodViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "context", "Landroid/content/Context;", "parent", "Landroid/view/ViewGroup;", "(Landroid/content/Context;Landroid/view/ViewGroup;)V", "viewBinding", "Lcom/stripe/android/databinding/AddPaymentMethodRowBinding;", "(Lcom/stripe/android/databinding/AddPaymentMethodRowBinding;)V", "payments-core_release"})
        public static final class AddCardPaymentMethodViewHolder
        extends RecyclerView.ViewHolder {
            public AddCardPaymentMethodViewHolder(@NotNull AddPaymentMethodRowBinding viewBinding2) {
                Intrinsics.checkNotNullParameter((Object)viewBinding2, (String)"viewBinding");
                super((View)viewBinding2.getRoot());
                this.itemView.setId(R.id.stripe_payment_methods_add_card);
                this.itemView.setContentDescription((CharSequence)this.itemView.getResources().getString(R.string.payment_method_add_new_card));
                viewBinding2.label.setText((CharSequence)this.itemView.getResources().getString(R.string.payment_method_add_new_card));
            }

            public AddCardPaymentMethodViewHolder(@NotNull Context context, @NotNull ViewGroup parent) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                AddPaymentMethodRowBinding addPaymentMethodRowBinding = AddPaymentMethodRowBinding.inflate(LayoutInflater.from((Context)context), parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)addPaymentMethodRowBinding, (String)"inflate(\n                    LayoutInflater.from(context),\n                    parent,\n                    false\n                )");
                this(addPaymentMethodRowBinding);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$AddFpxPaymentMethodViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "context", "Landroid/content/Context;", "parent", "Landroid/view/ViewGroup;", "(Landroid/content/Context;Landroid/view/ViewGroup;)V", "viewBinding", "Lcom/stripe/android/databinding/AddPaymentMethodRowBinding;", "(Lcom/stripe/android/databinding/AddPaymentMethodRowBinding;)V", "payments-core_release"})
        public static final class AddFpxPaymentMethodViewHolder
        extends RecyclerView.ViewHolder {
            public AddFpxPaymentMethodViewHolder(@NotNull AddPaymentMethodRowBinding viewBinding2) {
                Intrinsics.checkNotNullParameter((Object)viewBinding2, (String)"viewBinding");
                super((View)viewBinding2.getRoot());
                this.itemView.setId(R.id.stripe_payment_methods_add_fpx);
                this.itemView.setContentDescription((CharSequence)this.itemView.getResources().getString(R.string.payment_method_add_new_fpx));
                viewBinding2.label.setText((CharSequence)this.itemView.getResources().getString(R.string.payment_method_add_new_fpx));
            }

            public AddFpxPaymentMethodViewHolder(@NotNull Context context, @NotNull ViewGroup parent) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                AddPaymentMethodRowBinding addPaymentMethodRowBinding = AddPaymentMethodRowBinding.inflate(LayoutInflater.from((Context)context), parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)addPaymentMethodRowBinding, (String)"inflate(\n                    LayoutInflater.from(context),\n                    parent,\n                    false\n                )");
                this(addPaymentMethodRowBinding);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$GooglePayViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "context", "Landroid/content/Context;", "parent", "Landroid/view/ViewGroup;", "(Landroid/content/Context;Landroid/view/ViewGroup;)V", "viewBinding", "Lcom/stripe/android/databinding/GooglePayRowBinding;", "(Lcom/stripe/android/databinding/GooglePayRowBinding;)V", "themeConfig", "Lcom/stripe/android/view/ThemeConfig;", "bind", "", "isSelected", "", "payments-core_release"})
        public static final class GooglePayViewHolder
        extends RecyclerView.ViewHolder {
            @NotNull
            private final GooglePayRowBinding viewBinding;
            @NotNull
            private final ThemeConfig themeConfig;

            public GooglePayViewHolder(@NotNull GooglePayRowBinding viewBinding2) {
                Intrinsics.checkNotNullParameter((Object)viewBinding2, (String)"viewBinding");
                super((View)viewBinding2.getRoot());
                this.viewBinding = viewBinding2;
                Context context = this.itemView.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"itemView.context");
                this.themeConfig = new ThemeConfig(context);
                ImageViewCompat.setImageTintList((ImageView)((ImageView)this.viewBinding.checkIcon), (ColorStateList)ColorStateList.valueOf((int)this.themeConfig.getTintColor$payments_core_release(true)));
            }

            public GooglePayViewHolder(@NotNull Context context, @NotNull ViewGroup parent) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                GooglePayRowBinding googlePayRowBinding = GooglePayRowBinding.inflate(LayoutInflater.from((Context)context), parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)googlePayRowBinding, (String)"inflate(\n                    LayoutInflater.from(context),\n                    parent,\n                    false\n                )");
                this(googlePayRowBinding);
            }

            public final void bind(boolean isSelected) {
                this.viewBinding.label.setTextColor(ColorStateList.valueOf((int)this.themeConfig.getTextColor$payments_core_release(isSelected)));
                this.viewBinding.checkIcon.setVisibility(isSelected ? 0 : 4);
                this.itemView.setSelected(isSelected);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder$PaymentMethodViewHolder;", "Lcom/stripe/android/view/PaymentMethodsAdapter$ViewHolder;", "parent", "Landroid/view/ViewGroup;", "(Landroid/view/ViewGroup;)V", "viewBinding", "Lcom/stripe/android/databinding/MaskedCardRowBinding;", "(Lcom/stripe/android/databinding/MaskedCardRowBinding;)V", "setPaymentMethod", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "setSelected", "selected", "", "payments-core_release"})
        public static final class PaymentMethodViewHolder
        extends ViewHolder {
            @NotNull
            private final MaskedCardRowBinding viewBinding;

            public PaymentMethodViewHolder(@NotNull MaskedCardRowBinding viewBinding2) {
                Intrinsics.checkNotNullParameter((Object)viewBinding2, (String)"viewBinding");
                FrameLayout frameLayout = viewBinding2.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"viewBinding.root");
                super((View)frameLayout, null);
                this.viewBinding = viewBinding2;
            }

            public PaymentMethodViewHolder(@NotNull ViewGroup parent) {
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                MaskedCardRowBinding maskedCardRowBinding = MaskedCardRowBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
                Intrinsics.checkNotNullExpressionValue((Object)maskedCardRowBinding, (String)"inflate(\n                    LayoutInflater.from(parent.context),\n                    parent,\n                    false\n                )");
                this(maskedCardRowBinding);
            }

            public final void setPaymentMethod(@NotNull PaymentMethod paymentMethod) {
                Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
                this.viewBinding.maskedCardItem.setPaymentMethod(paymentMethod);
            }

            public final void setSelected(boolean selected) {
                this.viewBinding.maskedCardItem.setSelected(selected);
                this.itemView.setSelected(selected);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$Listener;", "", "onDeletePaymentMethodAction", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "onGooglePayClick", "onPaymentMethodClick", "payments-core_release"})
    public static interface Listener {
        public void onPaymentMethodClick(@NotNull PaymentMethod var1);

        public void onGooglePayClick();

        public void onDeletePaymentMethodAction(@NotNull PaymentMethod var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$ViewType;", "", "(Ljava/lang/String;I)V", "Card", "AddCard", "AddFpx", "GooglePay", "payments-core_release"})
    public static final class ViewType
    extends Enum<ViewType> {
        public static final /* enum */ ViewType Card = new ViewType();
        public static final /* enum */ ViewType AddCard = new ViewType();
        public static final /* enum */ ViewType AddFpx = new ViewType();
        public static final /* enum */ ViewType GooglePay = new ViewType();
        private static final /* synthetic */ ViewType[] $VALUES;

        public static ViewType[] values() {
            return (ViewType[])$VALUES.clone();
        }

        public static ViewType valueOf(String value) {
            return Enum.valueOf(ViewType.class, value);
        }

        static {
            $VALUES = viewTypeArray = new ViewType[]{ViewType.Card, ViewType.AddCard, ViewType.AddFpx, ViewType.GooglePay};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/view/PaymentMethodsAdapter$Companion;", "", "()V", "GOOGLE_PAY_ITEM_ID", "", "getGOOGLE_PAY_ITEM_ID$payments_core_release", "()J", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getGOOGLE_PAY_ITEM_ID$payments_core_release() {
            return GOOGLE_PAY_ITEM_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PaymentMethod.Type.values().length];
            nArray[PaymentMethod.Type.Card.ordinal()] = 1;
            nArray[PaymentMethod.Type.Fpx.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ViewType.values().length];
            nArray[ViewType.Card.ordinal()] = 1;
            nArray[ViewType.AddCard.ordinal()] = 2;
            nArray[ViewType.AddFpx.ordinal()] = 3;
            nArray[ViewType.GooglePay.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

