/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.model.CountryCode;
import com.stripe.android.model.CountryCodeKt;
import com.stripe.android.view.Country;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b\u0011J\u0015\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b\u0014J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\tJ\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\tH\u0007J\u0016\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\tJ\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0016\u001a\u00020\tH\u0007J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0016\u001a\u00020\tH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/view/CountryUtils;", "", "()V", "CARD_POSTAL_CODE_COUNTRIES", "", "", "getCARD_POSTAL_CODE_COUNTRIES$payments_core_release", "()Ljava/util/Set;", "cachedCountriesLocale", "Ljava/util/Locale;", "cachedOrderedLocalizedCountries", "", "Lcom/stripe/android/view/Country;", "doesCountryUsePostalCode", "", "countryCode", "Lcom/stripe/android/model/CountryCode;", "doesCountryUsePostalCode$payments_core_release", "formatNameForSorting", "name", "formatNameForSorting$payments_core_release", "getCountryByCode", "currentLocale", "getCountryCodeByName", "countryName", "getDisplayCountry", "getOrderedCountries", "getSortedLocalizedCountries", "localizedCountries", "payments-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@StabilityInferred(parameters=0)
public final class CountryUtils {
    @NotNull
    public static final CountryUtils INSTANCE = new CountryUtils();
    @NotNull
    private static final Set<String> CARD_POSTAL_CODE_COUNTRIES;
    @Nullable
    private static Locale cachedCountriesLocale;
    @NotNull
    private static List<Country> cachedOrderedLocalizedCountries;
    public static final int $stable;

    private CountryUtils() {
    }

    @NotNull
    public final Set<String> getCARD_POSTAL_CODE_COUNTRIES$payments_core_release() {
        return CARD_POSTAL_CODE_COUNTRIES;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Country> localizedCountries(Locale currentLocale) {
        void $this$mapTo$iv$iv;
        String[] stringArray = Locale.getISOCountries();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getISOCountries()");
        Object[] $this$map$iv = stringArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void code;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)code, (String)"code");
            CountryCode countryCode = CountryCode.Companion.create((String)code);
            String string3 = new Locale("", (String)code).getDisplayCountry(currentLocale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Locale(\"\", code).getDisplayCountry(currentLocale)");
            Country country = new Country(countryCode, string3);
            collection.add(country);
        }
        return (List)destination$iv$iv;
    }

    public final /* synthetic */ String getDisplayCountry(CountryCode countryCode, Locale currentLocale) {
        Object object;
        String string2;
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
        Object object2 = this.getCountryByCode(countryCode, currentLocale);
        String string3 = string2 = object2 == null ? null : ((Country)object2).getName();
        if (string2 == null) {
            object2 = new Locale("", countryCode.getValue()).getDisplayCountry(currentLocale);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"Locale(\"\", countryCode.value).getDisplayCountry(currentLocale)");
            object = object2;
        } else {
            object = string2;
        }
        return object;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final /* synthetic */ CountryCode getCountryCodeByName(String countryName, Locale currentLocale) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)countryName, (String)"countryName");
            Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
            Iterable $this$firstOrNull$iv = this.localizedCountries(currentLocale);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Country it = (Country)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)countryName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Country country = v0;
        return country == null ? null : country.getCode();
    }

    public final /* synthetic */ Country getCountryByCode(CountryCode countryCode, Locale currentLocale) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
            Iterable $this$firstOrNull$iv = this.localizedCountries(currentLocale);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Country it = (Country)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCode(), (Object)countryCode)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Country> getSortedLocalizedCountries(Locale currentLocale) {
        List<Country> list;
        if (Intrinsics.areEqual((Object)currentLocale, (Object)cachedCountriesLocale)) {
            list = cachedOrderedLocalizedCountries;
        } else {
            void $this$filterNotTo$iv$iv;
            cachedCountriesLocale = currentLocale;
            Iterable $this$sortedBy$iv = this.localizedCountries(currentLocale);
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            Iterable $this$filterNot$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Country it = (Country)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)CountryUtils.INSTANCE.formatNameForSorting$payments_core_release(it.getName()));
                    it = (Country)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string2 = CountryUtils.INSTANCE.formatNameForSorting$payments_core_release(it.getName());
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                }
            });
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Country it = (Country)element$iv$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it.getCode(), (Object)CountryCodeKt.getCountryCode(currentLocale))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            cachedOrderedLocalizedCountries = (List)destination$iv$iv;
            list = cachedOrderedLocalizedCountries;
        }
        return list;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final /* synthetic */ List getOrderedCountries(Locale currentLocale) {
        Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)this.getCountryByCode(CountryCodeKt.getCountryCode(currentLocale), currentLocale)), (Iterable)this.getSortedLocalizedCountries(currentLocale));
    }

    @VisibleForTesting
    @NotNull
    public final String formatNameForSorting$payments_core_release(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string2 = name;
        boolean bl = false;
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        CharSequence charSequence = Normalizer.normalize(string3, Normalizer.Form.NFD);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"normalize(name.lowercase(), Normalizer.Form.NFD)");
        charSequence = charSequence;
        string2 = "\\p{Mn}+";
        bl = false;
        string2 = new Regex(string2);
        String string4 = "";
        boolean bl2 = false;
        return string2.replace(charSequence, string4);
    }

    @Deprecated(message="Use with parameter CountryCode", replaceWith=@ReplaceWith(expression="CountryUtils.doesCountryUsePostalCode(CountryCode.create(countryCode))", imports={"com.stripe.android.model.CountryCode"}))
    public final /* synthetic */ boolean doesCountryUsePostalCode$payments_core_release(String countryCode) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        String string2 = countryCode;
        boolean bl = false;
        String string3 = string2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
        return CARD_POSTAL_CODE_COUNTRIES.contains(string3);
    }

    public final /* synthetic */ boolean doesCountryUsePostalCode(CountryCode countryCode) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        return CARD_POSTAL_CODE_COUNTRIES.contains(countryCode.getValue());
    }

    static {
        Object[] objectArray = new String[]{"US", "GB", "CA"};
        CARD_POSTAL_CODE_COUNTRIES = SetsKt.setOf((Object[])objectArray);
        cachedOrderedLocalizedCountries = CollectionsKt.emptyList();
        $stable = 8;
    }
}

