/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.payments.paymentlauncher;

import android.app.Application;
import android.content.Context;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultCaller;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.AbstractSavedStateViewModelFactory;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.savedstate.SavedStateRegistryOwner;
import com.stripe.android.StripeIntentResult;
import com.stripe.android.exception.APIException;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.ConfirmStripeIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.networking.AnalyticsEvent;
import com.stripe.android.networking.AnalyticsRequestFactory;
import com.stripe.android.networking.ApiRequest;
import com.stripe.android.networking.DefaultAnalyticsRequestExecutor;
import com.stripe.android.networking.StripeRepository;
import com.stripe.android.payments.DefaultReturnUrl;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.PaymentFlowResultProcessor;
import com.stripe.android.payments.PaymentIntentFlowResultProcessor;
import com.stripe.android.payments.SetupIntentFlowResultProcessor;
import com.stripe.android.payments.core.authentication.PaymentAuthenticatorRegistry;
import com.stripe.android.payments.core.injection.DaggerPaymentLauncherViewModelFactoryComponent;
import com.stripe.android.payments.core.injection.Injectable;
import com.stripe.android.payments.core.injection.InjectableKtxKt;
import com.stripe.android.payments.core.injection.PaymentLauncherViewModelSubcomponent;
import com.stripe.android.payments.core.injection.UIContext;
import com.stripe.android.payments.paymentlauncher.PaymentLauncherContract;
import com.stripe.android.payments.paymentlauncher.PaymentLauncherViewModel;
import com.stripe.android.payments.paymentlauncher.PaymentResult;
import com.stripe.android.view.AuthActivityStarterHost;
import dagger.Lazy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 B2\u00020\u0001:\u0002BCB\u0099\u0001\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\b\b\u0001\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010!J\r\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,J!\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u000fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J\u001b\u00103\u001a\u00020+2\u0006\u0010/\u001a\u000200H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b4\u00105J\u001b\u00106\u001a\u00020+2\u0006\u00107\u001a\u00020\u000fH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b8\u00109J\u0012\u0010:\u001a\u00020+2\b\u00101\u001a\u0004\u0018\u00010\u000fH\u0002J\u0015\u0010;\u001a\u00020+2\u0006\u0010<\u001a\u00020=H\u0001\u00a2\u0006\u0002\b>J\u0016\u0010?\u001a\u00020+2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020.0AH\u0002R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006D"}, d2={"Lcom/stripe/android/payments/paymentlauncher/PaymentLauncherViewModel;", "Landroidx/lifecycle/ViewModel;", "isPaymentIntent", "", "stripeApiRepository", "Lcom/stripe/android/networking/StripeRepository;", "authenticatorRegistry", "Lcom/stripe/android/payments/core/authentication/PaymentAuthenticatorRegistry;", "defaultReturnUrl", "Lcom/stripe/android/payments/DefaultReturnUrl;", "apiRequestOptionsProvider", "Ljavax/inject/Provider;", "Lcom/stripe/android/networking/ApiRequest$Options;", "threeDs1IntentReturnUrlMap", "", "", "lazyPaymentIntentFlowResultProcessor", "Ldagger/Lazy;", "Lcom/stripe/android/payments/PaymentIntentFlowResultProcessor;", "lazySetupIntentFlowResultProcessor", "Lcom/stripe/android/payments/SetupIntentFlowResultProcessor;", "analyticsRequestExecutor", "Lcom/stripe/android/networking/DefaultAnalyticsRequestExecutor;", "analyticsRequestFactory", "Lcom/stripe/android/networking/AnalyticsRequestFactory;", "uiContext", "Lkotlin/coroutines/CoroutineContext;", "authActivityStarterHost", "Lcom/stripe/android/view/AuthActivityStarterHost;", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "(ZLcom/stripe/android/networking/StripeRepository;Lcom/stripe/android/payments/core/authentication/PaymentAuthenticatorRegistry;Lcom/stripe/android/payments/DefaultReturnUrl;Ljavax/inject/Provider;Ljava/util/Map;Ldagger/Lazy;Ldagger/Lazy;Lcom/stripe/android/networking/DefaultAnalyticsRequestExecutor;Lcom/stripe/android/networking/AnalyticsRequestFactory;Lkotlin/coroutines/CoroutineContext;Lcom/stripe/android/view/AuthActivityStarterHost;Landroidx/activity/result/ActivityResultCaller;Landroidx/lifecycle/SavedStateHandle;)V", "hasStarted", "getHasStarted$payments_core_release", "()Z", "paymentLauncherResult", "Landroidx/lifecycle/MutableLiveData;", "Lcom/stripe/android/payments/paymentlauncher/PaymentResult;", "getPaymentLauncherResult$payments_core_release", "()Landroidx/lifecycle/MutableLiveData;", "cleanUp", "", "cleanUp$payments_core_release", "confirmIntent", "Lcom/stripe/android/model/StripeIntent;", "confirmStripeIntentParams", "Lcom/stripe/android/model/ConfirmStripeIntentParams;", "returnUrl", "(Lcom/stripe/android/model/ConfirmStripeIntentParams;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "confirmStripeIntent", "confirmStripeIntent$payments_core_release", "(Lcom/stripe/android/model/ConfirmStripeIntentParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleNextActionForStripeIntent", "clientSecret", "handleNextActionForStripeIntent$payments_core_release", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logReturnUrl", "onPaymentFlowResult", "paymentFlowResult", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "onPaymentFlowResult$payments_core_release", "postResult", "stripeIntentResult", "Lcom/stripe/android/StripeIntentResult;", "Companion", "Factory", "payments-core_release"})
public final class PaymentLauncherViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isPaymentIntent;
    @NotNull
    private final StripeRepository stripeApiRepository;
    @NotNull
    private final PaymentAuthenticatorRegistry authenticatorRegistry;
    @NotNull
    private final DefaultReturnUrl defaultReturnUrl;
    @NotNull
    private final Provider<ApiRequest.Options> apiRequestOptionsProvider;
    @NotNull
    private final Map<String, String> threeDs1IntentReturnUrlMap;
    @NotNull
    private final Lazy<PaymentIntentFlowResultProcessor> lazyPaymentIntentFlowResultProcessor;
    @NotNull
    private final Lazy<SetupIntentFlowResultProcessor> lazySetupIntentFlowResultProcessor;
    @NotNull
    private final DefaultAnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final AnalyticsRequestFactory analyticsRequestFactory;
    @NotNull
    private final CoroutineContext uiContext;
    @NotNull
    private final AuthActivityStarterHost authActivityStarterHost;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final MutableLiveData<PaymentResult> paymentLauncherResult;
    @NotNull
    public static final String TIMEOUT_ERROR = "Payment fails due to time out. \n";
    @NotNull
    public static final String UNKNOWN_ERROR = "Payment fails due to unknown error. \n";
    @NotNull
    public static final String REQUIRED_ERROR = "API request returned an invalid response.";
    @NotNull
    private static final List<String> EXPAND_PAYMENT_METHOD = CollectionsKt.listOf((Object)"payment_method");
    @NotNull
    public static final String KEY_HAS_STARTED = "key_has_started";

    @Inject
    public PaymentLauncherViewModel(@Named(value="isPaymentIntent") boolean isPaymentIntent, @NotNull StripeRepository stripeApiRepository, @NotNull PaymentAuthenticatorRegistry authenticatorRegistry, @NotNull DefaultReturnUrl defaultReturnUrl, @NotNull Provider<ApiRequest.Options> apiRequestOptionsProvider, @NotNull Map<String, String> threeDs1IntentReturnUrlMap, @NotNull Lazy<PaymentIntentFlowResultProcessor> lazyPaymentIntentFlowResultProcessor, @NotNull Lazy<SetupIntentFlowResultProcessor> lazySetupIntentFlowResultProcessor, @NotNull DefaultAnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsRequestFactory analyticsRequestFactory2, @UIContext @NotNull CoroutineContext uiContext, @NotNull AuthActivityStarterHost authActivityStarterHost, @NotNull ActivityResultCaller activityResultCaller, @NotNull SavedStateHandle savedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)stripeApiRepository, (String)"stripeApiRepository");
        Intrinsics.checkNotNullParameter((Object)authenticatorRegistry, (String)"authenticatorRegistry");
        Intrinsics.checkNotNullParameter((Object)defaultReturnUrl, (String)"defaultReturnUrl");
        Intrinsics.checkNotNullParameter(apiRequestOptionsProvider, (String)"apiRequestOptionsProvider");
        Intrinsics.checkNotNullParameter(threeDs1IntentReturnUrlMap, (String)"threeDs1IntentReturnUrlMap");
        Intrinsics.checkNotNullParameter(lazyPaymentIntentFlowResultProcessor, (String)"lazyPaymentIntentFlowResultProcessor");
        Intrinsics.checkNotNullParameter(lazySetupIntentFlowResultProcessor, (String)"lazySetupIntentFlowResultProcessor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory2, (String)"analyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)uiContext, (String)"uiContext");
        Intrinsics.checkNotNullParameter((Object)authActivityStarterHost, (String)"authActivityStarterHost");
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        this.isPaymentIntent = isPaymentIntent;
        this.stripeApiRepository = stripeApiRepository;
        this.authenticatorRegistry = authenticatorRegistry;
        this.defaultReturnUrl = defaultReturnUrl;
        this.apiRequestOptionsProvider = apiRequestOptionsProvider;
        this.threeDs1IntentReturnUrlMap = threeDs1IntentReturnUrlMap;
        this.lazyPaymentIntentFlowResultProcessor = lazyPaymentIntentFlowResultProcessor;
        this.lazySetupIntentFlowResultProcessor = lazySetupIntentFlowResultProcessor;
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.analyticsRequestFactory = analyticsRequestFactory2;
        this.uiContext = uiContext;
        this.authActivityStarterHost = authActivityStarterHost;
        this.savedStateHandle = savedStateHandle;
        this.authenticatorRegistry.onNewActivityResultCaller(activityResultCaller, (ActivityResultCallback<PaymentFlowResult.Unvalidated>)((ActivityResultCallback)this::onPaymentFlowResult$payments_core_release));
        this.paymentLauncherResult = new MutableLiveData();
    }

    public final boolean getHasStarted$payments_core_release() {
        Boolean bl = (Boolean)this.savedStateHandle.get(KEY_HAS_STARTED);
        return bl == null ? false : bl;
    }

    @NotNull
    public final MutableLiveData<PaymentResult> getPaymentLauncherResult$payments_core_release() {
        return this.paymentLauncherResult;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object confirmStripeIntent$payments_core_release(@NotNull ConfirmStripeIntentParams var1_1, @NotNull Continuation<? super Unit> var2_2) {
        block14: {
            if (!(var2_2 instanceof confirmStripeIntent.1)) ** GOTO lbl-1000
            var24_3 = var2_2;
            if ((var24_3.label & -2147483648) != 0) {
                var24_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ PaymentLauncherViewModel this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.confirmStripeIntent$payments_core_release(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var25_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    this.savedStateHandle.set("key_has_started", (Object)Boxing.boxBoolean((boolean)true));
                    this.logReturnUrl(confirmStripeIntentParams.getReturnUrl());
                    var5_6 = confirmStripeIntentParams.getReturnUrl();
                    var6_8 = false;
                    var7_12 = false;
                    it = var5_6;
                    $i$a$-takeUnless-PaymentLauncherViewModel$confirmStripeIntent$returnUrl$1 = false;
                    var10_22 = it;
                    var11_23 = false;
                    var12_24 = false;
                    var4_25 /* !! */  = Boxing.boxBoolean((boolean)(var10_22 == null || StringsKt.isBlank((CharSequence)var10_22))) == false ? var5_6 : null;
                    returnUrl = var4_25 /* !! */  == null ? this.defaultReturnUrl.getValue() : var4_25 /* !! */ ;
                    var4_25 /* !! */  = this;
                    var5_7 = false;
                    var6_9 = Result.Companion;
                    $this$confirmStripeIntent_u24lambda_u2d1 = (PaymentLauncherViewModel)var4_25 /* !! */ ;
                    $i$a$-runCatching-PaymentLauncherViewModel$confirmStripeIntent$2 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = returnUrl;
                    $continuation.label = 1;
                    v0 = super.confirmIntent((ConfirmStripeIntentParams)confirmStripeIntentParams, (String)returnUrl, (Continuation<? super StripeIntent>)$continuation);
                    ** if (v0 != var25_5) goto lbl37
lbl36:
                    // 1 sources

                    return var25_5;
lbl37:
                    // 1 sources

                    ** GOTO lbl46
                }
                case 1: {
                    $i$a$-runCatching-PaymentLauncherViewModel$confirmStripeIntent$2 = false;
                    returnUrl = (String)$continuation.L$1;
                    this = (PaymentLauncherViewModel)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl46:
                        // 2 sources

                        $this$confirmStripeIntent_u24lambda_u2d1 = (StripeIntent)v0;
                        $i$a$-runCatching-PaymentLauncherViewModel$confirmStripeIntent$2 = false;
                        var6_9 = Result.constructor-impl((Object)$this$confirmStripeIntent_u24lambda_u2d1);
                    }
                    catch (Throwable $this$confirmStripeIntent_u24lambda_u2d1) {
                        $i$a$-runCatching-PaymentLauncherViewModel$confirmStripeIntent$2 = Result.Companion;
                        var9_20 = false;
                        var6_9 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$confirmStripeIntent_u24lambda_u2d1));
                    }
                    var4_25 /* !! */  = var6_9;
                    var5_7 = false;
                    var6_10 = false;
                    var6_11 = Result.exceptionOrNull-impl((Object)var4_25 /* !! */ );
                    if (var6_11 != null) break;
                    intent = (StripeIntent)var4_25 /* !! */ ;
                    $i$a$-fold-PaymentLauncherViewModel$confirmStripeIntent$3 = false;
                    var9_21 = intent.getNextActionData();
                    if (var9_21 != null) {
                        var10_22 = var9_21;
                        var11_23 = false;
                        var12_24 = false;
                        it = var10_22;
                        $i$a$-let-PaymentLauncherViewModel$confirmStripeIntent$3$1 = false;
                        if (it instanceof StripeIntent.NextActionData.SdkData.Use3DS1 && (var15_29 = intent.getId()) != null) {
                            var16_30 = var15_29;
                            var17_31 = false;
                            var18_32 = false;
                            intentId = var16_30;
                            $i$a$-let-PaymentLauncherViewModel$confirmStripeIntent$3$1$1 = false;
                            var21_35 = this.threeDs1IntentReturnUrlMap;
                            var22_36 = false;
                            var21_35.put(intentId, (String)returnUrl);
                        }
                    }
                    v1 = this.authenticatorRegistry.getAuthenticator(intent);
                    var9_21 = this.apiRequestOptionsProvider.get();
                    Intrinsics.checkNotNullExpressionValue((Object)var9_21, (String)"apiRequestOptionsProvider.get()");
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.label = 2;
                    v2 = v1.authenticate(this.authActivityStarterHost, intent, (ApiRequest.Options)var9_21, (Continuation<Unit>)$continuation);
                    if (v2 == var25_5) {
                        return var25_5;
                    }
                    break block14;
                }
                case 2: {
                    $i$a$-fold-PaymentLauncherViewModel$confirmStripeIntent$3 = false;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                    break block14;
                }
            }
            it = var6_11;
            $i$a$-fold-PaymentLauncherViewModel$confirmStripeIntent$4 = false;
            this.getPaymentLauncherResult$payments_core_release().postValue((Object)new PaymentResult.Failed(it));
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object confirmIntent(ConfirmStripeIntentParams var1_1, String var2_2, Continuation<? super StripeIntent> var3_3) {
        block10: {
            block11: {
                if (!(var3_3 instanceof confirmIntent.1)) ** GOTO lbl-1000
                var14_4 = var3_3;
                if ((var14_4.label & -2147483648) != 0) {
                    var14_4.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, var3_3){
                        /* synthetic */ Object result;
                        final /* synthetic */ PaymentLauncherViewModel this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return PaymentLauncherViewModel.access$confirmIntent(this.this$0, null, null, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var4_7 = confirmStripeIntentParams;
                        var5_8 = false;
                        var6_9 = false;
                        it = var4_7;
                        $i$a$-also-PaymentLauncherViewModel$confirmIntent$2 = false;
                        it.setReturnUrl((String)returnUrl);
                        var4_7 = var4_7.withShouldUseStripeSdk(true);
                        var5_8 = false;
                        var6_9 = false;
                        decoratedParams = var4_7;
                        $i$a$-let-PaymentLauncherViewModel$confirmIntent$3 = false;
                        var9_12 /* !! */  = decoratedParams;
                        if (!(var9_12 /* !! */  instanceof ConfirmPaymentIntentParams)) break;
                        v0 = (ConfirmPaymentIntentParams)decoratedParams;
                        var10_13 = this.apiRequestOptionsProvider.get();
                        Intrinsics.checkNotNullExpressionValue((Object)var10_13, (String)"apiRequestOptionsProvider.get()");
                        $continuation.label = 1;
                        v1 = this.stripeApiRepository.confirmPaymentIntent$payments_core_release(v0, (ApiRequest.Options)var10_13, PaymentLauncherViewModel.EXPAND_PAYMENT_METHOD, (Continuation<? super PaymentIntent>)$continuation);
                        if (v1 == var15_6) {
                            return var15_6;
                        }
                        ** GOTO lbl38
                    }
                    case 1: {
                        $i$a$-let-PaymentLauncherViewModel$confirmIntent$3 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl38:
                        // 2 sources

                        v2 = (StripeIntent)v1;
                        break block10;
                    }
                }
                if (!(var9_12 /* !! */  instanceof ConfirmSetupIntentParams)) break block11;
                v3 = (ConfirmSetupIntentParams)decoratedParams;
                var10_13 = this.apiRequestOptionsProvider.get();
                Intrinsics.checkNotNullExpressionValue((Object)var10_13, (String)"apiRequestOptionsProvider.get()");
                $continuation.label = 2;
                v4 = this.stripeApiRepository.confirmSetupIntent$payments_core_release(v3, (ApiRequest.Options)var10_13, PaymentLauncherViewModel.EXPAND_PAYMENT_METHOD, (Continuation<? super SetupIntent>)$continuation);
                if (v4 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl53
                {
                    case 2: {
                        $i$a$-let-PaymentLauncherViewModel$confirmIntent$3 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl53:
                        // 2 sources

                        v2 = (StripeIntent)v4;
                        break block10;
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        var9_12 /* !! */  = v2;
        var10_14 = false;
        var11_15 = false;
        if (var9_12 /* !! */  == null) {
            $i$a$-requireNotNull-PaymentLauncherViewModel$confirmIntent$3$1 = false;
            var11_16 = "API request returned an invalid response.";
            throw (Throwable)new IllegalArgumentException(var11_16.toString());
        }
        return var9_12 /* !! */ ;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object handleNextActionForStripeIntent$payments_core_release(@NotNull String var1_1, @NotNull Continuation<? super Unit> var2_2) {
        block13: {
            if (!(var2_2 instanceof handleNextActionForStripeIntent.1)) ** GOTO lbl-1000
            var14_3 = var2_2;
            if ((var14_3.label & -2147483648) != 0) {
                var14_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ PaymentLauncherViewModel this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.handleNextActionForStripeIntent$payments_core_release(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    this.savedStateHandle.set("key_has_started", (Object)Boxing.boxBoolean((boolean)true));
                    var3_6 = this;
                    var4_7 = false;
                    var5_8 /* !! */  = Result.Companion;
                    $this$handleNextActionForStripeIntent_u24lambda_u2d9 /* !! */  = var3_6;
                    $i$a$-runCatching-PaymentLauncherViewModel$handleNextActionForStripeIntent$2 = false;
                    v0 = $this$handleNextActionForStripeIntent_u24lambda_u2d9 /* !! */ .stripeApiRepository;
                    var8_18 = $this$handleNextActionForStripeIntent_u24lambda_u2d9 /* !! */ .apiRequestOptionsProvider.get();
                    Intrinsics.checkNotNullExpressionValue((Object)var8_18, (String)"apiRequestOptionsProvider.get()");
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v1 = StripeRepository.retrieveStripeIntent$payments_core_release$default(v0, (String)clientSecret, (ApiRequest.Options)var8_18, null, (Continuation)$continuation, 4, null);
                    ** if (v1 != var15_5) goto lbl28
lbl27:
                    // 1 sources

                    return var15_5;
lbl28:
                    // 1 sources

                    ** GOTO lbl36
                }
                case 1: {
                    $i$a$-runCatching-PaymentLauncherViewModel$handleNextActionForStripeIntent$2 = false;
                    this = (PaymentLauncherViewModel)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl36:
                        // 2 sources

                        var8_18 = v1;
                        var9_21 = false;
                        var10_22 = false;
                        var10_22 = false;
                        var11_23 = false;
                        if (var8_18 == null) {
                            var12_25 = false;
                            var11_24 = "Required value was null.";
                            throw (Throwable)new IllegalArgumentException(var11_24.toString());
                        }
                        $this$handleNextActionForStripeIntent_u24lambda_u2d9 /* !! */  = (StripeIntent)var8_18;
                        $i$a$-runCatching-PaymentLauncherViewModel$handleNextActionForStripeIntent$2 = false;
                        var5_8 /* !! */  = Result.constructor-impl((Object)$this$handleNextActionForStripeIntent_u24lambda_u2d9 /* !! */ );
                    }
                    catch (Throwable $this$handleNextActionForStripeIntent_u24lambda_u2d9) {
                        $i$a$-runCatching-PaymentLauncherViewModel$handleNextActionForStripeIntent$2 = Result.Companion;
                        var8_19 = false;
                        var5_8 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$handleNextActionForStripeIntent_u24lambda_u2d9));
                    }
                    var3_6 = var5_8 /* !! */ ;
                    var4_7 = false;
                    var5_9 = false;
                    var5_10 = Result.exceptionOrNull-impl((Object)var3_6);
                    if (var5_10 != null) break;
                    intent = (StripeIntent)var3_6;
                    $i$a$-fold-PaymentLauncherViewModel$handleNextActionForStripeIntent$3 = false;
                    v2 = this.authenticatorRegistry.getAuthenticator(intent);
                    var8_20 = this.apiRequestOptionsProvider.get();
                    Intrinsics.checkNotNullExpressionValue((Object)var8_20, (String)"apiRequestOptionsProvider.get()");
                    $continuation.L$0 = null;
                    $continuation.label = 2;
                    v3 = v2.authenticate(this.authActivityStarterHost, intent, (ApiRequest.Options)var8_20, (Continuation<Unit>)$continuation);
                    if (v3 == var15_5) {
                        return var15_5;
                    }
                    break block13;
                }
                case 2: {
                    $i$a$-fold-PaymentLauncherViewModel$handleNextActionForStripeIntent$3 = false;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
                    break block13;
                }
            }
            it = var5_10;
            $i$a$-fold-PaymentLauncherViewModel$handleNextActionForStripeIntent$4 = false;
            this.getPaymentLauncherResult$payments_core_release().postValue((Object)new PaymentResult.Failed(it));
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @VisibleForTesting
    public final void onPaymentFlowResult$payments_core_release(@NotNull PaymentFlowResult.Unvalidated paymentFlowResult) {
        Intrinsics.checkNotNullParameter((Object)paymentFlowResult, (String)"paymentFlowResult");
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, paymentFlowResult, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PaymentLauncherViewModel this$0;
            final /* synthetic */ PaymentFlowResult.Unvalidated $paymentFlowResult;
            {
                this.this$0 = $receiver;
                this.$paymentFlowResult = $paymentFlowResult;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_4 /* !! */  = $this$launch = (CoroutineScope)this.L$0;
                        var4_5 = this.this$0;
                        var5_6 /* !! */  = this.$paymentFlowResult;
                        var6_7 = false;
                        var7_8 = Result.Companion;
                        var8_11 = var3_4 /* !! */ ;
                        $i$a$-runCatching-PaymentLauncherViewModel$onPaymentFlowResult$1$1 = false;
                        this.label = 1;
                        v0 = (PaymentLauncherViewModel.access$isPaymentIntent$p(var4_5) != false ? (PaymentFlowResultProcessor)PaymentLauncherViewModel.access$getLazyPaymentIntentFlowResultProcessor$p(var4_5).get() : (PaymentFlowResultProcessor)PaymentLauncherViewModel.access$getLazySetupIntentFlowResultProcessor$p(var4_5).get()).processResult(var5_6 /* !! */ , this);
                        ** if (v0 != var11_2) goto lbl18
lbl17:
                        // 1 sources

                        return var11_2;
lbl18:
                        // 1 sources

                        ** GOTO lbl25
                    }
                    case 1: {
                        $i$a$-runCatching-PaymentLauncherViewModel$onPaymentFlowResult$1$1 = false;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl25:
                            // 2 sources

                            var8_11 = (StripeIntentResult)v0;
                            $i$a$-runCatching-PaymentLauncherViewModel$onPaymentFlowResult$1$1 = false;
                            var7_8 = Result.constructor-impl((Object)var8_11);
                        }
                        catch (Throwable var8_12) {
                            $i$a$-runCatching-PaymentLauncherViewModel$onPaymentFlowResult$1$1 = Result.Companion;
                            var10_19 = false;
                            var7_8 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var8_12));
                        }
                        var3_4 /* !! */  = var7_8;
                        var4_5 = this.this$0;
                        var5_6 /* !! */  = this.this$0;
                        var6_7 = false;
                        var7_9 = false;
                        var7_10 = Result.exceptionOrNull-impl((Object)var3_4 /* !! */ );
                        if (var7_10 != null) break;
                        it = (StripeIntentResult)var3_4 /* !! */ ;
                        $i$a$-fold-PaymentLauncherViewModel$onPaymentFlowResult$1$2 = false;
                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)PaymentLauncherViewModel.access$getUiContext$p(var4_5), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(var4_5, (StripeIntentResult<? extends StripeIntent>)it, null){
                            int label;
                            final /* synthetic */ PaymentLauncherViewModel this$0;
                            final /* synthetic */ StripeIntentResult<StripeIntent> $it;
                            {
                                this.this$0 = $receiver;
                                this.$it = $it;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        PaymentLauncherViewModel.access$postResult(this.this$0, this.$it);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        if (v1 == var11_2) {
                            return var11_2;
                        }
                        ** GOTO lbl64
                    }
                    case 2: {
                        $i$a$-fold-PaymentLauncherViewModel$onPaymentFlowResult$1$2 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
                        ** GOTO lbl64
                    }
                }
                it = var7_10;
                $i$a$-fold-PaymentLauncherViewModel$onPaymentFlowResult$1$3 = false;
                this.label = 3;
                v2 = BuildersKt.withContext((CoroutineContext)PaymentLauncherViewModel.access$getUiContext$p((PaymentLauncherViewModel)var5_6 /* !! */ ), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((PaymentLauncherViewModel)var5_6 /* !! */ , (Throwable)it, null){
                    int label;
                    final /* synthetic */ PaymentLauncherViewModel this$0;
                    final /* synthetic */ Throwable $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.this$0.getPaymentLauncherResult$payments_core_release().postValue((Object)new PaymentResult.Failed(this.$it));
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)this);
                if (v2 == var11_2) {
                    return var11_2;
                }
                ** GOTO lbl64
                {
                    case 3: {
                        $i$a$-fold-PaymentLauncherViewModel$onPaymentFlowResult$1$3 = false;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl64:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void cleanUp$payments_core_release() {
        this.authenticatorRegistry.onLauncherInvalidated();
    }

    private final void postResult(StripeIntentResult<? extends StripeIntent> stripeIntentResult) {
        PaymentResult paymentResult;
        int n = stripeIntentResult.getOutcome();
        switch (n) {
            case 1: {
                paymentResult = PaymentResult.Completed.INSTANCE;
                break;
            }
            case 2: {
                paymentResult = new PaymentResult.Failed(new APIException(null, null, 0, stripeIntentResult.getFailureMessage(), null, 23, null));
                break;
            }
            case 3: {
                paymentResult = PaymentResult.Canceled.INSTANCE;
                break;
            }
            case 4: {
                paymentResult = new PaymentResult.Failed(new APIException(null, null, 0, Intrinsics.stringPlus((String)TIMEOUT_ERROR, (Object)stripeIntentResult.getFailureMessage()), null, 23, null));
                break;
            }
            default: {
                paymentResult = new PaymentResult.Failed(new APIException(null, null, 0, Intrinsics.stringPlus((String)UNKNOWN_ERROR, (Object)stripeIntentResult.getFailureMessage()), null, 23, null));
            }
        }
        this.paymentLauncherResult.postValue((Object)paymentResult);
    }

    private final void logReturnUrl(String returnUrl) {
        Object object = returnUrl;
        object = Intrinsics.areEqual((Object)object, (Object)this.defaultReturnUrl.getValue()) ? AnalyticsEvent.ConfirmReturnUrlDefault : (object == null ? AnalyticsEvent.ConfirmReturnUrlNull : AnalyticsEvent.ConfirmReturnUrlCustom);
        boolean bl = false;
        boolean bl2 = false;
        Object event = object;
        boolean bl3 = false;
        this.analyticsRequestExecutor.executeAsync(AnalyticsRequestFactory.createRequest$payments_core_release$default(this.analyticsRequestFactory, (AnalyticsEvent)((Object)event), null, null, null, null, 30, null));
    }

    public static final /* synthetic */ Object access$confirmIntent(PaymentLauncherViewModel $this, ConfirmStripeIntentParams confirmStripeIntentParams, String returnUrl, Continuation $completion) {
        return $this.confirmIntent(confirmStripeIntentParams, returnUrl, (Continuation<? super StripeIntent>)$completion);
    }

    public static final /* synthetic */ boolean access$isPaymentIntent$p(PaymentLauncherViewModel $this) {
        return $this.isPaymentIntent;
    }

    public static final /* synthetic */ Lazy access$getLazyPaymentIntentFlowResultProcessor$p(PaymentLauncherViewModel $this) {
        return $this.lazyPaymentIntentFlowResultProcessor;
    }

    public static final /* synthetic */ Lazy access$getLazySetupIntentFlowResultProcessor$p(PaymentLauncherViewModel $this) {
        return $this.lazySetupIntentFlowResultProcessor;
    }

    public static final /* synthetic */ CoroutineContext access$getUiContext$p(PaymentLauncherViewModel $this) {
        return $this.uiContext;
    }

    public static final /* synthetic */ void access$postResult(PaymentLauncherViewModel $this, StripeIntentResult stripeIntentResult) {
        $this.postResult(stripeIntentResult);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001$B?\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ7\u0010\u0017\u001a\u0002H\u0018\"\n\b\u0000\u0010\u0018*\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0003H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006%"}, d2={"Lcom/stripe/android/payments/paymentlauncher/PaymentLauncherViewModel$Factory;", "Landroidx/lifecycle/AbstractSavedStateViewModelFactory;", "Lcom/stripe/android/payments/core/injection/Injectable;", "Lcom/stripe/android/payments/paymentlauncher/PaymentLauncherViewModel$Factory$FallbackInitializeParam;", "argsSupplier", "Lkotlin/Function0;", "Lcom/stripe/android/payments/paymentlauncher/PaymentLauncherContract$Args;", "applicationSupplier", "Landroid/app/Application;", "authActivityStarterHostProvider", "Lcom/stripe/android/view/AuthActivityStarterHost;", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "owner", "Landroidx/savedstate/SavedStateRegistryOwner;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Landroidx/activity/result/ActivityResultCaller;Landroidx/savedstate/SavedStateRegistryOwner;)V", "subComponentBuilderProvider", "Ljavax/inject/Provider;", "Lcom/stripe/android/payments/core/injection/PaymentLauncherViewModelSubcomponent$Builder;", "getSubComponentBuilderProvider", "()Ljavax/inject/Provider;", "setSubComponentBuilderProvider", "(Ljavax/inject/Provider;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "key", "", "modelClass", "Ljava/lang/Class;", "handle", "Landroidx/lifecycle/SavedStateHandle;", "(Ljava/lang/String;Ljava/lang/Class;Landroidx/lifecycle/SavedStateHandle;)Landroidx/lifecycle/ViewModel;", "fallbackInitialize", "", "arg", "FallbackInitializeParam", "payments-core_release"})
    public static final class Factory
    extends AbstractSavedStateViewModelFactory
    implements Injectable<FallbackInitializeParam> {
        @NotNull
        private final Function0<PaymentLauncherContract.Args> argsSupplier;
        @NotNull
        private final Function0<Application> applicationSupplier;
        @NotNull
        private final Function0<AuthActivityStarterHost> authActivityStarterHostProvider;
        @NotNull
        private final ActivityResultCaller activityResultCaller;
        @Inject
        public Provider<PaymentLauncherViewModelSubcomponent.Builder> subComponentBuilderProvider;

        public Factory(@NotNull Function0<? extends PaymentLauncherContract.Args> argsSupplier, @NotNull Function0<? extends Application> applicationSupplier, @NotNull Function0<? extends AuthActivityStarterHost> authActivityStarterHostProvider, @NotNull ActivityResultCaller activityResultCaller, @NotNull SavedStateRegistryOwner owner) {
            Intrinsics.checkNotNullParameter(argsSupplier, (String)"argsSupplier");
            Intrinsics.checkNotNullParameter(applicationSupplier, (String)"applicationSupplier");
            Intrinsics.checkNotNullParameter(authActivityStarterHostProvider, (String)"authActivityStarterHostProvider");
            Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super(owner, null);
            this.argsSupplier = argsSupplier;
            this.applicationSupplier = applicationSupplier;
            this.authActivityStarterHostProvider = authActivityStarterHostProvider;
            this.activityResultCaller = activityResultCaller;
        }

        @NotNull
        public final Provider<PaymentLauncherViewModelSubcomponent.Builder> getSubComponentBuilderProvider() {
            Provider<PaymentLauncherViewModelSubcomponent.Builder> provider = this.subComponentBuilderProvider;
            if (provider != null) {
                return provider;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"subComponentBuilderProvider");
            throw null;
        }

        public final void setSubComponentBuilderProvider(@NotNull Provider<PaymentLauncherViewModelSubcomponent.Builder> provider) {
            Intrinsics.checkNotNullParameter(provider, (String)"<set-?>");
            this.subComponentBuilderProvider = provider;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected <T extends ViewModel> T create(@NotNull String key, @NotNull Class<T> modelClass, @NotNull SavedStateHandle handle) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            PaymentLauncherContract.Args arg = (PaymentLauncherContract.Args)this.argsSupplier.invoke();
            InjectableKtxKt.injectWithFallback(this, arg.getInjectorKey(), new FallbackInitializeParam((Application)this.applicationSupplier.invoke(), arg.getEnableLogging(), arg.getPublishableKey(), arg.getStripeAccountId(), arg.getProductUsage()));
            PaymentLauncherViewModelSubcomponent.Builder builder = (PaymentLauncherViewModelSubcomponent.Builder)this.getSubComponentBuilderProvider().get();
            PaymentLauncherContract.Args args2 = arg;
            if (args2 instanceof PaymentLauncherContract.Args.IntentConfirmationArgs) {
                ConfirmStripeIntentParams confirmStripeIntentParams = ((PaymentLauncherContract.Args.IntentConfirmationArgs)arg).getConfirmStripeIntentParams();
                if (confirmStripeIntentParams instanceof ConfirmPaymentIntentParams) {
                    bl = true;
                    return (T)((Object)builder.isPaymentIntent(bl).savedStateHandle(handle).authActivityStarterHost((AuthActivityStarterHost)this.authActivityStarterHostProvider.invoke()).activityResultCaller(this.activityResultCaller).build().getViewModel());
                } else {
                    if (!(confirmStripeIntentParams instanceof ConfirmSetupIntentParams)) throw new NoWhenBranchMatchedException();
                    bl = false;
                }
                return (T)((Object)builder.isPaymentIntent(bl).savedStateHandle(handle).authActivityStarterHost((AuthActivityStarterHost)this.authActivityStarterHostProvider.invoke()).activityResultCaller(this.activityResultCaller).build().getViewModel());
            } else if (args2 instanceof PaymentLauncherContract.Args.PaymentIntentNextActionArgs) {
                bl = true;
                return (T)((Object)builder.isPaymentIntent(bl).savedStateHandle(handle).authActivityStarterHost((AuthActivityStarterHost)this.authActivityStarterHostProvider.invoke()).activityResultCaller(this.activityResultCaller).build().getViewModel());
            } else {
                if (!(args2 instanceof PaymentLauncherContract.Args.SetupIntentNextActionArgs)) throw new NoWhenBranchMatchedException();
                bl = false;
            }
            return (T)((Object)builder.isPaymentIntent(bl).savedStateHandle(handle).authActivityStarterHost((AuthActivityStarterHost)this.authActivityStarterHostProvider.invoke()).activityResultCaller(this.activityResultCaller).build().getViewModel());
        }

        @Override
        public void fallbackInitialize(@NotNull FallbackInitializeParam arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            DaggerPaymentLauncherViewModelFactoryComponent.builder().context((Context)arg.getApplication()).enableLogging(arg.getEnableLogging()).publishableKeyProvider((Function0<String>)((Function0)new Function0<String>(arg){
                final /* synthetic */ FallbackInitializeParam $arg;
                {
                    this.$arg = $arg;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$arg.getPublishableKey();
                }
            })).stripeAccountIdProvider((Function0<String>)((Function0)new Function0<String>(arg){
                final /* synthetic */ FallbackInitializeParam $arg;
                {
                    this.$arg = $arg;
                    super(0);
                }

                @Nullable
                public final String invoke() {
                    return this.$arg.getStripeAccountId();
                }
            })).productUsage(arg.getProductUsage()).build().inject(this);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u00c6\u0003JC\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/stripe/android/payments/paymentlauncher/PaymentLauncherViewModel$Factory$FallbackInitializeParam;", "", "application", "Landroid/app/Application;", "enableLogging", "", "publishableKey", "", "stripeAccountId", "productUsage", "", "(Landroid/app/Application;ZLjava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "getApplication", "()Landroid/app/Application;", "getEnableLogging", "()Z", "getProductUsage", "()Ljava/util/Set;", "getPublishableKey", "()Ljava/lang/String;", "getStripeAccountId", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "payments-core_release"})
        public static final class FallbackInitializeParam {
            @NotNull
            private final Application application;
            private final boolean enableLogging;
            @NotNull
            private final String publishableKey;
            @Nullable
            private final String stripeAccountId;
            @NotNull
            private final Set<String> productUsage;

            public FallbackInitializeParam(@NotNull Application application, boolean enableLogging, @NotNull String publishableKey2, @Nullable String stripeAccountId2, @NotNull Set<String> productUsage) {
                Intrinsics.checkNotNullParameter((Object)application, (String)"application");
                Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
                Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
                this.application = application;
                this.enableLogging = enableLogging;
                this.publishableKey = publishableKey2;
                this.stripeAccountId = stripeAccountId2;
                this.productUsage = productUsage;
            }

            @NotNull
            public final Application getApplication() {
                return this.application;
            }

            public final boolean getEnableLogging() {
                return this.enableLogging;
            }

            @NotNull
            public final String getPublishableKey() {
                return this.publishableKey;
            }

            @Nullable
            public final String getStripeAccountId() {
                return this.stripeAccountId;
            }

            @NotNull
            public final Set<String> getProductUsage() {
                return this.productUsage;
            }

            @NotNull
            public final Application component1() {
                return this.application;
            }

            public final boolean component2() {
                return this.enableLogging;
            }

            @NotNull
            public final String component3() {
                return this.publishableKey;
            }

            @Nullable
            public final String component4() {
                return this.stripeAccountId;
            }

            @NotNull
            public final Set<String> component5() {
                return this.productUsage;
            }

            @NotNull
            public final FallbackInitializeParam copy(@NotNull Application application, boolean enableLogging, @NotNull String publishableKey2, @Nullable String stripeAccountId2, @NotNull Set<String> productUsage) {
                Intrinsics.checkNotNullParameter((Object)application, (String)"application");
                Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
                Intrinsics.checkNotNullParameter(productUsage, (String)"productUsage");
                return new FallbackInitializeParam(application, enableLogging, publishableKey2, stripeAccountId2, productUsage);
            }

            public static /* synthetic */ FallbackInitializeParam copy$default(FallbackInitializeParam fallbackInitializeParam, Application application, boolean bl, String string2, String string3, Set set, int n, Object object) {
                if ((n & 1) != 0) {
                    application = fallbackInitializeParam.application;
                }
                if ((n & 2) != 0) {
                    bl = fallbackInitializeParam.enableLogging;
                }
                if ((n & 4) != 0) {
                    string2 = fallbackInitializeParam.publishableKey;
                }
                if ((n & 8) != 0) {
                    string3 = fallbackInitializeParam.stripeAccountId;
                }
                if ((n & 0x10) != 0) {
                    set = fallbackInitializeParam.productUsage;
                }
                return fallbackInitializeParam.copy(application, bl, string2, string3, set);
            }

            @NotNull
            public String toString() {
                return "FallbackInitializeParam(application=" + this.application + ", enableLogging=" + this.enableLogging + ", publishableKey=" + this.publishableKey + ", stripeAccountId=" + this.stripeAccountId + ", productUsage=" + this.productUsage + ')';
            }

            public int hashCode() {
                int result2 = this.application.hashCode();
                int n = this.enableLogging ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                result2 = result2 * 31 + n;
                result2 = result2 * 31 + this.publishableKey.hashCode();
                result2 = result2 * 31 + (this.stripeAccountId == null ? 0 : this.stripeAccountId.hashCode());
                result2 = result2 * 31 + ((Object)this.productUsage).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FallbackInitializeParam)) {
                    return false;
                }
                FallbackInitializeParam fallbackInitializeParam = (FallbackInitializeParam)other;
                if (!Intrinsics.areEqual((Object)this.application, (Object)fallbackInitializeParam.application)) {
                    return false;
                }
                if (this.enableLogging != fallbackInitializeParam.enableLogging) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.publishableKey, (Object)fallbackInitializeParam.publishableKey)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.stripeAccountId, (Object)fallbackInitializeParam.stripeAccountId)) {
                    return false;
                }
                return Intrinsics.areEqual(this.productUsage, fallbackInitializeParam.productUsage);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\u00058\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/payments/paymentlauncher/PaymentLauncherViewModel$Companion;", "", "()V", "EXPAND_PAYMENT_METHOD", "", "", "getEXPAND_PAYMENT_METHOD", "()Ljava/util/List;", "KEY_HAS_STARTED", "getKEY_HAS_STARTED$payments_core_release$annotations", "REQUIRED_ERROR", "TIMEOUT_ERROR", "UNKNOWN_ERROR", "payments-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getEXPAND_PAYMENT_METHOD() {
            return EXPAND_PAYMENT_METHOD;
        }

        @VisibleForTesting
        public static /* synthetic */ void getKEY_HAS_STARTED$payments_core_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

